// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode.AttachInteropTypeNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode.ForeignAttachInteropTypeNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode.LLVMI64ReadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMReadNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMReadNodeFactory {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI64ReadNode#readI64}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link LLVMI64ReadNode#readObject}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI64ReadNode#readGeneric}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI64ReadNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI64ReadNodeGen extends LLVMI64ReadNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI64ReadNode#readI64}
         *   2: SpecializationExcluded {@link LLVMI64ReadNode#readI64}
         *   3: SpecializationActive {@link LLVMI64ReadNode#readObject}
         *   4: SpecializationExcluded {@link LLVMI64ReadNode#readObject}
         *   5: SpecializationActive {@link LLVMI64ReadNode#readGeneric}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI64ReadNodeGen(int slot) {
            super(slot);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue);
            }
            if ((state_0 & 0b101010) != 0 /* is SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] || SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] || SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readGeneric(VirtualFrame)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */) {
                    try {
                        return readI64(frameValue);
                    } catch (FrameSlotTypeException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(frameValue);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] */) {
                    try {
                        return readObject(frameValue);
                    } catch (FrameSlotTypeException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(frameValue);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readGeneric(VirtualFrame)] */) {
                    return readGeneric(frameValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] || SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readGeneric(VirtualFrame)] */) {
                return LLVMTypesGen.expectLong(executeGeneric(frameValue));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(frameValue));
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */) {
                try {
                    return readI64(frameValue);
                } catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return LLVMTypesGen.expectLong(executeAndSpecialize(frameValue));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(frameValue));
        }

        private Object executeAndSpecialize(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */;
                this.state_0_ = state_0;
                try {
                    return readI64(frameValue);
                } catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(frameValue);
                }
            }
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] */;
                this.state_0_ = state_0;
                try {
                    return readObject(frameValue);
                } catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(frameValue);
                }
            }
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readGeneric(VirtualFrame)] */;
            this.state_0_ = state_0;
            return readGeneric(frameValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b101010) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b101010) & ((state_0 & 0b101010) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readI64(VirtualFrame)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readObject(VirtualFrame)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMReadNode.LLVMI64ReadNode.readGeneric(VirtualFrame)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI64ReadNode create(int slot) {
            return new LLVMI64ReadNodeGen(slot);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AttachInteropTypeNode#doForeign}
     *     Activation probability: 0.65000
     *     With/without class size: 17/4 bytes
     *   Specialization {@link AttachInteropTypeNode#doOther}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(AttachInteropTypeNode.class)
    @SuppressWarnings("javadoc")
    public static final class AttachInteropTypeNodeGen extends AttachInteropTypeNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link AttachInteropTypeNode#doForeign}
         *   2: SpecializationActive {@link AttachInteropTypeNode#doOther}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ForeignData foreign_cache;

        private AttachInteropTypeNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Object arg0Value, LLVMInteropType arg1Value) {
            if (LLVMTypes.isManagedPointer(arg0Value) && arg1Value instanceof Structured) {
                Structured arg1Value_ = (Structured) arg1Value;
                if ((arg1Value_ != null)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((arg0Value_.getOffset() == 0)) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public Object execute(Object arg0Value, LLVMInteropType arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doForeign(LLVMManagedPointer, Structured, ForeignAttachInteropTypeNode)] || SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doOther(Object, LLVMInteropType)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doForeign(LLVMManagedPointer, Structured, ForeignAttachInteropTypeNode)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if (arg1Value instanceof Structured) {
                        Structured arg1Value_ = (Structured) arg1Value;
                        ForeignData s0_ = this.foreign_cache;
                        if (s0_ != null) {
                            if ((arg1Value_ != null) && (arg0Value_.getOffset() == 0)) {
                                return doForeign(arg0Value_, arg1Value_, s0_.attach_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doOther(Object, LLVMInteropType)] */) {
                    if (fallbackGuard_(arg0Value, arg1Value)) {
                        return doOther(arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Structured) {
                    Structured arg1Value_ = (Structured) arg1Value;
                    if ((arg1Value_ != null) && (arg0Value_.getOffset() == 0)) {
                        ForeignData s0_ = this.insert(new ForeignData());
                        s0_.attach_ = s0_.insert((ForeignAttachInteropTypeNode.create()));
                        VarHandle.storeStoreFence();
                        this.foreign_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doForeign(LLVMManagedPointer, Structured, ForeignAttachInteropTypeNode)] */;
                        this.state_0_ = state_0;
                        return doForeign(arg0Value_, arg1Value_, s0_.attach_);
                    }
                }
            }
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doOther(Object, LLVMInteropType)] */;
            this.state_0_ = state_0;
            return doOther(arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                ForeignData s0_ = this.insert(new ForeignData());
                s0_.attach_ = s0_.insert((ForeignAttachInteropTypeNode.create()));
                VarHandle.storeStoreFence();
                this.foreign_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.attach_, 1);
                ((GenerateAOT.Provider) s0_.attach_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doForeign(LLVMManagedPointer, Structured, ForeignAttachInteropTypeNode)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMReadNode.AttachInteropTypeNode.doOther(Object, LLVMInteropType)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.foreign_cache = null;
        }

        @NeverDefault
        public static AttachInteropTypeNode create() {
            return new AttachInteropTypeNodeGen();
        }

        @GeneratedBy(AttachInteropTypeNode.class)
        @DenyReplace
        private static final class ForeignData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link AttachInteropTypeNode#doForeign}
             *   Parameter: {@link ForeignAttachInteropTypeNode} attach</pre>
             */
            @Child ForeignAttachInteropTypeNode attach_;

            ForeignData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignAttachInteropTypeNode#doForeignNoNativeType}
     *     Activation probability: 0.65000
     *     With/without class size: 19/8 bytes
     *   Specialization {@link ForeignAttachInteropTypeNode#doOther}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignAttachInteropTypeNode.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignAttachInteropTypeNodeGen extends ForeignAttachInteropTypeNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignAttachInteropTypeNode#doForeignNoNativeType}
         *   2: GuardActive[guardIndex=0] {@link ForeignAttachInteropTypeNode#doForeignNoNativeType}
         *   3: GuardActive[guardIndex=1] {@link ForeignAttachInteropTypeNode#doForeignNoNativeType}
         *   4: SpecializationActive {@link ForeignAttachInteropTypeNode#doOther}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignAttachInteropTypeNode#doForeignNoNativeType}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child private LLVMAsForeignLibrary foreignNoNativeType_foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignAttachInteropTypeNode#doForeignNoNativeType}
         *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
         */
        @Child private NativeTypeLibrary foreignNoNativeType_nativeTypes_;

        private ForeignAttachInteropTypeNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value, Structured arg1Value) {
            {
                LLVMAsForeignLibrary foreigns__ = this.foreignNoNativeType_foreigns_;
                if ((((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary), guardIndex=0] */ || foreigns__ == null || (foreigns__.isForeign(arg0Value)))) {
                    NativeTypeLibrary nativeTypes__ = this.foreignNoNativeType_nativeTypes_;
                    if ((((state_0 & 0b1000)) == 0 /* is-not GuardActive[specialization=LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary), guardIndex=1] */ || nativeTypes__ == null || (!(nativeTypes__.hasNativeType(arg0Value))))) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public Object execute(Object arg0Value, Structured arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b10010) != 0 /* is SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)] || SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doOther(Object, Structured)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)] */) {
                    {
                        LLVMAsForeignLibrary foreigns__ = this.foreignNoNativeType_foreigns_;
                        if (foreigns__ != null) {
                            NativeTypeLibrary nativeTypes__ = this.foreignNoNativeType_nativeTypes_;
                            if (nativeTypes__ != null) {
                                if ((foreigns__.isForeign(arg0Value)) && (!(nativeTypes__.hasNativeType(arg0Value)))) {
                                    return doForeignNoNativeType(arg0Value, arg1Value, foreigns__, nativeTypes__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doOther(Object, Structured)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return doOther(arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("unused")
        private Object executeAndSpecialize(Object arg0Value, Structured arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            {
                LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                if (((state_0 & 0b100)) == 0 /* is-not GuardActive[specialization=LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary), guardIndex=0] */) {
                    Objects.requireNonNull(this.insert(foreigns__), "Specialization 'doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.foreignNoNativeType_foreigns_ = foreigns__;
                    state_0 = state_0 | 0b100 /* add GuardActive[specialization=LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary), guardIndex=0] */;
                }
                if ((foreigns__.isForeign(arg0Value))) {
                    NativeTypeLibrary nativeTypes__ = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                    if (((state_0 & 0b1000)) == 0 /* is-not GuardActive[specialization=LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary), guardIndex=1] */) {
                        Objects.requireNonNull(this.insert(nativeTypes__), "Specialization 'doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.foreignNoNativeType_nativeTypes_ = nativeTypes__;
                        state_0 = state_0 | 0b1000 /* add GuardActive[specialization=LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary), guardIndex=1] */;
                    }
                    if ((!(nativeTypes__.hasNativeType(arg0Value)))) {
                        Objects.requireNonNull(this.insert(foreigns__), "Specialization 'doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.foreignNoNativeType_foreigns_ = foreigns__;
                        Objects.requireNonNull(this.insert(nativeTypes__), "Specialization 'doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.foreignNoNativeType_nativeTypes_ = nativeTypes__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doForeignNoNativeType(Object, Structured, LLVMAsForeignLibrary, NativeTypeLibrary)] */;
                        this.state_0_ = state_0;
                        return doForeignNoNativeType(arg0Value, arg1Value, foreigns__, nativeTypes__);
                    }
                }
            }
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doOther(Object, Structured)] */;
            this.state_0_ = state_0;
            return doOther(arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10010) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b10010) & ((state_0 & 0b10010) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMReadNode.ForeignAttachInteropTypeNode.doOther(Object, Structured)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ForeignAttachInteropTypeNode create() {
            return new ForeignAttachInteropTypeNodeGen();
        }

    }
}
