// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleI16VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleI1VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleI32VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleI64VectorNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode.LLVMShuffleI8VectorNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMShuffleVectorNode.class)
@SuppressWarnings("javadoc")
public final class LLVMShuffleVectorNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleI1VectorNode#doI1Vector}
     *     Activation probability: 1.00000
     *     With/without class size: 20/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleI1VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleI1VectorNodeGen extends LLVMShuffleI1VectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleI1VectorNode#doI1Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI1VectorNode#doI1Vector}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI1VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI1VectorNode.doI1Vector(LLVMI1Vector, LLVMI1Vector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector leftValue__ = (LLVMI1Vector) leftValue_;
                if (rightValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector rightValue__ = (LLVMI1Vector) rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doI1Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI1Vector) {
                LLVMI1Vector leftValue_ = (LLVMI1Vector) leftValue;
                if (rightValue instanceof LLVMI1Vector) {
                    LLVMI1Vector rightValue_ = (LLVMI1Vector) rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doI1Vector(LLVMI1Vector, LLVMI1Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI1VectorNode.doI1Vector(LLVMI1Vector, LLVMI1Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doI1Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doI1Vector(LLVMI1Vector, LLVMI1Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.conditionProfile_ = conditionProfile__;
                this.conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI1VectorNode.doI1Vector(LLVMI1Vector, LLVMI1Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleI1VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI1VectorNodeGen(left, right, mask, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleI8VectorNode#doI8Vector}
     *     Activation probability: 1.00000
     *     With/without class size: 20/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleI8VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleI8VectorNodeGen extends LLVMShuffleI8VectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleI8VectorNode#doI8Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI8VectorNode#doI8Vector}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI8VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI8VectorNode.doI8Vector(LLVMI8Vector, LLVMI8Vector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector) leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector) rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doI8Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector) leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector) rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doI8Vector(LLVMI8Vector, LLVMI8Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI8VectorNode.doI8Vector(LLVMI8Vector, LLVMI8Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doI8Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doI8Vector(LLVMI8Vector, LLVMI8Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.conditionProfile_ = conditionProfile__;
                this.conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI8VectorNode.doI8Vector(LLVMI8Vector, LLVMI8Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleI8VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI8VectorNodeGen(left, right, mask, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleI16VectorNode#doI8Vector}
     *     Activation probability: 1.00000
     *     With/without class size: 20/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleI16VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleI16VectorNodeGen extends LLVMShuffleI16VectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleI16VectorNode#doI8Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI16VectorNode#doI8Vector}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI16VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI16VectorNode.doI8Vector(LLVMI16Vector, LLVMI16Vector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector) leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector) rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doI8Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector) leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector) rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doI8Vector(LLVMI16Vector, LLVMI16Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI16VectorNode.doI8Vector(LLVMI16Vector, LLVMI16Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doI8Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doI8Vector(LLVMI16Vector, LLVMI16Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.conditionProfile_ = conditionProfile__;
                this.conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI16VectorNode.doI8Vector(LLVMI16Vector, LLVMI16Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleI16VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI16VectorNodeGen(left, right, mask, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleI32VectorNode#doI32Vector}
     *     Activation probability: 1.00000
     *     With/without class size: 20/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleI32VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleI32VectorNodeGen extends LLVMShuffleI32VectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleI32VectorNode#doI32Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI32VectorNode#doI32Vector}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI32VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI32VectorNode.doI32Vector(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector) leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector) rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doI32Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector) leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector) rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doI32Vector(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI32VectorNode.doI32Vector(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doI32Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doI32Vector(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.conditionProfile_ = conditionProfile__;
                this.conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI32VectorNode.doI32Vector(LLVMI32Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleI32VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI32VectorNodeGen(left, right, mask, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleI64VectorNode#doI64Vector}
     *     Activation probability: 0.38500
     *     With/without class size: 10/4 bytes
     *   Specialization {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)}
     *     Activation probability: 0.29500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)}
     *     Activation probability: 0.20500
     *     With/without class size: 7/4 bytes
     *   Specialization {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)}
     *     Activation probability: 0.11500
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleI64VectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleI64VectorNodeGen extends LLVMShuffleI64VectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleI64VectorNode#doI64Vector}
         *   2: SpecializationActive {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)}
         *   3: SpecializationActive {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)}
         *   4: SpecializationActive {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI64VectorNode#doI64Vector}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile i64Vector_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile pointerVector0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile pointerVector1_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleI64VectorNode#doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile pointerVector2_conditionProfile_;

        private LLVMShuffleI64VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] || SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] || SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] || SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */ && maskValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] || SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */ && rightValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue__ = (LLVMI64Vector) rightValue_;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue__ = (LLVMI64Vector) leftValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.i64Vector_conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doI64Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue__ = (LLVMPointerVector) leftValue_;
                        {
                            CountingConditionProfile conditionProfile__1 = this.pointerVector0_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return doPointerVector(leftValue__, rightValue__, maskValue__, conditionProfile__1);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] || SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */ && rightValue_ instanceof LLVMPointerVector) {
                    LLVMPointerVector rightValue__ = (LLVMPointerVector) rightValue_;
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue__ = (LLVMI64Vector) leftValue_;
                        {
                            CountingConditionProfile conditionProfile__2 = this.pointerVector1_conditionProfile_;
                            if (conditionProfile__2 != null) {
                                return doPointerVector(leftValue__, rightValue__, maskValue__, conditionProfile__2);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue__ = (LLVMPointerVector) leftValue_;
                        {
                            CountingConditionProfile conditionProfile__3 = this.pointerVector2_conditionProfile_;
                            if (conditionProfile__3 != null) {
                                return doPointerVector(leftValue__, rightValue__, maskValue__, conditionProfile__3);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (maskValue instanceof LLVMI32Vector) {
                LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                if (rightValue instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue_ = (LLVMI64Vector) rightValue;
                    if (leftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue_ = (LLVMI64Vector) leftValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.i64Vector_conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doI64Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                    if (leftValue instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue_ = (LLVMPointerVector) leftValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.pointerVector0_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doPointerVector(leftValue_, rightValue_, maskValue_, conditionProfile__1);
                    }
                }
                if (rightValue instanceof LLVMPointerVector) {
                    LLVMPointerVector rightValue_ = (LLVMPointerVector) rightValue;
                    if (leftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue_ = (LLVMI64Vector) leftValue;
                        CountingConditionProfile conditionProfile__2 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__2, "Specialization 'doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.pointerVector1_conditionProfile_ = conditionProfile__2;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doPointerVector(leftValue_, rightValue_, maskValue_, conditionProfile__2);
                    }
                    if (leftValue instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue_ = (LLVMPointerVector) leftValue;
                        CountingConditionProfile conditionProfile__3 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__3, "Specialization 'doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.pointerVector2_conditionProfile_ = conditionProfile__3;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doPointerVector(leftValue_, rightValue_, maskValue_, conditionProfile__3);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i64Vector_conditionProfile_ = conditionProfile__;
                this.i64Vector_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doI64Vector(LLVMI64Vector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.pointerVector0_conditionProfile_ = conditionProfile__1;
                this.pointerVector0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMI64Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__2 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__2, "Specialization 'doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.pointerVector1_conditionProfile_ = conditionProfile__2;
                this.pointerVector1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMI64Vector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__3 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__3, "Specialization 'doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.pointerVector2_conditionProfile_ = conditionProfile__3;
                this.pointerVector2_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.doPointerVector(LLVMPointerVector, LLVMPointerVector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i64Vector_conditionProfile_.reset();
            this.pointerVector0_conditionProfile_.reset();
            this.pointerVector1_conditionProfile_.reset();
            this.pointerVector2_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleI64VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI64VectorNodeGen(left, right, mask, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleFloatVectorNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 20/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleFloatVectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleFloatVectorNodeGen extends LLVMShuffleFloatVectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleFloatVectorNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleFloatVectorNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile conditionProfile_;

        private LLVMShuffleFloatVectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode.doOp(LLVMFloatVector, LLVMFloatVector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector leftValue__ = (LLVMFloatVector) leftValue_;
                if (rightValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector rightValue__ = (LLVMFloatVector) rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doOp(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMFloatVector) {
                LLVMFloatVector leftValue_ = (LLVMFloatVector) leftValue;
                if (rightValue instanceof LLVMFloatVector) {
                    LLVMFloatVector rightValue_ = (LLVMFloatVector) rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(LLVMFloatVector, LLVMFloatVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode.doOp(LLVMFloatVector, LLVMFloatVector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(LLVMFloatVector, LLVMFloatVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.conditionProfile_ = conditionProfile__;
                this.conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode.doOp(LLVMFloatVector, LLVMFloatVector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleFloatVectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleFloatVectorNodeGen(left, right, mask, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMShuffleDoubleVectorNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 20/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMShuffleDoubleVectorNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMShuffleDoubleVectorNodeGen extends LLVMShuffleDoubleVectorNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode mask_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMShuffleDoubleVectorNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMShuffleDoubleVectorNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile conditionProfile_;

        private LLVMShuffleDoubleVectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode.doOp(LLVMDoubleVector, LLVMDoubleVector, LLVMI32Vector, CountingConditionProfile)] */ && leftValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftValue__ = (LLVMDoubleVector) leftValue_;
                if (rightValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightValue__ = (LLVMDoubleVector) rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector) maskValue_;
                        {
                            CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                            if (conditionProfile__ != null) {
                                return doOp(leftValue__, rightValue__, maskValue__, conditionProfile__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftValue_ = (LLVMDoubleVector) leftValue;
                if (rightValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightValue_ = (LLVMDoubleVector) rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector) maskValue;
                        CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(LLVMDoubleVector, LLVMDoubleVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode.doOp(LLVMDoubleVector, LLVMDoubleVector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.mask_}, leftValue, rightValue, maskValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(LLVMDoubleVector, LLVMDoubleVector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.conditionProfile_ = conditionProfile__;
                this.conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode.doOp(LLVMDoubleVector, LLVMDoubleVector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleDoubleVectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleDoubleVectorNodeGen(left, right, mask, vectorLength);
        }

    }
}
