/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model;

import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.LazyFunctionParser;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetInformation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModelModule {
    public static final String defaultLayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f16:16:16-f32:32:32-f64:64:64-f128:128:128";
    private final ArrayList<Type> types = new ArrayList();
    private final ArrayList<GlobalVariable> globalVariables = new ArrayList();
    private final ArrayList<GlobalAlias> aliases = new ArrayList();
    private final ArrayList<FunctionDeclaration> declares = new ArrayList();
    private final ArrayList<FunctionDefinition> defines = new ArrayList();
    private final ArrayList<TargetInformation> targetInfo = new ArrayList();
    private final ArrayList<String> sectionNames = new ArrayList();
    private final HashMap<LLVMSourceSymbol, SymbolImpl> sourceGlobals = new HashMap();
    private final HashMap<LLVMSourceStaticMemberType, SymbolImpl> sourceStaticMembers = new HashMap();
    private final HashMap<FunctionDefinition, LazyFunctionParser> lazyFunctionParsers = new HashMap();
    private String targetDataLayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f16:16:16-f32:32:32-f64:64:64-f128:128:128";
    private DebugInfoFunctionProcessor functionProcessor = null;
    private final ArrayList<LLVMSourceFileReference> sourceFiles = new ArrayList();
    private int totalSize;

    public void setTargetDataLayout(String layout) {
        this.targetDataLayout = layout;
    }

    public String getTargetDataLayout() {
        return this.targetDataLayout;
    }

    public void addFunctionDeclaration(FunctionDeclaration declaration) {
        this.declares.add(declaration);
    }

    public List<FunctionDeclaration> getDeclaredFunctions() {
        return this.declares;
    }

    public void addFunctionDefinition(FunctionDefinition definition) {
        this.defines.add(definition);
    }

    public List<FunctionDefinition> getDefinedFunctions() {
        return this.defines;
    }

    public void addFunctionParser(FunctionDefinition definition, LazyFunctionParser parser) {
        this.lazyFunctionParsers.put(definition, parser);
    }

    public LazyFunctionParser getFunctionParser(FunctionDefinition functionDefinition) {
        return this.lazyFunctionParsers.get(functionDefinition);
    }

    public void addGlobalType(Type type) {
        this.types.add(type);
    }

    public void addGlobalVariable(GlobalVariable global) {
        this.globalVariables.add(global);
    }

    public void addAlias(GlobalAlias alias) {
        this.aliases.add(alias);
    }

    public void addTargetInformation(TargetInformation info) {
        this.targetInfo.add(info);
    }

    public void addSectionName(String sectionName) {
        this.sectionNames.add(sectionName);
    }

    public List<String> getSectionNames() {
        return this.sectionNames;
    }

    public List<GlobalVariable> getGlobalVariables() {
        return this.globalVariables;
    }

    public List<GlobalAlias> getAliases() {
        return this.aliases;
    }

    public Map<LLVMSourceSymbol, SymbolImpl> getSourceGlobals() {
        return this.sourceGlobals;
    }

    public Map<LLVMSourceStaticMemberType, SymbolImpl> getSourceStaticMembers() {
        return this.sourceStaticMembers;
    }

    public DebugInfoFunctionProcessor getFunctionProcessor() {
        return this.functionProcessor;
    }

    public void setFunctionProcessor(DebugInfoFunctionProcessor functionProcessor) {
        this.functionProcessor = functionProcessor;
    }

    public String toString() {
        return String.format("Model (%d defines, %d declares, %d global variables, %d aliases, %d types)", this.defines.size(), this.declares.size(), this.globalVariables.size(), this.aliases.size(), this.types.size());
    }

    public void addSourceFileReference(LLVMSourceFileReference sourceFile) {
        this.sourceFiles.add(sourceFile);
    }

    public ArrayList<LLVMSourceFileReference> getSourceFileReferences() {
        return this.sourceFiles;
    }

    public <TI extends TargetInformation> TI getTargetInformation(Class<TI> targetInfoClazz) {
        for (TargetInformation info : this.targetInfo) {
            if (!targetInfoClazz.isInstance(info)) continue;
            return (TI)((TargetInformation)targetInfoClazz.cast(info));
        }
        return null;
    }

    public void setTotalSize(int index) {
        this.totalSize = index;
    }

    public int getTotalSize() {
        return this.totalSize;
    }
}

