/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.config.Configurations;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.spi.internal.LLVMResourceProvider;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class InternalLibraryLocator
extends LibraryLocator
implements LLVMCapability {
    private static final List<LLVMResourceProvider> LIBRARY_LOCATORS;

    public static InternalLibraryLocator create(String config, LLVMLanguage language, InternalResource.OS os, InternalResource.CPUArchitecture arch) {
        String home;
        InternalLibraryLocator resourceLocator = null;
        for (LLVMResourceProvider provider : LIBRARY_LOCATORS) {
            if (!provider.getConfiguration().equals(config)) continue;
            resourceLocator = new ResourceInternalLibraryLocator(provider, os, arch);
            break;
        }
        if ((home = language.getLLVMLanguageHome()) != null) {
            Path libPath = Path.of(home, config, "lib");
            try {
                if (Files.exists(libPath, new LinkOption[0])) {
                    resourceLocator = new HomeInternalLibraryLocator(config, resourceLocator);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (resourceLocator != null) {
            return resourceLocator;
        }
        throw new IllegalStateException(String.format("Could not find internal resources for configuration %s.", config));
    }

    protected abstract Source.SourceBuilder locateLibrary(LLVMContext var1, String var2, Object var3);

    static {
        ArrayList<LLVMResourceProvider> resourceLocators = new ArrayList<LLVMResourceProvider>();
        for (LLVMResourceProvider provider : Configurations.getService(LLVMResourceProvider.class)) {
            resourceLocators.add(provider);
        }
        LIBRARY_LOCATORS = resourceLocators;
    }

    private static final class ResourceInternalLibraryLocator
    extends InternalLibraryLocator {
        private final Class<?> resourceLocation;
        private final String basePath;

        private ResourceInternalLibraryLocator(LLVMResourceProvider provider, InternalResource.OS os, InternalResource.CPUArchitecture arch) {
            this.resourceLocation = provider.getClass();
            this.basePath = provider.getBasePath(os, arch);
        }

        @Override
        protected Source.SourceBuilder locateLibrary(LLVMContext context, String lib, Object reason) {
            URL url = this.resourceLocation.getResource(this.basePath + lib);
            if (url == null) {
                return null;
            }
            return Source.newBuilder((String)"llvm", (URL)url).internal(true);
        }

        public String toString() {
            return "ResourceInternalLibraryLocator [resourceLocation=" + this.resourceLocation + ", basePath=" + this.basePath + "]";
        }
    }

    private static final class HomeInternalLibraryLocator
    extends InternalLibraryLocator {
        private final String config;
        private final InternalLibraryLocator backup;

        private HomeInternalLibraryLocator(String config, InternalLibraryLocator backup) {
            this.config = config;
            this.backup = backup;
        }

        @Override
        protected Source.SourceBuilder locateLibrary(LLVMContext context, String lib, Object reason) {
            String home = context.getLanguage().getLLVMLanguageHome();
            if (home != null) {
                Path libPath = Path.of(home, this.config, "lib", lib);
                TruffleFile file = context.getEnv().getInternalTruffleFile(libPath.toString());
                if (file.exists(new LinkOption[0])) {
                    return Source.newBuilder((String)"llvm", (TruffleFile)file).internal(true);
                }
            }
            if (this.backup != null) {
                return this.backup.locateLibrary(context, lib, reason);
            }
            return null;
        }

        public String toString() {
            return "HomeInternalLibraryLocator [config=" + this.config + ", backup=" + this.backup + "]";
        }
    }
}

