/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class LLVMBuiltin
extends LLVMExpressionNode {

    public static interface TypedBuiltinFactory {
        public ScalarBuiltinFactory getScalar();

        public VectorBuiltinFactory getVector();

        public static TypedBuiltinFactory vector(final ScalarBuiltinFactory f, final VectorBuiltinFactory v) {
            return new TypedBuiltinFactory(){

                @Override
                public ScalarBuiltinFactory getScalar() {
                    return f;
                }

                @Override
                public VectorBuiltinFactory getVector() {
                    return v;
                }
            };
        }

        public static TypedBuiltinFactory vector1(ScalarBuiltinFactory1 f, VectorBuiltinFactory1 v) {
            return TypedBuiltinFactory.vector(f, v);
        }

        public static TypedBuiltinFactory vector2(ScalarBuiltinFactory2 f, VectorBuiltinFactory2 v) {
            return TypedBuiltinFactory.vector(f, v);
        }

        public static TypedBuiltinFactory vector3(ScalarBuiltinFactory3 f, VectorBuiltinFactory3 v) {
            return TypedBuiltinFactory.vector(f, v);
        }

        public static TypedBuiltinFactory simple(ScalarBuiltinFactory f) {
            return TypedBuiltinFactory.vector(f, null);
        }

        public static TypedBuiltinFactory simple1(ScalarBuiltinFactory1 f) {
            return TypedBuiltinFactory.vector(f, null);
        }

        public static TypedBuiltinFactory simple2(ScalarBuiltinFactory2 f) {
            return TypedBuiltinFactory.vector(f, null);
        }

        public static TypedBuiltinFactory simple3(ScalarBuiltinFactory3 f) {
            return TypedBuiltinFactory.vector(f, null);
        }
    }

    public static interface VectorBuiltinFactory3
    extends VectorBuiltinFactory {
        @Override
        default public LLVMExpressionNode create(int vectorSize, LLVMExpressionNode[] args) {
            return this.create(vectorSize, args[1], args[2], args[3]);
        }

        public LLVMExpressionNode create(int var1, LLVMExpressionNode var2, LLVMExpressionNode var3, LLVMExpressionNode var4);
    }

    public static interface VectorBuiltinFactory2
    extends VectorBuiltinFactory {
        @Override
        default public LLVMExpressionNode create(int vectorSize, LLVMExpressionNode[] args) {
            return this.create(vectorSize, args[1], args[2]);
        }

        public LLVMExpressionNode create(int var1, LLVMExpressionNode var2, LLVMExpressionNode var3);
    }

    public static interface VectorBuiltinFactory1
    extends VectorBuiltinFactory {
        @Override
        default public LLVMExpressionNode create(int vectorSize, LLVMExpressionNode[] args) {
            return this.create(vectorSize, args[1]);
        }

        public LLVMExpressionNode create(int var1, LLVMExpressionNode var2);
    }

    public static interface VectorBuiltinFactory {
        public LLVMExpressionNode create(int var1, LLVMExpressionNode[] var2);
    }

    public static interface ScalarBuiltinFactory3
    extends ScalarBuiltinFactory {
        @Override
        default public LLVMExpressionNode create(LLVMExpressionNode[] args) {
            return this.create(args[1], args[2], args[3]);
        }

        public LLVMExpressionNode create(LLVMExpressionNode var1, LLVMExpressionNode var2, LLVMExpressionNode var3);
    }

    public static interface ScalarBuiltinFactory2
    extends ScalarBuiltinFactory {
        @Override
        default public LLVMExpressionNode create(LLVMExpressionNode[] args) {
            return this.create(args[1], args[2]);
        }

        public LLVMExpressionNode create(LLVMExpressionNode var1, LLVMExpressionNode var2);
    }

    public static interface ScalarBuiltinFactory1
    extends ScalarBuiltinFactory {
        @Override
        default public LLVMExpressionNode create(LLVMExpressionNode[] args) {
            return this.create(args[1]);
        }

        public LLVMExpressionNode create(LLVMExpressionNode var1);
    }

    public static interface ScalarBuiltinFactory {
        public LLVMExpressionNode create(LLVMExpressionNode[] var1);
    }
}

