/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadKeyIntrinsics;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMThreadKeyIntrinsics.class)
public final class LLVMThreadKeyIntrinsicsFactory {

    @GeneratedBy(value=LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific.class)
    public static final class LLVMThreadSetSpecificNodeGen
    extends LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode key_;
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadSetSpecificNodeGen(LLVMExpressionNode key, LLVMExpressionNode value) {
            this.key_ = key;
            this.value_ = value;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state_0 = this.state_0_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object valueValue = this.value_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(keyValue_, valueValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return this.doIntrinsic(keyValue_, valueValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_, valueValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int keyValue_;
            int state_0 = this.state_0_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object valueValue = this.value_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(keyValue_, valueValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return this.doIntrinsic(keyValue_, valueValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_, valueValue_);
        }

        private int executeAndSpecialize(Object keyValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (keyValue instanceof Integer) {
                int keyValue_ = (Integer)keyValue;
                if (LLVMTypes.isPointer(valueValue)) {
                    LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                    this.state_0_ = state_0 |= 2;
                    return this.doIntrinsic(keyValue_, valueValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_, this.value_}, new Object[]{keyValue, valueValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific create(LLVMExpressionNode key, LLVMExpressionNode value) {
            return new LLVMThreadSetSpecificNodeGen(key, value);
        }
    }

    @GeneratedBy(value=LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific.class)
    public static final class LLVMThreadGetSpecificNodeGen
    extends LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode key_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadGetSpecificNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state_0 = this.state_0_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(keyValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doIntrinsic(keyValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        private LLVMPointer executeAndSpecialize(Object keyValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (keyValue instanceof Integer) {
                int keyValue_ = (Integer)keyValue;
                this.state_0_ = state_0 |= 2;
                return this.doIntrinsic(keyValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_}, new Object[]{keyValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific create(LLVMExpressionNode key) {
            return new LLVMThreadGetSpecificNodeGen(key);
        }
    }

    @GeneratedBy(value=LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete.class)
    public static final class LLVMThreadKeyDeleteNodeGen
    extends LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode key_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadKeyDeleteNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state_0 = this.state_0_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(keyValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doIntrinsic(keyValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int keyValue_;
            int state_0 = this.state_0_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(keyValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doIntrinsic(keyValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        private int executeAndSpecialize(Object keyValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (keyValue instanceof Integer) {
                int keyValue_ = (Integer)keyValue;
                this.state_0_ = state_0 |= 2;
                return this.doIntrinsic(keyValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_}, new Object[]{keyValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete create(LLVMExpressionNode key) {
            return new LLVMThreadKeyDeleteNodeGen(key);
        }
    }

    @GeneratedBy(value=LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate.class)
    public static final class LLVMThreadKeyCreateNodeGen
    extends LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode destructor_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadKeyCreateNodeGen(LLVMExpressionNode destructor) {
            this.destructor_ = destructor;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(destructorValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                return this.doIntrinsic(destructorValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destructorValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(destructorValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                return this.doIntrinsic(destructorValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destructorValue_);
        }

        private int executeAndSpecialize(Object destructorValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(destructorValue)) {
                LLVMPointer destructorValue_ = LLVMTypes.asPointer(destructorValue);
                this.state_0_ = state_0 |= 2;
                return this.doIntrinsic(destructorValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.destructor_}, new Object[]{destructorValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate create(LLVMExpressionNode destructor) {
            return new LLVMThreadKeyCreateNodeGen(destructor);
        }
    }
}

