/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.literals;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMRewriteException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMVectorLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

public class LLVMVectorLiteralNode {

    public static abstract class LLVMDoubleVectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMDoubleVectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doDoubleVector(VirtualFrame frame) {
            double[] vals = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = LLVMTypesGen.asDouble(this.values[i].executeGeneric(frame));
            }
            return LLVMDoubleVector.create(vals);
        }
    }

    public static abstract class LLVMFloatVectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMFloatVectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doFloatVector(VirtualFrame frame) {
            float[] vals = new float[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = LLVMTypesGen.asFloat(this.values[i].executeGeneric(frame));
            }
            return LLVMFloatVector.create(vals);
        }
    }

    public static abstract class LLVMPointerVectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMPointerVectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization(rewriteOn={LLVMRewriteException.class})
        @ExplodeLoop
        protected LLVMPointerVector doPointerVector(VirtualFrame frame) throws LLVMRewriteException {
            try {
                LLVMPointer[] vals = new LLVMPointer[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    vals[i] = this.values[i].executeLLVMPointer(frame);
                }
                return LLVMPointerVector.create(vals);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMRewriteException(e);
            }
        }

        @Specialization
        @ExplodeLoop
        protected LLVMPointerVector doMixedVector(VirtualFrame frame, @Cached(value="createToPointerNodes()") LLVMToPointerNode[] toPointer) {
            LLVMPointer[] vals = new LLVMPointer[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                Object value = this.values[i].executeGeneric(frame);
                vals[i] = toPointer[i].executeWithTarget(value);
            }
            return LLVMPointerVector.create(vals);
        }

        @CompilerDirectives.TruffleBoundary
        protected LLVMToPointerNode[] createToPointerNodes() {
            LLVMToPointerNode[] result = new LLVMToPointerNode[this.values.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = LLVMToPointerNodeGen.create();
            }
            return result;
        }
    }

    public static abstract class LLVMI64VectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMI64VectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization(rewriteOn={LLVMRewriteException.class})
        @ExplodeLoop
        protected LLVMI64Vector doI64Vector(VirtualFrame frame) throws LLVMRewriteException {
            try {
                long[] vals = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    vals[i] = this.values[i].executeI64(frame);
                }
                return LLVMI64Vector.create(vals);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMRewriteException(e);
            }
        }

        @Specialization
        @ExplodeLoop
        protected LLVMPointerVector doPointerVector(VirtualFrame frame, @Cached(value="createPointerLiteral()") LLVMPointerVectorLiteralNode pointerLiteral) {
            return LLVMTypesGen.asLLVMPointerVector(pointerLiteral.executeGeneric(frame));
        }

        protected LLVMPointerVectorLiteralNode createPointerLiteral() {
            CompilerAsserts.neverPartOfCompilation();
            return LLVMVectorLiteralNodeFactory.LLVMPointerVectorLiteralNodeGen.create(this.values);
        }
    }

    public static abstract class LLVMI32VectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMI32VectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI32Vector(VirtualFrame frame) {
            int[] vals = new int[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = LLVMTypesGen.asInteger(this.values[i].executeGeneric(frame));
            }
            return LLVMI32Vector.create(vals);
        }
    }

    public static abstract class LLVMI16VectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMI16VectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI16Vector(VirtualFrame frame) {
            short[] vals = new short[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = LLVMTypesGen.asShort(this.values[i].executeGeneric(frame));
            }
            return LLVMI16Vector.create(vals);
        }
    }

    public static abstract class LLVMI8VectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMI8VectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI8Vector(VirtualFrame frame) {
            byte[] vals = new byte[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = LLVMTypesGen.asByte(this.values[i].executeGeneric(frame));
            }
            return LLVMI8Vector.create(vals);
        }
    }

    public static abstract class LLVMI1VectorLiteralNode
    extends LLVMExpressionNode {
        @Node.Children
        private final LLVMExpressionNode[] values;

        public LLVMI1VectorLiteralNode(LLVMExpressionNode[] values) {
            this.values = values;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI1Vector(VirtualFrame frame) {
            boolean[] vals = new boolean[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = LLVMTypesGen.asBoolean(this.values[i].executeGeneric(frame));
            }
            return LLVMI1Vector.create(vals);
        }
    }
}

