/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMCompareExchangeNode.class)
public final class LLVMCompareExchangeNodeGen
extends LLVMCompareExchangeNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode comparisonValue_;
    @Node.Child
    private LLVMExpressionNode newValue_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMCompareExchangeNodeGen(LLVMExpressionNode resultAllocation, long secondValueOffset, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        super(resultAllocation, secondValueOffset);
        this.address_ = address;
        this.comparisonValue_ = comparisonValue;
        this.newValue_ = newValue;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object comparisonValueValue_ = this.comparisonValue_.executeGeneric(frameValue);
        Object newValueValue_ = this.newValue_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, addressValue_, comparisonValueValue_, newValueValue_);
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return this.doOp(frameValue, addressValue__, comparisonValueValue_, newValueValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, addressValue_, comparisonValueValue_, newValueValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object addressValue, Object comparisonValueValue, Object newValueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            this.state_0_ = state_0 |= 2;
            return this.doOp(frameValue, addressValue_, comparisonValueValue, newValueValue);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.comparisonValue_, this.newValue_}, new Object[]{addressValue, comparisonValueValue, newValueValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMCompareExchangeNode create(LLVMExpressionNode resultAllocation, long secondValueOffset, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        return new LLVMCompareExchangeNodeGen(resultAllocation, secondValueOffset, address, comparisonValue, newValue);
    }

    @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
    static final class LLVMCMPXCHInternalNodeGen
    extends LLVMCompareExchangeNode.LLVMCMPXCHInternalNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private Op5Data op5_cache;
        @Node.Child
        private Op6Data op6_cache;
        @Node.Child
        private Op7Data op7_cache;
        @Node.Child
        private LongData long_cache;
        @Node.Child
        private LongGenericData longGeneric_cache;
        @Node.Child
        private Op8Data op8_cache;

        private LLVMCMPXCHInternalNodeGen(LLVMCompareExchangeNode.AllocResultNode allocResult) {
            super(allocResult);
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0x1BFE) != 0) {
                LLVMPointer arg0Value_;
                if ((state_0 & 0x3E) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 2) != 0 && arg1Value instanceof Byte) {
                        byte by = (Byte)arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte by2 = (Byte)arg2Value;
                            return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, by, by2);
                        }
                    }
                    if ((state_0 & 4) != 0 && arg1Value instanceof Short) {
                        short s = (Short)arg1Value;
                        if (arg2Value instanceof Short) {
                            short s2 = (Short)arg2Value;
                            return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, s, s2);
                        }
                    }
                    if ((state_0 & 8) != 0 && arg1Value instanceof Integer) {
                        int n = (Integer)arg1Value;
                        if (arg2Value instanceof Integer) {
                            int n2 = (Integer)arg2Value;
                            return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, n, n2);
                        }
                    }
                    if ((state_0 & 0x10) != 0 && arg1Value instanceof Long) {
                        long l = (Long)arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (Long)arg2Value;
                            return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, l, arg2Value_);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                        LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                        if (LLVMTypes.isNativePointer(arg2Value)) {
                            LLVMNativePointer lLVMNativePointer2 = LLVMTypes.asNativePointer(arg2Value);
                            return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, lLVMNativePointer, lLVMNativePointer2);
                        }
                    }
                }
                if ((state_0 & 0x1BC0) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0x40) != 0 && arg1Value instanceof Byte) {
                        byte by = (Byte)arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte by3 = (Byte)arg2Value;
                            Op5Data s5_ = this.op5_cache;
                            if (s5_ != null) {
                                return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, by, by3, s5_.read_, s5_.write_);
                            }
                        }
                    }
                    if ((state_0 & 0x80) != 0 && arg1Value instanceof Short) {
                        short s = (Short)arg1Value;
                        if (arg2Value instanceof Short) {
                            short s3 = (Short)arg2Value;
                            Op6Data s6_ = this.op6_cache;
                            if (s6_ != null) {
                                return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, s, s3, s6_.read_, s6_.write_);
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && arg1Value instanceof Integer) {
                        int n = (Integer)arg1Value;
                        if (arg2Value instanceof Integer) {
                            int n3 = (Integer)arg2Value;
                            Op7Data s7_ = this.op7_cache;
                            if (s7_ != null) {
                                return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, n, n3, s7_.read_, s7_.write_);
                            }
                        }
                    }
                    if ((state_0 & 0xA00) != 0 && arg1Value instanceof Long) {
                        long l = (Long)arg1Value;
                        if (arg2Value instanceof Long) {
                            LongGenericData s9_;
                            LongData s8_;
                            long arg2Value_2 = (Long)arg2Value;
                            if ((state_0 & 0x200) != 0 && (s8_ = this.long_cache) != null) {
                                try {
                                    return this.doLong(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_2, s8_.read_, s8_.write_);
                                }
                                catch (LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.RewriteException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFDFF;
                                    this.state_0_ = state_0 |= 0x400;
                                    this.long_cache = null;
                                    return this.executeAndSpecialize(frameValue, arg0Value_, l, arg2Value_2);
                                }
                            }
                            if ((state_0 & 0x800) != 0 && (s9_ = this.longGeneric_cache) != null) {
                                return this.doLongGeneric(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_2, s9_.read_, s9_.write_, s9_.cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0x1000) != 0 && LLVMTypes.isPointer(arg1Value)) {
                        LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg1Value);
                        if (LLVMTypes.isPointer(arg2Value)) {
                            LLVMPointer lLVMPointer2 = LLVMTypes.asPointer(arg2Value);
                            Op8Data s10_ = this.op8_cache;
                            if (s10_ != null) {
                                return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, lLVMPointer, lLVMPointer2, s10_.read_, s10_.write_, s10_.cmp_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            LLVMPointer arg0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (Byte)arg2Value;
                        this.state_0_ = state_0 |= 2;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, by, arg2Value_);
                    }
                }
                if (arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (Short)arg2Value;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, s, arg2Value_);
                    }
                }
                if (arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (Integer)arg2Value;
                        this.state_0_ = state_0 |= 8;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, n, arg2Value_);
                    }
                }
                if (arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, l, arg2Value_);
                    }
                }
                if (LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                    if (LLVMTypes.isNativePointer(arg2Value)) {
                        LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                        this.state_0_ = state_0 |= 0x20;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, lLVMNativePointer, arg2Value_);
                    }
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (Byte)arg2Value;
                        Op5Data s5_ = (Op5Data)this.insert(new Op5Data());
                        s5_.read_ = (LLVMI8LoadNode)s5_.insert(LLVMI8LoadNode.create());
                        s5_.write_ = (LLVMI8StoreNode)s5_.insert(LLVMI8StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.op5_cache = s5_;
                        this.state_0_ = state_0 |= 0x40;
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, by, arg2Value_, s5_.read_, s5_.write_);
                    }
                }
                if (arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (Short)arg2Value;
                        Op6Data s6_ = (Op6Data)this.insert(new Op6Data());
                        s6_.read_ = (LLVMI16LoadNode)s6_.insert(LLVMI16LoadNode.create());
                        s6_.write_ = (LLVMI16StoreNode)s6_.insert(LLVMI16StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.op6_cache = s6_;
                        this.state_0_ = state_0 |= 0x80;
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, s, arg2Value_, s6_.read_, s6_.write_);
                    }
                }
                if (arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (Integer)arg2Value;
                        Op7Data s7_ = (Op7Data)this.insert(new Op7Data());
                        s7_.read_ = (LLVMI32LoadNode)s7_.insert(LLVMI32LoadNode.create());
                        s7_.write_ = (LLVMI32StoreNode)s7_.insert(LLVMI32StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.op7_cache = s7_;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, n, arg2Value_, s7_.read_, s7_.write_);
                    }
                }
                if (arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        if ((state_0 & 0x800) == 0 && (state_0 & 0x400) == 0) {
                            LongData s8_ = (LongData)this.insert(new LongData());
                            s8_.read_ = (LLVMI64LoadNode)s8_.insert(LLVMI64LoadNode.create());
                            s8_.write_ = (LLVMI64StoreNode)s8_.insert(LLVMI64StoreNode.create());
                            VarHandle.storeStoreFence();
                            this.long_cache = s8_;
                            this.state_0_ = state_0 |= 0x200;
                            try {
                                return this.doLong(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_, s8_.read_, s8_.write_);
                            }
                            catch (LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.RewriteException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFDFF;
                                this.state_0_ = state_0 |= 0x400;
                                this.long_cache = null;
                                return this.executeAndSpecialize(frameValue, arg0Value_, l, arg2Value_);
                            }
                        }
                        LongGenericData s9_ = (LongGenericData)this.insert(new LongGenericData());
                        s9_.read_ = (LLVMI64LoadNode)s9_.insert(LLVMI64LoadNode.create());
                        s9_.write_ = (LLVMI64StoreNode)s9_.insert(LLVMI64StoreNode.create());
                        s9_.cmp_ = (LLVMAddressEqualsNode)s9_.insert(LLVMAddressEqualsNode.create());
                        VarHandle.storeStoreFence();
                        this.longGeneric_cache = s9_;
                        this.long_cache = null;
                        state_0 &= 0xFFFFFDFF;
                        this.state_0_ = state_0 |= 0x800;
                        return this.doLongGeneric(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_, s9_.read_, s9_.write_, s9_.cmp_);
                    }
                }
                if (LLVMTypes.isPointer(arg1Value)) {
                    LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg1Value);
                    if (LLVMTypes.isPointer(arg2Value)) {
                        LLVMPointer arg2Value_ = LLVMTypes.asPointer(arg2Value);
                        Op8Data s10_ = (Op8Data)this.insert(new Op8Data());
                        s10_.read_ = (LLVMPointerLoadNode)s10_.insert(LLVMPointerLoadNode.create());
                        s10_.write_ = (LLVMPointerStoreNode)s10_.insert(LLVMPointerStoreNode.create());
                        s10_.cmp_ = (LLVMAddressEqualsNode)s10_.insert(LLVMAddressEqualsNode.create());
                        VarHandle.storeStoreFence();
                        this.op8_cache = s10_;
                        this.state_0_ = state_0 |= 0x1000;
                        return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, lLVMPointer, arg2Value_, s10_.read_, s10_.write_, s10_.cmp_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1BFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1BFE & (state_0 & 0x1BFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            Op5Data s5_ = (Op5Data)this.insert(new Op5Data());
            s5_.read_ = (LLVMI8LoadNode)s5_.insert(LLVMI8LoadNode.create());
            s5_.write_ = (LLVMI8StoreNode)s5_.insert(LLVMI8StoreNode.create());
            VarHandle.storeStoreFence();
            this.op5_cache = s5_;
            assert (NodeUtil.assertRecursion((Node)s5_.read_, (int)1));
            ((GenerateAOT.Provider)s5_.read_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s5_.write_, (int)1));
            ((GenerateAOT.Provider)s5_.write_).prepareForAOT(language, root);
            this.state_0_ |= 0x40;
            Op6Data s6_ = (Op6Data)this.insert(new Op6Data());
            s6_.read_ = (LLVMI16LoadNode)s6_.insert(LLVMI16LoadNode.create());
            s6_.write_ = (LLVMI16StoreNode)s6_.insert(LLVMI16StoreNode.create());
            VarHandle.storeStoreFence();
            this.op6_cache = s6_;
            assert (NodeUtil.assertRecursion((Node)s6_.read_, (int)1));
            ((GenerateAOT.Provider)s6_.read_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s6_.write_, (int)1));
            ((GenerateAOT.Provider)s6_.write_).prepareForAOT(language, root);
            this.state_0_ |= 0x80;
            Op7Data s7_ = (Op7Data)this.insert(new Op7Data());
            s7_.read_ = (LLVMI32LoadNode)s7_.insert(LLVMI32LoadNode.create());
            s7_.write_ = (LLVMI32StoreNode)s7_.insert(LLVMI32StoreNode.create());
            VarHandle.storeStoreFence();
            this.op7_cache = s7_;
            assert (NodeUtil.assertRecursion((Node)s7_.read_, (int)1));
            ((GenerateAOT.Provider)s7_.read_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s7_.write_, (int)1));
            ((GenerateAOT.Provider)s7_.write_).prepareForAOT(language, root);
            this.state_0_ |= 0x100;
            LongGenericData s9_ = (LongGenericData)this.insert(new LongGenericData());
            s9_.read_ = (LLVMI64LoadNode)s9_.insert(LLVMI64LoadNode.create());
            s9_.write_ = (LLVMI64StoreNode)s9_.insert(LLVMI64StoreNode.create());
            s9_.cmp_ = (LLVMAddressEqualsNode)s9_.insert(LLVMAddressEqualsNode.create());
            VarHandle.storeStoreFence();
            this.longGeneric_cache = s9_;
            this.long_cache = null;
            this.state_0_ &= 0xFFFFFDFF;
            assert (NodeUtil.assertRecursion((Node)s9_.read_, (int)1));
            ((GenerateAOT.Provider)s9_.read_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s9_.write_, (int)1));
            ((GenerateAOT.Provider)s9_.write_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s9_.cmp_, (int)1));
            ((GenerateAOT.Provider)s9_.cmp_).prepareForAOT(language, root);
            this.state_0_ |= 0x800;
            Op8Data s10_ = (Op8Data)this.insert(new Op8Data());
            s10_.read_ = (LLVMPointerLoadNode)s10_.insert(LLVMPointerLoadNode.create());
            s10_.write_ = (LLVMPointerStoreNode)s10_.insert(LLVMPointerStoreNode.create());
            s10_.cmp_ = (LLVMAddressEqualsNode)s10_.insert(LLVMAddressEqualsNode.create());
            VarHandle.storeStoreFence();
            this.op8_cache = s10_;
            assert (NodeUtil.assertRecursion((Node)s10_.read_, (int)1));
            ((GenerateAOT.Provider)s10_.read_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s10_.write_, (int)1));
            ((GenerateAOT.Provider)s10_.write_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s10_.cmp_, (int)1));
            ((GenerateAOT.Provider)s10_.cmp_).prepareForAOT(language, root);
            this.state_0_ |= 0x1000;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op5_cache = null;
            this.op6_cache = null;
            this.op7_cache = null;
            this.longGeneric_cache = null;
            this.op8_cache = null;
        }

        @NeverDefault
        public static LLVMCompareExchangeNode.LLVMCMPXCHInternalNode create(LLVMCompareExchangeNode.AllocResultNode allocResult) {
            return new LLVMCMPXCHInternalNodeGen(allocResult);
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op5Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8LoadNode read_;
            @Node.Child
            LLVMI8StoreNode write_;

            Op5Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op6Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16LoadNode read_;
            @Node.Child
            LLVMI16StoreNode write_;

            Op6Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op7Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32LoadNode read_;
            @Node.Child
            LLVMI32StoreNode write_;

            Op7Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class LongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64LoadNode read_;
            @Node.Child
            LLVMI64StoreNode write_;

            LongData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class LongGenericData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64LoadNode read_;
            @Node.Child
            LLVMI64StoreNode write_;
            @Node.Child
            LLVMAddressEqualsNode cmp_;

            LongGenericData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        @DenyReplace
        private static final class Op8Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMPointerLoadNode read_;
            @Node.Child
            LLVMPointerStoreNode write_;
            @Node.Child
            LLVMAddressEqualsNode cmp_;

            Op8Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=LLVMCompareExchangeNode.AllocResultNode.class)
    static final class AllocResultNodeGen
    extends LLVMCompareExchangeNode.AllocResultNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ByteData byte_cache;
        @Node.Child
        private ShortData short_cache;
        @Node.Child
        private IntData int_cache;
        @Node.Child
        private LongData long_cache;
        @Node.Child
        private PointerData pointer_cache;

        private AllocResultNodeGen(long secondValueOffset, LLVMExpressionNode resultAllocation) {
            super(secondValueOffset, resultAllocation);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, Object arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0x2AA) != 0) {
                if ((state_0 & 2) != 0 && arg0Value instanceof Byte) {
                    byte by = (Byte)arg0Value;
                    ByteData s0_ = this.byte_cache;
                    if (s0_ != null) {
                        try {
                            return this.doByte(frameValue, by, arg1Value, s0_.valueStore_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFD;
                            this.state_0_ = state_0 |= 4;
                            this.byte_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 8) != 0 && arg0Value instanceof Short) {
                    short s = (Short)arg0Value;
                    ShortData s1_ = this.short_cache;
                    if (s1_ != null) {
                        try {
                            return this.doShort(frameValue, s, arg1Value, s1_.valueStore_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFF7;
                            this.state_0_ = state_0 |= 0x10;
                            this.short_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0x20) != 0 && arg0Value instanceof Integer) {
                    int n = (Integer)arg0Value;
                    IntData s2_ = this.int_cache;
                    if (s2_ != null) {
                        try {
                            return this.doInt(frameValue, n, arg1Value, s2_.valueStore_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            this.int_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0x80) != 0 && arg0Value instanceof Long) {
                    long l = (Long)arg0Value;
                    LongData s3_ = this.long_cache;
                    if (s3_ != null) {
                        try {
                            return this.doLong(frameValue, l, arg1Value, s3_.valueStore_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFF7F;
                            this.state_0_ = state_0 |= 0x100;
                            this.long_cache = null;
                            return ex.getResult();
                        }
                    }
                }
                if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg0Value);
                    PointerData s4_ = this.pointer_cache;
                    if (s4_ != null) {
                        try {
                            return this.doPointer(frameValue, lLVMPointer, arg1Value, s4_.valueStore_);
                        }
                        catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFDFF;
                            this.state_0_ = state_0 |= 0x400;
                            this.pointer_cache = null;
                            return ex.getResult();
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, byte arg0Value, boolean arg1Value) {
            ByteData s0_;
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && (s0_ = this.byte_cache) != null) {
                try {
                    return this.doByte(frameValue, arg0Value, arg1Value, s0_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    this.byte_cache = null;
                    return ex.getResult();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, int arg0Value, boolean arg1Value) {
            IntData s2_;
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0x20) != 0 && (s2_ = this.int_cache) != null) {
                try {
                    return this.doInt(frameValue, arg0Value, arg1Value, s2_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFDF;
                    this.state_0_ = state_0 |= 0x40;
                    this.int_cache = null;
                    return ex.getResult();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, long arg0Value, boolean arg1Value) {
            LongData s3_;
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 0x80) != 0 && (s3_ = this.long_cache) != null) {
                try {
                    return this.doLong(frameValue, arg0Value, arg1Value, s3_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFF7F;
                    this.state_0_ = state_0 |= 0x100;
                    this.long_cache = null;
                    return ex.getResult();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        @Override
        protected Object execute(VirtualFrame frameValue, short arg0Value, boolean arg1Value) {
            ShortData s1_;
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }
            if ((state_0 & 8) != 0 && (s1_ = this.short_cache) != null) {
                try {
                    return this.doShort(frameValue, arg0Value, arg1Value, s1_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFF7;
                    this.state_0_ = state_0 |= 0x10;
                    this.short_cache = null;
                    return ex.getResult();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((state_0 & 4) == 0 && arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                ByteData s0_ = (ByteData)this.insert(new ByteData());
                s0_.valueStore_ = (LLVMI8StoreNode.LLVMI8OffsetStoreNode)s0_.insert(LLVMI8StoreNode.LLVMI8OffsetStoreNode.create());
                VarHandle.storeStoreFence();
                this.byte_cache = s0_;
                this.state_0_ = state_0 |= 2;
                try {
                    return this.doByte(frameValue, arg0Value_, arg1Value, s0_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    this.byte_cache = null;
                    return ex.getResult();
                }
            }
            if ((state_0 & 0x10) == 0 && arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                ShortData s1_ = (ShortData)this.insert(new ShortData());
                s1_.valueStore_ = (LLVMI16StoreNode.LLVMI16OffsetStoreNode)s1_.insert(LLVMI16StoreNode.LLVMI16OffsetStoreNode.create());
                VarHandle.storeStoreFence();
                this.short_cache = s1_;
                this.state_0_ = state_0 |= 8;
                try {
                    return this.doShort(frameValue, arg0Value_, arg1Value, s1_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFF7;
                    this.state_0_ = state_0 |= 0x10;
                    this.short_cache = null;
                    return ex.getResult();
                }
            }
            if ((state_0 & 0x40) == 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                IntData s2_ = (IntData)this.insert(new IntData());
                s2_.valueStore_ = (LLVMI32StoreNode.LLVMI32OffsetStoreNode)s2_.insert(LLVMI32StoreNode.LLVMI32OffsetStoreNode.create());
                VarHandle.storeStoreFence();
                this.int_cache = s2_;
                this.state_0_ = state_0 |= 0x20;
                try {
                    return this.doInt(frameValue, arg0Value_, arg1Value, s2_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFDF;
                    this.state_0_ = state_0 |= 0x40;
                    this.int_cache = null;
                    return ex.getResult();
                }
            }
            if ((state_0 & 0x100) == 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                LongData s3_ = (LongData)this.insert(new LongData());
                s3_.valueStore_ = (LLVMI64StoreNode.LLVMI64OffsetStoreNode)s3_.insert(LLVMI64StoreNode.LLVMI64OffsetStoreNode.create());
                VarHandle.storeStoreFence();
                this.long_cache = s3_;
                this.state_0_ = state_0 |= 0x80;
                try {
                    return this.doLong(frameValue, arg0Value_, arg1Value, s3_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFF7F;
                    this.state_0_ = state_0 |= 0x100;
                    this.long_cache = null;
                    return ex.getResult();
                }
            }
            if ((state_0 & 0x400) == 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                PointerData s4_ = (PointerData)this.insert(new PointerData());
                s4_.valueStore_ = (LLVMPointerStoreNode.LLVMPointerOffsetStoreNode)s4_.insert(LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.create());
                VarHandle.storeStoreFence();
                this.pointer_cache = s4_;
                this.state_0_ = state_0 |= 0x200;
                try {
                    return this.doPointer(frameValue, arg0Value_, arg1Value, s4_.valueStore_);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFDFF;
                    this.state_0_ = state_0 |= 0x400;
                    this.pointer_cache = null;
                    return ex.getResult();
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x2AA) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x2AA & (state_0 & 0x2AA) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            ByteData s0_ = (ByteData)this.insert(new ByteData());
            s0_.valueStore_ = (LLVMI8StoreNode.LLVMI8OffsetStoreNode)s0_.insert(LLVMI8StoreNode.LLVMI8OffsetStoreNode.create());
            VarHandle.storeStoreFence();
            this.byte_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.valueStore_, (int)1));
            ((GenerateAOT.Provider)s0_.valueStore_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            ShortData s1_ = (ShortData)this.insert(new ShortData());
            s1_.valueStore_ = (LLVMI16StoreNode.LLVMI16OffsetStoreNode)s1_.insert(LLVMI16StoreNode.LLVMI16OffsetStoreNode.create());
            VarHandle.storeStoreFence();
            this.short_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.valueStore_, (int)1));
            ((GenerateAOT.Provider)s1_.valueStore_).prepareForAOT(language, root);
            this.state_0_ |= 8;
            IntData s2_ = (IntData)this.insert(new IntData());
            s2_.valueStore_ = (LLVMI32StoreNode.LLVMI32OffsetStoreNode)s2_.insert(LLVMI32StoreNode.LLVMI32OffsetStoreNode.create());
            VarHandle.storeStoreFence();
            this.int_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.valueStore_, (int)1));
            ((GenerateAOT.Provider)s2_.valueStore_).prepareForAOT(language, root);
            this.state_0_ |= 0x20;
            LongData s3_ = (LongData)this.insert(new LongData());
            s3_.valueStore_ = (LLVMI64StoreNode.LLVMI64OffsetStoreNode)s3_.insert(LLVMI64StoreNode.LLVMI64OffsetStoreNode.create());
            VarHandle.storeStoreFence();
            this.long_cache = s3_;
            assert (NodeUtil.assertRecursion((Node)s3_.valueStore_, (int)1));
            ((GenerateAOT.Provider)s3_.valueStore_).prepareForAOT(language, root);
            this.state_0_ |= 0x80;
            PointerData s4_ = (PointerData)this.insert(new PointerData());
            s4_.valueStore_ = (LLVMPointerStoreNode.LLVMPointerOffsetStoreNode)s4_.insert(LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.create());
            VarHandle.storeStoreFence();
            this.pointer_cache = s4_;
            assert (NodeUtil.assertRecursion((Node)s4_.valueStore_, (int)1));
            ((GenerateAOT.Provider)s4_.valueStore_).prepareForAOT(language, root);
            this.state_0_ |= 0x200;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.byte_cache = null;
            this.short_cache = null;
            this.int_cache = null;
            this.long_cache = null;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMCompareExchangeNode.AllocResultNode create(long secondValueOffset, LLVMExpressionNode resultAllocation) {
            return new AllocResultNodeGen(secondValueOffset, resultAllocation);
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.AllocResultNode.class)
        @DenyReplace
        private static final class ByteData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8StoreNode.LLVMI8OffsetStoreNode valueStore_;

            ByteData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.AllocResultNode.class)
        @DenyReplace
        private static final class ShortData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16StoreNode.LLVMI16OffsetStoreNode valueStore_;

            ShortData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.AllocResultNode.class)
        @DenyReplace
        private static final class IntData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32StoreNode.LLVMI32OffsetStoreNode valueStore_;

            IntData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.AllocResultNode.class)
        @DenyReplace
        private static final class LongData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64StoreNode.LLVMI64OffsetStoreNode valueStore_;

            LongData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.AllocResultNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMPointerStoreNode.LLVMPointerOffsetStoreNode valueStore_;

            PointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }
}

