/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class SwitchInstruction
extends VoidInstruction
implements TerminatingInstruction {
    private SymbolImpl condition;
    private final InstructionBlock defaultBlock;
    private final SymbolImpl[] values;
    private final InstructionBlock[] blocks;

    private SwitchInstruction(InstructionBlock defaultBlock, int numCases) {
        this.defaultBlock = defaultBlock;
        this.values = new SymbolImpl[numCases];
        this.blocks = new InstructionBlock[numCases];
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public InstructionBlock getCaseBlock(int index) {
        return this.blocks[index];
    }

    public int getCaseCount() {
        return this.values.length;
    }

    public SymbolImpl getCaseValue(int index) {
        return this.values[index];
    }

    public SymbolImpl getCondition() {
        return this.condition;
    }

    public InstructionBlock getDefaultBlock() {
        return this.defaultBlock;
    }

    @Override
    public int getSuccessorCount() {
        return this.blocks.length + 1;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        assert (index >= 0 && index < this.getSuccessorCount());
        if (index >= this.blocks.length) {
            return this.defaultBlock;
        }
        return this.blocks[index];
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.condition == original) {
            this.condition = replacement;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != original) continue;
            this.values[i] = replacement;
        }
    }

    public static SwitchInstruction generate(FunctionDefinition function, SymbolTable symbols, int condition, int defaultBlock, int[] caseValues, int[] caseBlocks) {
        SwitchInstruction inst = new SwitchInstruction(function.getBlock(defaultBlock), caseBlocks.length);
        inst.condition = symbols.getForwardReferenced(condition, inst);
        for (int i = 0; i < caseBlocks.length; ++i) {
            inst.values[i] = symbols.getForwardReferenced(caseValues[i], inst);
            inst.blocks[i] = function.getBlock(caseBlocks[i]);
        }
        return inst;
    }
}

