/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFileDetector;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguageFactory;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.ToolchainImpl;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.Configurations;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprExecutableNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExprParser;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemorySizedOpNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.AggregateTLGlobalInPlaceNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.target.TargetTriple;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

@TruffleLanguage.Registration(id="llvm", name="LLVM", internal=false, interactive=false, defaultMimeType="application/x-llvm-ir-bitcode", byteMimeTypes={"application/x-llvm-ir-bitcode", "application/x-sharedlib", "application/x-executable", "application/x-mach-binary", "application/x-dosexec"}, fileTypeDetectors={LLVMFileDetector.class}, services={Toolchain.class}, version="16.0.1", contextPolicy=TruffleLanguage.ContextPolicy.SHARED, website="https://www.graalvm.org/${graalvm-website-version}/reference-manual/llvm/")
@ProvidedTags(value={StandardTags.StatementTag.class, StandardTags.CallTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, DebuggerTags.AlwaysHalt.class})
public class LLVMLanguage
extends TruffleLanguage<LLVMContext> {
    static final String LLVM_BITCODE_MIME_TYPE = "application/x-llvm-ir-bitcode";
    static final String LLVM_BITCODE_EXTENSION = "bc";
    static final String LLVM_ELF_SHARED_MIME_TYPE = "application/x-sharedlib";
    static final String LLVM_ELF_EXEC_MIME_TYPE = "application/x-executable";
    static final String LLVM_ELF_LINUX_EXTENSION = "so";
    static final String LLVM_MACHO_MIME_TYPE = "application/x-mach-binary";
    static final String LLVM_MS_DOS_MIME_TYPE = "application/x-dosexec";
    static final String MAIN_ARGS_KEY = "Sulong Main Args";
    static final String PARSE_ONLY_KEY = "Parse only";
    public static final String ID = "llvm";
    static final String NAME = "LLVM";
    @CompilerDirectives.CompilationFinal
    public boolean singleContext = true;
    @CompilerDirectives.CompilationFinal
    private Configuration activeConfiguration = null;
    private ContextExtensionKey<?>[] contextExtensions;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory cachedLLVMMemory;
    @CompilerDirectives.CompilationFinal
    private ByteArraySupport cachedByteArraySupport;
    private final EconomicMap<String, LLVMScope> internalFileScopes = EconomicMap.create();
    public final ContextThreadLocal<LLVMThreadLocalValue> contextThreadLocal = this.locals.createContextThreadLocal(LLVMThreadLocalValue::new);
    private final EconomicMap<String, LibraryCacheEntry> libraryCache = EconomicMap.create();
    private final ReferenceQueue<CallTarget> libraryCacheQueue = new ReferenceQueue();
    private final Object libraryCacheLock = new Object();
    private final IDGenerater idGenerater = new IDGenerater();
    private final LLDBSupport lldbSupport = new LLDBSupport();
    private final Assumption noCommonHandleAssumption = Truffle.getRuntime().createAssumption("no common handle");
    private final Assumption noDerefHandleAssumption = Truffle.getRuntime().createAssumption("no deref handle");
    private final LLVMInteropType.InteropTypeRegistry interopTypeRegistry = new LLVMInteropType.InteropTypeRegistry();
    private final ConcurrentHashMap<Class<?>, RootCallTarget> cachedCallTargets = new ConcurrentHashMap();
    private final EconomicMap<String, Source> defaultInternalLibraryCache = EconomicMap.create();
    private DataLayout defaultDataLayout;
    private TargetTriple defaultTargetTriple;
    @CompilerDirectives.CompilationFinal
    private LLVMFunctionCode sulongInitContextCode;
    @CompilerDirectives.CompilationFinal
    private LLVMFunction sulongDisposeContext;
    @CompilerDirectives.CompilationFinal
    private LLVMFunctionCode startFunctionCode;
    private static final TruffleLanguage.LanguageReference<LLVMLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(LLVMLanguage.class);
    private CallTarget freeGlobalBlocks;
    private LLVMMemorySizedOpNode freeOpNode;

    public LLVMLanguage() {
        this.noCommonHandleAssumption.isValid();
    }

    protected void initializeContext(LLVMContext context) {
        if (context.getEnv().isPreInitialization()) {
            context.initializationDeferred();
        } else {
            context.initialize(this.createContextExtensions(context.getEnv()));
        }
    }

    private ContextExtension[] createContextExtensions(TruffleLanguage.Env env) {
        ContextExtension[] ctxExts = new ContextExtension[this.contextExtensions.length];
        for (int i = 0; i < this.contextExtensions.length; ++i) {
            ContextExtensionKey<?> key = this.contextExtensions[i];
            Object ext = key.factory.create(env);
            ctxExts[i] = (ContextExtension)key.clazz.cast(ext);
        }
        return ctxExts;
    }

    public static LLVMContext getContext() {
        CompilerAsserts.neverPartOfCompilation((String)"Use faster context lookup methods for the fast-path.");
        return LLVMContext.get(null);
    }

    public static LLVMLanguage get(Node node) {
        return (LLVMLanguage)REFERENCE.get(node);
    }

    protected void initializeThread(LLVMContext context, Thread thread) {
        this.getCapability(PlatformCapability.class).initializeThread(context, thread);
        try (LLVMContext.TLSInitializerAccess access = context.getTLSInitializerAccess();){
            for (AggregateTLGlobalInPlaceNode globalInitializer : access.getThreadLocalGlobalInitializer()) {
                globalInitializer.executeWithThread(null, thread);
            }
            access.registerLiveThread(thread);
        }
    }

    public static CallTarget getLLDBLoadFunction(Type type) {
        LLVMLanguage language = LLVMLanguage.get(null);
        return language.lldbSupport.getLoadFunction(language, type);
    }

    public <C extends LLVMCapability> C getCapability(Class<C> type) {
        CompilerAsserts.partialEvaluationConstant(type);
        if (type == LLVMMemory.class) {
            return (C)((LLVMCapability)type.cast(this.getLLVMMemory()));
        }
        C ret = this.activeConfiguration.getCapability(type);
        if (CompilerDirectives.isPartialEvaluationConstant((Object)((Object)this))) {
            CompilerAsserts.partialEvaluationConstant(ret);
        }
        return ret;
    }

    public Assumption getNoCommonHandleAssumption() {
        return this.noCommonHandleAssumption;
    }

    public Assumption getNoDerefHandleAssumption() {
        return this.noDerefHandleAssumption;
    }

    public final String getLLVMLanguageHome() {
        return this.getLanguageHome();
    }

    public Configuration getActiveConfiguration() {
        if (this.activeConfiguration != null) {
            return this.activeConfiguration;
        }
        throw new IllegalStateException("No context, please create the context before accessing the configuration.");
    }

    public LLVMMemory getLLVMMemory() {
        assert (this.cachedLLVMMemory != null);
        return this.cachedLLVMMemory;
    }

    public ByteArraySupport getByteArraySupport() {
        assert (this.cachedByteArraySupport != null);
        return this.cachedByteArraySupport;
    }

    public LLVMScope getInternalFileScopes(String libraryName) {
        return (LLVMScope)this.internalFileScopes.get((Object)libraryName);
    }

    public void addInternalFileScope(String libraryName, LLVMScope scope) {
        this.internalFileScopes.put((Object)libraryName, (Object)scope);
    }

    public boolean isDefaultInternalLibraryCacheEmpty() {
        return this.defaultInternalLibraryCache.isEmpty();
    }

    public void setDefaultInternalLibraryCache(Source library) {
        this.defaultInternalLibraryCache.put((Object)library.getPath(), (Object)library);
    }

    public Source getDefaultInternalLibraryCache(String path) {
        return (Source)this.defaultInternalLibraryCache.get((Object)path);
    }

    public boolean isDefaultInternalLibrary(String path) {
        return this.defaultInternalLibraryCache.containsKey((Object)path);
    }

    protected LLVMContext createContext(TruffleLanguage.Env env) {
        this.ensureActiveConfiguration(env);
        ToolchainImpl toolchain = new ToolchainImpl(this.activeConfiguration.getCapability(ToolchainConfig.class), this);
        env.registerService((Object)toolchain);
        LLVMContext context = new LLVMContext(this, env, toolchain);
        return context;
    }

    private synchronized void ensureActiveConfiguration(TruffleLanguage.Env env) {
        if (this.activeConfiguration == null) {
            final ArrayList ctxExts = new ArrayList();
            ContextExtension.Registry r = new ContextExtension.Registry(){
                private int count;

                @Override
                public <C extends ContextExtension> ContextExtension.Key<C> register(Class<C> type, ContextExtension.Factory<C> factory) {
                    ContextExtensionKey<C> key = new ContextExtensionKey<C>(type, this.count++, factory);
                    ctxExts.add(key);
                    assert (this.count == ctxExts.size());
                    return key;
                }
            };
            this.activeConfiguration = Configurations.createConfiguration(this, r, env.getOptions());
            this.cachedLLVMMemory = this.activeConfiguration.getCapability(LLVMMemory.class);
            ByteOrder order = this.activeConfiguration.getCapability(PlatformCapability.class).getPlatformByteOrder();
            if (order == ByteOrder.LITTLE_ENDIAN) {
                this.cachedByteArraySupport = ByteArraySupport.littleEndian();
            } else if (order == ByteOrder.BIG_ENDIAN) {
                this.cachedByteArraySupport = ByteArraySupport.bigEndian();
            } else {
                throw new IllegalStateException("unexpected byte order " + order);
            }
            this.contextExtensions = ctxExts.toArray(ContextExtensionKey.EMPTY);
        }
    }

    public <C extends ContextExtension> ContextExtension.Key<C> lookupContextExtension(Class<C> type) {
        CompilerAsserts.neverPartOfCompilation();
        for (ContextExtensionKey<?> key : this.contextExtensions) {
            if (type != key.clazz) continue;
            return key.cast(type);
        }
        return null;
    }

    protected ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) {
        Object globalScope = this.getScope(LLVMLanguage.getContext());
        DebugExprParser d = new DebugExprParser(request, globalScope);
        try {
            return new DebugExprExecutableNode(d.parse());
        }
        catch (DebugExprException | LLVMParserException e) {
            final String errorMessage = e.getMessage();
            return new ExecutableNode(this){

                public Object execute(VirtualFrame frame) {
                    return errorMessage;
                }
            };
        }
    }

    protected boolean patchContext(LLVMContext context, TruffleLanguage.Env newEnv) {
        boolean compatible = Configurations.areOptionsCompatible(context.getEnv().getOptions(), newEnv.getOptions());
        if (!compatible) {
            return false;
        }
        return context.patchContext(newEnv, this.createContextExtensions(newEnv));
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return Configurations.areOptionsCompatible(firstOptions, newOptions);
    }

    protected void exitContext(LLVMContext context, TruffleLanguage.ExitMode exitMode, int exitCode) {
        context.exitContext(this.sulongDisposeContext);
    }

    protected void finalizeContext(LLVMContext context) {
        context.finalizeContext();
    }

    protected void disposeContext(LLVMContext context) {
        context.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeThreadLocalGlobal(LLVMThreadLocalValue threadLocalValue) {
        if (threadLocalValue != null) {
            LLVMThreadLocalValue lLVMThreadLocalValue = threadLocalValue;
            synchronized (lLVMThreadLocalValue) {
                if (!threadLocalValue.isDisposed()) {
                    for (LLVMThreadLocalAllocation lLVMThreadLocalAllocation : threadLocalValue.sections) {
                        if (lLVMThreadLocalAllocation == null) continue;
                        this.freeOpNode.execute(lLVMThreadLocalAllocation.getPointer(), lLVMThreadLocalAllocation.getSize());
                    }
                    for (LLVMThreadLocalAllocation lLVMThreadLocalAllocation : threadLocalValue.globalContainers) {
                        if (lLVMThreadLocalAllocation == null) continue;
                        for (LLVMThreadLocalAllocation globalContainer : lLVMThreadLocalAllocation) {
                            if (globalContainer == null) continue;
                            ((LLVMGlobalContainer)((Object)globalContainer)).dispose();
                        }
                    }
                    threadLocalValue.setDisposed();
                }
            }
        }
    }

    public void setSulongInitContext(LLVMFunction function) {
        this.sulongInitContextCode = new LLVMFunctionCode(function);
    }

    public void setSulongDisposeContext(LLVMFunction function) {
        this.sulongDisposeContext = function;
    }

    public void setStartFunctionCode(LLVMFunctionCode startFunctionCode) {
        this.startFunctionCode = startFunctionCode;
    }

    public LLVMFunctionCode getStartFunctionCode() {
        assert (this.startFunctionCode != null);
        return this.startFunctionCode;
    }

    protected void initFreeGlobalBlocks(NodeFactory nodeFactory) {
        if (this.freeGlobalBlocks == null) {
            this.freeGlobalBlocks = new FreeGlobalsNode(this, nodeFactory).getCallTarget();
        }
        if (this.freeOpNode == null) {
            this.freeOpNode = nodeFactory.getFreeGlobalsBlockUncached();
        }
    }

    public CallTarget getFreeGlobalBlocks() {
        return this.freeGlobalBlocks;
    }

    public synchronized void setDefaultBitcode(DataLayout datalayout, TargetTriple targetTriple) {
        if (this.defaultDataLayout != null) {
            throw new IllegalStateException("The default datalayout cannot be overwritten");
        }
        this.defaultDataLayout = datalayout;
        if (this.defaultTargetTriple != null) {
            throw new IllegalStateException("The default targetTriple cannot be overwritten");
        }
        this.defaultTargetTriple = targetTriple;
    }

    public DataLayout getDefaultDataLayout() {
        return this.defaultDataLayout;
    }

    public TargetTriple getDefaultTargetTriple() {
        return this.defaultTargetTriple;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMInteropType getInteropType(LLVMSourceType sourceType) {
        return this.interopTypeRegistry.get(sourceType);
    }

    public LLVMStatementNode createInitializeContextNode() {
        if (this.sulongInitContextCode == null) {
            throw new IllegalStateException("Context cannot be initialized:__sulong_init_context was not found");
        }
        return LLVMLanguageFactory.InitializeContextNodeGen.create(this.sulongInitContextCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        if (LLVMContext.get(null).getEnv().isPreInitialization()) {
            throw new UnsupportedOperationException("Parsing not supported during context pre-initialization");
        }
        Source source = request.getSource();
        String path = source.getPath();
        if (source.isCached()) {
            Object object = this.libraryCacheLock;
            synchronized (object) {
                CallTarget cached = this.getCachedLibrary(path);
                if (cached == null) {
                    assert (!this.libraryCache.containsKey((Object)path)) : "racy insertion despite lock?";
                    IDGenerater.BitcodeID id = this.idGenerater.generateID();
                    cached = this.getCapability(Loader.class).load(LLVMLanguage.getContext(), source, id);
                    LibraryCacheEntry entry = new LibraryCacheEntry(this, path, cached, id);
                    this.libraryCache.put((Object)path, (Object)entry);
                }
                return cached;
            }
        }
        return this.getCapability(Loader.class).load(LLVMLanguage.getContext(), source, this.idGenerater.generateID());
    }

    public MapCursor<String, LibraryCacheEntry> getLibraryCache() {
        return this.libraryCache.getEntries();
    }

    private void lazyCacheCleanup() {
        LibraryCacheEntry ref = (LibraryCacheEntry)this.libraryCacheQueue.poll();
        if (ref != null) {
            this.libraryCache.removeKey((Object)ref.path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public CallTarget getCachedLibrary(String path) {
        Object object = this.libraryCacheLock;
        synchronized (object) {
            this.lazyCacheCleanup();
            LibraryCacheEntry entry = (LibraryCacheEntry)this.libraryCache.get((Object)path);
            if (entry == null) {
                return null;
            }
            assert (entry.path.equals(path));
            CallTarget ret = (CallTarget)entry.get();
            if (ret == null) {
                this.libraryCache.removeKey((Object)entry.path);
            }
            return ret;
        }
    }

    protected Object getScope(LLVMContext context) {
        return context.getGlobalScopeChain();
    }

    protected OptionDescriptors getOptionDescriptors() {
        return Configurations.getOptionDescriptors();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected void disposeThread(LLVMContext context, Thread thread) {
        this.getCapability(PlatformCapability.class).disposeThread(context, thread);
        super.disposeThread((Object)context, thread);
        if (context.isInitialized()) {
            context.getThreadingStack().freeStack(this.getLLVMMemory(), thread);
        }
        LLVMThreadLocalValue threadLocalValue = (LLVMThreadLocalValue)this.contextThreadLocal.get(context.getEnv().getContext(), thread);
        threadLocalValue.removeThreadLocalStorage();
        if (!threadLocalValue.isDisposed()) {
            this.freeThreadLocalGlobal(threadLocalValue);
        }
        try (LLVMContext.TLSInitializerAccess access = context.getTLSInitializerAccess();){
            access.unregisterLiveThread(thread);
        }
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContext = false;
    }

    public RootCallTarget createCachedCallTarget(Class<?> key, Function<LLVMLanguage, RootNode> create) {
        return this.cachedCallTargets.computeIfAbsent(key, k -> ((RootNode)create.apply(this)).getCallTarget());
    }

    @Idempotent
    public static boolean isSingleContext(Node node) {
        return LLVMLanguage.get((Node)node).singleContext;
    }

    private static final class ContextExtensionKey<C extends ContextExtension>
    extends ContextExtension.Key<C> {
        private static final ContextExtensionKey<?>[] EMPTY = new ContextExtensionKey[0];
        private final Class<? extends C> clazz;
        private final int index;
        private final ContextExtension.Factory<C> factory;

        ContextExtensionKey(Class<C> clazz, int index, ContextExtension.Factory<C> factory) {
            this.clazz = clazz;
            this.index = index;
            this.factory = factory;
        }

        @Override
        public C get(LLVMContext ctx) {
            CompilerAsserts.compilationConstant(this.clazz);
            return (C)((ContextExtension)this.clazz.cast(ctx.getContextExtension(this.index)));
        }

        private <U extends ContextExtension> ContextExtensionKey<U> cast(Class<U> target) {
            Class<U> c = this.clazz.asSubclass(target);
            assert (c == this.clazz);
            return this;
        }
    }

    public static class LLVMThreadLocalValue {
        final LLVMContext context;
        LLVMThreadLocalAllocation[] sections = new LLVMThreadLocalAllocation[10];
        final WeakReference<Thread> thread;
        boolean isDisposed;
        LLVMStack stack;
        LLVMPointer localStorage;
        LLVMGlobalContainer[][] globalContainers = new LLVMGlobalContainer[10][];
        List<LLVMUserException> exceptionStack = new ArrayList<LLVMUserException>();

        LLVMThreadLocalValue(LLVMContext context, Thread thread) {
            this.context = context;
            this.thread = new WeakReference<Thread>(thread);
            this.isDisposed = false;
            this.localStorage = LLVMNativePointer.createNull();
        }

        public void addSection(LLVMPointer sectionBase, long size, IDGenerater.BitcodeID bitcodeID) {
            assert (sectionBase != null);
            assert (size > 0L);
            int index = bitcodeID.getId();
            if (index >= this.sections.length) {
                int newLength = index + 1 + (index + 1) / 2;
                this.sections = Arrays.copyOf(this.sections, newLength);
            }
            this.sections[index] = new LLVMThreadLocalAllocation(sectionBase, size);
        }

        public LLVMThreadLocalAllocation getSection(IDGenerater.BitcodeID bitcodeID) {
            int index = bitcodeID.getId();
            return index < this.sections.length ? this.sections[index] : null;
        }

        public LLVMPointer getSectionBase(IDGenerater.BitcodeID bitcodeID) {
            LLVMThreadLocalAllocation section = this.getSection(bitcodeID);
            return section == null ? null : section.getPointer();
        }

        public void setDisposed() {
            this.isDisposed = true;
        }

        public boolean isDisposed() {
            return this.isDisposed;
        }

        public LLVMPointer getThreadLocalStorage() {
            return this.localStorage;
        }

        public void setThreadLocalStorage(LLVMPointer value) {
            this.localStorage = value;
        }

        public void removeThreadLocalStorage() {
            this.localStorage = LLVMNativePointer.createNull();
        }

        public LLVMStack getLLVMStack() {
            return this.stack;
        }

        public void pushException(LLVMUserException exception) {
            this.exceptionStack.add(exception);
        }

        public LLVMUserException popException() {
            return this.exceptionStack.remove(this.exceptionStack.size() - 1);
        }

        public boolean hasException() {
            return !this.exceptionStack.isEmpty();
        }

        public void setLLVMStack(LLVMStack stack) {
            assert (this.stack == null);
            this.stack = stack;
        }

        public LLVMStack removeLLVMStack() {
            LLVMStack tmp = this.stack;
            this.stack = null;
            return tmp;
        }

        public void addGlobalContainer(LLVMGlobalContainer[] globalContainer, IDGenerater.BitcodeID bitcodeID) {
            int id = bitcodeID.getId();
            if (id >= this.globalContainers.length) {
                int newLength = id + 1 + (id + 1) / 2;
                this.globalContainers = (LLVMGlobalContainer[][])Arrays.copyOf(this.globalContainers, newLength);
            }
            this.globalContainers[id] = globalContainer;
        }

        public LLVMGlobalContainer getGlobalContainer(int index, IDGenerater.BitcodeID bitcodeID) {
            int id = bitcodeID.getId();
            assert (0 < id && id < this.globalContainers.length);
            assert (0 < index && index < this.globalContainers[id].length);
            return this.globalContainers[id][index];
        }
    }

    public static class LLVMThreadLocalAllocation {
        private LLVMPointer pointer;
        private long size;

        public LLVMThreadLocalAllocation(LLVMPointer pointer, long size) {
            this.pointer = pointer;
            this.size = size;
        }

        public LLVMPointer getPointer() {
            return this.pointer;
        }

        public long getSize() {
            return this.size;
        }
    }

    static class FreeGlobalsNode
    extends RootNode {
        @Node.Child
        LLVMMemorySizedOpNode freeNode;

        FreeGlobalsNode(LLVMLanguage language, NodeFactory nodeFactory) {
            super((TruffleLanguage)language);
            this.freeNode = nodeFactory.createFreeGlobalsBlock();
        }

        public Object execute(VirtualFrame frame) {
            LLVMContext context = LLVMContext.get((Node)this);
            for (int i = 0; i < context.globalsBlockStore.size(); ++i) {
                Pair<LLVMPointer, Long> store = FreeGlobalsNode.getElement(context.globalsBlockStore, i);
                if (store == null) continue;
                this.freeNode.doPair(store);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static <T> T getElement(EconomicMap<Integer, T> list, int idx) {
            return (T)list.get((Object)idx);
        }
    }

    static abstract class InitializeContextNode
    extends LLVMStatementNode {
        @Node.Child
        private DirectCallNode initContext;

        InitializeContextNode(LLVMFunctionCode initContextFunctionCode) {
            RootCallTarget initContextFunction = initContextFunctionCode.getLLVMIRFunctionSlowPath();
            this.initContext = DirectCallNode.create((CallTarget)initContextFunction);
        }

        @Specialization
        public void doInit() {
            LLVMContext ctx = LLVMContext.get(this);
            if (!ctx.initialized) {
                assert (!ctx.cleanupNecessary);
                ctx.initialized = true;
                ctx.cleanupNecessary = true;
                Object[] args = new Object[]{ctx.getThreadingStack().getStack(this), ctx.getApplicationArguments(), LLVMContext.getEnvironmentVariables(), LLVMContext.getRandomValues()};
                this.initContext.call(args);
            }
        }
    }

    public static abstract class Loader
    implements LLVMCapability {
        public abstract CallTarget load(LLVMContext var1, Source var2, IDGenerater.BitcodeID var3);
    }

    static final class LibraryCacheEntry
    extends WeakReference<CallTarget> {
        final String path;
        final WeakReference<IDGenerater.BitcodeID> id;

        LibraryCacheEntry(LLVMLanguage language, String path, CallTarget callTarget, IDGenerater.BitcodeID id) {
            super(callTarget, language.libraryCacheQueue);
            this.path = path;
            this.id = new WeakReference<IDGenerater.BitcodeID>(id);
        }
    }
}

