/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class NativeContextExtension
implements ContextExtension {
    public abstract NativePointerIntoLibrary getNativeHandle(String var1);

    public abstract CallTarget createNativeWrapperFactory(LLVMFunctionCode var1);

    public abstract void addLibraryHandles(Object var1);

    public abstract CallTarget parseNativeLibrary(String var1, LLVMContext var2) throws UnsatisfiedLinkError;

    public abstract NativeLookupResult getNativeFunctionOrNull(String var1);

    public abstract WellKnownNativeFunctionNode getWellKnownNativeFunction(String var1, String var2);

    public abstract WellKnownNativeFunctionAndSignature getWellKnownNativeFunctionAndSignature(String var1, String var2);

    public abstract Object getNativeFunction(String var1, String var2);

    public abstract Source getNativeSignatureSourceSkipStackArg(FunctionType var1) throws UnsupportedNativeTypeException;

    public abstract Object createSignature(Source var1);

    public abstract Object bindSignature(LLVMFunctionCode var1, Source var2);

    public abstract Object bindSignature(long var1, Source var3);

    public static String getNativeLibrary(String libname) {
        return NativeContextExtension.getNativeLibraryPrefix() + libname + "." + NativeContextExtension.getNativeLibrarySuffix();
    }

    public static String getNativeLibraryVersioned(String libname, int version) {
        return NativeContextExtension.getNativeLibraryPrefix() + libname + "." + NativeContextExtension.getNativeLibrarySuffixVersioned(version);
    }

    public static String getNativeLibraryPrefix() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return "";
        }
        return "lib";
    }

    public static String getNativeLibrarySuffix() {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return "dylib";
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return "dll";
        }
        return "so";
    }

    public static String getNativeLibrarySuffixVersioned(int version) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return version + ".dylib";
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return "dll";
        }
        return "so." + version;
    }

    public static final class WellKnownNativeFunctionAndSignature {
        private final Object signature;
        private final Object function;
        private final Object boundSignature;

        public WellKnownNativeFunctionAndSignature(Object signature, Object function, Object boundSignature) {
            this.signature = signature;
            this.function = function;
            this.boundSignature = boundSignature;
        }

        public Object getSignature() {
            return this.signature;
        }

        public Object getFunction() {
            return this.function;
        }

        public Object getBoundSignature() {
            return this.boundSignature;
        }
    }

    public static abstract class WellKnownNativeFunctionNode
    extends LLVMNode {
        public final Object execute(Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            return this.executeImpl(args);
        }

        protected abstract Object executeImpl(Object[] var1) throws ArityException, UnsupportedMessageException, UnsupportedTypeException;
    }

    public static final class NativePointerIntoLibrary {
        private final long address;

        public NativePointerIntoLibrary(long address) {
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }
    }

    public static final class NativeLookupResult {
        private final Object object;

        public NativeLookupResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class UnsupportedNativeTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final transient Type type;

        public UnsupportedNativeTypeException(Type type) {
            super("unsupported type " + type + " in native interop");
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }
}

