/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBMemoryValue;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMToDebugDeclaration
implements LLVMDebugValue.Builder {
    private static final LLVMNativePointerSupport.IsPointerNode IS_POINTER_NODE = LLVMNativePointerSupportFactory.IsPointerNodeGen.getUncached();
    private static final LLVMNativePointerSupport.ToNativePointerNode TO_NATIVE_POINTER_NODE = LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached();
    private static final LLVMToDebugDeclaration INSTANCE = new LLVMToDebugDeclaration();

    public static LLVMDebugValue.Builder getInstance() {
        return INSTANCE;
    }

    private LLVMToDebugDeclaration() {
    }

    @Override
    public LLVMDebugValue build(Object value) {
        Object target;
        LLVMPointer pointer;
        if (LLVMPointer.isInstance(value)) {
            pointer = LLVMPointer.cast(value);
        } else {
            if (!IS_POINTER_NODE.execute(value)) {
                return LLVMDebugValue.UNAVAILABLE;
            }
            pointer = TO_NATIVE_POINTER_NODE.execute(value);
        }
        if (LLVMManagedPointer.isInstance(pointer) && (target = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMGlobalContainer) {
            return LLVMToDebugDeclaration.fromGlobalContainer((LLVMGlobalContainer)target);
        }
        return new LLDBMemoryValue(pointer);
    }

    private static LLVMDebugValue fromGlobalContainer(LLVMGlobalContainer globalContainer) {
        if (globalContainer.isPointer()) {
            try {
                return new LLDBMemoryValue(LLVMNativePointer.create(globalContainer.asPointer()));
            }
            catch (UnsupportedMessageException e) {
                return LLVMDebugValue.UNAVAILABLE;
            }
        }
        Object currentValue = globalContainer.get();
        if (LLVMPointer.isInstance(currentValue)) {
            return new LLDBMemoryValue(LLVMPointer.cast(currentValue));
        }
        return new LLDBMemoryValue(LLVMManagedPointer.create(currentValue));
    }
}

