/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMStructLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMStructLoadNode.class)
public final class LLVMStructLoadNodeGen
extends LLVMStructLoadNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode address_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMStructLoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(addressValue);
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            return this.doPointer(addressValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return this.doPointer(addressValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue_);
    }

    private LLVMPointer executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            this.state_0_ = state_0 |= 2;
            return this.doPointer(addressValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMStructLoadNode create(LLVMExpressionNode address) {
        return new LLVMStructLoadNodeGen(address);
    }
}

