/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI1RMWNode
extends LLVMExpressionNode {

    public static abstract class LLVMI1RMWXorNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI1RMWOrNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> a | b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, result | value);
                return result;
            }
        }
    }

    public static abstract class LLVMI1RMWNandNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> !(a & b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, !(result & value));
                return result;
            }
        }
    }

    public static abstract class LLVMI1RMWAndNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> a & b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, result & value);
                return result;
            }
        }
    }

    public static abstract class LLVMI1RMWSubNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI1RMWAddNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI1RMWXchgNode
    extends LLVMI1RMWNode {
        @Specialization
        protected boolean doOp(LLVMNativePointer address, boolean value) {
            return this.getLanguage().getLLVMMemory().getAndOpI1(this, address, value, (a, b) -> b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected boolean doOp(LLVMManagedPointer address, boolean value, @Cached LLVMI1LoadNode read, @Cached LLVMI1StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean result = read.executeWithTarget(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

