/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMDynAccessSymbolNode
extends LLVMNode {
    public abstract LLVMPointer execute(LLVMSymbol var1);

    @CompilerDirectives.TruffleBoundary
    private LLVMLinkerException notFound(LLVMSymbol symbol) {
        throw new LLVMLinkerException((Node)this, "External %s %s cannot be found.", symbol.getKind(), symbol.getName());
    }

    @Specialization
    LLVMPointer doAccess(LLVMSymbol symbol, @Cached BranchProfile exception) {
        LLVMPointer value = this.getContext().getSymbolResolved(symbol, exception);
        if (value != null) {
            return value;
        }
        exception.enter();
        throw this.notFound(symbol);
    }
}

