/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMNativeLibrary.class, useForAOT=false), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=2)})
public final class LLVMFunctionDescriptor
extends LLVMInternalTruffleObject
implements Comparable<LLVMFunctionDescriptor> {
    private static final long SULONG_FUNCTION_POINTER_TAG = -4981268375154982912L;
    private final LLVMFunction llvmFunction;
    private final LLVMFunctionCode functionCode;
    @CompilerDirectives.CompilationFinal
    private Object nativeWrapper;
    @CompilerDirectives.CompilationFinal
    private long nativePointer;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xBADEFACE00000000L;
    }

    public LLVMFunction getLLVMFunction() {
        return this.llvmFunction;
    }

    public LLVMFunctionCode getFunctionCode() {
        return this.functionCode;
    }

    public long getNativePointer() {
        return this.nativePointer;
    }

    public LLVMFunctionDescriptor(LLVMFunction llvmFunction, LLVMFunctionCode functionCode) {
        CompilerAsserts.neverPartOfCompilation();
        this.llvmFunction = llvmFunction;
        this.functionCode = functionCode;
    }

    public String toString() {
        return String.format("function@%d '%s'", this.llvmFunction.getSymbolIndexIllegalOk(), this.llvmFunction.getName());
    }

    @Override
    public int compareTo(LLVMFunctionDescriptor o) {
        int otherIndex = o.llvmFunction.getSymbolIndexIllegalOk();
        IDGenerater.BitcodeID otherBitcodeID = o.llvmFunction.getBitcodeIDIllegalOk();
        int index = this.llvmFunction.getSymbolIndexIllegalOk();
        IDGenerater.BitcodeID bitcodeID = this.llvmFunction.getBitcodeIDIllegalOk();
        if (bitcodeID == otherBitcodeID) {
            return Long.compare(index, otherIndex);
        }
        throw new IllegalStateException("Comparing functions from different bitcode files.");
    }

    @ExportMessage
    public long asPointer(@Cached @Cached.Exclusive BranchProfile exception) throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.nativePointer;
        }
        exception.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean isPointer() {
        return this.nativeWrapper != null;
    }

    @ExportMessage
    public LLVMFunctionDescriptor toNative() {
        if (this.nativeWrapper == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeWrapper = this.functionCode.getFunction().createNativeWrapper(this);
            try {
                this.nativePointer = ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer(this.nativeWrapper);
            }
            catch (UnsupportedMessageException ex) {
                this.nativePointer = LLVMFunctionDescriptor.tagSulongFunctionPointer(this.llvmFunction.getSymbolIndexIllegalOk());
            }
        }
        return this;
    }

    @ExportMessage
    public LLVMNativePointer toNativePointer(@CachedLibrary(value="this") LLVMNativeLibrary self, @Cached @Cached.Exclusive BranchProfile exceptionProfile) {
        try {
            return this.asNativePointer(exceptionProfile);
        }
        catch (UnsupportedMessageException e) {
            exceptionProfile.enter();
            throw new LLVMPolyglotException((Node)self, "Cannot convert %s to native pointer.", this);
        }
    }

    public LLVMNativePointer asNativePointer(BranchProfile exceptionProfile) throws UnsupportedMessageException {
        if (!this.isPointer()) {
            this.toNative();
        }
        return LLVMNativePointer.create(this.asPointer(exceptionProfile));
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean isInstantiable() {
        return true;
    }

    @ExportMessage
    Object instantiate(Object[] arguments, @Cached.Exclusive @Cached IndirectCallNode call) {
        Object[] newArgs = new Object[arguments.length + 1];
        for (int i = 0; i < arguments.length; ++i) {
            newArgs[i + 1] = arguments[i];
        }
        return call.call(this.functionCode.getForeignConstructorCallTarget(), newArgs);
    }

    @ExportMessage
    public boolean hasExecutableName() {
        return this.llvmFunction.getSourceLocation() != null && this.llvmFunction.getSourceLocation().getName() != null;
    }

    @ExportMessage
    public Object getExecutableName() throws UnsupportedMessageException {
        if (this.hasExecutableName()) {
            return this.llvmFunction.getSourceLocation().getName();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return this.llvmFunction.getSourceLocation() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public SourceSection getSourceLocation() throws UnsupportedMessageException {
        if (this.hasSourceLocation()) {
            return this.llvmFunction.getSourceLocation().getSourceSection();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static boolean isForeign(LLVMFunctionDescriptor receiver) {
        return false;
    }

    static {
        boolean bl = $assertionsDisabled = !LLVMFunctionDescriptor.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !LLVMHandleMemoryBase.isCommonHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && LLVMHandleMemoryBase.isDerefHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class Execute {
        Execute() {
        }

        @Specialization(limit="5", guards={"self == cachedSelf", "isSingleContext($node)"})
        static Object doDescriptor(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self") LLVMFunctionDescriptor cachedSelf, @Cached(value="createCall(cachedSelf)") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doDescriptor"}, limit="5", guards={"self.getFunctionCode() == cachedFunctionCode"})
        static Object doCached(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCall(self)") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doCached"})
        static Object doPolymorphic(LLVMFunctionDescriptor self, Object[] args, @Cached.Exclusive @Cached IndirectCallNode call) {
            return call.call(self.getFunctionCode().getForeignCallTarget(), args);
        }

        protected static DirectCallNode createCall(LLVMFunctionDescriptor self) {
            DirectCallNode callNode = DirectCallNode.create((CallTarget)self.getFunctionCode().getForeignCallTarget());
            callNode.forceInlining();
            return callNode;
        }
    }
}

