/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemMoveFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.move.LLVMPrimitiveMoveNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMMemMove {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="dest"), @NodeChild(type=LLVMExpressionNode.class, value="src"), @NodeChild(type=LLVMExpressionNode.class, value="length"), @NodeChild(type=LLVMExpressionNode.class, value="isVolatile")})
    public static abstract class LLVMMemMoveI64
    extends LLVMBuiltin {
        @Node.Child
        private LLVMMemMoveNode memMove;

        public LLVMMemMoveI64(LLVMMemMoveNode memMove) {
            this.memMove = memMove;
        }

        public static LLVMExpressionNode createIntrinsic(LLVMExpressionNode[] args, LLVMMemMoveNode memMove, NodeFactory nodeFactory) {
            LLVMExpressionNode serialMovesReplacement = LLVMPrimitiveMoveNode.createSerialMoves(args, nodeFactory, memMove);
            if (serialMovesReplacement != null) {
                return serialMovesReplacement;
            }
            if (args.length == 6) {
                return LLVMMemMoveFactory.LLVMMemMoveI64NodeGen.create(memMove, args[1], args[2], args[3], args[5]);
            }
            if (args.length == 5) {
                return LLVMMemMoveFactory.LLVMMemMoveI64NodeGen.create(memMove, args[1], args[2], args[3], args[4]);
            }
            throw new LLVMParserException("Illegal number of arguments to @llvm.memmove.*: " + args.length);
        }

        @Specialization
        protected Object doVoid(LLVMPointer dest, LLVMPointer source, long length, boolean isVolatile) {
            this.memMove.executeWithTarget(dest, source, length);
            return null;
        }
    }
}

