// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor.Execute;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(LLVMFunctionDescriptor.class)
@SuppressWarnings("javadoc")
public final class LLVMFunctionDescriptorGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMFunctionDescriptor.class, new InteropLibraryExports(), new LLVMNativeLibraryExports(), new LLVMAsForeignLibraryExports());
    }

    private LLVMFunctionDescriptorGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(LLVMFunctionDescriptor.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMFunctionDescriptor.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMFunctionDescriptor;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMFunctionDescriptor;
            return new Cached(receiver);
        }

        @GeneratedBy(LLVMFunctionDescriptor.class)
        private static final class Cached extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Cached {

            static final ReferenceField<ExecuteDescriptorData> EXECUTE_DESCRIPTOR_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "execute_descriptor_cache", ExecuteDescriptorData.class);
            static final ReferenceField<ExecuteCachedData> EXECUTE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "execute_cached_cache", ExecuteCachedData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Execute#doDescriptor}
             *   1: SpecializationActive {@link Execute#doCached}
             *   2: SpecializationActive {@link Execute#doPolymorphic}
             *   3: SpecializationActive {@link LLVMFunctionDescriptor#asPointer(LLVMFunctionDescriptor, BranchProfile)}
             *   4: SpecializationActive {@link LLVMFunctionDescriptor#instantiate(LLVMFunctionDescriptor, Object[], IndirectCallNode)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private ExecuteDescriptorData execute_descriptor_cache;
            @UnsafeAccessedField @Child private ExecuteCachedData execute_cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Execute#doPolymorphic}
             *   Parameter: {@link IndirectCallNode} call</pre>
             */
            @Child private IndirectCallNode execute_polymorphic_call_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMFunctionDescriptor#asPointer(LLVMFunctionDescriptor, BranchProfile)}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile asPointerNode__asPointer_exception_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMFunctionDescriptor#instantiate(LLVMFunctionDescriptor, Object[], IndirectCallNode)}
             *   Parameter: {@link IndirectCallNode} call</pre>
             */
            @Child private IndirectCallNode instantiateNode__instantiate_call_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Execute#doDescriptor}
             *     Activation probability: 0.16111
             *     With/without class size: 8/8 bytes
             *   Specialization {@link Execute#doCached}
             *     Activation probability: 0.11111
             *     With/without class size: 7/8 bytes
             *   Specialization {@link Execute#doPolymorphic}
             *     Activation probability: 0.06111
             *     With/without class size: 5/4 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.Execute.doDescriptor(LLVMFunctionDescriptor, Object[], LLVMFunctionDescriptor, DirectCallNode)] || SpecializationActive[LLVMFunctionDescriptor.Execute.doCached(LLVMFunctionDescriptor, Object[], LLVMFunctionCode, DirectCallNode)] || SpecializationActive[LLVMFunctionDescriptor.Execute.doPolymorphic(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.Execute.doDescriptor(LLVMFunctionDescriptor, Object[], LLVMFunctionDescriptor, DirectCallNode)] */) {
                        ExecuteDescriptorData s0_ = this.execute_descriptor_cache;
                        while (s0_ != null) {
                            if ((arg0Value == s0_.cachedSelf_)) {
                                assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(s0_)));
                                return Execute.doDescriptor(arg0Value, arg1Value, s0_.cachedSelf_, s0_.call_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.Execute.doCached(LLVMFunctionDescriptor, Object[], LLVMFunctionCode, DirectCallNode)] */) {
                        ExecuteCachedData s1_ = this.execute_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.getFunctionCode() == s1_.cachedFunctionCode_)) {
                                return Execute.doCached(arg0Value, arg1Value, s1_.cachedFunctionCode_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.Execute.doPolymorphic(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */) {
                        {
                            IndirectCallNode call__ = this.execute_polymorphic_call_;
                            if (call__ != null) {
                                return Execute.doPolymorphic(arg0Value, arg1Value, call__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b110)) == 0 /* is-not SpecializationActive[LLVMFunctionDescriptor.Execute.doCached(LLVMFunctionDescriptor, Object[], LLVMFunctionCode, DirectCallNode)] && SpecializationActive[LLVMFunctionDescriptor.Execute.doPolymorphic(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */) {
                    while (true) {
                        int count0_ = 0;
                        ExecuteDescriptorData s0_ = EXECUTE_DESCRIPTOR_CACHE_UPDATER.getVolatile(this);
                        ExecuteDescriptorData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value == s0_.cachedSelf_)) {
                                assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(s0_)));
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (arg0Value == s0_.cachedSelf_);
                            {
                                s0_ = this.insert(new ExecuteDescriptorData(s0_original));
                                if ((LLVMLanguage.isSingleContext(s0_))) {
                                    if (count0_ < (5)) {
                                        s0_.cachedSelf_ = (arg0Value);
                                        s0_.call_ = s0_.insert((Execute.createCall(s0_.cachedSelf_)));
                                        if (!EXECUTE_DESCRIPTOR_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[LLVMFunctionDescriptor.Execute.doDescriptor(LLVMFunctionDescriptor, Object[], LLVMFunctionDescriptor, DirectCallNode)] */;
                                        this.state_0_ = state_0;
                                    } else {
                                        s0_ = null;
                                    }
                                } else {
                                    s0_ = null;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return Execute.doDescriptor(arg0Value, arg1Value, s0_.cachedSelf_, s0_.call_);
                        }
                        break;
                    }
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMFunctionDescriptor.Execute.doPolymorphic(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */) {
                    while (true) {
                        int count1_ = 0;
                        ExecuteCachedData s1_ = EXECUTE_CACHED_CACHE_UPDATER.getVolatile(this);
                        ExecuteCachedData s1_original = s1_;
                        while (s1_ != null) {
                            if ((arg0Value.getFunctionCode() == s1_.cachedFunctionCode_)) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                LLVMFunctionCode cachedFunctionCode__ = (arg0Value.getFunctionCode());
                                if ((arg0Value.getFunctionCode() == cachedFunctionCode__) && count1_ < (5)) {
                                    s1_ = this.insert(new ExecuteCachedData(s1_original));
                                    s1_.cachedFunctionCode_ = cachedFunctionCode__;
                                    s1_.call_ = s1_.insert((Execute.createCall(arg0Value)));
                                    if (!EXECUTE_CACHED_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    this.execute_descriptor_cache = null;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[LLVMFunctionDescriptor.Execute.doDescriptor(LLVMFunctionDescriptor, Object[], LLVMFunctionDescriptor, DirectCallNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunctionDescriptor.Execute.doCached(LLVMFunctionDescriptor, Object[], LLVMFunctionCode, DirectCallNode)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            return Execute.doCached(arg0Value, arg1Value, s1_.cachedFunctionCode_, s1_.call_);
                        }
                        break;
                    }
                }
                VarHandle.storeStoreFence();
                this.execute_polymorphic_call_ = this.insert((IndirectCallNode.create()));
                this.execute_descriptor_cache = null;
                this.execute_cached_cache = null;
                state_0 = state_0 & 0xfffffffc /* remove SpecializationActive[LLVMFunctionDescriptor.Execute.doDescriptor(LLVMFunctionDescriptor, Object[], LLVMFunctionDescriptor, DirectCallNode)], SpecializationActive[LLVMFunctionDescriptor.Execute.doCached(LLVMFunctionDescriptor, Object[], LLVMFunctionCode, DirectCallNode)] */;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMFunctionDescriptor.Execute.doPolymorphic(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */;
                this.state_0_ = state_0;
                return Execute.doPolymorphic(arg0Value, arg1Value, this.execute_polymorphic_call_);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111) & ((state_0 & 0b111) - 1)) == 0 /* is-single  */) {
                        ExecuteDescriptorData s0_ = this.execute_descriptor_cache;
                        ExecuteCachedData s1_ = this.execute_cached_cache;
                        if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMFunctionDescriptor#asPointer(LLVMFunctionDescriptor, BranchProfile)}
             *     Activation probability: 0.33333
             *     With/without class size: 9/4 bytes
             * </pre>
             */
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.asPointer(LLVMFunctionDescriptor, BranchProfile)] */) {
                    {
                        BranchProfile exception__ = this.asPointerNode__asPointer_exception_;
                        if (exception__ != null) {
                            return arg0Value.asPointer(exception__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(LLVMFunctionDescriptor arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile exception__ = (BranchProfile.create());
                Objects.requireNonNull(exception__, "Specialization 'asPointer(LLVMFunctionDescriptor, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.asPointerNode__asPointer_exception_ = exception__;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMFunctionDescriptor.asPointer(LLVMFunctionDescriptor, BranchProfile)] */;
                this.state_0_ = state_0;
                return arg0Value.asPointer(exception__);
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).isPointer();
            }

            @Override
            public void toNative(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                (((LLVMFunctionDescriptor) receiver)).toNative();
                return;
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).isExecutable();
            }

            @Override
            public boolean isInstantiable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).isInstantiable();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMFunctionDescriptor#instantiate(LLVMFunctionDescriptor, Object[], IndirectCallNode)}
             *     Activation probability: 0.33333
             *     With/without class size: 10/4 bytes
             * </pre>
             */
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.instantiate(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */) {
                    {
                        IndirectCallNode call__ = this.instantiateNode__instantiate_call_;
                        if (call__ != null) {
                            return arg0Value.instantiate(arg1Value, call__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateNode_AndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                int state_0 = this.state_0_;
                VarHandle.storeStoreFence();
                this.instantiateNode__instantiate_call_ = this.insert((IndirectCallNode.create()));
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMFunctionDescriptor.instantiate(LLVMFunctionDescriptor, Object[], IndirectCallNode)] */;
                this.state_0_ = state_0;
                return arg0Value.instantiate(arg1Value, this.instantiateNode__instantiate_call_);
            }

            @Override
            public boolean hasExecutableName(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).hasExecutableName();
            }

            @Override
            public Object getExecutableName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).getExecutableName();
            }

            @Override
            public boolean hasSourceLocation(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).hasSourceLocation();
            }

            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LLVMFunctionDescriptor) receiver)).getSourceLocation();
            }

            @GeneratedBy(LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class ExecuteDescriptorData extends Node implements SpecializationDataNode {

                @Child ExecuteDescriptorData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doDescriptor}
                 *   Parameter: {@link LLVMFunctionDescriptor} cachedSelf</pre>
                 */
                @CompilationFinal LLVMFunctionDescriptor cachedSelf_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doDescriptor}
                 *   Parameter: {@link DirectCallNode} call</pre>
                 */
                @Child DirectCallNode call_;

                ExecuteDescriptorData(ExecuteDescriptorData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
            @GeneratedBy(LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class ExecuteCachedData extends Node implements SpecializationDataNode {

                @Child ExecuteCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doCached}
                 *   Parameter: {@link LLVMFunctionCode} cachedFunctionCode</pre>
                 */
                @CompilationFinal LLVMFunctionCode cachedFunctionCode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doCached}
                 *   Parameter: {@link DirectCallNode} call</pre>
                 */
                @Child DirectCallNode call_;

                ExecuteCachedData(ExecuteCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
        @GeneratedBy(LLVMFunctionDescriptor.class)
        @DenyReplace
        private static final class Uncached extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Uncached {

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                return Execute.doPolymorphic(arg0Value, arg1Value, (IndirectCallNode.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                return arg0Value.asPointer((BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public void toNative(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMFunctionDescriptor) receiver) .toNative();
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .isInstantiable();
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                return arg0Value.instantiate(arg1Value, (IndirectCallNode.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasExecutableName(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .hasExecutableName();
            }

            @TruffleBoundary
            @Override
            public Object getExecutableName(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .getExecutableName();
            }

            @TruffleBoundary
            @Override
            public boolean hasSourceLocation(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .hasSourceLocation();
            }

            @TruffleBoundary
            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .getSourceLocation();
            }

        }
    }
    @GeneratedBy(LLVMFunctionDescriptor.class)
    private static final class LLVMNativeLibraryExports extends LibraryExport<LLVMNativeLibrary> {

        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, LLVMFunctionDescriptor.class, false, false, 0);
        }

        @Override
        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMFunctionDescriptor;
            LLVMNativeLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected LLVMNativeLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMFunctionDescriptor;
            return new Cached();
        }

        @GeneratedBy(LLVMFunctionDescriptor.class)
        private static final class Cached extends LLVMNativeLibrary {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LLVMFunctionDescriptor#asPointer(LLVMFunctionDescriptor, BranchProfile)}
             *   1: SpecializationActive {@link LLVMFunctionDescriptor#toNativePointer(LLVMFunctionDescriptor, LLVMNativeLibrary, BranchProfile)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMFunctionDescriptor#asPointer(LLVMFunctionDescriptor, BranchProfile)}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile asPointerNode__asPointer_exception_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMFunctionDescriptor#toNativePointer(LLVMFunctionDescriptor, LLVMNativeLibrary, BranchProfile)}
             *   Parameter: {@link BranchProfile} exceptionProfile</pre>
             */
            @CompilationFinal private BranchProfile toNativePointerNode__toNativePointer_exceptionProfile_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMFunctionDescriptor) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMFunctionDescriptor#asPointer(LLVMFunctionDescriptor, BranchProfile)}
             *     Activation probability: 0.50000
             *     With/without class size: 12/4 bytes
             * </pre>
             */
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.asPointer(LLVMFunctionDescriptor, BranchProfile)] */) {
                    {
                        BranchProfile exception__ = this.asPointerNode__asPointer_exception_;
                        if (exception__ != null) {
                            return arg0Value.asPointer(exception__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(LLVMFunctionDescriptor arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile exception__ = (BranchProfile.create());
                Objects.requireNonNull(exception__, "Specialization 'asPointer(LLVMFunctionDescriptor, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.asPointerNode__asPointer_exception_ = exception__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[LLVMFunctionDescriptor.asPointer(LLVMFunctionDescriptor, BranchProfile)] */;
                this.state_0_ = state_0;
                return arg0Value.asPointer(exception__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((LLVMFunctionDescriptor) receiver)).isPointer();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LLVMFunctionDescriptor#toNativePointer(LLVMFunctionDescriptor, LLVMNativeLibrary, BranchProfile)}
             *     Activation probability: 0.50000
             *     With/without class size: 12/4 bytes
             * </pre>
             */
            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFunctionDescriptor.toNativePointer(LLVMFunctionDescriptor, LLVMNativeLibrary, BranchProfile)] */) {
                    {
                        BranchProfile exceptionProfile__ = this.toNativePointerNode__toNativePointer_exceptionProfile_;
                        if (exceptionProfile__ != null) {
                            LLVMNativeLibrary self__ = (this);
                            return arg0Value.toNativePointer(self__, exceptionProfile__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return toNativePointerNode_AndSpecialize(arg0Value);
            }

            private LLVMNativePointer toNativePointerNode_AndSpecialize(LLVMFunctionDescriptor arg0Value) {
                int state_0 = this.state_0_;
                {
                    LLVMNativeLibrary self__ = null;
                    self__ = (this);
                    BranchProfile exceptionProfile__ = (BranchProfile.create());
                    Objects.requireNonNull(exceptionProfile__, "Specialization 'toNativePointer(LLVMFunctionDescriptor, LLVMNativeLibrary, BranchProfile)' cache 'exceptionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.toNativePointerNode__toNativePointer_exceptionProfile_ = exceptionProfile__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFunctionDescriptor.toNativePointer(LLVMFunctionDescriptor, LLVMNativeLibrary, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return arg0Value.toNativePointer(self__, exceptionProfile__);
                }
            }

        }
        @GeneratedBy(LLVMFunctionDescriptor.class)
        @DenyReplace
        private static final class Uncached extends LLVMNativeLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMFunctionDescriptor) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                return arg0Value.asPointer((BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = ((LLVMFunctionDescriptor) arg0Value_);
                return arg0Value.toNativePointer((this), (BranchProfile.getUncached()));
            }

        }
    }
    @GeneratedBy(LLVMFunctionDescriptor.class)
    public static final class LLVMAsForeignLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            LLVMFunctionDescriptorGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary";
        }

    }
    @GeneratedBy(LLVMFunctionDescriptor.class)
    private static final class LLVMAsForeignLibraryExports extends LibraryExport<LLVMAsForeignLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMFunctionDescriptor.class, false, true, 2);
        }

        @Override
        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMFunctionDescriptor;
            LLVMAsForeignLibrary uncached = LLVMAsForeignLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMFunctionDescriptor || receiver instanceof LibraryExport<?>;
            return LLVMAsForeignLibraryExports.CACHE;
        }

        @GeneratedBy(LLVMFunctionDescriptor.class)
        private static final class Cached extends LLVMAsForeignLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMFunctionDescriptor) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMFunctionDescriptor.isForeign((((LLVMFunctionDescriptor) receiver)));
            }

        }
        @GeneratedBy(LLVMFunctionDescriptor.class)
        @DenyReplace
        private static final class Uncached extends LLVMAsForeignLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMFunctionDescriptor) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isForeign(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMFunctionDescriptor.isForeign(((LLVMFunctionDescriptor) receiver) );
            }

        }
    }
}
