// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadDouble;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadGenericI64;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadI16;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadI32;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadI8;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.ReadPointer;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteDouble;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteGenericI64;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteI16;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteI32;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteI64;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer.WriteI8;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.ToNativePointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.ToNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMGlobalContainer.class)
@SuppressWarnings("javadoc")
public final class LLVMGlobalContainerGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMGlobalContainer.class, new InteropLibraryExports(), new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports(), new LLVMAsForeignLibraryExports());
    }

    private LLVMGlobalContainerGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(LLVMGlobalContainer.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMGlobalContainer.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer;
            return new Cached(receiver);
        }

        @GeneratedBy(LLVMGlobalContainer.class)
        private static final class Cached extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Cached {

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMGlobalContainer) receiver)).isPointer();
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((LLVMGlobalContainer) receiver)).asPointer();
            }

            @Override
            public void toNative(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((LLVMGlobalContainer) receiver)).toNative();
                return;
            }

        }
        @GeneratedBy(LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Uncached {

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer) receiver) .asPointer();
            }

            @TruffleBoundary
            @Override
            public void toNative(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMGlobalContainer) receiver) .toNative();
                return;
            }

        }
    }
    @GeneratedBy(LLVMGlobalContainer.class)
    public static final class LLVMManagedReadLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            LLVMGlobalContainerGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary";
        }

    }
    @GeneratedBy(LLVMGlobalContainer.class)
    private static final class LLVMManagedReadLibraryExports extends LibraryExport<LLVMManagedReadLibrary> {

        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMGlobalContainer.class, false, true, 1);
        }

        @Override
        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer;
            LLVMManagedReadLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer || receiver instanceof LibraryExport<?>;
            return new Cached();
        }

        @GeneratedBy(LLVMGlobalContainer.class)
        private static final class Cached extends LLVMManagedReadLibrary implements GenerateAOT.Provider {

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ReadI8#readNative}
             *   2: SpecializationActive {@link ReadI8#readManaged}
             *   3: SpecializationActive {@link ReadI16#readNative}
             *   4: SpecializationActive {@link ReadI16#readManaged}
             *   5: SpecializationActive {@link ReadI32#readNative}
             *   6: SpecializationActive {@link ReadI32#readManaged}
             *   7: SpecializationActive {@link ReadFloat#readNative}
             *   8: SpecializationActive {@link ReadFloat#readManaged}
             *   9: SpecializationActive {@link ReadDouble#readNative}
             *   10: SpecializationActive {@link ReadDouble#readManaged}
             *   11: SpecializationActive {@link ReadGenericI64#readNative}
             *   12: SpecializationActive {@link ReadGenericI64#readI64ManagedSingleContext}
             *   13: SpecializationActive {@link ReadGenericI64#readI64Managed}
             *   14: SpecializationActive {@link ReadGenericI64#readFallback}
             *   15: SpecializationActive {@link ReadPointer#readNative}
             *   16: SpecializationActive {@link ReadPointer#readManagedSingleContext}
             *   17: SpecializationActive {@link ReadPointer#readManaged}
             *   18: SpecializationActive {@link ReadPointer#readFallback}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadPointer#readManagedSingleContext}
             *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
             */
            @Child private LLVMToPointerNode toPointer;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMGlobalContainer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadI8#readNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ReadI8#readManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readI8AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI8.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadI8.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI8.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadI8.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI8.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadI8.readManaged(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI8AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadI8.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMGlobalContainer.ReadI8.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadI8.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMGlobalContainer.ReadI8.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMGlobalContainer.ReadI8.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return ReadI8.readManaged(arg0Value, arg1Value, location__1);
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[LLVMGlobalContainer.ReadI8.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMGlobalContainer.ReadI8.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMGlobalContainer.ReadI16.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMGlobalContainer.ReadI32.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMGlobalContainer.ReadFloat.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadDouble.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64Managed(LLVMGlobalContainer, long)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                {
                    LLVMToPointerNode toPointer_;
                    LLVMToPointerNode toPointer__shared = this.toPointer;
                    if (toPointer__shared != null) {
                        toPointer_ = toPointer__shared;
                    } else {
                        toPointer_ = this.insert((LLVMToPointerNodeGen.create()));
                        if (toPointer_ == null) {
                            throw new IllegalStateException("Specialization 'readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)' contains a shared cache with name 'toPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toPointer == null) {
                        VarHandle.storeStoreFence();
                        this.toPointer = toPointer_;
                    }
                    assert NodeUtil.assertRecursion(this.toPointer, 1);
                    ((GenerateAOT.Provider) this.toPointer).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0x20000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)] */;
                }
                {
                    this.state_0_ = state_0_ | 0x40000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.toPointer = null;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadI16#readNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ReadI16#readManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readI16AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI16.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadI16.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI16.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadI16.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI16.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadI16.readManaged(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI16AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadI16.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMGlobalContainer.ReadI16.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadI16.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMGlobalContainer.ReadI16.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMGlobalContainer.ReadI16.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return ReadI16.readManaged(arg0Value, arg1Value, location__1);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadI32#readNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ReadI32#readManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readI32AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI32.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadI32.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI32.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadI32.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadI32.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadI32.readManaged(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI32AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadI32.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMGlobalContainer.ReadI32.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadI32.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMGlobalContainer.ReadI32.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMGlobalContainer.ReadI32.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return ReadI32.readManaged(arg0Value, arg1Value, location__1);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadFloat#readNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ReadFloat#readManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readFloatAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadFloat.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadFloat.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadFloat.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadFloat.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadFloat.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadFloat.readManaged(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatAndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadFloat.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMGlobalContainer.ReadFloat.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadFloat.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[LLVMGlobalContainer.ReadFloat.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMGlobalContainer.ReadFloat.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return ReadFloat.readManaged(arg0Value, arg1Value, location__1);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadDouble#readNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link ReadDouble#readManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readDoubleAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadDouble.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadDouble.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadDouble.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadDouble.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadDouble.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadDouble.readManaged(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleAndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadDouble.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadDouble.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return ReadDouble.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMGlobalContainer.ReadDouble.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadDouble.readManaged(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return ReadDouble.readManaged(arg0Value, arg1Value, location__1);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadGenericI64#readNative}
             *     Activation probability: 0.05500
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadGenericI64#readI64ManagedSingleContext}
             *     Activation probability: 0.04214
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadGenericI64#readI64Managed}
             *     Activation probability: 0.02929
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadGenericI64#readFallback}
             *     Activation probability: 0.01643
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readGenericI64AndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111100000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64ManagedSingleContext(LLVMGlobalContainer, long)] || SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64Managed(LLVMGlobalContainer, long)] || SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadGenericI64.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64ManagedSingleContext(LLVMGlobalContainer, long)] */) {
                        assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                        if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                            return ReadGenericI64.readI64ManagedSingleContext(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64Managed(LLVMGlobalContainer, long)] */) {
                        if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                            return ReadGenericI64.readI64Managed(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadGenericI64.readFallback(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readGenericI64AndSpecialize(arg0Value, arg1Value);
            }

            private Object readGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if ((arg0Value.isPointer())) {
                        location__ = (this);
                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return ReadGenericI64.readNative(arg0Value, arg1Value, location__);
                    }
                }
                if (((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64Managed(LLVMGlobalContainer, long)] */) {
                    if ((LLVMLanguage.isSingleContext(this)) && (!(arg0Value.isPointer())) && (arg1Value == 0)) {
                        state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64ManagedSingleContext(LLVMGlobalContainer, long)] */;
                        this.state_0_ = state_0;
                        return ReadGenericI64.readI64ManagedSingleContext(arg0Value, arg1Value);
                    }
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    state_0 = state_0 & 0xffffefff /* remove SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64ManagedSingleContext(LLVMGlobalContainer, long)] */;
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readI64Managed(LLVMGlobalContainer, long)] */;
                    this.state_0_ = state_0;
                    return ReadGenericI64.readI64Managed(arg0Value, arg1Value);
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                        location__1 = (this);
                        state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadGenericI64.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return ReadGenericI64.readFallback(arg0Value, arg1Value, location__1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadPointer#readNative}
             *     Activation probability: 0.05500
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadPointer#readManagedSingleContext}
             *     Activation probability: 0.04214
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadPointer#readManaged}
             *     Activation probability: 0.02929
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadPointer#readFallback}
             *     Activation probability: 0.01643
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return readPointerAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x78000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadPointer.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMGlobalContainer.ReadPointer.readManagedSingleContext(LLVMGlobalContainer, long, LLVMToPointerNode)] || SpecializationActive[LLVMGlobalContainer.ReadPointer.readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)] || SpecializationActive[LLVMGlobalContainer.ReadPointer.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadPointer.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedReadLibrary location__ = (this);
                            return ReadPointer.readNative(arg0Value, arg1Value, location__);
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadPointer.readManagedSingleContext(LLVMGlobalContainer, long, LLVMToPointerNode)] */) {
                        {
                            LLVMToPointerNode toPointer_ = this.toPointer;
                            if (toPointer_ != null) {
                                assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                                    return ReadPointer.readManagedSingleContext(arg0Value, arg1Value, toPointer_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadPointer.readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)] */) {
                        {
                            LLVMToPointerNode toPointer_1 = this.toPointer;
                            if (toPointer_1 != null) {
                                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                                    return ReadPointer.readManaged(arg0Value, arg1Value, toPointer_1);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMGlobalContainer.ReadPointer.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */) {
                        if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                            LLVMManagedReadLibrary location__1 = (this);
                            return ReadPointer.readFallback(arg0Value, arg1Value, location__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readPointerAndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedReadLibrary location__ = null;
                    if ((arg0Value.isPointer())) {
                        location__ = (this);
                        state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readNative(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return ReadPointer.readNative(arg0Value, arg1Value, location__);
                    }
                }
                if (((state_0 & 0x20000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.ReadPointer.readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)] */) {
                    if ((LLVMLanguage.isSingleContext(this)) && (!(arg0Value.isPointer())) && (arg1Value == 0)) {
                        LLVMToPointerNode toPointer_;
                        LLVMToPointerNode toPointer__shared = this.toPointer;
                        if (toPointer__shared != null) {
                            toPointer_ = toPointer__shared;
                        } else {
                            toPointer_ = this.insert((LLVMToPointerNodeGen.create()));
                            if (toPointer_ == null) {
                                throw new IllegalStateException("Specialization 'readManagedSingleContext(LLVMGlobalContainer, long, LLVMToPointerNode)' contains a shared cache with name 'toPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.toPointer == null) {
                            VarHandle.storeStoreFence();
                            this.toPointer = toPointer_;
                        }
                        state_0 = state_0 | 0x10000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readManagedSingleContext(LLVMGlobalContainer, long, LLVMToPointerNode)] */;
                        this.state_0_ = state_0;
                        return ReadPointer.readManagedSingleContext(arg0Value, arg1Value, toPointer_);
                    }
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    LLVMToPointerNode toPointer_1;
                    LLVMToPointerNode toPointer_1_shared = this.toPointer;
                    if (toPointer_1_shared != null) {
                        toPointer_1 = toPointer_1_shared;
                    } else {
                        toPointer_1 = this.insert((LLVMToPointerNodeGen.create()));
                        if (toPointer_1 == null) {
                            throw new IllegalStateException("Specialization 'readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)' contains a shared cache with name 'toPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toPointer == null) {
                        VarHandle.storeStoreFence();
                        this.toPointer = toPointer_1;
                    }
                    state_0 = state_0 & 0xfffeffff /* remove SpecializationActive[LLVMGlobalContainer.ReadPointer.readManagedSingleContext(LLVMGlobalContainer, long, LLVMToPointerNode)] */;
                    state_0 = state_0 | 0x20000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readManaged(LLVMGlobalContainer, long, LLVMToPointerNode)] */;
                    this.state_0_ = state_0;
                    return ReadPointer.readManaged(arg0Value, arg1Value, toPointer_1);
                }
                {
                    LLVMManagedReadLibrary location__1 = null;
                    if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                        location__1 = (this);
                        state_0 = state_0 | 0x40000 /* add SpecializationActive[LLVMGlobalContainer.ReadPointer.readFallback(LLVMGlobalContainer, long, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return ReadPointer.readFallback(arg0Value, arg1Value, location__1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((LLVMGlobalContainer) receiver)).isAccessible();
            }

        }
        @GeneratedBy(LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached extends LLVMManagedReadLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMGlobalContainer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                return ReadI8.readManaged(arg0Value, arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                return ReadI16.readManaged(arg0Value, arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                return ReadI32.readManaged(arg0Value, arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                return ReadFloat.readManaged(arg0Value, arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                return ReadDouble.readManaged(arg0Value, arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                if ((arg0Value.isPointer())) {
                    return ReadGenericI64.readNative(arg0Value, arg1Value, (this));
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    return ReadGenericI64.readI64Managed(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                    return ReadGenericI64.readFallback(arg0Value, arg1Value, (this));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                if ((arg0Value.isPointer())) {
                    return ReadPointer.readNative(arg0Value, arg1Value, (this));
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    return ReadPointer.readManaged(arg0Value, arg1Value, (LLVMToPointerNodeGen.getUncached()));
                }
                if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                    return ReadPointer.readFallback(arg0Value, arg1Value, (this));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isReadable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer) receiver) .isAccessible();
            }

        }
    }
    @GeneratedBy(LLVMGlobalContainer.class)
    public static final class LLVMManagedWriteLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            LLVMGlobalContainerGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary";
        }

    }
    @GeneratedBy(LLVMGlobalContainer.class)
    private static final class LLVMManagedWriteLibraryExports extends LibraryExport<LLVMManagedWriteLibrary> {

        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMGlobalContainer.class, false, true, 2);
        }

        @Override
        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer;
            LLVMManagedWriteLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer || receiver instanceof LibraryExport<?>;
            return new Cached();
        }

        @GeneratedBy(LLVMGlobalContainer.class)
        private static final class Cached extends LLVMManagedWriteLibrary implements GenerateAOT.Provider {

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link WriteI8#writeNative}
             *   2: SpecializationActive {@link WriteI8#writeManaged}
             *   3: SpecializationActive {@link WriteI16#writeNative}
             *   4: SpecializationActive {@link WriteI16#writeManaged}
             *   5: SpecializationActive {@link WriteI32#writeNative}
             *   6: SpecializationActive {@link WriteI32#writeManaged}
             *   7: SpecializationActive {@link WriteFloat#writeNative}
             *   8: SpecializationActive {@link WriteFloat#writeManaged}
             *   9: SpecializationActive {@link WriteDouble#writeNative}
             *   10: SpecializationActive {@link WriteDouble#writeManaged}
             *   11: SpecializationActive {@link WriteI64#writeNative}
             *   12: SpecializationActive {@link WriteI64#writeManagedSingleContext}
             *   13: SpecializationActive {@link WriteI64#writeManaged}
             *   14: SpecializationActive {@link WriteI64#writeFallback}
             *   15: SpecializationActive {@link WriteGenericI64#writeNative}
             *   16: SpecializationActive {@link WriteGenericI64#writeI64ManagedSingleContext}
             *   17: SpecializationActive {@link WriteGenericI64#writeI64Managed}
             *   18: SpecializationActive {@link WriteGenericI64#writeFallback}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteGenericI64#writeNative}
             *   Parameter: {@link ToNativePointerNode} toNative</pre>
             */
            @Child private ToNativePointerNode toNative;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMGlobalContainer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteI8#writeNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link WriteI8#writeManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeI8AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI8.writeNative(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMGlobalContainer.WriteI8.writeManaged(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI8.writeNative(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedWriteLibrary location__ = (this);
                            WriteI8.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI8.writeManaged(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMManagedWriteLibrary location__1 = (this);
                            WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI8AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, byte arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedWriteLibrary location__ = null;
                    if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteI8.writeManaged(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMGlobalContainer.WriteI8.writeNative(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            WriteI8.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                }
                {
                    LLVMManagedWriteLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMGlobalContainer.WriteI8.writeNative(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMGlobalContainer.WriteI8.writeManaged(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                    return;
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[LLVMGlobalContainer.WriteI8.writeNative(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMGlobalContainer.WriteI8.writeManaged(LLVMGlobalContainer, long, byte, LLVMManagedWriteLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMGlobalContainer.WriteI16.writeManaged(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI32.writeManaged(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMGlobalContainer.WriteFloat.writeManaged(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteDouble.writeManaged(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeNative(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeManaged(LLVMGlobalContainer, long, long)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeFallback(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */;
                }
                {
                    ToNativePointerNode toNative_;
                    ToNativePointerNode toNative__shared = this.toNative;
                    if (toNative__shared != null) {
                        toNative_ = toNative__shared;
                    } else {
                        toNative_ = this.insert((ToNativePointerNodeGen.create()));
                        if (toNative_ == null) {
                            throw new IllegalStateException("Specialization 'writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)' contains a shared cache with name 'toNative' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toNative == null) {
                        VarHandle.storeStoreFence();
                        this.toNative = toNative_;
                    }
                    assert NodeUtil.assertRecursion(this.toNative, 1);
                    ((GenerateAOT.Provider) this.toNative).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b1000000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)] */;
                }
                {
                    this.state_0_ = state_0_ | 0x20000 /* add SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64Managed(LLVMGlobalContainer, long, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.toNative = null;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteI16#writeNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link WriteI16#writeManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeI16AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI16.writeNative(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMGlobalContainer.WriteI16.writeManaged(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI16.writeNative(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedWriteLibrary location__ = (this);
                            WriteI16.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI16.writeManaged(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMManagedWriteLibrary location__1 = (this);
                            WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI16AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, short arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedWriteLibrary location__ = null;
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteI16.writeManaged(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMGlobalContainer.WriteI16.writeNative(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            WriteI16.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                }
                {
                    LLVMManagedWriteLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMGlobalContainer.WriteI16.writeNative(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMGlobalContainer.WriteI16.writeManaged(LLVMGlobalContainer, long, short, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteI32#writeNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link WriteI32#writeManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeI32AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI32.writeNative(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMGlobalContainer.WriteI32.writeManaged(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI32.writeNative(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedWriteLibrary location__ = (this);
                            WriteI32.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI32.writeManaged(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMManagedWriteLibrary location__1 = (this);
                            WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI32AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedWriteLibrary location__ = null;
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteI32.writeManaged(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMGlobalContainer.WriteI32.writeNative(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            WriteI32.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                }
                {
                    LLVMManagedWriteLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMGlobalContainer.WriteI32.writeNative(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI32.writeManaged(LLVMGlobalContainer, long, int, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteFloat#writeNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link WriteFloat#writeManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteFloat.writeNative(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMGlobalContainer.WriteFloat.writeManaged(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteFloat.writeNative(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedWriteLibrary location__ = (this);
                            WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteFloat.writeManaged(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMManagedWriteLibrary location__1 = (this);
                            WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, float arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedWriteLibrary location__ = null;
                    if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteFloat.writeManaged(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMGlobalContainer.WriteFloat.writeNative(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                }
                {
                    LLVMManagedWriteLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[LLVMGlobalContainer.WriteFloat.writeNative(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */;
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMGlobalContainer.WriteFloat.writeManaged(LLVMGlobalContainer, long, float, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteDouble#writeNative}
             *     Activation probability: 0.09286
             *     With/without class size: 5/0 bytes
             *   Specialization {@link WriteDouble#writeManaged}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteDouble.writeNative(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMGlobalContainer.WriteDouble.writeManaged(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteDouble.writeNative(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedWriteLibrary location__ = (this);
                            WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteDouble.writeManaged(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMManagedWriteLibrary location__1 = (this);
                            WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, double arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedWriteLibrary location__ = null;
                    if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteDouble.writeManaged(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            location__ = (this);
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteDouble.writeNative(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                }
                {
                    LLVMManagedWriteLibrary location__1 = null;
                    location__1 = (this);
                    state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[LLVMGlobalContainer.WriteDouble.writeNative(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */;
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteDouble.writeManaged(LLVMGlobalContainer, long, double, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, location__1);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteI64#writeNative}
             *     Activation probability: 0.05500
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteI64#writeManagedSingleContext}
             *     Activation probability: 0.04214
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteI64#writeManaged}
             *     Activation probability: 0.02929
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteI64#writeFallback}
             *     Activation probability: 0.01643
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0b111100000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI64.writeNative(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMGlobalContainer.WriteI64.writeManagedSingleContext(LLVMGlobalContainer, long, long)] || SpecializationActive[LLVMGlobalContainer.WriteI64.writeManaged(LLVMGlobalContainer, long, long)] || SpecializationActive[LLVMGlobalContainer.WriteI64.writeFallback(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */) {
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI64.writeNative(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */) {
                        if ((arg0Value.isPointer())) {
                            LLVMManagedWriteLibrary location__ = (this);
                            WriteI64.writeNative(arg0Value, arg1Value, arg2Value, location__);
                            return;
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI64.writeManagedSingleContext(LLVMGlobalContainer, long, long)] */) {
                        assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                        if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                            WriteI64.writeManagedSingleContext(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI64.writeManaged(LLVMGlobalContainer, long, long)] */) {
                        if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                            WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteI64.writeFallback(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */) {
                        if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                            LLVMManagedWriteLibrary location__1 = (this);
                            WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, location__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, long arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                {
                    LLVMManagedWriteLibrary location__ = null;
                    if ((arg0Value.isPointer())) {
                        location__ = (this);
                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeNative(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        WriteI64.writeNative(arg0Value, arg1Value, arg2Value, location__);
                        return;
                    }
                }
                if (((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteI64.writeManaged(LLVMGlobalContainer, long, long)] */) {
                    if ((LLVMLanguage.isSingleContext(this)) && (!(arg0Value.isPointer())) && (arg1Value == 0)) {
                        state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeManagedSingleContext(LLVMGlobalContainer, long, long)] */;
                        this.state_0_ = state_0;
                        WriteI64.writeManagedSingleContext(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    state_0 = state_0 & 0xffffefff /* remove SpecializationActive[LLVMGlobalContainer.WriteI64.writeManagedSingleContext(LLVMGlobalContainer, long, long)] */;
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeManaged(LLVMGlobalContainer, long, long)] */;
                    this.state_0_ = state_0;
                    WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                    return;
                }
                {
                    LLVMManagedWriteLibrary location__1 = null;
                    if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                        location__1 = (this);
                        state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteI64.writeFallback(LLVMGlobalContainer, long, long, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, location__1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteGenericI64#writeNative}
             *     Activation probability: 0.05500
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteGenericI64#writeI64ManagedSingleContext}
             *     Activation probability: 0.04214
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteGenericI64#writeI64Managed}
             *     Activation probability: 0.02929
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteGenericI64#writeFallback}
             *     Activation probability: 0.01643
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x78000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)] || SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64ManagedSingleContext(LLVMGlobalContainer, long, Object)] || SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64Managed(LLVMGlobalContainer, long, Object)] || SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeFallback(LLVMGlobalContainer, long, Object, ToNativePointerNode)] */) {
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)] */) {
                        {
                            ToNativePointerNode toNative_ = this.toNative;
                            if (toNative_ != null) {
                                if ((arg0Value.isPointer())) {
                                    WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, toNative_);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64ManagedSingleContext(LLVMGlobalContainer, long, Object)] */) {
                        assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                        if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                            WriteGenericI64.writeI64ManagedSingleContext(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64Managed(LLVMGlobalContainer, long, Object)] */) {
                        if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                            WriteGenericI64.writeI64Managed(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeFallback(LLVMGlobalContainer, long, Object, ToNativePointerNode)] */) {
                        {
                            ToNativePointerNode toNative_1 = this.toNative;
                            if (toNative_1 != null) {
                                if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                                    WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, toNative_1);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((arg0Value.isPointer())) {
                    ToNativePointerNode toNative_;
                    ToNativePointerNode toNative__shared = this.toNative;
                    if (toNative__shared != null) {
                        toNative_ = toNative__shared;
                    } else {
                        toNative_ = this.insert((ToNativePointerNodeGen.create()));
                        if (toNative_ == null) {
                            throw new IllegalStateException("Specialization 'writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)' contains a shared cache with name 'toNative' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toNative == null) {
                        VarHandle.storeStoreFence();
                        this.toNative = toNative_;
                    }
                    state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeNative(LLVMGlobalContainer, long, Object, ToNativePointerNode)] */;
                    this.state_0_ = state_0;
                    WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, toNative_);
                    return;
                }
                if (((state_0 & 0x20000)) == 0 /* is-not SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64Managed(LLVMGlobalContainer, long, Object)] */) {
                    if ((LLVMLanguage.isSingleContext(this)) && (!(arg0Value.isPointer())) && (arg1Value == 0)) {
                        state_0 = state_0 | 0x10000 /* add SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64ManagedSingleContext(LLVMGlobalContainer, long, Object)] */;
                        this.state_0_ = state_0;
                        WriteGenericI64.writeI64ManagedSingleContext(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    state_0 = state_0 & 0xfffeffff /* remove SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64ManagedSingleContext(LLVMGlobalContainer, long, Object)] */;
                    state_0 = state_0 | 0x20000 /* add SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeI64Managed(LLVMGlobalContainer, long, Object)] */;
                    this.state_0_ = state_0;
                    WriteGenericI64.writeI64Managed(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                    ToNativePointerNode toNative_1;
                    ToNativePointerNode toNative_1_shared = this.toNative;
                    if (toNative_1_shared != null) {
                        toNative_1 = toNative_1_shared;
                    } else {
                        toNative_1 = this.insert((ToNativePointerNodeGen.create()));
                        if (toNative_1 == null) {
                            throw new IllegalStateException("Specialization 'writeFallback(LLVMGlobalContainer, long, Object, ToNativePointerNode)' contains a shared cache with name 'toNative' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.toNative == null) {
                        VarHandle.storeStoreFence();
                        this.toNative = toNative_1;
                    }
                    state_0 = state_0 | 0x40000 /* add SpecializationActive[LLVMGlobalContainer.WriteGenericI64.writeFallback(LLVMGlobalContainer, long, Object, ToNativePointerNode)] */;
                    this.state_0_ = state_0;
                    WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, toNative_1);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((LLVMGlobalContainer) receiver)).isAccessible();
            }

        }
        @GeneratedBy(LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached extends LLVMManagedWriteLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMGlobalContainer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                if ((arg0Value.isPointer())) {
                    WriteI64.writeNative(arg0Value, arg1Value, arg2Value, (this));
                    return;
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                    WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, (this));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = ((LLVMGlobalContainer) arg0Value_);
                if ((arg0Value.isPointer())) {
                    WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, (ToNativePointerNodeGen.getUncached()));
                    return;
                }
                if ((!(arg0Value.isPointer())) && (arg1Value == 0)) {
                    WriteGenericI64.writeI64Managed(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((!(arg0Value.isPointer())) && (arg1Value != 0)) {
                    WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, (ToNativePointerNodeGen.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public boolean isWritable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer) receiver) .isAccessible();
            }

        }
    }
    @GeneratedBy(LLVMGlobalContainer.class)
    public static final class LLVMAsForeignLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            LLVMGlobalContainerGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary";
        }

    }
    @GeneratedBy(LLVMGlobalContainer.class)
    private static final class LLVMAsForeignLibraryExports extends LibraryExport<LLVMAsForeignLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMGlobalContainer.class, false, true, 3);
        }

        @Override
        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer;
            LLVMAsForeignLibrary uncached = LLVMAsForeignLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert receiver instanceof LLVMGlobalContainer || receiver instanceof LibraryExport<?>;
            return LLVMAsForeignLibraryExports.CACHE;
        }

        @GeneratedBy(LLVMGlobalContainer.class)
        private static final class Cached extends LLVMAsForeignLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMGlobalContainer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMGlobalContainer.isForeign((((LLVMGlobalContainer) receiver)));
            }

        }
        @GeneratedBy(LLVMGlobalContainer.class)
        @DenyReplace
        private static final class Uncached extends LLVMAsForeignLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LLVMGlobalContainer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isForeign(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMGlobalContainer.isForeign(((LLVMGlobalContainer) receiver) );
            }

        }
    }
}
