// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode.LLVMPointerDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNodeFactory.GetForeignTypeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNodeFactory.ResolveNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Buffer;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode.ForeignWriteFloatNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode.ForeignWriteI16Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode.ForeignWriteI32Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode.ForeignWriteI64Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode.ForeignWriteI8Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.ToNativePointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.ToNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMWriteToForeignObjectNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMWriteToForeignObjectNodeFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignWriteI8Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignWriteI8Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignWriteI8Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignWriteI8Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI8Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI8Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignWriteI8Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignWriteI8NodeGen extends ForeignWriteI8Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ForeignDummy value_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignWriteI8Node#doNative}
         *   2: SpecializationActive {@link ForeignWriteI8Node#doBuffer}
         *   3: SpecializationActive {@link ForeignWriteI8Node#doBuffer}
         *   4: SpecializationActive {@link ForeignWriteI8Node#doStructured}
         *   5: SpecializationActive {@link ForeignWriteI8Node#doFallback}
         *   6: SpecializationActive {@link ForeignWriteI8Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteI8Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;

        private ForeignWriteI8NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.value_ = (ForeignDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public void execute(Object foreignValue, long offsetValue, byte valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doNative(Object, long, byte, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doStructured(Object, long, byte, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doNative(Object, long, byte, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                    return;
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doStructured(Object, long, byte, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    this.buffer1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, oobProfile__);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doStructured(Object, long, byte, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s4_.interop_);
                                    return;
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            if ((typeValue_ == null)) {
                                this.fallback1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void buffer1Boundary(int state_0, Object foreignValue, long offsetValue, byte valueValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, interop__, oobProfile__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallback1Boundary(int state_0, Object foreignValue, long offsetValue, byte valueValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object foreignValue, long offsetValue, Object valueValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Byte) {
                byte valueValue_ = (byte) valueValue;
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doNative(Object, long, byte, LLVMNativePointer, Object)] */;
                    this.state_0_ = state_0;
                    doNative(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            while (true) {
                                int count1_ = 0;
                                Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                                Buffer0Data s1_original = s1_;
                                while (s1_ != null) {
                                    if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                        break;
                                    }
                                    count1_++;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ == null) {
                                    // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                    if (count1_ < (3)) {
                                        s1_ = this.insert(new Buffer0Data(s1_original));
                                        InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                        Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.interop_ = interop__;
                                        BranchProfile oobProfile__ = (BranchProfile.create());
                                        Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.oobProfile_ = oobProfile__;
                                        if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s1_ != null) {
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            InteropLibrary interop__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    VarHandle.storeStoreFence();
                                    this.buffer1_oobProfile_ = oobProfile__;
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doBuffer(Object, long, byte, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, interop__, oobProfile__);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        StructuredData s3_ = this.insert(new StructuredData());
                        s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                        VarHandle.storeStoreFence();
                        this.structured_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doStructured(Object, long, byte, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
                        this.state_0_ = state_0;
                        doStructured(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s3_.interopWrite_);
                        return;
                    }
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        while (true) {
                            int count4_ = 0;
                            Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                            Fallback0Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((typeValue == null) && count4_ < (3)) {
                                    // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                    s4_ = this.insert(new Fallback0Data(s4_original));
                                    InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s4_.interop_ = interop__1;
                                    if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s4_ != null) {
                                doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s4_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallback0_cache = null;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doFallback(Object, long, byte, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, interop__1);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.value_, this.resolve_, this.type_}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doNative(Object, long, byte, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopWrite_, 1);
                ((GenerateAOT.Provider) s3_.interopWrite_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI8Node.doStructured(Object, long, byte, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignWriteI8Node create() {
            return new ForeignWriteI8NodeGen();
        }

        @NeverDefault
        public static ForeignWriteI8Node getUncached() {
            return ForeignWriteI8NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignWriteI8Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI8Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI8Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI8Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI8Node#doStructured}
             *   Parameter: {@link LLVMInteropWriteNode} interopWrite</pre>
             */
            @Child LLVMInteropWriteNode interopWrite_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI8Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI8Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI8Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignWriteI8Node {

            @TruffleBoundary
            @Override
            public void execute(Object foreignValue, long offsetValue, byte valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBuffer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if ((typeValue == null)) {
                        doFallback(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignWriteI16Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignWriteI16Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignWriteI16Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignWriteI16Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI16Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI16Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignWriteI16Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignWriteI16NodeGen extends ForeignWriteI16Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ForeignDummy value_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignWriteI16Node#doNative}
         *   2: SpecializationActive {@link ForeignWriteI16Node#doBuffer}
         *   3: SpecializationActive {@link ForeignWriteI16Node#doBuffer}
         *   4: SpecializationActive {@link ForeignWriteI16Node#doStructured}
         *   5: SpecializationActive {@link ForeignWriteI16Node#doFallback}
         *   6: SpecializationActive {@link ForeignWriteI16Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteI16Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;

        private ForeignWriteI16NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.value_ = (ForeignDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public void execute(Object foreignValue, long offsetValue, short valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doNative(Object, long, short, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doStructured(Object, long, short, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doNative(Object, long, short, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                    return;
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doStructured(Object, long, short, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    this.buffer1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, oobProfile__);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doStructured(Object, long, short, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s4_.interop_);
                                    return;
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            if ((typeValue_ == null)) {
                                this.fallback1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void buffer1Boundary(int state_0, Object foreignValue, long offsetValue, short valueValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, interop__, oobProfile__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallback1Boundary(int state_0, Object foreignValue, long offsetValue, short valueValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object foreignValue, long offsetValue, Object valueValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Short) {
                short valueValue_ = (short) valueValue;
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doNative(Object, long, short, LLVMNativePointer, Object)] */;
                    this.state_0_ = state_0;
                    doNative(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            while (true) {
                                int count1_ = 0;
                                Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                                Buffer0Data s1_original = s1_;
                                while (s1_ != null) {
                                    if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                        break;
                                    }
                                    count1_++;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ == null) {
                                    // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                    if (count1_ < (3)) {
                                        s1_ = this.insert(new Buffer0Data(s1_original));
                                        InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                        Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.interop_ = interop__;
                                        BranchProfile oobProfile__ = (BranchProfile.create());
                                        Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.oobProfile_ = oobProfile__;
                                        if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s1_ != null) {
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            InteropLibrary interop__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    VarHandle.storeStoreFence();
                                    this.buffer1_oobProfile_ = oobProfile__;
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doBuffer(Object, long, short, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, interop__, oobProfile__);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        StructuredData s3_ = this.insert(new StructuredData());
                        s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                        VarHandle.storeStoreFence();
                        this.structured_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doStructured(Object, long, short, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
                        this.state_0_ = state_0;
                        doStructured(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s3_.interopWrite_);
                        return;
                    }
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        while (true) {
                            int count4_ = 0;
                            Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                            Fallback0Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((typeValue == null) && count4_ < (3)) {
                                    // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                    s4_ = this.insert(new Fallback0Data(s4_original));
                                    InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s4_.interop_ = interop__1;
                                    if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s4_ != null) {
                                doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s4_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallback0_cache = null;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doFallback(Object, long, short, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, interop__1);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.value_, this.resolve_, this.type_}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doNative(Object, long, short, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopWrite_, 1);
                ((GenerateAOT.Provider) s3_.interopWrite_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI16Node.doStructured(Object, long, short, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignWriteI16Node create() {
            return new ForeignWriteI16NodeGen();
        }

        @NeverDefault
        public static ForeignWriteI16Node getUncached() {
            return ForeignWriteI16NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignWriteI16Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI16Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI16Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI16Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI16Node#doStructured}
             *   Parameter: {@link LLVMInteropWriteNode} interopWrite</pre>
             */
            @Child LLVMInteropWriteNode interopWrite_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI16Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI16Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI16Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignWriteI16Node {

            @TruffleBoundary
            @Override
            public void execute(Object foreignValue, long offsetValue, short valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBuffer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if ((typeValue == null)) {
                        doFallback(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignWriteI32Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignWriteI32Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignWriteI32Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignWriteI32Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI32Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI32Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignWriteI32Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignWriteI32NodeGen extends ForeignWriteI32Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ForeignDummy value_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignWriteI32Node#doNative}
         *   2: SpecializationActive {@link ForeignWriteI32Node#doBuffer}
         *   3: SpecializationActive {@link ForeignWriteI32Node#doBuffer}
         *   4: SpecializationActive {@link ForeignWriteI32Node#doStructured}
         *   5: SpecializationActive {@link ForeignWriteI32Node#doFallback}
         *   6: SpecializationActive {@link ForeignWriteI32Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteI32Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;

        private ForeignWriteI32NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.value_ = (ForeignDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public void execute(Object foreignValue, long offsetValue, int valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doNative(Object, long, int, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doStructured(Object, long, int, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doNative(Object, long, int, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                    return;
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doStructured(Object, long, int, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    this.buffer1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, oobProfile__);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doStructured(Object, long, int, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s4_.interop_);
                                    return;
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            if ((typeValue_ == null)) {
                                this.fallback1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void buffer1Boundary(int state_0, Object foreignValue, long offsetValue, int valueValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, interop__, oobProfile__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallback1Boundary(int state_0, Object foreignValue, long offsetValue, int valueValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object foreignValue, long offsetValue, Object valueValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Integer) {
                int valueValue_ = (int) valueValue;
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doNative(Object, long, int, LLVMNativePointer, Object)] */;
                    this.state_0_ = state_0;
                    doNative(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            while (true) {
                                int count1_ = 0;
                                Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                                Buffer0Data s1_original = s1_;
                                while (s1_ != null) {
                                    if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                        break;
                                    }
                                    count1_++;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ == null) {
                                    // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                    if (count1_ < (3)) {
                                        s1_ = this.insert(new Buffer0Data(s1_original));
                                        InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                        Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.interop_ = interop__;
                                        BranchProfile oobProfile__ = (BranchProfile.create());
                                        Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.oobProfile_ = oobProfile__;
                                        if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s1_ != null) {
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            InteropLibrary interop__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    VarHandle.storeStoreFence();
                                    this.buffer1_oobProfile_ = oobProfile__;
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doBuffer(Object, long, int, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, interop__, oobProfile__);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        StructuredData s3_ = this.insert(new StructuredData());
                        s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                        VarHandle.storeStoreFence();
                        this.structured_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doStructured(Object, long, int, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
                        this.state_0_ = state_0;
                        doStructured(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s3_.interopWrite_);
                        return;
                    }
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        while (true) {
                            int count4_ = 0;
                            Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                            Fallback0Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((typeValue == null) && count4_ < (3)) {
                                    // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                    s4_ = this.insert(new Fallback0Data(s4_original));
                                    InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s4_.interop_ = interop__1;
                                    if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s4_ != null) {
                                doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s4_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallback0_cache = null;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doFallback(Object, long, int, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, interop__1);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.value_, this.resolve_, this.type_}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doNative(Object, long, int, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopWrite_, 1);
                ((GenerateAOT.Provider) s3_.interopWrite_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI32Node.doStructured(Object, long, int, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignWriteI32Node create() {
            return new ForeignWriteI32NodeGen();
        }

        @NeverDefault
        public static ForeignWriteI32Node getUncached() {
            return ForeignWriteI32NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignWriteI32Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI32Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI32Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI32Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI32Node#doStructured}
             *   Parameter: {@link LLVMInteropWriteNode} interopWrite</pre>
             */
            @Child LLVMInteropWriteNode interopWrite_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI32Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI32Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI32Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignWriteI32Node {

            @TruffleBoundary
            @Override
            public void execute(Object foreignValue, long offsetValue, int valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBuffer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if ((typeValue == null)) {
                        doFallback(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignWriteFloatNode#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignWriteFloatNode#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignWriteFloatNode#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignWriteFloatNode#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteFloatNode#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteFloatNode#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignWriteFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignWriteFloatNodeGen extends ForeignWriteFloatNode implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ForeignDummy value_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignWriteFloatNode#doNative}
         *   2: SpecializationActive {@link ForeignWriteFloatNode#doBuffer}
         *   3: SpecializationActive {@link ForeignWriteFloatNode#doBuffer}
         *   4: SpecializationActive {@link ForeignWriteFloatNode#doStructured}
         *   5: SpecializationActive {@link ForeignWriteFloatNode#doFallback}
         *   6: SpecializationActive {@link ForeignWriteFloatNode#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteFloatNode#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;

        private ForeignWriteFloatNodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.value_ = (ForeignDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public void execute(Object foreignValue, long offsetValue, float valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doNative(Object, long, float, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doStructured(Object, long, float, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doNative(Object, long, float, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                    return;
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doStructured(Object, long, float, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    this.buffer1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, oobProfile__);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doStructured(Object, long, float, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s4_.interop_);
                                    return;
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            if ((typeValue_ == null)) {
                                this.fallback1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void buffer1Boundary(int state_0, Object foreignValue, long offsetValue, float valueValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, interop__, oobProfile__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallback1Boundary(int state_0, Object foreignValue, long offsetValue, float valueValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object foreignValue, long offsetValue, Object valueValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Float) {
                float valueValue_ = (float) valueValue;
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doNative(Object, long, float, LLVMNativePointer, Object)] */;
                    this.state_0_ = state_0;
                    doNative(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            while (true) {
                                int count1_ = 0;
                                Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                                Buffer0Data s1_original = s1_;
                                while (s1_ != null) {
                                    if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                        break;
                                    }
                                    count1_++;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ == null) {
                                    // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                    if (count1_ < (3)) {
                                        s1_ = this.insert(new Buffer0Data(s1_original));
                                        InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                        Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.interop_ = interop__;
                                        BranchProfile oobProfile__ = (BranchProfile.create());
                                        Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.oobProfile_ = oobProfile__;
                                        if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s1_ != null) {
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            InteropLibrary interop__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    VarHandle.storeStoreFence();
                                    this.buffer1_oobProfile_ = oobProfile__;
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doBuffer(Object, long, float, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, interop__, oobProfile__);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        StructuredData s3_ = this.insert(new StructuredData());
                        s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                        VarHandle.storeStoreFence();
                        this.structured_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doStructured(Object, long, float, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
                        this.state_0_ = state_0;
                        doStructured(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s3_.interopWrite_);
                        return;
                    }
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        while (true) {
                            int count4_ = 0;
                            Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                            Fallback0Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((typeValue == null) && count4_ < (3)) {
                                    // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                    s4_ = this.insert(new Fallback0Data(s4_original));
                                    InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s4_.interop_ = interop__1;
                                    if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s4_ != null) {
                                doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s4_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallback0_cache = null;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doFallback(Object, long, float, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, interop__1);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.value_, this.resolve_, this.type_}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doNative(Object, long, float, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopWrite_, 1);
                ((GenerateAOT.Provider) s3_.interopWrite_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteFloatNode.doStructured(Object, long, float, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignWriteFloatNode create() {
            return new ForeignWriteFloatNodeGen();
        }

        @NeverDefault
        public static ForeignWriteFloatNode getUncached() {
            return ForeignWriteFloatNodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignWriteFloatNode.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteFloatNode#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteFloatNode#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteFloatNode.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteFloatNode#doStructured}
             *   Parameter: {@link LLVMInteropWriteNode} interopWrite</pre>
             */
            @Child LLVMInteropWriteNode interopWrite_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteFloatNode.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteFloatNode#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteFloatNode.class)
        @DenyReplace
        private static final class Uncached extends ForeignWriteFloatNode {

            @TruffleBoundary
            @Override
            public void execute(Object foreignValue, long offsetValue, float valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBuffer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if ((typeValue == null)) {
                        doFallback(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignWriteDoubleNode#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignWriteDoubleNode#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignWriteDoubleNode#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignWriteDoubleNode#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteDoubleNode#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteDoubleNode#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ForeignWriteDoubleNode.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignWriteDoubleNodeGen extends ForeignWriteDoubleNode implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ForeignDummy value_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignWriteDoubleNode#doNative}
         *   2: SpecializationActive {@link ForeignWriteDoubleNode#doBuffer}
         *   3: SpecializationActive {@link ForeignWriteDoubleNode#doBuffer}
         *   4: SpecializationActive {@link ForeignWriteDoubleNode#doStructured}
         *   5: SpecializationActive {@link ForeignWriteDoubleNode#doFallback}
         *   6: SpecializationActive {@link ForeignWriteDoubleNode#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteDoubleNode#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;

        private ForeignWriteDoubleNodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.value_ = (ForeignDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public void execute(Object foreignValue, long offsetValue, double valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doNative(Object, long, double, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doStructured(Object, long, double, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doNative(Object, long, double, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                    return;
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doStructured(Object, long, double, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    this.buffer1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, oobProfile__);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doStructured(Object, long, double, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s4_.interop_);
                                    return;
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            if ((typeValue_ == null)) {
                                this.fallback1Boundary(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void buffer1Boundary(int state_0, Object foreignValue, long offsetValue, double valueValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doBuffer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, interop__, oobProfile__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallback1Boundary(int state_0, Object foreignValue, long offsetValue, double valueValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallback(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object foreignValue, long offsetValue, Object valueValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Double) {
                double valueValue_ = (double) valueValue;
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doNative(Object, long, double, LLVMNativePointer, Object)] */;
                    this.state_0_ = state_0;
                    doNative(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            while (true) {
                                int count1_ = 0;
                                Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                                Buffer0Data s1_original = s1_;
                                while (s1_ != null) {
                                    if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                        break;
                                    }
                                    count1_++;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ == null) {
                                    // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                    if (count1_ < (3)) {
                                        s1_ = this.insert(new Buffer0Data(s1_original));
                                        InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                        Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.interop_ = interop__;
                                        BranchProfile oobProfile__ = (BranchProfile.create());
                                        Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s1_.oobProfile_ = oobProfile__;
                                        if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s1_ != null) {
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            InteropLibrary interop__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    VarHandle.storeStoreFence();
                                    this.buffer1_oobProfile_ = oobProfile__;
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doBuffer(Object, long, double, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                    doBuffer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, interop__, oobProfile__);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        StructuredData s3_ = this.insert(new StructuredData());
                        s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                        VarHandle.storeStoreFence();
                        this.structured_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doStructured(Object, long, double, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
                        this.state_0_ = state_0;
                        doStructured(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, s3_.interopWrite_);
                        return;
                    }
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        while (true) {
                            int count4_ = 0;
                            Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                            Fallback0Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((typeValue == null) && count4_ < (3)) {
                                    // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                    s4_ = this.insert(new Fallback0Data(s4_original));
                                    InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s4_.interop_ = interop__1;
                                    if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s4_ != null) {
                                doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s4_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallback0_cache = null;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doFallback(Object, long, double, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallback(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, interop__1);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.value_, this.resolve_, this.type_}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doNative(Object, long, double, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopWrite_ = s3_.insert((LLVMInteropWriteNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopWrite_, 1);
                ((GenerateAOT.Provider) s3_.interopWrite_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode.doStructured(Object, long, double, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignWriteDoubleNode create() {
            return new ForeignWriteDoubleNodeGen();
        }

        @NeverDefault
        public static ForeignWriteDoubleNode getUncached() {
            return ForeignWriteDoubleNodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignWriteDoubleNode.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteDoubleNode#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteDoubleNode#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteDoubleNode.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteDoubleNode#doStructured}
             *   Parameter: {@link LLVMInteropWriteNode} interopWrite</pre>
             */
            @Child LLVMInteropWriteNode interopWrite_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteDoubleNode.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteDoubleNode#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteDoubleNode.class)
        @DenyReplace
        private static final class Uncached extends ForeignWriteDoubleNode {

            @TruffleBoundary
            @Override
            public void execute(Object foreignValue, long offsetValue, double valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNative(foreignValue, offsetValue, valueValue, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBuffer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if ((typeValue == null)) {
                        doFallback(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignWriteI64Node#doNativeLong}
     *     Activation probability: 0.19111
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ForeignWriteI64Node#doNativePointer}
     *     Activation probability: 0.17111
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignWriteI64Node#doBufferLong}
     *     Activation probability: 0.15111
     *     With/without class size: 7/8 bytes
     *   Specialization {@link ForeignWriteI64Node#doBufferPointer}
     *     Activation probability: 0.13111
     *     With/without class size: 7/12 bytes
     *   Specialization {@link ForeignWriteI64Node#doStructured}
     *     Activation probability: 0.11111
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI64Node#doFallbackLong}
     *     Activation probability: 0.09111
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignWriteI64Node#doFallbackLong}
     *     Activation probability: 0.07111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ForeignWriteI64Node#doFallbackPointer}
     *     Activation probability: 0.05111
     *     With/without class size: 5/8 bytes
     *   Specialization {@link ForeignWriteI64Node#doFallbackPointer}
     *     Activation probability: 0.03111
     *     With/without class size: 4/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignWriteI64Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignWriteI64NodeGen extends ForeignWriteI64Node implements GenerateAOT.Provider {

        static final ReferenceField<FallbackLong0Data> FALLBACK_LONG0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallbackLong0_cache", FallbackLong0Data.class);
        static final ReferenceField<FallbackPointer0Data> FALLBACK_POINTER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallbackPointer0_cache", FallbackPointer0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ForeignDummy value_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignWriteI64Node#doNativeLong}
         *   2: SpecializationActive {@link ForeignWriteI64Node#doNativePointer}
         *   3: SpecializationActive {@link ForeignWriteI64Node#doBufferLong}
         *   4: SpecializationActive {@link ForeignWriteI64Node#doBufferPointer}
         *   5: SpecializationActive {@link ForeignWriteI64Node#doStructured}
         *   6: SpecializationActive {@link ForeignWriteI64Node#doFallbackLong}
         *   7: SpecializationActive {@link ForeignWriteI64Node#doFallbackLong}
         *   8: SpecializationActive {@link ForeignWriteI64Node#doFallbackPointer}
         *   9: SpecializationActive {@link ForeignWriteI64Node#doFallbackPointer}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteI64Node#doNativePointer}
         *   Parameter: {@link ToNativePointerNode} toNativePointer</pre>
         */
        @Child private ToNativePointerNode nativePointer_toNativePointer_;
        @Child private BufferLongData bufferLong_cache;
        @Child private BufferPointerData bufferPointer_cache;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private FallbackLong0Data fallbackLong0_cache;
        @UnsafeAccessedField @Child private FallbackPointer0Data fallbackPointer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignWriteI64Node#doFallbackPointer}
         *   Parameter: {@link LLVMPointerDataEscapeNode} dataEscape</pre>
         */
        @Child private LLVMPointerDataEscapeNode fallbackPointer1_dataEscape_;

        private ForeignWriteI64NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.value_ = (ForeignDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public void execute(Object foreignValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] */ && valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        doNativeLong(foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_);
                        return;
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */) {
                        {
                            ToNativePointerNode toNativePointer__ = this.nativePointer_toNativePointer_;
                            if (toNativePointer__ != null) {
                                doNativePointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, toNativePointer__);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b1111111000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && valueValue instanceof Long) {
                            long valueValue_ = (long) valueValue;
                            BufferLongData s2_ = this.bufferLong_cache;
                            if (s2_ != null) {
                                doBufferLong(foreignValue, offsetValue, valueValue_, resolveValue__, typeValue__, s2_.interop_, s2_.oobProfile_);
                                return;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] */) {
                            BufferPointerData s3_ = this.bufferPointer_cache;
                            if (s3_ != null) {
                                doBufferPointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interop_, s3_.toNativePointer_, s3_.oobProfile_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s4_ = this.structured_cache;
                        if (s4_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s4_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b1111000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                        if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */ && valueValue instanceof Long) {
                            long valueValue_ = (long) valueValue;
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                                FallbackLong0Data s5_ = this.fallbackLong0_cache;
                                while (s5_ != null) {
                                    if ((s5_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                        doFallbackLong(foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_, s5_.interop_);
                                        return;
                                    }
                                    s5_ = s5_.next_;
                                }
                            }
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                                if ((typeValue_ == null)) {
                                    this.fallbackLong1Boundary(state_0, foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_);
                                    return;
                                }
                            }
                        }
                        if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */ && LLVMTypes.isPointer(valueValue)) {
                            LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                                FallbackPointer0Data s7_ = this.fallbackPointer0_cache;
                                while (s7_ != null) {
                                    if ((s7_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                        doFallbackPointer(foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_, s7_.dataEscape_, s7_.interop_);
                                        return;
                                    }
                                    s7_ = s7_.next_;
                                }
                            }
                            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                                {
                                    LLVMPointerDataEscapeNode dataEscape__ = this.fallbackPointer1_dataEscape_;
                                    if (dataEscape__ != null) {
                                        if ((typeValue_ == null)) {
                                            this.fallbackPointer1Boundary(state_0, foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_, dataEscape__);
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallbackLong1Boundary(int state_0, Object foreignValue, long offsetValue, long valueValue_, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallbackLong(foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_, interop__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallbackPointer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMPointer valueValue_, LLVMManagedPointer resolveValue__, Object typeValue_, LLVMPointerDataEscapeNode dataEscape__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallbackPointer(foreignValue, offsetValue, valueValue_, resolveValue__, typeValue_, dataEscape__, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executePointer(Object foreignValue, long offsetValue, LLVMPointer valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b1100110100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                if ((state_0 & 0b110100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                        LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                        {
                            ToNativePointerNode toNativePointer__ = this.nativePointer_toNativePointer_;
                            if (toNativePointer__ != null) {
                                doNativePointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, toNativePointer__);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                        LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                            Buffer typeValue__ = (Buffer) typeValue_;
                            BufferPointerData s3_ = this.bufferPointer_cache;
                            if (s3_ != null) {
                                doBufferPointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interop_, s3_.toNativePointer_, s3_.oobProfile_);
                                return;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                            Structured typeValue__ = (Structured) typeValue_;
                            StructuredData s4_ = this.structured_cache;
                            if (s4_ != null) {
                                doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s4_.interopWrite_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                        FallbackPointer0Data s7_ = this.fallbackPointer0_cache;
                        while (s7_ != null) {
                            if ((s7_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                doFallbackPointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s7_.dataEscape_, s7_.interop_);
                                return;
                            }
                            s7_ = s7_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                        {
                            LLVMPointerDataEscapeNode dataEscape__ = this.fallbackPointer1_dataEscape_;
                            if (dataEscape__ != null) {
                                if ((typeValue_ == null)) {
                                    this.fallbackPointer1Boundary0(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, dataEscape__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallbackPointer1Boundary0(int state_0, Object foreignValue, long offsetValue, LLVMPointer valueValue, LLVMManagedPointer resolveValue__, Object typeValue_, LLVMPointerDataEscapeNode dataEscape__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallbackPointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, dataEscape__, interop__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeLong(Object foreignValue, long offsetValue, long valueValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
                return;
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] */) {
                        doNativeLong(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                        return;
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */) {
                        {
                            ToNativePointerNode toNativePointer__ = this.nativePointer_toNativePointer_;
                            if (toNativePointer__ != null) {
                                doNativePointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, toNativePointer__);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b11111000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            BufferLongData s2_ = this.bufferLong_cache;
                            if (s2_ != null) {
                                doBufferLong(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s2_.interop_, s2_.oobProfile_);
                                return;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] */) {
                            BufferPointerData s3_ = this.bufferPointer_cache;
                            if (s3_ != null) {
                                doBufferPointer(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s3_.interop_, s3_.toNativePointer_, s3_.oobProfile_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s4_ = this.structured_cache;
                        if (s4_ != null) {
                            doStructured(foreignValue, offsetValue, valueValue, resolveValue__, typeValue__, s4_.interopWrite_);
                            return;
                        }
                    }
                    if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] || SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            FallbackLong0Data s5_ = this.fallbackLong0_cache;
                            while (s5_ != null) {
                                if ((s5_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    doFallbackLong(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, s5_.interop_);
                                    return;
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                            if ((typeValue_ == null)) {
                                this.fallbackLong1Boundary1(state_0, foreignValue, offsetValue, valueValue, resolveValue__, typeValue_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void fallbackLong1Boundary1(int state_0, Object foreignValue, long offsetValue, long valueValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    doFallbackLong(foreignValue, offsetValue, valueValue, resolveValue__, typeValue_, interop__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object foreignValue, long offsetValue, Object valueValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                if (valueValue instanceof Long) {
                    long valueValue_ = (long) valueValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] */;
                    this.state_0_ = state_0;
                    doNativeLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                    return;
                }
                ToNativePointerNode toNativePointer__ = this.insert((ToNativePointerNodeGen.create()));
                Objects.requireNonNull(toNativePointer__, "Specialization 'doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)' cache 'toNativePointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.nativePointer_toNativePointer_ = toNativePointer__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */;
                this.state_0_ = state_0;
                doNativePointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, toNativePointer__);
                return;
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        BufferLongData s2_ = this.insert(new BufferLongData());
                        InteropLibrary interop__2 = s2_.insert((INTEROP_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(interop__2, "Specialization 'doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.interop_ = interop__2;
                        BranchProfile oobProfile__ = (BranchProfile.create());
                        Objects.requireNonNull(oobProfile__, "Specialization 'doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.oobProfile_ = oobProfile__;
                        VarHandle.storeStoreFence();
                        this.bufferLong_cache = s2_;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferLong(Object, long, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                        this.state_0_ = state_0;
                        doBufferLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, interop__2, oobProfile__);
                        return;
                    }
                    BufferPointerData s3_ = this.insert(new BufferPointerData());
                    InteropLibrary interop__3 = s3_.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(interop__3, "Specialization 'doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s3_.interop_ = interop__3;
                    ToNativePointerNode toNativePointer__1 = s3_.insert((ToNativePointerNodeGen.create()));
                    Objects.requireNonNull(toNativePointer__1, "Specialization 'doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)' cache 'toNativePointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s3_.toNativePointer_ = toNativePointer__1;
                    BranchProfile oobProfile__1 = (BranchProfile.create());
                    Objects.requireNonNull(oobProfile__1, "Specialization 'doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s3_.oobProfile_ = oobProfile__1;
                    VarHandle.storeStoreFence();
                    this.bufferPointer_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doBufferPointer(Object, long, Object, LLVMManagedPointer, Buffer, InteropLibrary, ToNativePointerNode, BranchProfile)] */;
                    this.state_0_ = state_0;
                    doBufferPointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, interop__3, toNativePointer__1, oobProfile__1);
                    return;
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s4_ = this.insert(new StructuredData());
                    s4_.interopWrite_ = s4_.insert((LLVMInteropWriteNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s4_;
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
                    this.state_0_ = state_0;
                    doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, s4_.interopWrite_);
                    return;
                }
                if (valueValue instanceof Long) {
                    long valueValue_ = (long) valueValue;
                    if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */) {
                        while (true) {
                            int count5_ = 0;
                            FallbackLong0Data s5_ = FALLBACK_LONG0_CACHE_UPDATER.getVolatile(this);
                            FallbackLong0Data s5_original = s5_;
                            while (s5_ != null) {
                                if ((s5_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count5_++;
                                s5_ = s5_.next_;
                            }
                            if (s5_ == null) {
                                if ((typeValue == null) && count5_ < (3)) {
                                    // assert (s5_.interop_.accepts(resolveValue_.getObject()));
                                    s5_ = this.insert(new FallbackLong0Data(s5_original));
                                    InteropLibrary interop__ = s5_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s5_.interop_ = interop__;
                                    if (!FALLBACK_LONG0_CACHE_UPDATER.compareAndSet(this, s5_original, s5_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s5_ != null) {
                                doFallbackLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s5_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallbackLong0_cache = null;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackLong(Object, long, long, LLVMManagedPointer, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallbackLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, interop__);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (LLVMTypes.isPointer(valueValue)) {
                    LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                    if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */) {
                        while (true) {
                            int count7_ = 0;
                            FallbackPointer0Data s7_ = FALLBACK_POINTER0_CACHE_UPDATER.getVolatile(this);
                            FallbackPointer0Data s7_original = s7_;
                            while (s7_ != null) {
                                if ((s7_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                    break;
                                }
                                count7_++;
                                s7_ = s7_.next_;
                            }
                            if (s7_ == null) {
                                if ((typeValue == null) && count7_ < (3)) {
                                    // assert (s7_.interop_.accepts(resolveValue_.getObject()));
                                    s7_ = this.insert(new FallbackPointer0Data(s7_original));
                                    LLVMPointerDataEscapeNode dataEscape__ = s7_.insert((LLVMPointerDataEscapeNodeGen.create()));
                                    Objects.requireNonNull(dataEscape__, "Specialization 'doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s7_.dataEscape_ = dataEscape__;
                                    InteropLibrary interop__1 = s7_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__1, "Specialization 'doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s7_.interop_ = interop__1;
                                    if (!FALLBACK_POINTER0_CACHE_UPDATER.compareAndSet(this, s7_original, s7_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s7_ != null) {
                                doFallbackPointer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, s7_.dataEscape_, s7_.interop_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__1 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((typeValue == null)) {
                                    LLVMPointerDataEscapeNode dataEscape__ = this.insert((LLVMPointerDataEscapeNodeGen.create()));
                                    Objects.requireNonNull(dataEscape__, "Specialization 'doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    VarHandle.storeStoreFence();
                                    this.fallbackPointer1_dataEscape_ = dataEscape__;
                                    interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                    this.fallbackPointer0_cache = null;
                                    state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doFallbackPointer(Object, long, LLVMPointer, LLVMManagedPointer, Object, LLVMPointerDataEscapeNode, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    doFallbackPointer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, dataEscape__, interop__1);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.value_, this.resolve_, this.type_}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111111110) & ((state_0 & 0b1111111110) - 1)) == 0 /* is-single  */) {
                    FallbackLong0Data s5_ = this.fallbackLong0_cache;
                    FallbackPointer0Data s7_ = this.fallbackPointer0_cache;
                    if ((s5_ == null || s5_.next_ == null) && (s7_ == null || s7_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativeLong(Object, long, long, LLVMNativePointer, Object)] */;
            }
            {
                ToNativePointerNode toNativePointer__ = this.insert((ToNativePointerNodeGen.create()));
                Objects.requireNonNull(toNativePointer__, "Specialization 'doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)' cache 'toNativePointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.nativePointer_toNativePointer_ = toNativePointer__;
                assert NodeUtil.assertRecursion(this.nativePointer_toNativePointer_, 1);
                ((GenerateAOT.Provider) this.nativePointer_toNativePointer_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doNativePointer(Object, long, Object, LLVMNativePointer, Object, ToNativePointerNode)] */;
            }
            {
                StructuredData s4_ = this.insert(new StructuredData());
                s4_.interopWrite_ = s4_.insert((LLVMInteropWriteNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s4_;
                assert NodeUtil.assertRecursion(s4_.interopWrite_, 1);
                ((GenerateAOT.Provider) s4_.interopWrite_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMWriteToForeignObjectNode.ForeignWriteI64Node.doStructured(Object, long, Object, LLVMManagedPointer, Structured, LLVMInteropWriteNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.nativePointer_toNativePointer_ = null;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignWriteI64Node create() {
            return new ForeignWriteI64NodeGen();
        }

        @NeverDefault
        public static ForeignWriteI64Node getUncached() {
            return ForeignWriteI64NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignWriteI64Node.class)
        @DenyReplace
        private static final class BufferLongData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doBufferLong}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doBufferLong}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            BufferLongData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI64Node.class)
        @DenyReplace
        private static final class BufferPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doBufferPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doBufferPointer}
             *   Parameter: {@link ToNativePointerNode} toNativePointer</pre>
             */
            @Child ToNativePointerNode toNativePointer_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doBufferPointer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            BufferPointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI64Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doStructured}
             *   Parameter: {@link LLVMInteropWriteNode} interopWrite</pre>
             */
            @Child LLVMInteropWriteNode interopWrite_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI64Node.class)
        @DenyReplace
        private static final class FallbackLong0Data extends Node implements SpecializationDataNode {

            @Child FallbackLong0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doFallbackLong}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            FallbackLong0Data(FallbackLong0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI64Node.class)
        @DenyReplace
        private static final class FallbackPointer0Data extends Node implements SpecializationDataNode {

            @Child FallbackPointer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doFallbackPointer}
             *   Parameter: {@link LLVMPointerDataEscapeNode} dataEscape</pre>
             */
            @Child LLVMPointerDataEscapeNode dataEscape_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignWriteI64Node#doFallbackPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            FallbackPointer0Data(FallbackPointer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignWriteI64Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignWriteI64Node {

            @TruffleBoundary
            @Override
            public void execute(Object foreignValue, long offsetValue, Object valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    if (valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        doNativeLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue);
                        return;
                    }
                    doNativePointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (ToNativePointerNodeGen.getUncached()));
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        if (valueValue instanceof Long) {
                            long valueValue_ = (long) valueValue;
                            doBufferLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
                            return;
                        }
                        doBufferPointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached()), (ToNativePointerNodeGen.getUncached()), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if (valueValue instanceof Long) {
                        long valueValue_ = (long) valueValue;
                        if ((typeValue == null)) {
                            doFallbackLong(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                            return;
                        }
                    }
                    if (LLVMTypes.isPointer(valueValue)) {
                        LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                        if ((typeValue == null)) {
                            doFallbackPointer(foreignValue, offsetValue, valueValue_, resolveValue_, typeValue, (LLVMPointerDataEscapeNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                            return;
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @TruffleBoundary
            @Override
            public void executePointer(Object foreignValue, long offsetValue, LLVMPointer valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNativePointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (ToNativePointerNodeGen.getUncached()));
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBufferPointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached()), (ToNativePointerNodeGen.getUncached()), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if ((typeValue == null)) {
                        doFallbackPointer(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (LLVMPointerDataEscapeNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @TruffleBoundary
            @Override
            public void executeLong(Object foreignValue, long offsetValue, long valueValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    doNativeLong(foreignValue, offsetValue, valueValue, resolveValue_, typeValue);
                    return;
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        doBufferLong(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
                        return;
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        doStructured(foreignValue, offsetValue, valueValue, resolveValue_, typeValue_, (LLVMInteropWriteNodeGen.getUncached()));
                        return;
                    }
                    if ((typeValue == null)) {
                        doFallbackLong(foreignValue, offsetValue, valueValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, foreignValue, offsetValue, valueValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
