// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Value;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.ValueKind;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMForeignWriteNode#doValue}
 *     Activation probability: 0.65000
 *     With/without class size: 24/12 bytes
 *   Specialization {@link LLVMForeignWriteNode#doStructured}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMForeignWriteNode.class)
@SuppressWarnings("javadoc")
public final class LLVMForeignWriteNodeGen extends LLVMForeignWriteNode implements GenerateAOT.Provider {

    static final ReferenceField<ValueData> VALUE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "value_cache", ValueData.class);
    private static final Uncached UNCACHED = new Uncached();
    @CompilationFinal(dimensions = 1) private static final ValueKind[] VALUE_KIND_VALUES = DSLSupport.lookupEnumConstants(ValueKind.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMForeignWriteNode#doValue}
     *   2: SpecializationActive {@link LLVMForeignWriteNode#doStructured}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private ValueData value_cache;

    private LLVMForeignWriteNodeGen() {
    }

    @ExplodeLoop
    @Override
    public void execute(LLVMPointer arg0Value, LLVMInteropType arg1Value, Object arg2Value) throws UnsupportedMessageException {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMForeignWriteNode.doValue(LLVMPointer, Value, Object, ValueKind, LLVMOffsetStoreNode, ForeignToLLVM)] || SpecializationActive[LLVMForeignWriteNode.doStructured(LLVMPointer, Structured, Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMForeignWriteNode.doValue(LLVMPointer, Value, Object, ValueKind, LLVMOffsetStoreNode, ForeignToLLVM)] */ && arg1Value instanceof Value) {
                Value arg1Value_ = (Value) arg1Value;
                ValueData s0_ = this.value_cache;
                while (s0_ != null) {
                    if ((arg1Value_.kind == decodeValueKind((s0_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */) - 2))) {
                        LLVMForeignWriteNode.doValue(arg0Value, arg1Value_, arg2Value, decodeValueKind((s0_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */) - 2), s0_.store_, s0_.toLLVM_);
                        return;
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMForeignWriteNode.doStructured(LLVMPointer, Structured, Object)] */ && arg1Value instanceof Structured) {
                Structured arg1Value_ = (Structured) arg1Value;
                LLVMForeignWriteNode.doStructured(arg0Value, arg1Value_, arg2Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        return;
    }

    private void executeAndSpecialize(LLVMPointer arg0Value, LLVMInteropType arg1Value, Object arg2Value) throws UnsupportedMessageException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg1Value instanceof Value) {
            Value arg1Value_ = (Value) arg1Value;
            while (true) {
                int count0_ = 0;
                ValueData s0_ = VALUE_CACHE_UPDATER.getVolatile(this);
                ValueData s0_original = s0_;
                while (s0_ != null) {
                    if ((arg1Value_.kind == decodeValueKind((s0_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */) - 2))) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    // assert (arg1Value_.kind == decodeValueKind((s0_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */) - 2));
                    if (count0_ < (LLVMForeignWriteNode.VALUE_KIND_COUNT)) {
                        s0_ = this.insert(new ValueData(s0_original));
                        s0_.value_state_0_ = (s0_.value_state_0_ | ((encodeValueKind((arg1Value_.kind)) + 2) << 0) /* set-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */);
                        s0_.store_ = s0_.insert((LLVMOffsetStoreNode.create(decodeValueKind((s0_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */) - 2))));
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM(arg1Value_)));
                        if (!VALUE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMForeignWriteNode.doValue(LLVMPointer, Value, Object, ValueKind, LLVMOffsetStoreNode, ForeignToLLVM)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s0_ != null) {
                    LLVMForeignWriteNode.doValue(arg0Value, arg1Value_, arg2Value, decodeValueKind((s0_.value_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)] */) - 2), s0_.store_, s0_.toLLVM_);
                    return;
                }
                break;
            }
        }
        if (arg1Value instanceof Structured) {
            Structured arg1Value_ = (Structured) arg1Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMForeignWriteNode.doStructured(LLVMPointer, Structured, Object)] */;
            this.state_0_ = state_0;
            LLVMForeignWriteNode.doStructured(arg0Value, arg1Value_, arg2Value);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                ValueData s0_ = this.value_cache;
                if ((s0_ == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMForeignWriteNode.doStructured(LLVMPointer, Structured, Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMForeignWriteNode create() {
        return new LLVMForeignWriteNodeGen();
    }

    @NeverDefault
    public static LLVMForeignWriteNode getUncached() {
        return LLVMForeignWriteNodeGen.UNCACHED;
    }

    private static ValueKind decodeValueKind(int state) {
        if (state >= 0) {
            return VALUE_KIND_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeValueKind(ValueKind e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    @GeneratedBy(LLVMForeignWriteNode.class)
    @DenyReplace
    private static final class ValueData extends Node implements SpecializationDataNode {

        @Child ValueData next_;
        /**
         * State Info: <pre>
         *   0-3: EncodedEnum[cache=LLVMForeignWriteNode.doValue(..., ValueKind cachedKind, ...)]
         * </pre>
         */
        @CompilationFinal private int value_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMForeignWriteNode#doValue}
         *   Parameter: {@link LLVMOffsetStoreNode} store</pre>
         */
        @Child LLVMOffsetStoreNode store_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMForeignWriteNode#doValue}
         *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
         */
        @Child ForeignToLLVM toLLVM_;

        ValueData(ValueData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMForeignWriteNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMForeignWriteNode {

        @TruffleBoundary
        @Override
        public void execute(LLVMPointer arg0Value, LLVMInteropType arg1Value, Object arg2Value) throws UnsupportedMessageException {
            if (arg1Value instanceof Value) {
                Value arg1Value_ = (Value) arg1Value;
                // assert (arg1Value_.kind == (arg1Value_.kind));
                LLVMForeignWriteNode.doValue(arg0Value, arg1Value_, arg2Value, (arg1Value_.kind), (LLVMOffsetStoreNode.getUncached((arg1Value_.kind))), (ForeignToLLVM.getSlowPath()));
                return;
            }
            if (arg1Value instanceof Structured) {
                Structured arg1Value_ = (Structured) arg1Value;
                LLVMForeignWriteNode.doStructured(arg0Value, arg1Value_, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
