// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.ToNativePointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.ToNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToNativeNode#doConvert}
 *     Activation probability: 1.00000
 *     With/without class size: 24/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMToNativeNode.class)
@SuppressWarnings("javadoc")
public final class LLVMToNativeNodeGen extends LLVMToNativeNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToNativeNode#doConvert}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMToNativeNode#doConvert}
     *   Parameter: {@link ToNativePointerNode} toNativePointer</pre>
     */
    @Child private ToNativePointerNode toNativePointer_;

    private LLVMToNativeNodeGen() {
    }

    @Override
    public LLVMNativePointer executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToNativeNode.doConvert(Object, ToNativePointerNode)] */) {
            {
                ToNativePointerNode toNativePointer__ = this.toNativePointer_;
                if (toNativePointer__ != null) {
                    return LLVMToNativeNode.doConvert(arg0Value, toNativePointer__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private LLVMNativePointer executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        ToNativePointerNode toNativePointer__ = this.insert((ToNativePointerNodeGen.create()));
        Objects.requireNonNull(toNativePointer__, "Specialization 'doConvert(Object, ToNativePointerNode)' cache 'toNativePointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.toNativePointer_ = toNativePointer__;
        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToNativeNode.doConvert(Object, ToNativePointerNode)] */;
        this.state_0_ = state_0;
        return LLVMToNativeNode.doConvert(arg0Value, toNativePointer__);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            ToNativePointerNode toNativePointer__ = this.insert((ToNativePointerNodeGen.create()));
            Objects.requireNonNull(toNativePointer__, "Specialization 'doConvert(Object, ToNativePointerNode)' cache 'toNativePointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.toNativePointer_ = toNativePointer__;
            assert NodeUtil.assertRecursion(this.toNativePointer_, 1);
            ((GenerateAOT.Provider) this.toNativePointer_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToNativeNode.doConvert(Object, ToNativePointerNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.toNativePointer_ = null;
    }

    @NeverDefault
    public static LLVMToNativeNode create() {
        return new LLVMToNativeNodeGen();
    }

    @NeverDefault
    public static LLVMToNativeNode getUncached() {
        return LLVMToNativeNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMToNativeNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMToNativeNode {

        @TruffleBoundary
        @Override
        public LLVMNativePointer executeWithTarget(Object arg0Value) {
            return LLVMToNativeNode.doConvert(arg0Value, (ToNativePointerNodeGen.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
