// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMResumeNode#doRethrow}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMResumeNode.class)
@SuppressWarnings("javadoc")
public final class LLVMResumeNodeGen extends LLVMResumeNode implements GenerateAOT.Provider {

    private final int exceptionSlot;

    private LLVMResumeNodeGen(int exceptionSlot) {
        this.exceptionSlot = exceptionSlot;
    }

    @Override
    int getExceptionSlot() {
        return this.exceptionSlot;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        doRethrow(frameValue);
        return;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.MONOMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        {
        }
    }

    @NeverDefault
    public static LLVMResumeNode create(int exceptionSlot) {
        return new LLVMResumeNodeGen(exceptionSlot);
    }

}
