// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMArrayTypeIDNode#doArray}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMArrayTypeIDNode#doError}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMArrayTypeIDNode.class)
@SuppressWarnings("javadoc")
public final class LLVMArrayTypeIDNodeGen extends LLVMArrayTypeIDNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode base_;
    @Child private LLVMExpressionNode len_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMArrayTypeIDNode#doArray}
     *   2: SpecializationActive {@link LLVMArrayTypeIDNode#doError}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMArrayTypeIDNodeGen(LLVMExpressionNode base, LLVMExpressionNode len) {
        this.base_ = base;
        this.len_ = len;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(Object baseValue, Object lenValue) {
        if (baseValue instanceof LLVMInteropType && lenValue instanceof Long) {
            long lenValue_ = (long) lenValue;
            if ((lenValue_ >= 0)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] && SpecializationActive[LLVMArrayTypeIDNode.doError(Object, Object)] */)) {
            return executeGeneric_long0(state_0, frameValue);
        } else {
            return executeGeneric_generic1(state_0, frameValue);
        }
    }

    private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        long lenValue_;
        try {
            lenValue_ = this.len_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, lenValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] */;
        if (baseValue_ instanceof LLVMInteropType) {
            LLVMInteropType baseValue__ = (LLVMInteropType) baseValue_;
            if ((lenValue_ >= 0)) {
                return doArray(baseValue__, lenValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, lenValue_);
    }

    private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        Object lenValue_ = this.len_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, lenValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] || SpecializationActive[LLVMArrayTypeIDNode.doError(Object, Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] */ && baseValue_ instanceof LLVMInteropType) {
                LLVMInteropType baseValue__ = (LLVMInteropType) baseValue_;
                if (lenValue_ instanceof Long) {
                    long lenValue__ = (long) lenValue_;
                    if ((lenValue__ >= 0)) {
                        return doArray(baseValue__, lenValue__);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArrayTypeIDNode.doError(Object, Object)] */) {
                if (fallbackGuard_(baseValue_, lenValue_)) {
                    return doError(baseValue_, lenValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, lenValue_);
    }

    private Object executeAndSpecialize(Object baseValue, Object lenValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (baseValue instanceof LLVMInteropType) {
            LLVMInteropType baseValue_ = (LLVMInteropType) baseValue;
            if (lenValue instanceof Long) {
                long lenValue_ = (long) lenValue;
                if ((lenValue_ >= 0)) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] */;
                    this.state_0_ = state_0;
                    return doArray(baseValue_, lenValue_);
                }
            }
        }
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMArrayTypeIDNode.doError(Object, Object)] */;
        this.state_0_ = state_0;
        return doError(baseValue, lenValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMArrayTypeIDNode.doArray(LLVMInteropType, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMArrayTypeIDNode.doError(Object, Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMArrayTypeIDNode create(LLVMExpressionNode base, LLVMExpressionNode len) {
        return new LLVMArrayTypeIDNodeGen(base, len);
    }

}
