// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMComplexDoubleMul#doDouble}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMComplexDoubleMul.class)
@SuppressWarnings("javadoc")
public final class LLVMComplexDoubleMulNodeGen extends LLVMComplexDoubleMul implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode result_;
    @Child private LLVMExpressionNode a_;
    @Child private LLVMExpressionNode b_;
    @Child private LLVMExpressionNode c_;
    @Child private LLVMExpressionNode d_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMComplexDoubleMul#doDouble}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMComplexDoubleMulNodeGen(LLVMExpressionNode result, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.result_ = result;
        this.a_ = a;
        this.b_ = b;
        this.c_ = c;
        this.d_ = d;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object resultValue_ = this.result_.executeGeneric(frameValue);
        double aValue_;
        try {
            aValue_ = this.a_.executeDouble(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object bValue = this.b_.executeGeneric(frameValue);
            Object cValue = this.c_.executeGeneric(frameValue);
            Object dValue = this.d_.executeGeneric(frameValue);
            return executeAndSpecialize(resultValue_, ex.getResult(), bValue, cValue, dValue);
        }
        double bValue_;
        try {
            bValue_ = this.b_.executeDouble(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object cValue = this.c_.executeGeneric(frameValue);
            Object dValue = this.d_.executeGeneric(frameValue);
            return executeAndSpecialize(resultValue_, aValue_, ex.getResult(), cValue, dValue);
        }
        double cValue_;
        try {
            cValue_ = this.c_.executeDouble(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object dValue = this.d_.executeGeneric(frameValue);
            return executeAndSpecialize(resultValue_, aValue_, bValue_, ex.getResult(), dValue);
        }
        double dValue_;
        try {
            dValue_ = this.d_.executeDouble(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(resultValue_, aValue_, bValue_, cValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(resultValue_, aValue_, bValue_, cValue_, dValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMComplexDoubleMul.doDouble(LLVMPointer, double, double, double, double)] */ && LLVMTypes.isPointer(resultValue_)) {
            LLVMPointer resultValue__ = LLVMTypes.asPointer(resultValue_);
            return doDouble(resultValue__, aValue_, bValue_, cValue_, dValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(resultValue_, aValue_, bValue_, cValue_, dValue_);
    }

    private LLVMPointer executeAndSpecialize(Object resultValue, Object aValue, Object bValue, Object cValue, Object dValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(resultValue)) {
            LLVMPointer resultValue_ = LLVMTypes.asPointer(resultValue);
            if (aValue instanceof Double) {
                double aValue_ = (double) aValue;
                if (bValue instanceof Double) {
                    double bValue_ = (double) bValue;
                    if (cValue instanceof Double) {
                        double cValue_ = (double) cValue;
                        if (dValue instanceof Double) {
                            double dValue_ = (double) dValue;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMComplexDoubleMul.doDouble(LLVMPointer, double, double, double, double)] */;
                            this.state_0_ = state_0;
                            return doDouble(resultValue_, aValue_, bValue_, cValue_, dValue_);
                        }
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.result_, this.a_, this.b_, this.c_, this.d_}, resultValue, aValue, bValue, cValue, dValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMComplexDoubleMul.doDouble(LLVMPointer, double, double, double, double)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMComplexDoubleMul create(LLVMExpressionNode result, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        return new LLVMComplexDoubleMulNodeGen(result, a, b, c, d);
    }

}
