// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugThreadLocalGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToDebugValueNode#fromBoolean}
 *     Activation probability: 0.07617
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromByte}
 *     Activation probability: 0.07317
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromShort}
 *     Activation probability: 0.07017
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromInt}
 *     Activation probability: 0.06717
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromLong}
 *     Activation probability: 0.06417
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromIVarBit}
 *     Activation probability: 0.06117
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromNativePointer}
 *     Activation probability: 0.05817
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromManagedPointer}
 *     Activation probability: 0.05517
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromFunctionHandle}
 *     Activation probability: 0.05217
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromFloat}
 *     Activation probability: 0.04917
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromDouble}
 *     Activation probability: 0.04617
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#from80BitFloat}
 *     Activation probability: 0.04317
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromI1Vector}
 *     Activation probability: 0.04017
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromI8Vector}
 *     Activation probability: 0.03717
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromI16Vector}
 *     Activation probability: 0.03417
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromI32Vector}
 *     Activation probability: 0.03117
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromI64Vector}
 *     Activation probability: 0.02817
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromFloatVector}
 *     Activation probability: 0.02517
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromDoubleVector}
 *     Activation probability: 0.02217
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromAddressVector}
 *     Activation probability: 0.01917
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromGlobalContainer}
 *     Activation probability: 0.01617
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromGlobal}
 *     Activation probability: 0.01317
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromThreadLocalGlobal}
 *     Activation probability: 0.01017
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMToDebugValueNode#fromGenericObject}
 *     Activation probability: 0.00717
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMToDebugValueNode.class)
@SuppressWarnings("javadoc")
public final class LLVMToDebugValueNodeGen extends LLVMToDebugValueNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToDebugValueNode#fromBoolean}
     *   2: SpecializationActive {@link LLVMToDebugValueNode#fromByte}
     *   3: SpecializationActive {@link LLVMToDebugValueNode#fromShort}
     *   4: SpecializationActive {@link LLVMToDebugValueNode#fromInt}
     *   5: SpecializationActive {@link LLVMToDebugValueNode#fromLong}
     *   6: SpecializationActive {@link LLVMToDebugValueNode#fromIVarBit}
     *   7: SpecializationActive {@link LLVMToDebugValueNode#fromNativePointer}
     *   8: SpecializationActive {@link LLVMToDebugValueNode#fromManagedPointer}
     *   9: SpecializationActive {@link LLVMToDebugValueNode#fromFunctionHandle}
     *   10: SpecializationActive {@link LLVMToDebugValueNode#fromFloat}
     *   11: SpecializationActive {@link LLVMToDebugValueNode#fromDouble}
     *   12: SpecializationActive {@link LLVMToDebugValueNode#from80BitFloat}
     *   13: SpecializationActive {@link LLVMToDebugValueNode#fromI1Vector}
     *   14: SpecializationActive {@link LLVMToDebugValueNode#fromI8Vector}
     *   15: SpecializationActive {@link LLVMToDebugValueNode#fromI16Vector}
     *   16: SpecializationActive {@link LLVMToDebugValueNode#fromI32Vector}
     *   17: SpecializationActive {@link LLVMToDebugValueNode#fromI64Vector}
     *   18: SpecializationActive {@link LLVMToDebugValueNode#fromFloatVector}
     *   19: SpecializationActive {@link LLVMToDebugValueNode#fromDoubleVector}
     *   20: SpecializationActive {@link LLVMToDebugValueNode#fromAddressVector}
     *   21: SpecializationActive {@link LLVMToDebugValueNode#fromGlobalContainer}
     *   22: SpecializationActive {@link LLVMToDebugValueNode#fromGlobal}
     *   23: SpecializationActive {@link LLVMToDebugValueNode#fromThreadLocalGlobal}
     *   24: SpecializationActive {@link LLVMToDebugValueNode#fromGenericObject}
     *   25-27: ImplicitCast[type=LLVMIVarBit, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMToDebugValueNode#fromGlobal}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile fromGlobal_exception_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMToDebugValueNode#fromThreadLocalGlobal}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile fromThreadLocalGlobal_exception_;

    private LLVMToDebugValueNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromBoolean(boolean)] */) && arg0Value instanceof Boolean) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromByte(byte)] */) && arg0Value instanceof Byte) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromShort(short)] */) && arg0Value instanceof Short) {
            return false;
        }
        if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromInt(int)] */) && arg0Value instanceof Integer) {
            return false;
        }
        if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromLong(long)] */) && arg0Value instanceof Long) {
            return false;
        }
        if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
            return false;
        }
        if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromNativePointer(LLVMNativePointer)] */) && LLVMTypes.isNativePointer(arg0Value)) {
            return false;
        }
        if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromManagedPointer(LLVMManagedPointer)] */) && LLVMTypes.isManagedPointer(arg0Value)) {
            return false;
        }
        if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromFunctionHandle(LLVMFunctionDescriptor)] */) && arg0Value instanceof LLVMFunctionDescriptor) {
            return false;
        }
        if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromFloat(float)] */) && arg0Value instanceof Float) {
            return false;
        }
        if (!((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromDouble(double)] */) && arg0Value instanceof Double) {
            return false;
        }
        if (!((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.from80BitFloat(LLVM80BitFloat)] */) && arg0Value instanceof LLVM80BitFloat) {
            return false;
        }
        if (!((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI1Vector(LLVMI1Vector)] */) && arg0Value instanceof LLVMI1Vector) {
            return false;
        }
        if (!((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI8Vector(LLVMI8Vector)] */) && arg0Value instanceof LLVMI8Vector) {
            return false;
        }
        if (!((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI16Vector(LLVMI16Vector)] */) && arg0Value instanceof LLVMI16Vector) {
            return false;
        }
        if (!((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI32Vector(LLVMI32Vector)] */) && arg0Value instanceof LLVMI32Vector) {
            return false;
        }
        if (!((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI64Vector(LLVMI64Vector)] */) && arg0Value instanceof LLVMI64Vector) {
            return false;
        }
        if (!((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromFloatVector(LLVMFloatVector)] */) && arg0Value instanceof LLVMFloatVector) {
            return false;
        }
        if (!((state_0 & 0x80000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromDoubleVector(LLVMDoubleVector)] */) && arg0Value instanceof LLVMDoubleVector) {
            return false;
        }
        if (!((state_0 & 0x100000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromAddressVector(LLVMPointerVector)] */) && arg0Value instanceof LLVMPointerVector) {
            return false;
        }
        if (!((state_0 & 0x200000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromGlobalContainer(LLVMGlobalContainer)] */) && arg0Value instanceof LLVMGlobalContainer) {
            return false;
        }
        if (!((state_0 & 0x400000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromGlobal(LLVMDebugGlobalVariable, BranchProfile)] */) && arg0Value instanceof LLVMDebugGlobalVariable) {
            return false;
        }
        if (!((state_0 & 0x800000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)] */) && arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
            return false;
        }
        return true;
    }

    @Override
    protected LLVMDebugValue executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0x1fffffe) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromBoolean(boolean)] || SpecializationActive[LLVMToDebugValueNode.fromByte(byte)] || SpecializationActive[LLVMToDebugValueNode.fromShort(short)] || SpecializationActive[LLVMToDebugValueNode.fromInt(int)] || SpecializationActive[LLVMToDebugValueNode.fromLong(long)] || SpecializationActive[LLVMToDebugValueNode.fromIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToDebugValueNode.fromNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMToDebugValueNode.fromManagedPointer(LLVMManagedPointer)] || SpecializationActive[LLVMToDebugValueNode.fromFunctionHandle(LLVMFunctionDescriptor)] || SpecializationActive[LLVMToDebugValueNode.fromFloat(float)] || SpecializationActive[LLVMToDebugValueNode.fromDouble(double)] || SpecializationActive[LLVMToDebugValueNode.from80BitFloat(LLVM80BitFloat)] || SpecializationActive[LLVMToDebugValueNode.fromI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToDebugValueNode.fromI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToDebugValueNode.fromI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToDebugValueNode.fromI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToDebugValueNode.fromI64Vector(LLVMI64Vector)] || SpecializationActive[LLVMToDebugValueNode.fromFloatVector(LLVMFloatVector)] || SpecializationActive[LLVMToDebugValueNode.fromDoubleVector(LLVMDoubleVector)] || SpecializationActive[LLVMToDebugValueNode.fromAddressVector(LLVMPointerVector)] || SpecializationActive[LLVMToDebugValueNode.fromGlobalContainer(LLVMGlobalContainer)] || SpecializationActive[LLVMToDebugValueNode.fromGlobal(LLVMDebugGlobalVariable, BranchProfile)] || SpecializationActive[LLVMToDebugValueNode.fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)] || SpecializationActive[LLVMToDebugValueNode.fromGenericObject(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, arg0Value)) {
                LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, arg0Value);
                return fromIVarBit(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromNativePointer(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                return fromNativePointer(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromManagedPointer(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return fromManagedPointer(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromFunctionHandle(LLVMFunctionDescriptor)] */ && arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                return fromFunctionHandle(arg0Value_);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.from80BitFloat(LLVM80BitFloat)] */ && arg0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat arg0Value_ = (LLVM80BitFloat) arg0Value;
                return from80BitFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI1Vector(LLVMI1Vector)] */ && arg0Value instanceof LLVMI1Vector) {
                LLVMI1Vector arg0Value_ = (LLVMI1Vector) arg0Value;
                return fromI1Vector(arg0Value_);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI8Vector(LLVMI8Vector)] */ && arg0Value instanceof LLVMI8Vector) {
                LLVMI8Vector arg0Value_ = (LLVMI8Vector) arg0Value;
                return fromI8Vector(arg0Value_);
            }
            if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI16Vector(LLVMI16Vector)] */ && arg0Value instanceof LLVMI16Vector) {
                LLVMI16Vector arg0Value_ = (LLVMI16Vector) arg0Value;
                return fromI16Vector(arg0Value_);
            }
            if ((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI32Vector(LLVMI32Vector)] */ && arg0Value instanceof LLVMI32Vector) {
                LLVMI32Vector arg0Value_ = (LLVMI32Vector) arg0Value;
                return fromI32Vector(arg0Value_);
            }
            if ((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromI64Vector(LLVMI64Vector)] */ && arg0Value instanceof LLVMI64Vector) {
                LLVMI64Vector arg0Value_ = (LLVMI64Vector) arg0Value;
                return fromI64Vector(arg0Value_);
            }
            if ((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromFloatVector(LLVMFloatVector)] */ && arg0Value instanceof LLVMFloatVector) {
                LLVMFloatVector arg0Value_ = (LLVMFloatVector) arg0Value;
                return fromFloatVector(arg0Value_);
            }
            if ((state_0 & 0x80000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromDoubleVector(LLVMDoubleVector)] */ && arg0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector arg0Value_ = (LLVMDoubleVector) arg0Value;
                return fromDoubleVector(arg0Value_);
            }
            if ((state_0 & 0x100000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromAddressVector(LLVMPointerVector)] */ && arg0Value instanceof LLVMPointerVector) {
                LLVMPointerVector arg0Value_ = (LLVMPointerVector) arg0Value;
                return fromAddressVector(arg0Value_);
            }
            if ((state_0 & 0x200000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromGlobalContainer(LLVMGlobalContainer)] */ && arg0Value instanceof LLVMGlobalContainer) {
                LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer) arg0Value;
                return fromGlobalContainer(arg0Value_);
            }
            if ((state_0 & 0x400000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromGlobal(LLVMDebugGlobalVariable, BranchProfile)] */ && arg0Value instanceof LLVMDebugGlobalVariable) {
                LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable) arg0Value;
                {
                    BranchProfile exception__ = this.fromGlobal_exception_;
                    if (exception__ != null) {
                        return fromGlobal(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0x800000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)] */ && arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
                LLVMDebugThreadLocalGlobalVariable arg0Value_ = (LLVMDebugThreadLocalGlobalVariable) arg0Value;
                {
                    BranchProfile exception__1 = this.fromThreadLocalGlobal_exception_;
                    if (exception__1 != null) {
                        return fromThreadLocalGlobal(arg0Value_, exception__1);
                    }
                }
            }
            if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[LLVMToDebugValueNode.fromGenericObject(Object)] */) {
                if (fallbackGuard_(state_0, arg0Value)) {
                    return fromGenericObject(arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private LLVMDebugValue executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToDebugValueNode.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToDebugValueNode.fromByte(byte)] */;
            this.state_0_ = state_0;
            return fromByte(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToDebugValueNode.fromShort(short)] */;
            this.state_0_ = state_0;
            return fromShort(arg0Value_);
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToDebugValueNode.fromInt(int)] */;
            this.state_0_ = state_0;
            return fromInt(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToDebugValueNode.fromLong(long)] */;
            this.state_0_ = state_0;
            return fromLong(arg0Value_);
        }
        {
            int lLVMIVarBitCast0;
            if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(arg0Value)) != 0) {
                LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, arg0Value);
                state_0 = (state_0 | (lLVMIVarBitCast0 << 25) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToDebugValueNode.fromIVarBit(LLVMIVarBit)] */;
                this.state_0_ = state_0;
                return fromIVarBit(arg0Value_);
            }
        }
        if (LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToDebugValueNode.fromNativePointer(LLVMNativePointer)] */;
            this.state_0_ = state_0;
            return fromNativePointer(arg0Value_);
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToDebugValueNode.fromManagedPointer(LLVMManagedPointer)] */;
            this.state_0_ = state_0;
            return fromManagedPointer(arg0Value_);
        }
        if (arg0Value instanceof LLVMFunctionDescriptor) {
            LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromFunctionHandle(LLVMFunctionDescriptor)] */;
            this.state_0_ = state_0;
            return fromFunctionHandle(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromFloat(float)] */;
            this.state_0_ = state_0;
            return fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (double) arg0Value;
            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromDouble(double)] */;
            this.state_0_ = state_0;
            return fromDouble(arg0Value_);
        }
        if (arg0Value instanceof LLVM80BitFloat) {
            LLVM80BitFloat arg0Value_ = (LLVM80BitFloat) arg0Value;
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMToDebugValueNode.from80BitFloat(LLVM80BitFloat)] */;
            this.state_0_ = state_0;
            return from80BitFloat(arg0Value_);
        }
        if (arg0Value instanceof LLVMI1Vector) {
            LLVMI1Vector arg0Value_ = (LLVMI1Vector) arg0Value;
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromI1Vector(LLVMI1Vector)] */;
            this.state_0_ = state_0;
            return fromI1Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI8Vector) {
            LLVMI8Vector arg0Value_ = (LLVMI8Vector) arg0Value;
            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromI8Vector(LLVMI8Vector)] */;
            this.state_0_ = state_0;
            return fromI8Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI16Vector) {
            LLVMI16Vector arg0Value_ = (LLVMI16Vector) arg0Value;
            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromI16Vector(LLVMI16Vector)] */;
            this.state_0_ = state_0;
            return fromI16Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI32Vector) {
            LLVMI32Vector arg0Value_ = (LLVMI32Vector) arg0Value;
            state_0 = state_0 | 0x10000 /* add SpecializationActive[LLVMToDebugValueNode.fromI32Vector(LLVMI32Vector)] */;
            this.state_0_ = state_0;
            return fromI32Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI64Vector) {
            LLVMI64Vector arg0Value_ = (LLVMI64Vector) arg0Value;
            state_0 = state_0 | 0x20000 /* add SpecializationActive[LLVMToDebugValueNode.fromI64Vector(LLVMI64Vector)] */;
            this.state_0_ = state_0;
            return fromI64Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMFloatVector) {
            LLVMFloatVector arg0Value_ = (LLVMFloatVector) arg0Value;
            state_0 = state_0 | 0x40000 /* add SpecializationActive[LLVMToDebugValueNode.fromFloatVector(LLVMFloatVector)] */;
            this.state_0_ = state_0;
            return fromFloatVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMDoubleVector) {
            LLVMDoubleVector arg0Value_ = (LLVMDoubleVector) arg0Value;
            state_0 = state_0 | 0x80000 /* add SpecializationActive[LLVMToDebugValueNode.fromDoubleVector(LLVMDoubleVector)] */;
            this.state_0_ = state_0;
            return fromDoubleVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMPointerVector) {
            LLVMPointerVector arg0Value_ = (LLVMPointerVector) arg0Value;
            state_0 = state_0 | 0x100000 /* add SpecializationActive[LLVMToDebugValueNode.fromAddressVector(LLVMPointerVector)] */;
            this.state_0_ = state_0;
            return fromAddressVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMGlobalContainer) {
            LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer) arg0Value;
            state_0 = state_0 | 0x200000 /* add SpecializationActive[LLVMToDebugValueNode.fromGlobalContainer(LLVMGlobalContainer)] */;
            this.state_0_ = state_0;
            return fromGlobalContainer(arg0Value_);
        }
        if (arg0Value instanceof LLVMDebugGlobalVariable) {
            LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable) arg0Value;
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "Specialization 'fromGlobal(LLVMDebugGlobalVariable, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromGlobal_exception_ = exception__;
            state_0 = state_0 | 0x400000 /* add SpecializationActive[LLVMToDebugValueNode.fromGlobal(LLVMDebugGlobalVariable, BranchProfile)] */;
            this.state_0_ = state_0;
            return fromGlobal(arg0Value_, exception__);
        }
        if (arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
            LLVMDebugThreadLocalGlobalVariable arg0Value_ = (LLVMDebugThreadLocalGlobalVariable) arg0Value;
            BranchProfile exception__1 = (BranchProfile.create());
            Objects.requireNonNull(exception__1, "Specialization 'fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromThreadLocalGlobal_exception_ = exception__1;
            state_0 = state_0 | 0x800000 /* add SpecializationActive[LLVMToDebugValueNode.fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)] */;
            this.state_0_ = state_0;
            return fromThreadLocalGlobal(arg0Value_, exception__1);
        }
        state_0 = state_0 | 0x1000000 /* add SpecializationActive[LLVMToDebugValueNode.fromGenericObject(Object)] */;
        this.state_0_ = state_0;
        return fromGenericObject(arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1fffffe) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0x1fffffe) & ((state_0 & 0x1fffffe) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToDebugValueNode.fromBoolean(boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToDebugValueNode.fromByte(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToDebugValueNode.fromShort(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToDebugValueNode.fromInt(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToDebugValueNode.fromLong(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToDebugValueNode.fromIVarBit(LLVMIVarBit)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToDebugValueNode.fromNativePointer(LLVMNativePointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToDebugValueNode.fromManagedPointer(LLVMManagedPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromFunctionHandle(LLVMFunctionDescriptor)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromFloat(float)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromDouble(double)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMToDebugValueNode.from80BitFloat(LLVM80BitFloat)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromI1Vector(LLVMI1Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromI8Vector(LLVMI8Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000000000 /* add SpecializationActive[LLVMToDebugValueNode.fromI16Vector(LLVMI16Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0x10000 /* add SpecializationActive[LLVMToDebugValueNode.fromI32Vector(LLVMI32Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0x20000 /* add SpecializationActive[LLVMToDebugValueNode.fromI64Vector(LLVMI64Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0x40000 /* add SpecializationActive[LLVMToDebugValueNode.fromFloatVector(LLVMFloatVector)] */;
        }
        {
            this.state_0_ = state_0_ | 0x80000 /* add SpecializationActive[LLVMToDebugValueNode.fromDoubleVector(LLVMDoubleVector)] */;
        }
        {
            this.state_0_ = state_0_ | 0x100000 /* add SpecializationActive[LLVMToDebugValueNode.fromAddressVector(LLVMPointerVector)] */;
        }
        {
            this.state_0_ = state_0_ | 0x200000 /* add SpecializationActive[LLVMToDebugValueNode.fromGlobalContainer(LLVMGlobalContainer)] */;
        }
        {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "Specialization 'fromGlobal(LLVMDebugGlobalVariable, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromGlobal_exception_ = exception__;
            this.fromGlobal_exception_.disable();
            this.state_0_ = state_0_ | 0x400000 /* add SpecializationActive[LLVMToDebugValueNode.fromGlobal(LLVMDebugGlobalVariable, BranchProfile)] */;
        }
        {
            BranchProfile exception__1 = (BranchProfile.create());
            Objects.requireNonNull(exception__1, "Specialization 'fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromThreadLocalGlobal_exception_ = exception__1;
            this.fromThreadLocalGlobal_exception_.disable();
            this.state_0_ = state_0_ | 0x800000 /* add SpecializationActive[LLVMToDebugValueNode.fromThreadLocalGlobal(LLVMDebugThreadLocalGlobalVariable, BranchProfile)] */;
        }
        {
            this.state_0_ = state_0_ | 0x1000000 /* add SpecializationActive[LLVMToDebugValueNode.fromGenericObject(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        state_0 = state_0 | 0xe000000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.fromGlobal_exception_.reset();
        this.fromThreadLocalGlobal_exception_.reset();
    }

    @NeverDefault
    public static LLVMToDebugValueNode create() {
        return new LLVMToDebugValueNodeGen();
    }

    @NeverDefault
    public static LLVMToDebugValueNode getUncached() {
        return LLVMToDebugValueNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMToDebugValueNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMToDebugValueNode {

        @TruffleBoundary
        @Override
        protected LLVMDebugValue executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
                LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit(arg0Value);
                return fromIVarBit(arg0Value_);
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                return fromNativePointer(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return fromManagedPointer(arg0Value_);
            }
            if (arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                return fromFunctionHandle(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat arg0Value_ = (LLVM80BitFloat) arg0Value;
                return from80BitFloat(arg0Value_);
            }
            if (arg0Value instanceof LLVMI1Vector) {
                LLVMI1Vector arg0Value_ = (LLVMI1Vector) arg0Value;
                return fromI1Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI8Vector) {
                LLVMI8Vector arg0Value_ = (LLVMI8Vector) arg0Value;
                return fromI8Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI16Vector) {
                LLVMI16Vector arg0Value_ = (LLVMI16Vector) arg0Value;
                return fromI16Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI32Vector) {
                LLVMI32Vector arg0Value_ = (LLVMI32Vector) arg0Value;
                return fromI32Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI64Vector) {
                LLVMI64Vector arg0Value_ = (LLVMI64Vector) arg0Value;
                return fromI64Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMFloatVector) {
                LLVMFloatVector arg0Value_ = (LLVMFloatVector) arg0Value;
                return fromFloatVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector arg0Value_ = (LLVMDoubleVector) arg0Value;
                return fromDoubleVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMPointerVector) {
                LLVMPointerVector arg0Value_ = (LLVMPointerVector) arg0Value;
                return fromAddressVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMGlobalContainer) {
                LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer) arg0Value;
                return fromGlobalContainer(arg0Value_);
            }
            if (arg0Value instanceof LLVMDebugGlobalVariable) {
                LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable) arg0Value;
                return fromGlobal(arg0Value_, (BranchProfile.getUncached()));
            }
            if (arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
                LLVMDebugThreadLocalGlobalVariable arg0Value_ = (LLVMDebugThreadLocalGlobalVariable) arg0Value;
                return fromThreadLocalGlobal(arg0Value_, (BranchProfile.getUncached()));
            }
            return fromGenericObject(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
