// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.rust;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPanic#doOp}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMPanic.class)
@SuppressWarnings("javadoc")
public final class LLVMPanicNodeGen extends LLVMPanic implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPanic#doOp}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private OpData op_cache;

    private LLVMPanicNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPanic.doOp(LLVMPointer, LLVMToNativeNode, PanicLocType)] */ && LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            OpData s0_ = this.op_cache;
            if (s0_ != null) {
                return doOp(child0Value__, s0_.toNative_, s0_.panicLoc_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private Object executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            OpData s0_ = this.insert(new OpData());
            s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            s0_.panicLoc_ = (createPanicLocation());
            VarHandle.storeStoreFence();
            this.op_cache = s0_;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPanic.doOp(LLVMPointer, LLVMToNativeNode, PanicLocType)] */;
            this.state_0_ = state_0;
            return doOp(child0Value_, s0_.toNative_, s0_.panicLoc_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            OpData s0_ = this.insert(new OpData());
            s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            s0_.panicLoc_ = (createPanicLocation());
            VarHandle.storeStoreFence();
            this.op_cache = s0_;
            assert NodeUtil.assertRecursion(s0_.toNative_, 1);
            ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPanic.doOp(LLVMPointer, LLVMToNativeNode, PanicLocType)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.op_cache = null;
    }

    @NeverDefault
    public static LLVMPanic create(LLVMExpressionNode child0) {
        return new LLVMPanicNodeGen(child0);
    }

    @GeneratedBy(LLVMPanic.class)
    @DenyReplace
    private static final class OpData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPanic#doOp}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPanic#doOp}
         *   Parameter: {@link PanicLocType} panicLoc</pre>
         */
        @CompilationFinal PanicLocType panicLoc_;

        OpData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
