// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMDerefHandleGetReceiverNode#doPointer}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMDerefHandleGetReceiverNode#doLong}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMDerefHandleGetReceiverNode.class)
@SuppressWarnings("javadoc")
public final class LLVMDerefHandleGetReceiverNodeGen extends LLVMDerefHandleGetReceiverNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMDerefHandleGetReceiverNode#doPointer}
     *   2: SpecializationActive {@link LLVMDerefHandleGetReceiverNode#doLong}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMDerefHandleGetReceiverNodeGen() {
    }

    @Override
    public LLVMManagedPointer execute(LLVMNativePointer arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMDerefHandleGetReceiverNode.doPointer(LLVMNativePointer)] */) {
            return doPointer(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @Override
    public LLVMManagedPointer execute(long arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMDerefHandleGetReceiverNode.doLong(long)] */) {
            return doLong(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private LLVMManagedPointer executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMDerefHandleGetReceiverNode.doPointer(LLVMNativePointer)] */;
            this.state_0_ = state_0;
            return doPointer(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMDerefHandleGetReceiverNode.doLong(long)] */;
            this.state_0_ = state_0;
            return doLong(arg0Value_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMDerefHandleGetReceiverNode.doPointer(LLVMNativePointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMDerefHandleGetReceiverNode.doLong(long)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMDerefHandleGetReceiverNode create() {
        return new LLVMDerefHandleGetReceiverNodeGen();
    }

    @NeverDefault
    public static LLVMDerefHandleGetReceiverNode getUncached() {
        return LLVMDerefHandleGetReceiverNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMDerefHandleGetReceiverNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMDerefHandleGetReceiverNode {

        @TruffleBoundary
        @Override
        public LLVMManagedPointer execute(LLVMNativePointer arg0Value) {
            return doPointer(arg0Value);
        }

        @TruffleBoundary
        @Override
        public LLVMManagedPointer execute(long arg0Value) {
            return doLong(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
