// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMI16StoreNode#doOp}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMI16StoreNode#doOpDerefHandle}
 *     Activation probability: 0.29500
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMI16StoreNode#doOpManaged}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMI16StoreNode#doOpManaged}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMI16StoreNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMI16StoreNodeGen extends LLVMI16StoreNode implements GenerateAOT.Provider {

    static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMI16StoreNode#doOp}
     *   2: SpecializationActive {@link LLVMI16StoreNode#doOpDerefHandle}
     *   3: SpecializationActive {@link LLVMI16StoreNode#doOpManaged}
     *   4: SpecializationActive {@link LLVMI16StoreNode#doOpManaged}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI16StoreNode#doOpDerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI16StoreNode#doOpDerefHandle}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
    @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

    private LLVMI16StoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] || SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */ && valueValue instanceof Short) {
            short valueValue_ = (short) valueValue;
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] || SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                            if (nativeWrite__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    LLVMI16StoreNode.doOpDerefHandle(addressValue_, valueValue_, getReceiver__, nativeWrite__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMI16StoreNode.doOpManaged(addressValue_, valueValue_, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    this.opManaged1Boundary(state_0, addressValue_, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary(int state_0, LLVMManagedPointer addressValue_, short valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                LLVMI16StoreNode.doOpManaged(addressValue_, valueValue_, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(LLVMPointer addressValue, short valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] || SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] || SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                            if (nativeWrite__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    LLVMI16StoreNode.doOpDerefHandle(addressValue_, valueValue, getReceiver__, nativeWrite__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMI16StoreNode.doOpManaged(addressValue_, valueValue, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    this.opManaged1Boundary0(state_0, addressValue_, valueValue);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary0(int state_0, LLVMManagedPointer addressValue_, short valueValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                LLVMI16StoreNode.doOpManaged(addressValue_, valueValue, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        short valueValue_;
        try {
            valueValue_ = this.value_.executeI16(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(addressValue_, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] || SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] || SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doOp(addressValue__, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                            if (nativeWrite__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    LLVMI16StoreNode.doOpDerefHandle(addressValue__, valueValue_, getReceiver__, nativeWrite__);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeWrite_.accepts(addressValue__.getObject()))) {
                            LLVMI16StoreNode.doOpManaged(addressValue__, valueValue_, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    this.opManaged1Boundary1(state_0, addressValue__, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary1(int state_0, LLVMManagedPointer addressValue__, short valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                LLVMI16StoreNode.doOpManaged(addressValue__, valueValue_, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (valueValue instanceof Short) {
            short valueValue_ = (short) valueValue;
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] */;
                    this.state_0_ = state_0;
                    doOp(addressValue_, valueValue_);
                    return;
                }
                if ((isAutoDerefHandle(addressValue_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_getReceiver_ = getReceiver__;
                    LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_nativeWrite_ = nativeWrite__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    LLVMI16StoreNode.doOpDerefHandle(addressValue_, valueValue_, getReceiver__, nativeWrite__);
                    return;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        OpManaged0Data s2_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                        OpManaged0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new OpManaged0Data(s2_original));
                                LLVMManagedWriteLibrary nativeWrite__1 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__1, "Specialization 'doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeWrite_ = nativeWrite__1;
                                if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            LLVMI16StoreNode.doOpManaged(addressValue_, valueValue_, s2_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.opManaged0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI16StoreNode.doOpManaged(LLVMManagedPointer, short, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            LLVMI16StoreNode.doOpManaged(addressValue_, valueValue_, nativeWrite__1);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                OpManaged0Data s2_ = this.opManaged0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI16StoreNode.doOp(LLVMNativePointer, short)] */;
        }
        {
            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.opDerefHandle_getReceiver_ = getReceiver__;
            LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.opDerefHandle_nativeWrite_ = nativeWrite__;
            assert NodeUtil.assertRecursion(this.opDerefHandle_getReceiver_, 1);
            ((GenerateAOT.Provider) this.opDerefHandle_getReceiver_).prepareForAOT(language, root);
            if (this.opDerefHandle_nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.opDerefHandle_nativeWrite_, 1);
                ((GenerateAOT.Provider) this.opDerefHandle_nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMI16StoreNode.doOpDerefHandle(LLVMNativePointer, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_getReceiver_ = null;
        this.opDerefHandle_nativeWrite_ = null;
    }

    @NeverDefault
    public static LLVMI16StoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMI16StoreNodeGen(address, value);
    }

    @GeneratedBy(LLVMI16StoreNode.class)
    @DenyReplace
    private static final class OpManaged0Data extends Node implements SpecializationDataNode {

        @Child OpManaged0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI16StoreNode#doOpManaged}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        OpManaged0Data(OpManaged0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI16OffsetStoreNode#doOp}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI16OffsetStoreNode#doOpDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMI16OffsetStoreNode#doOpManaged}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMI16OffsetStoreNode#doOpManaged}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI16OffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI16OffsetStoreNodeGen extends LLVMI16OffsetStoreNode implements GenerateAOT.Provider {

        static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI16OffsetStoreNode#doOp}
         *   2: SpecializationActive {@link LLVMI16OffsetStoreNode#doOpDerefHandle}
         *   3: SpecializationActive {@link LLVMI16OffsetStoreNode#doOpManaged}
         *   4: SpecializationActive {@link LLVMI16OffsetStoreNode#doOpManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI16OffsetStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI16OffsetStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
        @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

        private LLVMI16OffsetStoreNodeGen(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @ExplodeLoop
        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */ && valueValue instanceof Short) {
                short valueValue_ = (short) valueValue;
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVMI16OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary(state_0, targetValue_, offsetValue, valueValue_);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary(int state_0, LLVMManagedPointer targetValue_, long offsetValue, short valueValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(LLVMPointer targetValue, long offsetValue, short valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVMI16OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary0(state_0, targetValue_, offsetValue, valueValue);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary0(int state_0, LLVMManagedPointer targetValue_, long offsetValue, short valueValue) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(targetValue, offsetValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.opDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedWriteLibrary nativeWrite__ = this.opDerefHandle_nativeWrite_;
                                if (nativeWrite__ != null) {
                                    if ((isAutoDerefHandle(targetValue_))) {
                                        LLVMI16OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, getReceiver__, nativeWrite__);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary1(state_0, targetValue_, offsetValue, valueValue_);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary1(int state_0, LLVMManagedPointer targetValue_, long offsetValue, short valueValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__1);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                if (valueValue instanceof Short) {
                    short valueValue_ = (short) valueValue;
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] */;
                            this.state_0_ = state_0;
                            doOp(targetValue_, offsetValue_, valueValue_);
                            return;
                        }
                        if ((isAutoDerefHandle(targetValue_))) {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                            Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_getReceiver_ = getReceiver__;
                            LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                            Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_nativeWrite_ = nativeWrite__;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            LLVMI16OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue_, valueValue_, getReceiver__, nativeWrite__);
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */) {
                            while (true) {
                                int count2_ = 0;
                                OpManaged0Data s2_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                                OpManaged0Data s2_original = s2_;
                                while (s2_ != null) {
                                    if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                        break;
                                    }
                                    count2_++;
                                    s2_ = s2_.next_;
                                }
                                if (s2_ == null) {
                                    // assert (s2_.nativeWrite_.accepts(targetValue_.getObject()));
                                    if (count2_ < (3)) {
                                        s2_ = this.insert(new OpManaged0Data(s2_original));
                                        LLVMManagedWriteLibrary nativeWrite__1 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(targetValue_.getObject())));
                                        Objects.requireNonNull(nativeWrite__1, "Specialization 'doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s2_.nativeWrite_ = nativeWrite__1;
                                        if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s2_ != null) {
                                    LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, s2_.nativeWrite_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            LLVMManagedWriteLibrary nativeWrite__1 = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                                    this.opManaged0_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpManaged(LLVMManagedPointer, long, short, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                    LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, nativeWrite__1);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOp(LLVMNativePointer, long, short)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.opDerefHandle_nativeWrite_ = nativeWrite__;
                assert NodeUtil.assertRecursion(this.opDerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.opDerefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.opDerefHandle_nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.opDerefHandle_nativeWrite_, 1);
                    ((GenerateAOT.Provider) this.opDerefHandle_nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMI16StoreNode.LLVMI16OffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, short, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.opDerefHandle_getReceiver_ = null;
            this.opDerefHandle_nativeWrite_ = null;
        }

        @NeverDefault
        public static LLVMI16OffsetStoreNode create(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMI16OffsetStoreNodeGen(target, offset, value);
        }

        @NeverDefault
        public static LLVMI16OffsetStoreNode getUncached() {
            return LLVMI16OffsetStoreNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMI16OffsetStoreNode.class)
        @DenyReplace
        private static final class OpManaged0Data extends Node implements SpecializationDataNode {

            @Child OpManaged0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI16OffsetStoreNode#doOpManaged}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpManaged0Data(OpManaged0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI16OffsetStoreNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMI16OffsetStoreNode {

            @TruffleBoundary
            @Override
            public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
                if (valueValue instanceof Short) {
                    short valueValue_ = (short) valueValue;
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                        if ((isAutoDerefHandle(targetValue_))) {
                            LLVMI16OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject())));
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @TruffleBoundary
            @Override
            public void executeWithTarget(LLVMPointer targetValue, long offsetValue, short valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doOp(targetValue_, offsetValue, valueValue);
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVMI16OffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVMI16OffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue, (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject())));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @Override
            public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
                throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
