// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMIVarBitStoreNode#doOp}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMIVarBitStoreNode#doOpDerefHandle}
 *     Activation probability: 0.29500
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMIVarBitStoreNode#doOpManaged}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMIVarBitStoreNode#doOpManaged}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMIVarBitStoreNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMIVarBitStoreNodeGen extends LLVMIVarBitStoreNode implements GenerateAOT.Provider {

    static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMIVarBitStoreNode#doOp}
     *   2: SpecializationActive {@link LLVMIVarBitStoreNode#doOpDerefHandle}
     *   3: SpecializationActive {@link LLVMIVarBitStoreNode#doOpManaged}
     *   4: SpecializationActive {@link LLVMIVarBitStoreNode#doOpManaged}
     *   5-7: ImplicitCast[type=LLVMIVarBit, index=1]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private OpDerefHandleData opDerefHandle_cache;
    @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

    private LLVMIVarBitStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMIVarBitStoreNodeGen(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value) {
        super(isRecursive);
        this.address_ = address;
        this.value_ = value;
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=1] */, valueValue)) {
            LLVMIVarBit valueValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=1] */, valueValue);
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doOp(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVMIVarBitStoreNode.doOpDerefHandle(addressValue_, valueValue_, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMIVarBitStoreNode.doOpManaged(addressValue_, valueValue_, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                    this.opManaged1Boundary(state_0, addressValue_, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMIVarBit valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                LLVMIVarBitStoreNode.doOpManaged(addressValue_, valueValue_, nativeWrite__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    protected void executeWithTarget(LLVMManagedPointer addressValue, LLVMIVarBit valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=1] */, valueValue)) {
            LLVMIVarBit valueValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=1] */, valueValue);
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                OpManaged0Data s2_ = this.opManaged0_cache;
                while (s2_ != null) {
                    if ((s2_.nativeWrite_.accepts(addressValue.getObject()))) {
                        LLVMIVarBitStoreNode.doOpManaged(addressValue, valueValue_, s2_.nativeWrite_);
                        return;
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                this.opManaged1Boundary0(state_0, addressValue, valueValue_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary0(int state_0, LLVMManagedPointer addressValue, LLVMIVarBit valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue.getObject()));
                LLVMIVarBitStoreNode.doOpManaged(addressValue, valueValue_, nativeWrite__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=1] */, valueValue_)) {
            LLVMIVarBit valueValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=1] */, valueValue_);
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doOp(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] */) {
                    OpDerefHandleData s1_ = this.opDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue__))) {
                            LLVMIVarBitStoreNode.doOpDerefHandle(addressValue__, valueValue__, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeWrite_.accepts(addressValue__.getObject()))) {
                            LLVMIVarBitStoreNode.doOpManaged(addressValue__, valueValue__, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                    this.opManaged1Boundary1(state_0, addressValue__, valueValue__);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void opManaged1Boundary1(int state_0, LLVMManagedPointer addressValue__, LLVMIVarBit valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                LLVMIVarBitStoreNode.doOpManaged(addressValue__, valueValue__, nativeWrite__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        {
            int lLVMIVarBitCast1;
            if ((lLVMIVarBitCast1 = LLVMTypesGen.specializeImplicitLLVMIVarBit(valueValue)) != 0) {
                LLVMIVarBit valueValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast1, valueValue);
                if (LLVMTypes.isNativePointer(addressValue)) {
                    LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        state_0 = (state_0 | (lLVMIVarBitCast1 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=1] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] */;
                        this.state_0_ = state_0;
                        doOp(addressValue_, valueValue_);
                        return;
                    }
                    if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                        OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                        LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                        Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s1_.getReceiver_ = getReceiver__;
                        s1_.store_ = s1_.insert((LLVMIVarBitStoreNode.createRecursive()));
                        VarHandle.storeStoreFence();
                        this.opDerefHandle_cache = s1_;
                        state_0 = (state_0 | (lLVMIVarBitCast1 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=1] */);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] */;
                        this.state_0_ = state_0;
                        LLVMIVarBitStoreNode.doOpDerefHandle(addressValue_, valueValue_, getReceiver__, s1_.store_);
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        while (true) {
                            int count2_ = 0;
                            OpManaged0Data s2_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                            OpManaged0Data s2_original = s2_;
                            while (s2_ != null) {
                                if ((s2_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                    break;
                                }
                                count2_++;
                                s2_ = s2_.next_;
                            }
                            if (s2_ == null) {
                                // assert (s2_.nativeWrite_.accepts(addressValue_.getObject()));
                                if (count2_ < (3)) {
                                    s2_ = this.insert(new OpManaged0Data(s2_original));
                                    LLVMManagedWriteLibrary nativeWrite__ = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                    Objects.requireNonNull(nativeWrite__, "Specialization 'doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s2_.nativeWrite_ = nativeWrite__;
                                    if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = (state_0 | (lLVMIVarBitCast1 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            } else {
                                state_0 = (state_0 | (lLVMIVarBitCast1 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=1] */);
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                            if (s2_ != null) {
                                LLVMIVarBitStoreNode.doOpManaged(addressValue_, valueValue_, s2_.nativeWrite_);
                                return;
                            }
                            break;
                        }
                    }
                    {
                        LLVMManagedWriteLibrary nativeWrite__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                                this.opManaged0_cache = null;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                state_0 = (state_0 | (lLVMIVarBitCast1 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=1] */);
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMIVarBitStoreNode.doOpManaged(LLVMManagedPointer, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                                LLVMIVarBitStoreNode.doOpManaged(addressValue_, valueValue_, nativeWrite__);
                                return;
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                OpManaged0Data s2_ = this.opManaged0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIVarBitStoreNode.doOp(LLVMNativePointer, LLVMIVarBit)] */;
        }
        {
            if ((!(isRecursive))) {
                OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.getReceiver_ = getReceiver__;
                s1_.store_ = s1_.insert((LLVMIVarBitStoreNode.createRecursive()));
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMIVarBitStoreNode.doOpDerefHandle(LLVMNativePointer, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitStoreNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        state_0 = state_0 | 0b11100000 /* add ImplicitCast[type=LLVMIVarBit, index=1] */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_cache = null;
    }

    @NeverDefault
    public static LLVMIVarBitStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMIVarBitStoreNodeGen(address, value);
    }

    @NeverDefault
    public static LLVMIVarBitStoreNode create(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMIVarBitStoreNodeGen(isRecursive, address, value);
    }

    @GeneratedBy(LLVMIVarBitStoreNode.class)
    @DenyReplace
    private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMIVarBitStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMIVarBitStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMIVarBitStoreNode} store</pre>
         */
        @Child LLVMIVarBitStoreNode store_;

        OpDerefHandleData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMIVarBitStoreNode.class)
    @DenyReplace
    private static final class OpManaged0Data extends Node implements SpecializationDataNode {

        @Child OpManaged0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMIVarBitStoreNode#doOpManaged}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        OpManaged0Data(OpManaged0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMIVarBitOffsetStoreNode#doOp}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMIVarBitOffsetStoreNode#doOpDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMIVarBitOffsetStoreNode#doOpManaged}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMIVarBitOffsetStoreNode#doOpManaged}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMIVarBitOffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMIVarBitOffsetStoreNodeGen extends LLVMIVarBitOffsetStoreNode implements GenerateAOT.Provider {

        static final ReferenceField<OpManaged0Data> OP_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "opManaged0_cache", OpManaged0Data.class);

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMIVarBitOffsetStoreNode#doOp}
         *   2: SpecializationActive {@link LLVMIVarBitOffsetStoreNode#doOpDerefHandle}
         *   3: SpecializationActive {@link LLVMIVarBitOffsetStoreNode#doOpManaged}
         *   4: SpecializationActive {@link LLVMIVarBitOffsetStoreNode#doOpManaged}
         *   5-7: ImplicitCast[type=LLVMIVarBit, index=2]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private OpDerefHandleData opDerefHandle_cache;
        @UnsafeAccessedField @Child private OpManaged0Data opManaged0_cache;

        private LLVMIVarBitOffsetStoreNodeGen(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        private LLVMIVarBitOffsetStoreNodeGen(boolean isRecursive, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            super(isRecursive);
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @ExplodeLoop
        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=2] */, valueValue)) {
                LLVMIVarBit valueValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=2] */, valueValue);
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */) {
                        OpDerefHandleData s1_ = this.opDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMIVarBitOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, s1_.getReceiver_, s1_.store_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary(state_0, targetValue_, offsetValue, valueValue_);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary(int state_0, LLVMManagedPointer targetValue_, long offsetValue, LLVMIVarBit valueValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(LLVMPointer targetValue, long offsetValue, LLVMIVarBit valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=2] */, valueValue)) {
                LLVMIVarBit valueValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=2] */, valueValue);
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */) {
                        OpDerefHandleData s1_ = this.opDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMIVarBitOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, s1_.getReceiver_, s1_.store_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary0(state_0, targetValue_, offsetValue, valueValue_);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary0(int state_0, LLVMManagedPointer targetValue_, long offsetValue, LLVMIVarBit valueValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue_, nativeWrite__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=2] */, valueValue_)) {
                LLVMIVarBit valueValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=LLVMIVarBit, index=2] */, valueValue_);
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] */) {
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            doOp(targetValue_, offsetValue, valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */) {
                        OpDerefHandleData s1_ = this.opDerefHandle_cache;
                        if (s1_ != null) {
                            assert DSLSupport.assertIdempotence((!(isRecursive)));
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMIVarBitOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue__, s1_.getReceiver_, s1_.store_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        OpManaged0Data s2_ = this.opManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue__, s2_.nativeWrite_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                        this.opManaged1Boundary1(state_0, targetValue_, offsetValue, valueValue__);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void opManaged1Boundary1(int state_0, LLVMManagedPointer targetValue_, long offsetValue, LLVMIVarBit valueValue__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                    LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue, valueValue__, nativeWrite__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                int lLVMIVarBitCast2;
                if ((lLVMIVarBitCast2 = LLVMTypesGen.specializeImplicitLLVMIVarBit(valueValue)) != 0) {
                    LLVMIVarBit valueValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast2, valueValue);
                    if (LLVMTypes.isNativePointer(targetValue)) {
                        LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                        if ((!(isAutoDerefHandle(targetValue_)))) {
                            state_0 = (state_0 | (lLVMIVarBitCast2 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=2] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] */;
                            this.state_0_ = state_0;
                            doOp(targetValue_, offsetValue_, valueValue_);
                            return;
                        }
                        if ((!(isRecursive)) && (isAutoDerefHandle(targetValue_))) {
                            OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                            LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                            Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s1_.getReceiver_ = getReceiver__;
                            s1_.store_ = s1_.insert((LLVMIVarBitOffsetStoreNode.createRecursive()));
                            VarHandle.storeStoreFence();
                            this.opDerefHandle_cache = s1_;
                            state_0 = (state_0 | (lLVMIVarBitCast2 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=2] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */;
                            this.state_0_ = state_0;
                            LLVMIVarBitOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue_, valueValue_, getReceiver__, s1_.store_);
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(targetValue)) {
                        LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */) {
                            while (true) {
                                int count2_ = 0;
                                OpManaged0Data s2_ = OP_MANAGED0_CACHE_UPDATER.getVolatile(this);
                                OpManaged0Data s2_original = s2_;
                                while (s2_ != null) {
                                    if ((s2_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                        break;
                                    }
                                    count2_++;
                                    s2_ = s2_.next_;
                                }
                                if (s2_ == null) {
                                    // assert (s2_.nativeWrite_.accepts(targetValue_.getObject()));
                                    if (count2_ < (3)) {
                                        s2_ = this.insert(new OpManaged0Data(s2_original));
                                        LLVMManagedWriteLibrary nativeWrite__ = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(targetValue_.getObject())));
                                        Objects.requireNonNull(nativeWrite__, "Specialization 'doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s2_.nativeWrite_ = nativeWrite__;
                                        if (!OP_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        state_0 = (state_0 | (lLVMIVarBitCast2 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=2] */);
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                } else {
                                    state_0 = (state_0 | (lLVMIVarBitCast2 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=2] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                                if (s2_ != null) {
                                    LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, s2_.nativeWrite_);
                                    return;
                                }
                                break;
                            }
                        }
                        {
                            LLVMManagedWriteLibrary nativeWrite__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(targetValue_.getObject()));
                                    this.opManaged0_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                    state_0 = (state_0 | (lLVMIVarBitCast2 << 5) /* set-int ImplicitCast[type=LLVMIVarBit, index=2] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpManaged(LLVMManagedPointer, long, LLVMIVarBit, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                    LLVMIVarBitOffsetStoreNode.doOpManaged(targetValue_, offsetValue_, valueValue_, nativeWrite__);
                                    return;
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOp(LLVMNativePointer, long, LLVMIVarBit)] */;
            }
            {
                if ((!(isRecursive))) {
                    OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                    LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.getReceiver_ = getReceiver__;
                    s1_.store_ = s1_.insert((LLVMIVarBitOffsetStoreNode.createRecursive()));
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                    ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.store_, 1);
                    ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMIVarBitStoreNode.LLVMIVarBitOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, LLVMIVarBit, LLVMDerefHandleGetReceiverNode, LLVMIVarBitOffsetStoreNode)] */;
                }
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b11100000 /* add ImplicitCast[type=LLVMIVarBit, index=2] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.opDerefHandle_cache = null;
        }

        @NeverDefault
        public static LLVMIVarBitOffsetStoreNode create(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMIVarBitOffsetStoreNodeGen(target, offset, value);
        }

        @NeverDefault
        public static LLVMIVarBitOffsetStoreNode create(boolean isRecursive, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMIVarBitOffsetStoreNodeGen(isRecursive, target, offset, value);
        }

        @GeneratedBy(LLVMIVarBitOffsetStoreNode.class)
        @DenyReplace
        private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMIVarBitOffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMIVarBitOffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMIVarBitOffsetStoreNode} store</pre>
             */
            @Child LLVMIVarBitOffsetStoreNode store_;

            OpDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMIVarBitOffsetStoreNode.class)
        @DenyReplace
        private static final class OpManaged0Data extends Node implements SpecializationDataNode {

            @Child OpManaged0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMIVarBitOffsetStoreNode#doOpManaged}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpManaged0Data(OpManaged0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
