/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.DataSectionFactory;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class InitializeGlobalsBlockNode
extends LLVMNode {
    @Node.Child
    private LLVMAllocateNode allocDataSection;
    private final NodeFactory nodeFactory;
    private final StructureType rwSectionType;
    private final StructureType roSectionType;
    private final long rwSectionSize;
    private final long globalsBlockSize;

    public InitializeGlobalsBlockNode(LLVMParserResult result, DataSectionFactory dataSectionFactory, LLVMLanguage language) {
        this.nodeFactory = result.getRuntime().getNodeFactory();
        this.rwSectionType = dataSectionFactory.getRwSection().getStructureType("rwglobals_struct");
        this.roSectionType = dataSectionFactory.getRoSection().getStructureType("roglobals_struct");
        long blockSize = 0L;
        long rwSize = 0L;
        try {
            if (this.rwSectionType != null) {
                blockSize += InitializeGlobalsBlockNode.alignPageSize(language, this.rwSectionType.getSize(result.getDataLayout()));
            }
            rwSize = blockSize;
            if (this.roSectionType != null) {
                blockSize += InitializeGlobalsBlockNode.alignPageSize(language, this.roSectionType.getSize(result.getDataLayout()));
            }
            this.allocDataSection = blockSize > 0L ? this.nodeFactory.createAllocateGlobalsBlock(blockSize) : null;
        }
        catch (Type.TypeOverflowException ex) {
            this.allocDataSection = Type.handleOverflowAllocate(ex);
        }
        this.globalsBlockSize = blockSize;
        this.rwSectionSize = rwSize;
    }

    public long getGlobalsBlockSize() {
        return this.globalsBlockSize;
    }

    public long getRoBlockSize() {
        return this.globalsBlockSize - this.rwSectionSize;
    }

    public boolean hasGlobalsBlock() {
        return this.allocDataSection != null;
    }

    public boolean hasRwSection() {
        return this.rwSectionSize > 0L;
    }

    public boolean hasRoSection() {
        return this.getRoBlockSize() > 0L;
    }

    public LLVMPointer getRwSectionPointer(LLVMPointer basePointer) {
        return this.hasRwSection() ? basePointer : null;
    }

    public LLVMPointer getRoSectionPointer(LLVMPointer basePointer) {
        return this.hasRoSection() ? basePointer.increment(this.rwSectionSize) : null;
    }

    private static long alignPageSize(LLVMLanguage language, long value) {
        int pageSize = language.getLLVMMemory().getPageSize();
        return (value + (long)(pageSize - 1)) / (long)pageSize * (long)pageSize;
    }

    public LLVMPointer allocateGlobalsSectionBlock() {
        return this.allocDataSection != null ? this.allocDataSection.executeWithTarget() : null;
    }
}

