/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.config;

import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.ConfigurationFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

public final class Configurations {
    private static final ConfigurationFactory<?>[] factories;

    public static <S> Iterable<S> getService(Class<S> serviceClass) {
        Module polyglotModule = serviceClass.getModule();
        if (polyglotModule.isNamed()) {
            return ServiceLoader.load(polyglotModule.getLayer(), serviceClass);
        }
        return ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
    }

    private static <KEY> Configuration tryCreate(ConfigurationFactory<KEY> factory, LLVMLanguage language, ContextExtension.Registry ctxExtRegistry, OptionValues options) {
        KEY key = factory.parseOptions(options);
        if (key != null) {
            return factory.createConfiguration(language, ctxExtRegistry, key);
        }
        return null;
    }

    public static Configuration createConfiguration(LLVMLanguage language, ContextExtension.Registry ctxExtRegistry, OptionValues options) {
        if (factories.length == 0) {
            throw new IllegalStateException("should not reach here: no configuration found");
        }
        for (ConfigurationFactory<?> factory : factories) {
            Configuration ret = Configurations.tryCreate(factory, language, ctxExtRegistry, options);
            if (ret == null) continue;
            return ret;
        }
        throw new LLVMPolyglotException(null, "No viable configuration found. " + Configurations.formatHint());
    }

    private static String formatHint() {
        int maxNameSize = Arrays.stream(factories).mapToInt(c -> c.getName().length()).max().orElse(30);
        String format = "  %" + maxNameSize + "s:   %s (priority %d)";
        StringBuilder sb = new StringBuilder();
        sb.append("Known configurations:").append(System.lineSeparator());
        Arrays.stream(factories).map(c -> String.format(format, c.getName(), c.getHint(), c.getPriority())).forEach(s -> sb.append((String)s).append(System.lineSeparator()));
        return sb.toString();
    }

    public static boolean areOptionsCompatible(OptionValues o1, OptionValues o2) {
        for (ConfigurationFactory<?> factory : factories) {
            Object key1 = factory.parseOptions(o1);
            Object key2 = factory.parseOptions(o2);
            if (key1 == null && key2 == null) continue;
            return Objects.equals(key1, key2);
        }
        return false;
    }

    public static OptionDescriptors getOptionDescriptors() {
        ArrayList<OptionDescriptor> optionDescriptors = new ArrayList<OptionDescriptor>();
        optionDescriptors.addAll(SulongEngineOption.describeOptions());
        for (ConfigurationFactory<?> f : factories) {
            optionDescriptors.addAll(f.getOptionDescriptors());
        }
        return OptionDescriptors.create(optionDescriptors);
    }

    static {
        ArrayList<ConfigurationFactory> cfgs = new ArrayList<ConfigurationFactory>();
        for (ConfigurationFactory f : Configurations.getService(ConfigurationFactory.class)) {
            cfgs.add(f);
        }
        cfgs.sort((o1, o2) -> o2.getPriority() - o1.getPriority());
        factories = cfgs.toArray(new ConfigurationFactory[cfgs.size()]);
    }
}

