/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.CompareOperator;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprArrayElementNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprBitFlipNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprDereferenceNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprDereferenceNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprFunctionCallNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprLogicalAndNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprLogicalOrNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprNotNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprObjectMemberNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprObjectMemberNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprPointerCastNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprPointerCastNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprShortCircuitEvaluationNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprShortCircuitEvaluationNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprSizeofNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTernaryNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTernaryNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTypeofNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTypeofNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprVarNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprVarNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExpressionPair;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.List;

public final class DebugExprNodeFactory {
    private Object globalScope;
    private MaterializedFrame frame;
    private Node location;

    private DebugExprNodeFactory(Object globalScope, MaterializedFrame frame, Node location) {
        this.globalScope = globalScope;
        this.frame = frame;
        this.location = location;
    }

    public static DebugExprNodeFactory create(Object globalScope, MaterializedFrame frame, Node location) {
        return new DebugExprNodeFactory(globalScope, frame, location);
    }

    private static void checkError(DebugExpressionPair p, String operationDescription) {
        if (p == null) {
            throw DebugExprException.nullObject(operationDescription);
        }
    }

    public DebugExpressionPair createArithmeticOp(ArithmeticOperation op, DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, op.name());
        DebugExprNodeFactory.checkError(right, op.name());
        DebugExprType commonType = DebugExprType.commonType(left.getType(), right.getType());
        DebugExpressionPair leftPair = this.createCastIfNecessary(left, commonType);
        DebugExpressionPair rightPair = this.createCastIfNecessary(right, commonType);
        LLVMExpressionNode node = CommonNodeFactory.createArithmeticOp(op, commonType.getLLVMRuntimeType(), leftPair.getNode(), rightPair.getNode());
        return DebugExpressionPair.create(node, commonType);
    }

    public DebugExpressionPair createDivNode(DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, "/");
        DebugExprNodeFactory.checkError(right, "/");
        DebugExprType commonType = DebugExprType.commonType(left.getType(), right.getType());
        DebugExpressionPair leftPair = this.createCastIfNecessary(left, commonType);
        DebugExpressionPair rightPair = this.createCastIfNecessary(right, commonType);
        ArithmeticOperation op = commonType.isUnsigned() ? ArithmeticOperation.UDIV : ArithmeticOperation.DIV;
        LLVMExpressionNode node = CommonNodeFactory.createArithmeticOp(op, commonType.getLLVMRuntimeType(), leftPair.getNode(), rightPair.getNode());
        return DebugExpressionPair.create(node, commonType);
    }

    public DebugExpressionPair createRemNode(DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, "%");
        DebugExprNodeFactory.checkError(right, "%");
        DebugExprType commonType = DebugExprType.commonType(left.getType(), right.getType());
        ArithmeticOperation op = commonType.isUnsigned() ? ArithmeticOperation.UREM : ArithmeticOperation.REM;
        LLVMExpressionNode node = CommonNodeFactory.createArithmeticOp(op, commonType.getLLVMRuntimeType(), left.getNode(), right.getNode());
        return DebugExpressionPair.create(node, commonType);
    }

    public DebugExpressionPair createShiftLeft(DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, "<<");
        DebugExprNodeFactory.checkError(right, "<<");
        LLVMExpressionNode node = CommonNodeFactory.createArithmeticOp(ArithmeticOperation.SHL, left.getType().getLLVMRuntimeType(), left.getNode(), right.getNode());
        if (!right.getType().isIntegerType() || !left.getType().isIntegerType()) {
            throw DebugExprException.typeError(node, new Object[]{left.getNode(), right.getNode()});
        }
        return DebugExpressionPair.create(node, left.getType());
    }

    public DebugExpressionPair createShiftRight(DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, ">>");
        DebugExprNodeFactory.checkError(right, ">>");
        ArithmeticOperation op = left.getType().isUnsigned() ? ArithmeticOperation.LSHR : ArithmeticOperation.ASHR;
        LLVMExpressionNode node = CommonNodeFactory.createArithmeticOp(op, left.getType().getLLVMRuntimeType(), left.getNode(), right.getNode());
        if (!right.getType().isIntegerType() || !left.getType().isIntegerType()) {
            throw DebugExprException.typeError(node, new Object[]{left.getNode(), right.getNode()});
        }
        return DebugExpressionPair.create(node, left.getType());
    }

    public DebugExpressionPair createTernaryNode(DebugExpressionPair condition, DebugExpressionPair thenNode, DebugExpressionPair elseNode) {
        DebugExprNodeFactory.checkError(condition, "? :");
        DebugExprNodeFactory.checkError(thenNode, "? :");
        DebugExprNodeFactory.checkError(elseNode, "? :");
        DebugExprTernaryNode node = DebugExprTernaryNodeGen.create(thenNode.getNode(), elseNode.getNode(), condition.getNode());
        return DebugExpressionPair.create(node, DebugExprType.commonType(thenNode.getType(), elseNode.getType()));
    }

    public DebugExpressionPair createUnaryOpNode(DebugExpressionPair pair, char unaryOp) {
        DebugExprNodeFactory.checkError(pair, Character.toString(unaryOp));
        switch (unaryOp) {
            case '*': {
                return this.createDereferenceNode(pair);
            }
            case '+': {
                return pair;
            }
            case '-': {
                return this.createArithmeticOp(ArithmeticOperation.SUB, this.createIntegerConstant(0), pair);
            }
            case '~': {
                return DebugExpressionPair.create(DebugExprBitFlipNodeGen.create(pair.getNode()), pair.getType());
            }
            case '!': {
                return DebugExpressionPair.create(DebugExprNotNodeGen.create(pair.getNode()), pair.getType());
            }
        }
        throw DebugExprException.create(pair.getNode(), "unknown symbol: %c", Character.valueOf(unaryOp));
    }

    public DebugExpressionPair createVarNode(String name) {
        DebugExprVarNode node = DebugExprVarNodeGen.create(name, this.location);
        return DebugExpressionPair.create(node, node.getType((VirtualFrame)this.frame));
    }

    public DebugExpressionPair createSizeofNode(DebugExprType type) {
        LLVMExpressionNode node;
        try {
            node = DebugExprSizeofNode.create(type);
        }
        catch (Type.TypeOverflowException e) {
            node = Type.handleOverflowExpression(e);
        }
        return DebugExpressionPair.create(node, DebugExprType.getIntType(32L, true));
    }

    public DebugExpressionPair createLogicalAndNode(DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, "&&");
        DebugExprNodeFactory.checkError(right, "&&");
        DebugExprShortCircuitEvaluationNode node = DebugExprShortCircuitEvaluationNodeGen.create(left.getNode(), right.getNode(), new DebugExprLogicalAndNode());
        return DebugExpressionPair.create(node, DebugExprType.getBoolType());
    }

    public DebugExpressionPair createLogicalOrNode(DebugExpressionPair left, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, "||");
        DebugExprNodeFactory.checkError(right, "||");
        DebugExprShortCircuitEvaluationNode node = DebugExprShortCircuitEvaluationNodeGen.create(left.getNode(), right.getNode(), new DebugExprLogicalOrNode());
        return DebugExpressionPair.create(node, DebugExprType.getBoolType());
    }

    public DebugExpressionPair createCompareNode(DebugExpressionPair left, CompareKind op, DebugExpressionPair right) {
        DebugExprNodeFactory.checkError(left, op.name());
        DebugExprNodeFactory.checkError(right, op.name());
        DebugExprType commonType = DebugExprType.commonType(left.getType(), right.getType());
        DebugExpressionPair leftPair = this.createCastIfNecessary(left, commonType);
        DebugExpressionPair rightPair = this.createCastIfNecessary(right, commonType);
        CompareOperator cop = commonType.isFloatingType() ? DebugExprNodeFactory.getFloatingCompareOperator(op) : (commonType.isUnsigned() ? DebugExprNodeFactory.getUnsignedCompareOperator(op) : DebugExprNodeFactory.getSignedCompareOperator(op));
        LLVMExpressionNode node = CommonNodeFactory.createComparison(cop, commonType.getLLVMRuntimeType(), leftPair.getNode(), rightPair.getNode());
        return DebugExpressionPair.create(node, DebugExprType.getBoolType());
    }

    public DebugExpressionPair createIntegerConstant(int value) {
        return this.createIntegerConstant(value, true);
    }

    public DebugExpressionPair createIntegerConstant(int value, boolean signed) {
        LLVMExpressionNode node = CommonNodeFactory.createSimpleConstantNoArray(value, PrimitiveType.I32);
        return DebugExpressionPair.create(node, DebugExprType.getIntType(32L, signed));
    }

    public DebugExpressionPair createFloatConstant(float value) {
        LLVMExpressionNode node = CommonNodeFactory.createSimpleConstantNoArray(Float.valueOf(value), PrimitiveType.FLOAT);
        return DebugExpressionPair.create(node, DebugExprType.getFloatType(32L));
    }

    public DebugExpressionPair createCharacterConstant(String charString) {
        boolean valid = true;
        int value = charString.charAt(1);
        if (value == 92) {
            switch (charString.charAt(2)) {
                case 'n': {
                    value = 10;
                    break;
                }
                case 'r': {
                    value = 13;
                    break;
                }
                case '\'': {
                    value = 39;
                    break;
                }
                case '\\': {
                    value = 92;
                    break;
                }
                case '\"': {
                    value = 34;
                    break;
                }
                default: {
                    valid = false;
                }
            }
        }
        LLVMExpressionNode node = CommonNodeFactory.createSimpleConstantNoArray((byte)value, PrimitiveType.I8);
        if (!valid) {
            throw DebugExprException.create(node, "character %s not found", charString);
        }
        return DebugExpressionPair.create(node, DebugExprType.getIntType(8L, false));
    }

    public DebugExpressionPair createCastIfNecessary(DebugExpressionPair pair, DebugExprType type) {
        DebugExprNodeFactory.checkError(pair, "cast");
        if (pair.getType().equalsType(type)) {
            return pair;
        }
        if (!pair.getType().canBeCastTo(type)) {
            throw DebugExprException.create(pair.getNode(), "Cast from %s to %s not possible!", pair.getType(), type);
        }
        LLVMExpressionNode node = type.isFloatingType() || type.isIntegerType() ? (type.isUnsigned() ? CommonNodeFactory.createUnsignedCast(pair.getNode(), type.getLLVMRuntimeType()) : CommonNodeFactory.createSignedCast(pair.getNode(), type.getLLVMRuntimeType())) : CommonNodeFactory.createBitcast(pair.getNode(), type.getLLVMRuntimeType(), pair.getType().getLLVMRuntimeType());
        return DebugExpressionPair.create(node, type);
    }

    public DebugExpressionPair createObjectMember(DebugExpressionPair receiver, String fieldName) {
        LLVMExpressionNode baseNode = receiver.getNode();
        DebugExprObjectMemberNode node = DebugExprObjectMemberNodeGen.create(baseNode, fieldName);
        DebugExprType type = node.getType((VirtualFrame)this.frame);
        return DebugExpressionPair.create(node, type);
    }

    public DebugExpressionPair createDereferenceNode(DebugExpressionPair pointerPair) {
        DebugExprNodeFactory.checkError(pointerPair, "*");
        DebugExprDereferenceNode node = DebugExprDereferenceNodeGen.create(pointerPair.getNode());
        DebugExprType type = pointerPair.getType().getInnerType();
        return DebugExpressionPair.create(node, type);
    }

    public DebugExpressionPair createObjectPointerMember(DebugExpressionPair receiver, String fieldName) {
        DebugExpressionPair dereferenced = this.createDereferenceNode(receiver);
        return this.createObjectMember(dereferenced, fieldName);
    }

    public DebugExpressionPair createFunctionCall(DebugExpressionPair functionPair, List<DebugExpressionPair> arguments) {
        DebugExprNodeFactory.checkError(functionPair, "call(...)");
        if (functionPair.getNode() instanceof DebugExprVarNode) {
            DebugExprVarNode varNode = (DebugExprVarNode)functionPair.getNode();
            DebugExprFunctionCallNode node = varNode.createFunctionCall(arguments, this.globalScope);
            DebugExprType type = node.getType();
            return DebugExpressionPair.create(node, type);
        }
        throw DebugExprException.typeError(functionPair.getNode(), functionPair.getNode().toString());
    }

    public DebugExpressionPair createArrayElement(DebugExpressionPair array, DebugExpressionPair index) {
        DebugExprArrayElementNode node = DebugExprArrayElementNode.create(array, index.getNode());
        if (array.getType() == null) {
            throw DebugExprException.typeError(node, new Object[]{node});
        }
        return DebugExpressionPair.create(node, array.getType().getInnerType());
    }

    public DebugExprTypeofNode createTypeofNode(String ident) {
        return DebugExprTypeofNodeGen.create(ident, this.location);
    }

    public DebugExpressionPair createPointerCastNode(DebugExpressionPair pair, DebugExprTypeofNode typeNode) {
        DebugExprNodeFactory.checkError(pair, "pointer cast");
        DebugExprPointerCastNode node = DebugExprPointerCastNodeGen.create(pair.getNode(), typeNode);
        return DebugExpressionPair.create(node, node.getType((VirtualFrame)this.frame));
    }

    private static CompareOperator getSignedCompareOperator(CompareKind kind) {
        switch (kind.ordinal()) {
            case 0: {
                return CompareOperator.INT_EQUAL;
            }
            case 5: {
                return CompareOperator.INT_SIGNED_GREATER_OR_EQUAL;
            }
            case 4: {
                return CompareOperator.INT_SIGNED_GREATER_THAN;
            }
            case 3: {
                return CompareOperator.INT_SIGNED_LESS_OR_EQUAL;
            }
            case 2: {
                return CompareOperator.INT_SIGNED_LESS_THAN;
            }
            case 1: {
                return CompareOperator.INT_NOT_EQUAL;
            }
        }
        return CompareOperator.INT_EQUAL;
    }

    private static CompareOperator getUnsignedCompareOperator(CompareKind kind) {
        switch (kind.ordinal()) {
            case 0: {
                return CompareOperator.INT_EQUAL;
            }
            case 5: {
                return CompareOperator.INT_UNSIGNED_GREATER_OR_EQUAL;
            }
            case 4: {
                return CompareOperator.INT_UNSIGNED_GREATER_THAN;
            }
            case 3: {
                return CompareOperator.INT_UNSIGNED_LESS_OR_EQUAL;
            }
            case 2: {
                return CompareOperator.INT_UNSIGNED_LESS_THAN;
            }
            case 1: {
                return CompareOperator.INT_NOT_EQUAL;
            }
        }
        return CompareOperator.INT_EQUAL;
    }

    private static CompareOperator getFloatingCompareOperator(CompareKind kind) {
        switch (kind.ordinal()) {
            case 0: {
                return CompareOperator.FP_ORDERED_EQUAL;
            }
            case 5: {
                return CompareOperator.FP_ORDERED_GREATER_OR_EQUAL;
            }
            case 4: {
                return CompareOperator.FP_ORDERED_GREATER_THAN;
            }
            case 3: {
                return CompareOperator.FP_ORDERED_LESS_OR_EQUAL;
            }
            case 2: {
                return CompareOperator.FP_ORDERED_LESS_THAN;
            }
            case 1: {
                return CompareOperator.FP_ORDERED_NOT_EQUAL;
            }
        }
        return CompareOperator.FP_FALSE;
    }

    public static enum CompareKind {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE;

    }
}

