/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;

@NodeChildren(value={@NodeChild(value="src"), @NodeChild(value="dst")})
public abstract class LLVMAMD64BsrNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeZFNode;
    protected final CountingConditionProfile profile;

    public LLVMAMD64BsrNode(LLVMAMD64WriteBooleanNode writeZFNode) {
        this.writeZFNode = writeZFNode;
        this.profile = CountingConditionProfile.create();
    }

    public static abstract class LLVMAMD64BsrqNode
    extends LLVMAMD64BsrNode {
        public LLVMAMD64BsrqNode(LLVMAMD64WriteBooleanNode writeZFNode) {
            super(writeZFNode);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long src, long dst) {
            if (this.profile.profile(src == 0L)) {
                this.writeZFNode.execute(frame, true);
                return dst;
            }
            this.writeZFNode.execute(frame, false);
            int numberOfLeadingZeros = Long.numberOfLeadingZeros(src);
            return 64 - numberOfLeadingZeros - 1;
        }
    }

    public static abstract class LLVMAMD64BsrlNode
    extends LLVMAMD64BsrNode {
        public LLVMAMD64BsrlNode(LLVMAMD64WriteBooleanNode writeZFNode) {
            super(writeZFNode);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int src, int dst) {
            if (this.profile.profile(src == 0)) {
                this.writeZFNode.execute(frame, true);
                return dst;
            }
            this.writeZFNode.execute(frame, false);
            int numberOfLeadingZeros = Integer.numberOfLeadingZeros(src);
            return 32 - numberOfLeadingZeros - 1;
        }
    }

    public static abstract class LLVMAMD64BsrwNode
    extends LLVMAMD64BsrNode {
        public LLVMAMD64BsrwNode(LLVMAMD64WriteBooleanNode writeZFNode) {
            super(writeZFNode);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short src, short dst) {
            if (this.profile.profile(src == 0)) {
                this.writeZFNode.execute(frame, true);
                return dst;
            }
            this.writeZFNode.execute(frame, false);
            int val = Short.toUnsignedInt(src);
            int numberOfLeadingZeros = Integer.numberOfLeadingZeros(val) - 32 + 16;
            return (short)(16 - numberOfLeadingZeros - 1);
        }
    }
}

