/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(value="value", type=LLVMExpressionNode.class)
public abstract class LLVMAMD64PushNode
extends LLVMStatementNode {
    protected final LLVMStack.LLVMStackAccess stackAccess;

    protected LLVMAMD64PushNode(LLVMStack.LLVMStackAccess stackAccess) {
        this.stackAccess = stackAccess;
    }

    public static abstract class LLVMAMD64PushqNode
    extends LLVMAMD64PushNode {
        protected LLVMAMD64PushqNode(LLVMStack.LLVMStackAccess stackAccess) {
            super(stackAccess);
        }

        @Specialization
        protected void doVoid(VirtualFrame frame, long value, @Cached LLVMI64StoreNode store) {
            LLVMPointer stackPointer = this.stackAccess.executeGet(frame).increment(-8L);
            this.stackAccess.executeSet(frame, stackPointer);
            store.executeWithTarget(stackPointer, value);
        }
    }

    public static abstract class LLVMAMD64PushlNode
    extends LLVMAMD64PushNode {
        protected LLVMAMD64PushlNode(LLVMStack.LLVMStackAccess stackAccess) {
            super(stackAccess);
        }

        @Specialization
        protected void doVoid(VirtualFrame frame, int value, @Cached LLVMI32StoreNode store) {
            LLVMPointer stackPointer = this.stackAccess.executeGet(frame).increment(-4L);
            this.stackAccess.executeSet(frame, stackPointer);
            store.executeWithTarget(stackPointer, value);
        }
    }

    public static abstract class LLVMAMD64PushwNode
    extends LLVMAMD64PushNode {
        protected LLVMAMD64PushwNode(LLVMStack.LLVMStackAccess stackAccess) {
            super(stackAccess);
        }

        @Specialization
        protected void doVoid(VirtualFrame frame, short value, @Cached LLVMI16StoreNode store) {
            LLVMPointer stackPointer = this.stackAccess.executeGet(frame).increment(-2L);
            this.stackAccess.executeSet(frame, stackPointer);
            store.executeWithTarget(stackPointer, value);
        }
    }
}

