/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsString;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMPolyglotAsString.class)
public final class LLVMPolyglotAsStringNodeGen
extends LLVMPolyglotAsString
implements GenerateAOT.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode object_;
    @Node.Child
    private LLVMExpressionNode buffer_;
    @Node.Child
    private LLVMExpressionNode buflen_;
    @Node.Child
    private LLVMReadCharsetNode charset_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMPolyglotAsStringNodeGen(LLVMExpressionNode object, LLVMExpressionNode buffer, LLVMExpressionNode buflen, LLVMReadCharsetNode charset) {
        this.object_ = object;
        this.buffer_ = buffer;
        this.buflen_ = buflen;
        this.charset_ = charset;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        long buflenValue_;
        int state_0 = this.state_0_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
        try {
            buflenValue_ = this.buflen_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object charsetValue = this.charset_.execute(frameValue);
            return this.executeAndSpecialize(objectValue_, bufferValue_, ex.getResult(), charsetValue);
        }
        Object charsetValue_ = this.charset_.execute(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(objectValue_, bufferValue_, buflenValue_, charsetValue_);
        }
        if ((state_0 & 2) != 0 && charsetValue_ instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue__ = (LLVMReadCharsetNode.LLVMCharset)charsetValue_;
            return this.doAsString(objectValue_, bufferValue_, buflenValue_, charsetValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectValue_, bufferValue_, buflenValue_, charsetValue_);
    }

    @Override
    public long executeI64(VirtualFrame frameValue) {
        long buflenValue_;
        int state_0 = this.state_0_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
        try {
            buflenValue_ = this.buflen_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object charsetValue = this.charset_.execute(frameValue);
            return this.executeAndSpecialize(objectValue_, bufferValue_, ex.getResult(), charsetValue);
        }
        Object charsetValue_ = this.charset_.execute(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(objectValue_, bufferValue_, buflenValue_, charsetValue_);
        }
        if ((state_0 & 2) != 0 && charsetValue_ instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue__ = (LLVMReadCharsetNode.LLVMCharset)charsetValue_;
            return this.doAsString(objectValue_, bufferValue_, buflenValue_, charsetValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectValue_, bufferValue_, buflenValue_, charsetValue_);
    }

    private long executeAndSpecialize(Object objectValue, Object bufferValue, Object buflenValue, Object charsetValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (buflenValue instanceof Long) {
            long buflenValue_ = (Long)buflenValue;
            if (charsetValue instanceof LLVMReadCharsetNode.LLVMCharset) {
                LLVMReadCharsetNode.LLVMCharset charsetValue_ = (LLVMReadCharsetNode.LLVMCharset)charsetValue;
                this.state_0_ = state_0 |= 2;
                return this.doAsString(objectValue, bufferValue, buflenValue_, charsetValue_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.buffer_, this.buflen_, this.charset_}, new Object[]{objectValue, bufferValue, buflenValue, charsetValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotAsString create(LLVMExpressionNode object, LLVMExpressionNode buffer, LLVMExpressionNode buflen, LLVMReadCharsetNode charset) {
        return new LLVMPolyglotAsStringNodeGen(object, buffer, buflen, charset);
    }

    @GeneratedBy(value=LLVMPolyglotAsString.WriteStringNode.class)
    static final class WriteStringNodeGen
    extends LLVMPolyglotAsString.WriteStringNode
    implements GenerateAOT.Provider {
        static final InlineSupport.ReferenceField<WriteData> WRITE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"write_cache", WriteData.class);
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private WriteData write_cache;

        private WriteStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected long execute(ByteBuffer arg0Value, Object arg1Value, long arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(arg1Value)) {
                LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                WriteData s0_ = this.write_cache;
                while (s0_ != null) {
                    if (CompilerDirectives.isExact((Object)arg0Value, s0_.srcBufferClass_)) {
                        return this.doWrite(arg0Value, arg1Value_, arg2Value, arg3Value, s0_.srcBufferClass_, s0_.write_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private long executeAndSpecialize(ByteBuffer arg0Value, Object arg1Value, long arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(arg1Value)) {
                WriteData s0_;
                LLVMPointer arg1Value_;
                block5: {
                    WriteData s0_original;
                    arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    do {
                        Class<?> srcBufferClass__;
                        int count0_ = 0;
                        s0_original = s0_ = (WriteData)((Object)WRITE_CACHE_UPDATER.getVolatile((Node)this));
                        while (s0_ != null && !CompilerDirectives.isExact((Object)arg0Value, s0_.srcBufferClass_)) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || !CompilerDirectives.isExact((Object)arg0Value, srcBufferClass__ = arg0Value.getClass()) || count0_ >= 3) break block5;
                        s0_ = (WriteData)this.insert(new WriteData(s0_original));
                        s0_.srcBufferClass_ = srcBufferClass__;
                        s0_.write_ = (LLVMI8StoreNode.LLVMI8OffsetStoreNode)s0_.insert(LLVMI8StoreNode.LLVMI8OffsetStoreNode.create());
                    } while (!WRITE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 2;
                }
                if (s0_ != null) {
                    return this.doWrite(arg0Value, arg1Value_, arg2Value, arg3Value, s0_.srcBufferClass_, s0_.write_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        public NodeCost getCost() {
            WriteData s0_;
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 2 & (state_0 & 2) - 1) == 0 && ((s0_ = this.write_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMPolyglotAsString.WriteStringNode create() {
            return new WriteStringNodeGen();
        }

        @GeneratedBy(value=LLVMPolyglotAsString.WriteStringNode.class)
        @DenyReplace
        private static final class WriteData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            WriteData next_;
            @CompilerDirectives.CompilationFinal
            Class<? extends ByteBuffer> srcBufferClass_;
            @Node.Child
            LLVMI8StoreNode.LLVMI8OffsetStoreNode write_;

            WriteData(WriteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsString.BoxedEncodeStringNode.class)
    static final class BoxedEncodeStringNodeGen
    extends LLVMPolyglotAsString.BoxedEncodeStringNode
    implements GenerateAOT.Provider {
        static final InlineSupport.ReferenceField<Boxed0Data> BOXED0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boxed0_cache", Boxed0Data.class);
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Boxed0Data boxed0_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile boxed1_exception_;

        private BoxedEncodeStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        ByteBuffer execute(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 6) != 0) {
                BranchProfile exception__;
                if ((state_0 & 2) != 0) {
                    Boxed0Data s0_ = this.boxed0_cache;
                    while (s0_ != null) {
                        if (s0_.interop_.accepts(arg0Value)) {
                            return this.doBoxed(arg0Value, arg1Value, s0_.interop_, s0_.exception_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && (exception__ = this.boxed1_exception_) != null) {
                    return this.boxed1Boundary(state_0, arg0Value, arg1Value, exception__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private ByteBuffer boxed1Boundary(int state_0, Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value, BranchProfile exception__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                ByteBuffer byteBuffer = this.doBoxed(arg0Value, arg1Value, interop__, exception__);
                return byteBuffer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer executeAndSpecialize(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((state_0 & 4) == 0) {
                Boxed0Data s0_;
                block8: {
                    Boxed0Data s0_original;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = (Boxed0Data)((Object)BOXED0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s0_ != null && !s0_.interop_.accepts(arg0Value)) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 3) break block8;
                        s0_ = (Boxed0Data)this.insert(new Boxed0Data(s0_original));
                        InteropLibrary interop__ = (InteropLibrary)s0_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value)));
                        Objects.requireNonNull(interop__, "Specialization 'doBoxed(Object, LLVMCharset, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        BranchProfile exception__ = BranchProfile.create();
                        Objects.requireNonNull(exception__, "Specialization 'doBoxed(Object, LLVMCharset, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.exception_ = exception__;
                    } while (!BOXED0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 2;
                }
                if (s0_ != null) {
                    return this.doBoxed(arg0Value, arg1Value, s0_.interop_, s0_.exception_);
                }
            }
            InteropLibrary interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                BranchProfile exception__ = BranchProfile.create();
                Objects.requireNonNull(exception__, "Specialization 'doBoxed(Object, LLVMCharset, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.boxed1_exception_ = exception__;
                this.boxed0_cache = null;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                ByteBuffer byteBuffer = this.doBoxed(arg0Value, arg1Value, interop__, exception__);
                return byteBuffer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public NodeCost getCost() {
            Boxed0Data s0_;
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0 && ((s0_ = this.boxed0_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMPolyglotAsString.BoxedEncodeStringNode create() {
            return new BoxedEncodeStringNodeGen();
        }

        @GeneratedBy(value=LLVMPolyglotAsString.BoxedEncodeStringNode.class)
        @DenyReplace
        private static final class Boxed0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            Boxed0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            Boxed0Data(Boxed0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsString.EncodeStringNode.class)
    static final class EncodeStringNodeGen
    extends LLVMPolyglotAsString.EncodeStringNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ForeignData foreign_cache;

        private EncodeStringNodeGen() {
        }

        @Override
        protected ByteBuffer execute(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    return this.doString(arg0Value_, arg1Value);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    ForeignData s1_ = this.foreign_cache;
                    if (s1_ != null) {
                        return this.doForeign(arg0Value_, arg1Value, s1_.asForeign_, s1_.encode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private ByteBuffer executeAndSpecialize(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_0_ = state_0 |= 2;
                return this.doString(arg0Value_, arg1Value);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                ForeignData s1_ = (ForeignData)this.insert(new ForeignData());
                s1_.asForeign_ = (LLVMAsForeignNode)s1_.insert(LLVMAsForeignNode.create());
                LLVMPolyglotAsString.BoxedEncodeStringNode encode__ = (LLVMPolyglotAsString.BoxedEncodeStringNode)s1_.insert(BoxedEncodeStringNodeGen.create());
                Objects.requireNonNull(encode__, "Specialization 'doForeign(LLVMManagedPointer, LLVMCharset, LLVMAsForeignNode, BoxedEncodeStringNode)' cache 'encode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.encode_ = encode__;
                VarHandle.storeStoreFence();
                this.foreign_cache = s1_;
                this.state_0_ = state_0 |= 4;
                return this.doForeign(arg0Value_, arg1Value, s1_.asForeign_, encode__);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            ForeignData s1_ = (ForeignData)this.insert(new ForeignData());
            s1_.asForeign_ = (LLVMAsForeignNode)s1_.insert(LLVMAsForeignNode.create());
            LLVMPolyglotAsString.BoxedEncodeStringNode encode__ = (LLVMPolyglotAsString.BoxedEncodeStringNode)s1_.insert(BoxedEncodeStringNodeGen.create());
            Objects.requireNonNull(encode__, "Specialization 'doForeign(LLVMManagedPointer, LLVMCharset, LLVMAsForeignNode, BoxedEncodeStringNode)' cache 'encode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s1_.encode_ = encode__;
            VarHandle.storeStoreFence();
            this.foreign_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.asForeign_, (int)1));
            ((GenerateAOT.Provider)s1_.asForeign_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s1_.encode_, (int)1));
            ((GenerateAOT.Provider)s1_.encode_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.foreign_cache = null;
        }

        @NeverDefault
        public static LLVMPolyglotAsString.EncodeStringNode create() {
            return new EncodeStringNodeGen();
        }

        @GeneratedBy(value=LLVMPolyglotAsString.EncodeStringNode.class)
        @DenyReplace
        private static final class ForeignData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMAsForeignNode asForeign_;
            @Node.Child
            LLVMPolyglotAsString.BoxedEncodeStringNode encode_;

            ForeignData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }
}

