/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMIVarBitStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMIVarBitStoreNode
extends LLVMStoreNode {
    protected final boolean isRecursive;

    protected LLVMIVarBitStoreNode() {
        this(false);
    }

    protected LLVMIVarBitStoreNode(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    protected abstract void executeWithTarget(LLVMManagedPointer var1, LLVMIVarBit var2);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, LLVMIVarBit value) {
        this.getLanguage().getLLVMMemory().putIVarBit((Node)this, addr, value);
    }

    @Specialization(guards={"!isRecursive", "isAutoDerefHandle(addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, LLVMIVarBit value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached(value="createRecursive()") LLVMIVarBitStoreNode store) {
        store.executeWithTarget(getReceiver.execute(addr), value);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected static void doOpManaged(LLVMManagedPointer address, LLVMIVarBit value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        byte[] bytes = value.getBytes();
        long curOffset = address.getOffset();
        for (int i = bytes.length - 1; i >= 0; --i) {
            nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
            ++curOffset;
        }
    }

    public static LLVMIVarBitStoreNode create() {
        return LLVMIVarBitStoreNodeGen.create(false, null, null);
    }

    public static LLVMIVarBitStoreNode createRecursive() {
        return LLVMIVarBitStoreNodeGen.create(true, null, null);
    }

    public static abstract class LLVMIVarBitOffsetStoreNode
    extends LLVMOffsetStoreNode {
        protected final boolean isRecursive;

        protected LLVMIVarBitOffsetStoreNode() {
            this(false);
        }

        protected LLVMIVarBitOffsetStoreNode(boolean isRecursive) {
            this.isRecursive = isRecursive;
        }

        public static LLVMIVarBitOffsetStoreNode create() {
            return LLVMIVarBitStoreNodeGen.LLVMIVarBitOffsetStoreNodeGen.create(false, null, null, null);
        }

        public static LLVMIVarBitOffsetStoreNode createRecursive() {
            return LLVMIVarBitStoreNodeGen.LLVMIVarBitOffsetStoreNodeGen.create(true, null, null, null);
        }

        public static LLVMIVarBitOffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMIVarBitStoreNodeGen.LLVMIVarBitOffsetStoreNodeGen.create(false, null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, LLVMIVarBit var4);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, LLVMIVarBit value) {
            this.getLanguage().getLLVMMemory().putIVarBit((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"!isRecursive", "isAutoDerefHandle(addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, LLVMIVarBit value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached(value="createRecursive()") LLVMIVarBitOffsetStoreNode store) {
            store.executeWithTarget(getReceiver.execute(addr), offset, value);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected static void doOpManaged(LLVMManagedPointer address, long offset, LLVMIVarBit value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            byte[] bytes = value.getBytes();
            long curOffset = address.getOffset() + offset;
            for (int i = bytes.length - 1; i >= 0; --i) {
                nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
                ++curOffset;
            }
        }
    }
}

