/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMInsertElementNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMInsertElementNode.class)
public final class LLVMInsertElementNodeFactory {

    @GeneratedBy(value=LLVMInsertElementNode.LLVMDoubleInsertElementNode.class)
    public static final class LLVMDoubleInsertElementNodeGen
    extends LLVMInsertElementNode.LLVMDoubleInsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMDoubleInsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            double elementValue_;
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, child0Value_, elementValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int1(state_0, frameValue, child0Value_, elementValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_, elementValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object child0Value_, double elementValue_) {
            long indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue, Object child0Value_, double elementValue_) {
            int indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_, double elementValue_) {
            int state_0 = state_0__;
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                    long indexValue__ = (Long)indexValue_;
                    return this.doDouble(child0Value__, elementValue_, indexValue__);
                }
                if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                    int indexValue__ = (Integer)indexValue_;
                    return this.doDouble(child0Value__, elementValue_, indexValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                if (elementValue instanceof Double) {
                    double elementValue_ = (Double)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doDouble(child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doDouble(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMDoubleInsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMDoubleInsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMFloatInsertElementNode.class)
    public static final class LLVMFloatInsertElementNodeGen
    extends LLVMInsertElementNode.LLVMFloatInsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFloatInsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            float elementValue_;
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, child0Value_, elementValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int1(state_0, frameValue, child0Value_, elementValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_, elementValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object child0Value_, float elementValue_) {
            long indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doFloat(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue, Object child0Value_, float elementValue_) {
            int indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doFloat(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_, float elementValue_) {
            int state_0 = state_0__;
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                    long indexValue__ = (Long)indexValue_;
                    return this.doFloat(child0Value__, elementValue_, indexValue__);
                }
                if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                    int indexValue__ = (Integer)indexValue_;
                    return this.doFloat(child0Value__, elementValue_, indexValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value_ = (LLVMFloatVector)child0Value;
                if (elementValue instanceof Float) {
                    float elementValue_ = ((Float)elementValue).floatValue();
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFloat(child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doFloat(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMFloatInsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMFloatInsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI64InsertElementNode.class)
    public static final class LLVMI64InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI64InsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI64InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x5C) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_long_long0(state_0, frameValue);
            }
            if ((state_0 & 0x3A) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_long_int1(state_0, frameValue);
            }
            if ((state_0 & 0x56) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_long2(state_0, frameValue);
            }
            if ((state_0 & 0x2E) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_long_long0(int state_0__, VirtualFrame frameValue) {
            long indexValue_;
            long elementValue_;
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 0x22) != 0) {
                if ((state_0 & 2) != 0 && child0Value_ instanceof LLVMI64Vector) {
                    LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                    return this.doI64(child0Value__, elementValue_, indexValue_);
                }
                if ((state_0 & 0x20) != 0 && child0Value_ instanceof LLVMPointerVector) {
                    LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                    return this.doPointer(child0Value__, elementValue_, indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_long_int1(int state_0__, VirtualFrame frameValue) {
            int indexValue_;
            long elementValue_;
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 0x44) != 0) {
                if ((state_0 & 4) != 0 && child0Value_ instanceof LLVMI64Vector) {
                    LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                    return this.doI64(child0Value__, elementValue_, indexValue_);
                }
                if ((state_0 & 0x40) != 0 && child0Value_ instanceof LLVMPointerVector) {
                    LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                    return this.doPointer(child0Value__, elementValue_, indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
            long indexValue_;
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object elementValue_ = this.element_.executeGeneric(frameValue);
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 0x28) != 0 && child0Value_ instanceof LLVMPointerVector) {
                LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                if ((state_0 & 8) != 0 && LLVMTypes.isPointer(elementValue_)) {
                    LLVMPointer elementValue__ = LLVMTypes.asPointer(elementValue_);
                    return this.doPointer(child0Value__, elementValue__, indexValue_);
                }
                if ((state_0 & 0x20) != 0 && elementValue_ instanceof Long) {
                    long elementValue__ = (Long)elementValue_;
                    return this.doPointer(child0Value__, elementValue__, indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int indexValue_;
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object elementValue_ = this.element_.executeGeneric(frameValue);
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 0x50) != 0 && child0Value_ instanceof LLVMPointerVector) {
                LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                if ((state_0 & 0x10) != 0 && LLVMTypes.isPointer(elementValue_)) {
                    LLVMPointer elementValue__ = LLVMTypes.asPointer(elementValue_);
                    return this.doPointer(child0Value__, elementValue__, indexValue_);
                }
                if ((state_0 & 0x40) != 0 && elementValue_ instanceof Long) {
                    long elementValue__ = (Long)elementValue_;
                    return this.doPointer(child0Value__, elementValue__, indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object elementValue_ = this.element_.executeGeneric(frameValue);
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 0x7E) != 0) {
                long elementValue__;
                LLVMVector child0Value__;
                if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI64Vector) {
                    child0Value__ = (LLVMI64Vector)child0Value_;
                    if (elementValue_ instanceof Long) {
                        elementValue__ = (Long)elementValue_;
                        if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                            long indexValue__ = (Long)indexValue_;
                            return this.doI64((LLVMI64Vector)child0Value__, elementValue__, indexValue__);
                        }
                        if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                            int indexValue__ = (Integer)indexValue_;
                            return this.doI64((LLVMI64Vector)child0Value__, elementValue__, indexValue__);
                        }
                    }
                }
                if ((state_0 & 0x78) != 0 && child0Value_ instanceof LLVMPointerVector) {
                    child0Value__ = (LLVMPointerVector)child0Value_;
                    if ((state_0 & 0x18) != 0 && LLVMTypes.isPointer(elementValue_)) {
                        LLVMPointer elementValue__2 = LLVMTypes.asPointer(elementValue_);
                        if ((state_0 & 8) != 0 && indexValue_ instanceof Long) {
                            long indexValue__ = (Long)indexValue_;
                            return this.doPointer((LLVMPointerVector)child0Value__, elementValue__2, indexValue__);
                        }
                        if ((state_0 & 0x10) != 0 && indexValue_ instanceof Integer) {
                            int indexValue__ = (Integer)indexValue_;
                            return this.doPointer((LLVMPointerVector)child0Value__, elementValue__2, indexValue__);
                        }
                    }
                    if ((state_0 & 0x60) != 0 && elementValue_ instanceof Long) {
                        elementValue__ = (Long)elementValue_;
                        if ((state_0 & 0x20) != 0 && indexValue_ instanceof Long) {
                            long indexValue__ = (Long)indexValue_;
                            return this.doPointer((LLVMPointerVector)child0Value__, elementValue__, indexValue__);
                        }
                        if ((state_0 & 0x40) != 0 && indexValue_ instanceof Integer) {
                            int indexValue__ = (Integer)indexValue_;
                            return this.doPointer((LLVMPointerVector)child0Value__, elementValue__, indexValue__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMVector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            long elementValue_;
            LLVMVector child0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI64Vector) {
                child0Value_ = (LLVMI64Vector)child0Value;
                if (elementValue instanceof Long) {
                    elementValue_ = (Long)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doI64((LLVMI64Vector)child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doI64((LLVMI64Vector)child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            if (child0Value instanceof LLVMPointerVector) {
                child0Value_ = (LLVMPointerVector)child0Value;
                if (LLVMTypes.isPointer(elementValue)) {
                    LLVMPointer elementValue_2 = LLVMTypes.asPointer(elementValue);
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 8;
                        return this.doPointer((LLVMPointerVector)child0Value_, elementValue_2, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doPointer((LLVMPointerVector)child0Value_, elementValue_2, indexValue_);
                    }
                }
                if (elementValue instanceof Long) {
                    elementValue_ = (Long)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 0x20;
                        return this.doPointer((LLVMPointerVector)child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 0x40;
                        return this.doPointer((LLVMPointerVector)child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7E) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x7E & (state_0 & 0x7E) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMI64InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI64InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI32InsertElementNode.class)
    public static final class LLVMI32InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI32InsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI32InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int elementValue_;
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, child0Value_, elementValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int1(state_0, frameValue, child0Value_, elementValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_, elementValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object child0Value_, int elementValue_) {
            long indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue, Object child0Value_, int elementValue_) {
            int indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_, int elementValue_) {
            int state_0 = state_0__;
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                    long indexValue__ = (Long)indexValue_;
                    return this.doI32(child0Value__, elementValue_, indexValue__);
                }
                if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                    int indexValue__ = (Integer)indexValue_;
                    return this.doI32(child0Value__, elementValue_, indexValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value_ = (LLVMI32Vector)child0Value;
                if (elementValue instanceof Integer) {
                    int elementValue_ = (Integer)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doI32(child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doI32(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMI32InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI32InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI16InsertElementNode.class)
    public static final class LLVMI16InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI16InsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI16InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short elementValue_;
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, child0Value_, elementValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int1(state_0, frameValue, child0Value_, elementValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_, elementValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object child0Value_, short elementValue_) {
            long indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue, Object child0Value_, short elementValue_) {
            int indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_, short elementValue_) {
            int state_0 = state_0__;
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                    long indexValue__ = (Long)indexValue_;
                    return this.doI16(child0Value__, elementValue_, indexValue__);
                }
                if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                    int indexValue__ = (Integer)indexValue_;
                    return this.doI16(child0Value__, elementValue_, indexValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value_ = (LLVMI16Vector)child0Value;
                if (elementValue instanceof Short) {
                    short elementValue_ = (Short)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doI16(child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doI16(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMI16InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI16InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI8InsertElementNode.class)
    public static final class LLVMI8InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI8InsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI8InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte elementValue_;
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, child0Value_, elementValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int1(state_0, frameValue, child0Value_, elementValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_, elementValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object child0Value_, byte elementValue_) {
            long indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue, Object child0Value_, byte elementValue_) {
            int indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_, byte elementValue_) {
            int state_0 = state_0__;
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                    long indexValue__ = (Long)indexValue_;
                    return this.doI8(child0Value__, elementValue_, indexValue__);
                }
                if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                    int indexValue__ = (Integer)indexValue_;
                    return this.doI8(child0Value__, elementValue_, indexValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value_ = (LLVMI8Vector)child0Value;
                if (elementValue instanceof Byte) {
                    byte elementValue_ = (Byte)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doI8(child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doI8(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMI8InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI8InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI1InsertElementNode.class)
    public static final class LLVMI1InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI1InsertElementNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI1InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean elementValue_;
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, child0Value_, elementValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int1(state_0, frameValue, child0Value_, elementValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_, elementValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object child0Value_, boolean elementValue_) {
            long indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue, Object child0Value_, boolean elementValue_) {
            int indexValue_;
            int state_0 = state_0__;
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_, boolean elementValue_) {
            int state_0 = state_0__;
            Object indexValue_ = this.index_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                if ((state_0 & 2) != 0 && indexValue_ instanceof Long) {
                    long indexValue__ = (Long)indexValue_;
                    return this.doI1(child0Value__, elementValue_, indexValue__);
                }
                if ((state_0 & 4) != 0 && indexValue_ instanceof Integer) {
                    int indexValue__ = (Integer)indexValue_;
                    return this.doI1(child0Value__, elementValue_, indexValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value_ = (LLVMI1Vector)child0Value;
                if (elementValue instanceof Boolean) {
                    boolean elementValue_ = (Boolean)elementValue;
                    if (indexValue instanceof Long) {
                        long indexValue_ = (Long)indexValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doI1(child0Value_, elementValue_, indexValue_);
                    }
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_0_ = state_0 |= 4;
                        return this.doI1(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMInsertElementNode.LLVMI1InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI1InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }
}

