// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMGetStackFromThreadNode#cached}
 *     Activation probability: 0.65000
 *     With/without class size: 19/8 bytes
 *   Specialization {@link LLVMGetStackFromThreadNode#generic}
 *     Activation probability: 0.35000
 *     With/without class size: 9/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMGetStackFromThreadNode.class)
@SuppressWarnings("javadoc")
public final class LLVMGetStackFromThreadNodeGen extends LLVMGetStackFromThreadNode implements GenerateAOT.Provider {

    static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMGetStackFromThreadNode#cached}
     *   2: SpecializationActive {@link LLVMGetStackFromThreadNode#generic}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private CachedData cached_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMGetStackFromThreadNode#generic}
     *   Parameter: {@link ConditionProfile} profile</pre>
     */
    @CompilationFinal private ConditionProfile generic_profile_;

    private LLVMGetStackFromThreadNodeGen() {
    }

    @ExplodeLoop
    @Override
    public LLVMStack executeWithTarget(LLVMThreadingStack arg0Value, Thread arg1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMGetStackFromThreadNode.cached(LLVMThreadingStack, Thread, Thread, LLVMStack)] || SpecializationActive[LLVMGetStackFromThreadNode.generic(LLVMThreadingStack, Thread, ConditionProfile)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMGetStackFromThreadNode.cached(LLVMThreadingStack, Thread, Thread, LLVMStack)] */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((arg1Value == s0_.cachedThread_)) {
                        assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                        return cached(arg0Value, arg1Value, s0_.cachedThread_, s0_.cachedStack_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMGetStackFromThreadNode.generic(LLVMThreadingStack, Thread, ConditionProfile)] */) {
                {
                    ConditionProfile profile__ = this.generic_profile_;
                    if (profile__ != null) {
                        return generic(arg0Value, arg1Value, profile__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private LLVMStack executeAndSpecialize(LLVMThreadingStack arg0Value, Thread arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMGetStackFromThreadNode.generic(LLVMThreadingStack, Thread, ConditionProfile)] */) {
            while (true) {
                int count0_ = 0;
                CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                CachedData s0_original = s0_;
                while (s0_ != null) {
                    if ((arg1Value == s0_.cachedThread_)) {
                        assert DSLSupport.assertIdempotence((LLVMLanguage.isSingleContext(this)));
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    if ((LLVMLanguage.isSingleContext(this)) && count0_ < (3)) {
                        // assert (arg1Value == s0_.cachedThread_);
                        s0_ = new CachedData(s0_original);
                        s0_.cachedThread_ = (arg1Value);
                        s0_.cachedStack_ = (getStack(arg0Value, s0_.cachedThread_));
                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMGetStackFromThreadNode.cached(LLVMThreadingStack, Thread, Thread, LLVMStack)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s0_ != null) {
                    return cached(arg0Value, arg1Value, s0_.cachedThread_, s0_.cachedStack_);
                }
                break;
            }
        }
        ConditionProfile profile__ = (ConditionProfile.create());
        Objects.requireNonNull(profile__, "Specialization 'generic(LLVMThreadingStack, Thread, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.generic_profile_ = profile__;
        this.cached_cache = null;
        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMGetStackFromThreadNode.cached(LLVMThreadingStack, Thread, Thread, LLVMStack)] */;
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMGetStackFromThreadNode.generic(LLVMThreadingStack, Thread, ConditionProfile)] */;
        this.state_0_ = state_0;
        return generic(arg0Value, arg1Value, profile__);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                CachedData s0_ = this.cached_cache;
                if ((s0_ == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            ConditionProfile profile__ = (ConditionProfile.create());
            Objects.requireNonNull(profile__, "Specialization 'generic(LLVMThreadingStack, Thread, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.generic_profile_ = profile__;
            this.generic_profile_.disable();
            this.cached_cache = null;
            this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[LLVMGetStackFromThreadNode.cached(LLVMThreadingStack, Thread, Thread, LLVMStack)] */;
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMGetStackFromThreadNode.generic(LLVMThreadingStack, Thread, ConditionProfile)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.generic_profile_.reset();
    }

    @NeverDefault
    public static LLVMGetStackFromThreadNode create() {
        return new LLVMGetStackFromThreadNodeGen();
    }

    @NeverDefault
    public static LLVMGetStackFromThreadNode getUncached() {
        return LLVMGetStackFromThreadNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMGetStackFromThreadNode.class)
    @DenyReplace
    private static final class CachedData implements SpecializationDataNode {

        @CompilationFinal final CachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMGetStackFromThreadNode#cached}
         *   Parameter: {@link Thread} cachedThread</pre>
         */
        @CompilationFinal Thread cachedThread_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMGetStackFromThreadNode#cached}
         *   Parameter: {@link LLVMStack} cachedStack</pre>
         */
        @CompilationFinal LLVMStack cachedStack_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMGetStackFromThreadNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMGetStackFromThreadNode {

        @TruffleBoundary
        @Override
        public LLVMStack executeWithTarget(LLVMThreadingStack arg0Value, Thread arg1Value) {
            return generic(arg0Value, arg1Value, (ConditionProfile.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
