// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode.LLVMI16DataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode.LLVMI32DataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode.LLVMI64DataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory.LLVMI16DataEscapeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory.LLVMI32DataEscapeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory.LLVMI64DataEscapeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode.AccessLocation;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Value;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM.ForeignToLLVMType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropWriteNode#doKnownType}
 *     Activation probability: 0.65000
 *     With/without class size: 19/8 bytes
 *   Specialization {@link LLVMInteropWriteNode#doUnknownType}
 *     Activation probability: 0.35000
 *     With/without class size: 11/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropWriteNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMInteropWriteNodeGen extends LLVMInteropWriteNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilationFinal(dimensions = 1) private static final ForeignToLLVMType[] FOREIGN_TO_L_L_V_M_TYPE_VALUES = DSLSupport.lookupEnumConstants(ForeignToLLVMType.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropWriteNode#doKnownType}
     *   2: SpecializationActive {@link LLVMInteropWriteNode#doUnknownType}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private KnownTypeData knownType_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropWriteNode#doUnknownType}
     *   Parameter: {@link WriteLocationNode} write</pre>
     */
    @Child private WriteLocationNode unknownType_write_;

    private LLVMInteropWriteNodeGen() {
    }

    @Override
    public void execute(Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVMType arg4Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            return;
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropWriteNode.doKnownType(Structured, Object, long, Object, ForeignToLLVMType, LLVMInteropAccessNode, WriteLocationNode)] || SpecializationActive[LLVMInteropWriteNode.doUnknownType(Structured, Object, long, Object, ForeignToLLVMType, WriteLocationNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropWriteNode.doKnownType(Structured, Object, long, Object, ForeignToLLVMType, LLVMInteropAccessNode, WriteLocationNode)] */) {
                KnownTypeData s0_ = this.knownType_cache;
                if (s0_ != null) {
                    if ((arg0Value != null)) {
                        doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.access_, s0_.write_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropWriteNode.doUnknownType(Structured, Object, long, Object, ForeignToLLVMType, WriteLocationNode)] */) {
                {
                    WriteLocationNode write__ = this.unknownType_write_;
                    if (write__ != null) {
                        if ((arg0Value == null)) {
                            doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, write__);
                            return;
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        return;
    }

    private void executeAndSpecialize(Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVMType arg4Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((arg0Value != null)) {
            KnownTypeData s0_ = this.insert(new KnownTypeData());
            s0_.access_ = s0_.insert((LLVMInteropAccessNode.create()));
            WriteLocationNode write__1 = s0_.insert((WriteLocationNodeGen.create()));
            Objects.requireNonNull(write__1, "Specialization 'doKnownType(Structured, Object, long, Object, ForeignToLLVMType, LLVMInteropAccessNode, WriteLocationNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s0_.write_ = write__1;
            VarHandle.storeStoreFence();
            this.knownType_cache = s0_;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropWriteNode.doKnownType(Structured, Object, long, Object, ForeignToLLVMType, LLVMInteropAccessNode, WriteLocationNode)] */;
            this.state_0_ = state_0;
            doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.access_, write__1);
            return;
        }
        if ((arg0Value == null)) {
            WriteLocationNode write__ = this.insert((WriteLocationNodeGen.create()));
            Objects.requireNonNull(write__, "Specialization 'doUnknownType(Structured, Object, long, Object, ForeignToLLVMType, WriteLocationNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.unknownType_write_ = write__;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropWriteNode.doUnknownType(Structured, Object, long, Object, ForeignToLLVMType, WriteLocationNode)] */;
            this.state_0_ = state_0;
            doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, write__);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            KnownTypeData s0_ = this.insert(new KnownTypeData());
            s0_.access_ = s0_.insert((LLVMInteropAccessNode.create()));
            WriteLocationNode write__1 = s0_.insert((WriteLocationNodeGen.create()));
            Objects.requireNonNull(write__1, "Specialization 'doKnownType(Structured, Object, long, Object, ForeignToLLVMType, LLVMInteropAccessNode, WriteLocationNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s0_.write_ = write__1;
            VarHandle.storeStoreFence();
            this.knownType_cache = s0_;
            assert NodeUtil.assertRecursion(s0_.access_, 1);
            ((GenerateAOT.Provider) s0_.access_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s0_.write_, 1);
            ((GenerateAOT.Provider) s0_.write_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMInteropWriteNode.doKnownType(Structured, Object, long, Object, ForeignToLLVMType, LLVMInteropAccessNode, WriteLocationNode)] */;
        }
        {
            WriteLocationNode write__ = this.insert((WriteLocationNodeGen.create()));
            Objects.requireNonNull(write__, "Specialization 'doUnknownType(Structured, Object, long, Object, ForeignToLLVMType, WriteLocationNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.unknownType_write_ = write__;
            assert NodeUtil.assertRecursion(this.unknownType_write_, 1);
            ((GenerateAOT.Provider) this.unknownType_write_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMInteropWriteNode.doUnknownType(Structured, Object, long, Object, ForeignToLLVMType, WriteLocationNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.knownType_cache = null;
        this.unknownType_write_ = null;
    }

    @NeverDefault
    public static LLVMInteropWriteNode create() {
        return new LLVMInteropWriteNodeGen();
    }

    @NeverDefault
    public static LLVMInteropWriteNode getUncached() {
        return LLVMInteropWriteNodeGen.UNCACHED;
    }

    private static ForeignToLLVMType decodeForeignToLLVMType(int state) {
        if (state >= 0) {
            return FOREIGN_TO_L_L_V_M_TYPE_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeForeignToLLVMType(ForeignToLLVMType e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    @GeneratedBy(LLVMInteropWriteNode.class)
    @DenyReplace
    private static final class KnownTypeData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropWriteNode#doKnownType}
         *   Parameter: {@link LLVMInteropAccessNode} access</pre>
         */
        @Child LLVMInteropAccessNode access_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropWriteNode#doKnownType}
         *   Parameter: {@link WriteLocationNode} write</pre>
         */
        @Child WriteLocationNode write_;

        KnownTypeData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMInteropWriteNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropWriteNode {

        @TruffleBoundary
        @Override
        public void execute(Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVMType arg4Value) {
            if ((arg0Value != null)) {
                doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (LLVMInteropAccessNodeGen.getUncached()), (WriteLocationNodeGen.getUncached()));
                return;
            }
            if ((arg0Value == null)) {
                doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (WriteLocationNodeGen.getUncached()));
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link WriteLocationNode#writeMember}
     *     Activation probability: 0.23929
     *     With/without class size: 11/12 bytes
     *   Specialization {@link WriteLocationNode#writeMember}
     *     Activation probability: 0.20714
     *     With/without class size: 8/8 bytes
     *   Specialization {@link WriteLocationNode#writeArrayElementTypeMatch}
     *     Activation probability: 0.17500
     *     With/without class size: 9/12 bytes
     *   Specialization {@link WriteLocationNode#writeArrayElementTypeMatch}
     *     Activation probability: 0.14286
     *     With/without class size: 7/8 bytes
     *   Specialization {@link WriteLocationNode#writeArrayElementToI8}
     *     Activation probability: 0.11071
     *     With/without class size: 7/12 bytes
     *   Specialization {@link WriteLocationNode#writeArrayElementToI8}
     *     Activation probability: 0.07857
     *     With/without class size: 5/8 bytes
     *   Specialization {@link WriteLocationNode#fallback}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(WriteLocationNode.class)
    @SuppressWarnings("javadoc")
    static final class WriteLocationNodeGen extends WriteLocationNode implements GenerateAOT.Provider {

        static final ReferenceField<WriteMember0Data> WRITE_MEMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeMember0_cache", WriteMember0Data.class);
        static final ReferenceField<WriteArrayElementTypeMatch0Data> WRITE_ARRAY_ELEMENT_TYPE_MATCH0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeArrayElementTypeMatch0_cache", WriteArrayElementTypeMatch0Data.class);
        static final ReferenceField<WriteArrayElementToI80Data> WRITE_ARRAY_ELEMENT_TO_I80_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeArrayElementToI80_cache", WriteArrayElementToI80Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link WriteLocationNode#writeMember}
         *   2: SpecializationActive {@link WriteLocationNode#writeMember}
         *   3: SpecializationActive {@link WriteLocationNode#writeArrayElementTypeMatch}
         *   4: SpecializationActive {@link WriteLocationNode#writeArrayElementTypeMatch}
         *   5: SpecializationActive {@link WriteLocationNode#writeArrayElementToI8}
         *   6: SpecializationActive {@link WriteLocationNode#writeArrayElementToI8}
         *   7: SpecializationActive {@link WriteLocationNode#fallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private WriteMember0Data writeMember0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WriteLocationNode#writeMember}
         *   Parameter: {@link ConvertOutgoingNode} convertOutgoing</pre>
         */
        @Child private ConvertOutgoingNode writeMember1_convertOutgoing_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WriteLocationNode#writeMember}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal private BranchProfile writeMember1_exception_;
        @UnsafeAccessedField @Child private WriteArrayElementTypeMatch0Data writeArrayElementTypeMatch0_cache;
        @Child private WriteArrayElementTypeMatch1Data writeArrayElementTypeMatch1_cache;
        @UnsafeAccessedField @Child private WriteArrayElementToI80Data writeArrayElementToI80_cache;
        @Child private WriteArrayElementToI81Data writeArrayElementToI81_cache;

        private WriteLocationNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value) {
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) && arg0Value instanceof String) {
                return false;
            }
            if (arg0Value instanceof Long) {
                if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) && (WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                    return false;
                }
                if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */) && (!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) && ((arg1Value.type.kind.foreignToLLVMType).isI8()) && ((arg3Value.getSizeInBytes()) > 1)) {
                    return false;
                }
            }
            return true;
        }

        @ExplodeLoop
        @Override
        void execute(Object arg0Value, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.fallback(Object, AccessLocation, Object, ForeignToLLVMType)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */ && arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) {
                        WriteMember0Data s0_ = this.writeMember0_cache;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value.base))) {
                                writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, s0_.interop_, s0_.convertOutgoing_, s0_.exception_);
                                return;
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) {
                        {
                            ConvertOutgoingNode convertOutgoing__ = this.writeMember1_convertOutgoing_;
                            if (convertOutgoing__ != null) {
                                BranchProfile exception__ = this.writeMember1_exception_;
                                if (exception__ != null) {
                                    this.writeMember1Boundary(state_0, arg0Value_, arg1Value, arg2Value, arg3Value, convertOutgoing__, exception__);
                                    return;
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1111000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] || SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) {
                        WriteArrayElementTypeMatch0Data s2_ = this.writeArrayElementTypeMatch0_cache;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value.base)) && (WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                                writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, s2_.interop_, s2_.convertOutgoing_, s2_.exception_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) {
                        WriteArrayElementTypeMatch1Data s3_ = this.writeArrayElementTypeMatch1_cache;
                        if (s3_ != null) {
                            if ((WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                                this.writeArrayElementTypeMatch1Boundary(state_0, s3_, arg0Value_, arg1Value, arg2Value, arg3Value);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */) {
                        WriteArrayElementToI80Data s4_ = this.writeArrayElementToI80_cache;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arg1Value.base)) && (!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)))) {
                                ForeignToLLVMType locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                if ((locationType__.isI8())) {
                                    int writeTypeSizeInBytes__ = (arg3Value.getSizeInBytes());
                                    if ((writeTypeSizeInBytes__ > 1)) {
                                        writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, s4_.interop_, s4_.toLong_, s4_.exception_, locationType__, writeTypeSizeInBytes__);
                                        return;
                                    }
                                }
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */) {
                        WriteArrayElementToI81Data s5_ = this.writeArrayElementToI81_cache;
                        if (s5_ != null) {
                            if ((!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)))) {
                                ForeignToLLVMType locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                if ((locationType__.isI8())) {
                                    int writeTypeSizeInBytes__ = (arg3Value.getSizeInBytes());
                                    if ((writeTypeSizeInBytes__ > 1)) {
                                        this.writeArrayElementToI81Boundary(state_0, s5_, arg0Value_, arg1Value, arg2Value, arg3Value);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.fallback(Object, AccessLocation, Object, ForeignToLLVMType)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        fallback(arg0Value, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void writeMember1Boundary(int state_0, String arg0Value_, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value, ConvertOutgoingNode convertOutgoing__, BranchProfile exception__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                    writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, interop__, convertOutgoing__, exception__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void writeArrayElementTypeMatch1Boundary(int state_0, WriteArrayElementTypeMatch1Data s3_, long arg0Value_, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                    writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, interop__1, s3_.convertOutgoing_, s3_.exception_);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void writeArrayElementToI81Boundary(int state_0, WriteArrayElementToI81Data s5_, long arg0Value_, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__2 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                    ForeignToLLVMType locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                    int writeTypeSizeInBytes__ = (arg3Value.getSizeInBytes());
                    writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, interop__2, s5_.toLong_, s5_.exception_, locationType__, writeTypeSizeInBytes__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(Object arg0Value, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) {
                    while (true) {
                        int count0_ = 0;
                        WriteMember0Data s0_ = WRITE_MEMBER0_CACHE_UPDATER.getVolatile(this);
                        WriteMember0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value.base))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.interop_.accepts(arg1Value.base));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new WriteMember0Data(s0_original));
                                InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value.base)));
                                Objects.requireNonNull(interop__, "Specialization 'writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.interop_ = interop__;
                                ConvertOutgoingNode convertOutgoing__ = s0_.insert((ConvertOutgoingNodeGen.create()));
                                Objects.requireNonNull(convertOutgoing__, "Specialization 'writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'convertOutgoing' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.convertOutgoing_ = convertOutgoing__;
                                BranchProfile exception__ = (BranchProfile.create());
                                Objects.requireNonNull(exception__, "Specialization 'writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.exception_ = exception__;
                                if (!WRITE_MEMBER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, s0_.interop_, s0_.convertOutgoing_, s0_.exception_);
                            return;
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                            ConvertOutgoingNode convertOutgoing__ = this.insert((ConvertOutgoingNodeGen.create()));
                            Objects.requireNonNull(convertOutgoing__, "Specialization 'writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'convertOutgoing' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.writeMember1_convertOutgoing_ = convertOutgoing__;
                            BranchProfile exception__ = (BranchProfile.create());
                            Objects.requireNonNull(exception__, "Specialization 'writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.writeMember1_exception_ = exception__;
                            this.writeMember0_cache = null;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeMember(String, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */;
                            this.state_0_ = state_0;
                            writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, interop__, convertOutgoing__, exception__);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */) {
                    while (true) {
                        int count2_ = 0;
                        WriteArrayElementTypeMatch0Data s2_ = WRITE_ARRAY_ELEMENT_TYPE_MATCH0_CACHE_UPDATER.getVolatile(this);
                        WriteArrayElementTypeMatch0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value.base)) && (WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            if ((WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)) && count2_ < (3)) {
                                // assert (s2_.interop_.accepts(arg1Value.base));
                                s2_ = this.insert(new WriteArrayElementTypeMatch0Data(s2_original));
                                InteropLibrary interop__1 = s2_.insert((INTEROP_LIBRARY_.create(arg1Value.base)));
                                Objects.requireNonNull(interop__1, "Specialization 'writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.interop_ = interop__1;
                                ConvertOutgoingNode convertOutgoing__1 = s2_.insert((ConvertOutgoingNodeGen.create()));
                                Objects.requireNonNull(convertOutgoing__1, "Specialization 'writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'convertOutgoing' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.convertOutgoing_ = convertOutgoing__1;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "Specialization 'writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.exception_ = exception__1;
                                if (!WRITE_ARRAY_ELEMENT_TYPE_MATCH0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, s2_.interop_, s2_.convertOutgoing_, s2_.exception_);
                            return;
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                                WriteArrayElementTypeMatch1Data s3_ = this.insert(new WriteArrayElementTypeMatch1Data());
                                interop__1 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                                ConvertOutgoingNode convertOutgoing__1 = s3_.insert((ConvertOutgoingNodeGen.create()));
                                Objects.requireNonNull(convertOutgoing__1, "Specialization 'writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'convertOutgoing' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s3_.convertOutgoing_ = convertOutgoing__1;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "Specialization 'writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s3_.exception_ = exception__1;
                                VarHandle.storeStoreFence();
                                this.writeArrayElementTypeMatch1_cache = s3_;
                                this.writeArrayElementTypeMatch0_cache = null;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementTypeMatch(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ConvertOutgoingNode, BranchProfile)] */;
                                this.state_0_ = state_0;
                                writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, interop__1, convertOutgoing__1, exception__1);
                                return;
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                {
                    int writeTypeSizeInBytes__ = 0;
                    ForeignToLLVMType locationType__ = null;
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */) {
                        while (true) {
                            int count4_ = 0;
                            WriteArrayElementToI80Data s4_ = WRITE_ARRAY_ELEMENT_TO_I80_CACHE_UPDATER.getVolatile(this);
                            WriteArrayElementToI80Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(arg1Value.base)) && (!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)))) {
                                    locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                    if ((locationType__.isI8())) {
                                        writeTypeSizeInBytes__ = (arg3Value.getSizeInBytes());
                                        if ((writeTypeSizeInBytes__ > 1)) {
                                            break;
                                        }
                                    }
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)))) {
                                    // assert (s4_.interop_.accepts(arg1Value.base));
                                    locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                    if ((locationType__.isI8())) {
                                        writeTypeSizeInBytes__ = (arg3Value.getSizeInBytes());
                                        if ((writeTypeSizeInBytes__ > 1) && count4_ < (3)) {
                                            s4_ = this.insert(new WriteArrayElementToI80Data(s4_original));
                                            InteropLibrary interop__2 = s4_.insert((INTEROP_LIBRARY_.create(arg1Value.base)));
                                            Objects.requireNonNull(interop__2, "Specialization 'writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                            s4_.interop_ = interop__2;
                                            ReinterpretLLVMAsLong toLong__ = s4_.insert((ReinterpretLLVMAsLongNodeGen.create()));
                                            Objects.requireNonNull(toLong__, "Specialization 'writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)' cache 'toLong' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                            s4_.toLong_ = toLong__;
                                            BranchProfile exception__2 = (BranchProfile.create());
                                            Objects.requireNonNull(exception__2, "Specialization 'writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                            s4_.exception_ = exception__2;
                                            if (!WRITE_ARRAY_ELEMENT_TO_I80_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                            if (s4_ != null) {
                                writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, s4_.interop_, s4_.toLong_, s4_.exception_, locationType__, writeTypeSizeInBytes__);
                                return;
                            }
                            break;
                        }
                    }
                }
                {
                    int writeTypeSizeInBytes__ = 0;
                    ForeignToLLVMType locationType__ = null;
                    InteropLibrary interop__2 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)))) {
                                locationType__ = (arg1Value.type.kind.foreignToLLVMType);
                                if ((locationType__.isI8())) {
                                    writeTypeSizeInBytes__ = (arg3Value.getSizeInBytes());
                                    if ((writeTypeSizeInBytes__ > 1)) {
                                        WriteArrayElementToI81Data s5_ = this.insert(new WriteArrayElementToI81Data());
                                        interop__2 = (INTEROP_LIBRARY_.getUncached(arg1Value.base));
                                        ReinterpretLLVMAsLong toLong__ = s5_.insert((ReinterpretLLVMAsLongNodeGen.create()));
                                        Objects.requireNonNull(toLong__, "Specialization 'writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)' cache 'toLong' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s5_.toLong_ = toLong__;
                                        BranchProfile exception__2 = (BranchProfile.create());
                                        Objects.requireNonNull(exception__2, "Specialization 'writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s5_.exception_ = exception__2;
                                        VarHandle.storeStoreFence();
                                        this.writeArrayElementToI81_cache = s5_;
                                        this.writeArrayElementToI80_cache = null;
                                        state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */;
                                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.writeArrayElementToI8(long, AccessLocation, Object, ForeignToLLVMType, InteropLibrary, ReinterpretLLVMAsLong, BranchProfile, ForeignToLLVMType, int)] */;
                                        this.state_0_ = state_0;
                                        writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, interop__2, toLong__, exception__2, locationType__, writeTypeSizeInBytes__);
                                        return;
                                    }
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.fallback(Object, AccessLocation, Object, ForeignToLLVMType)] */;
            this.state_0_ = state_0;
            fallback(arg0Value, arg1Value, arg2Value, arg3Value);
            return;
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11111110) & ((state_0 & 0b11111110) - 1)) == 0 /* is-single  */) {
                    WriteMember0Data s0_ = this.writeMember0_cache;
                    WriteArrayElementTypeMatch0Data s2_ = this.writeArrayElementTypeMatch0_cache;
                    WriteArrayElementToI80Data s4_ = this.writeArrayElementToI80_cache;
                    if ((s0_ == null || s0_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMInteropWriteNode.WriteLocationNode.fallback(Object, AccessLocation, Object, ForeignToLLVMType)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static WriteLocationNode create() {
            return new WriteLocationNodeGen();
        }

        @NeverDefault
        public static WriteLocationNode getUncached() {
            return WriteLocationNodeGen.UNCACHED;
        }

        @GeneratedBy(WriteLocationNode.class)
        @DenyReplace
        private static final class WriteMember0Data extends Node implements SpecializationDataNode {

            @Child WriteMember0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeMember}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeMember}
             *   Parameter: {@link ConvertOutgoingNode} convertOutgoing</pre>
             */
            @Child ConvertOutgoingNode convertOutgoing_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeMember}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            WriteMember0Data(WriteMember0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(WriteLocationNode.class)
        @DenyReplace
        private static final class WriteArrayElementTypeMatch0Data extends Node implements SpecializationDataNode {

            @Child WriteArrayElementTypeMatch0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementTypeMatch}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementTypeMatch}
             *   Parameter: {@link ConvertOutgoingNode} convertOutgoing</pre>
             */
            @Child ConvertOutgoingNode convertOutgoing_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementTypeMatch}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            WriteArrayElementTypeMatch0Data(WriteArrayElementTypeMatch0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(WriteLocationNode.class)
        @DenyReplace
        private static final class WriteArrayElementTypeMatch1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementTypeMatch}
             *   Parameter: {@link ConvertOutgoingNode} convertOutgoing</pre>
             */
            @Child ConvertOutgoingNode convertOutgoing_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementTypeMatch}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            WriteArrayElementTypeMatch1Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(WriteLocationNode.class)
        @DenyReplace
        private static final class WriteArrayElementToI80Data extends Node implements SpecializationDataNode {

            @Child WriteArrayElementToI80Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementToI8}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementToI8}
             *   Parameter: {@link ReinterpretLLVMAsLong} toLong</pre>
             */
            @Child ReinterpretLLVMAsLong toLong_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementToI8}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            WriteArrayElementToI80Data(WriteArrayElementToI80Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(WriteLocationNode.class)
        @DenyReplace
        private static final class WriteArrayElementToI81Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementToI8}
             *   Parameter: {@link ReinterpretLLVMAsLong} toLong</pre>
             */
            @Child ReinterpretLLVMAsLong toLong_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteLocationNode#writeArrayElementToI8}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal BranchProfile exception_;

            WriteArrayElementToI81Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(WriteLocationNode.class)
        @DenyReplace
        private static final class Uncached extends WriteLocationNode {

            @TruffleBoundary
            @Override
            void execute(Object arg0Value, AccessLocation arg1Value, Object arg2Value, ForeignToLLVMType arg3Value) {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, (INTEROP_LIBRARY_.getUncached(arg1Value.base)), (ConvertOutgoingNodeGen.getUncached()), (BranchProfile.getUncached()));
                    return;
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if ((WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                        writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, (INTEROP_LIBRARY_.getUncached(arg1Value.base)), (ConvertOutgoingNodeGen.getUncached()), (BranchProfile.getUncached()));
                        return;
                    }
                    if ((!(WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) && ((arg1Value.type.kind.foreignToLLVMType).isI8()) && ((arg3Value.getSizeInBytes()) > 1)) {
                        writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, (INTEROP_LIBRARY_.getUncached(arg1Value.base)), (ReinterpretLLVMAsLongNodeGen.getUncached()), (BranchProfile.getUncached()), (arg1Value.type.kind.foreignToLLVMType), (arg3Value.getSizeInBytes()));
                        return;
                    }
                }
                fallback(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReinterpretLLVMAsLong#doI16}
     *     Activation probability: 0.38500
     *     With/without class size: 11/4 bytes
     *   Specialization {@link ReinterpretLLVMAsLong#doI32}
     *     Activation probability: 0.29500
     *     With/without class size: 9/4 bytes
     *   Specialization {@link ReinterpretLLVMAsLong#doI64}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link ReinterpretLLVMAsLong#fallback}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(ReinterpretLLVMAsLong.class)
    @SuppressWarnings("javadoc")
    static final class ReinterpretLLVMAsLongNodeGen extends ReinterpretLLVMAsLong implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReinterpretLLVMAsLong#doI16}
         *   2: SpecializationActive {@link ReinterpretLLVMAsLong#doI32}
         *   3: SpecializationActive {@link ReinterpretLLVMAsLong#doI64}
         *   4: SpecializationActive {@link ReinterpretLLVMAsLong#fallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ReinterpretLLVMAsLong#doI16}
         *   Parameter: {@link LLVMI16DataEscapeNode} dataEscape</pre>
         */
        @Child private LLVMI16DataEscapeNode i16_dataEscape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ReinterpretLLVMAsLong#doI32}
         *   Parameter: {@link LLVMI32DataEscapeNode} dataEscape</pre>
         */
        @Child private LLVMI32DataEscapeNode i32_dataEscape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ReinterpretLLVMAsLong#doI64}
         *   Parameter: {@link LLVMI64DataEscapeNode} dataEscape</pre>
         */
        @Child private LLVMI64DataEscapeNode i64_dataEscape_;

        private ReinterpretLLVMAsLongNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value, ForeignToLLVMType arg1Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)] */) && (arg1Value.getSizeInBytes() == 2)) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)] */) && (arg1Value.getSizeInBytes() == 4)) {
                return false;
            }
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)] */) && (arg1Value.getSizeInBytes() == 8)) {
                return false;
            }
            return true;
        }

        @Override
        long executeWithWriteType(Object arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)] || SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)] || SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)] || SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.fallback(Object, ForeignToLLVMType)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)] */) {
                    {
                        LLVMI16DataEscapeNode dataEscape__ = this.i16_dataEscape_;
                        if (dataEscape__ != null) {
                            if ((arg1Value.getSizeInBytes() == 2)) {
                                return doI16(arg0Value, arg1Value, dataEscape__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)] */) {
                    {
                        LLVMI32DataEscapeNode dataEscape__1 = this.i32_dataEscape_;
                        if (dataEscape__1 != null) {
                            if ((arg1Value.getSizeInBytes() == 4)) {
                                return doI32(arg0Value, arg1Value, dataEscape__1);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)] */) {
                    {
                        LLVMI64DataEscapeNode dataEscape__2 = this.i64_dataEscape_;
                        if (dataEscape__2 != null) {
                            if ((arg1Value.getSizeInBytes() == 8)) {
                                return doI64(arg0Value, arg1Value, dataEscape__2);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.fallback(Object, ForeignToLLVMType)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return fallback(arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(Object arg0Value, ForeignToLLVMType arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((arg1Value.getSizeInBytes() == 2)) {
                LLVMI16DataEscapeNode dataEscape__ = this.insert((LLVMI16DataEscapeNodeGen.create()));
                Objects.requireNonNull(dataEscape__, "Specialization 'doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i16_dataEscape_ = dataEscape__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)] */;
                this.state_0_ = state_0;
                return doI16(arg0Value, arg1Value, dataEscape__);
            }
            if ((arg1Value.getSizeInBytes() == 4)) {
                LLVMI32DataEscapeNode dataEscape__1 = this.insert((LLVMI32DataEscapeNodeGen.create()));
                Objects.requireNonNull(dataEscape__1, "Specialization 'doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i32_dataEscape_ = dataEscape__1;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)] */;
                this.state_0_ = state_0;
                return doI32(arg0Value, arg1Value, dataEscape__1);
            }
            if ((arg1Value.getSizeInBytes() == 8)) {
                LLVMI64DataEscapeNode dataEscape__2 = this.insert((LLVMI64DataEscapeNodeGen.create()));
                Objects.requireNonNull(dataEscape__2, "Specialization 'doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i64_dataEscape_ = dataEscape__2;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)] */;
                this.state_0_ = state_0;
                return doI64(arg0Value, arg1Value, dataEscape__2);
            }
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.fallback(Object, ForeignToLLVMType)] */;
            this.state_0_ = state_0;
            return fallback(arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                LLVMI16DataEscapeNode dataEscape__ = this.insert((LLVMI16DataEscapeNodeGen.create()));
                Objects.requireNonNull(dataEscape__, "Specialization 'doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i16_dataEscape_ = dataEscape__;
                assert NodeUtil.assertRecursion(this.i16_dataEscape_, 1);
                ((GenerateAOT.Provider) this.i16_dataEscape_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI16(Object, ForeignToLLVMType, LLVMI16DataEscapeNode)] */;
            }
            {
                LLVMI32DataEscapeNode dataEscape__1 = this.insert((LLVMI32DataEscapeNodeGen.create()));
                Objects.requireNonNull(dataEscape__1, "Specialization 'doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i32_dataEscape_ = dataEscape__1;
                assert NodeUtil.assertRecursion(this.i32_dataEscape_, 1);
                ((GenerateAOT.Provider) this.i32_dataEscape_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI32(Object, ForeignToLLVMType, LLVMI32DataEscapeNode)] */;
            }
            {
                LLVMI64DataEscapeNode dataEscape__2 = this.insert((LLVMI64DataEscapeNodeGen.create()));
                Objects.requireNonNull(dataEscape__2, "Specialization 'doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)' cache 'dataEscape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.i64_dataEscape_ = dataEscape__2;
                assert NodeUtil.assertRecursion(this.i64_dataEscape_, 1);
                ((GenerateAOT.Provider) this.i64_dataEscape_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.doI64(Object, ForeignToLLVMType, LLVMI64DataEscapeNode)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMInteropWriteNode.ReinterpretLLVMAsLong.fallback(Object, ForeignToLLVMType)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i16_dataEscape_ = null;
            this.i32_dataEscape_ = null;
            this.i64_dataEscape_ = null;
        }

        @NeverDefault
        public static ReinterpretLLVMAsLong create() {
            return new ReinterpretLLVMAsLongNodeGen();
        }

        @NeverDefault
        public static ReinterpretLLVMAsLong getUncached() {
            return ReinterpretLLVMAsLongNodeGen.UNCACHED;
        }

        @GeneratedBy(ReinterpretLLVMAsLong.class)
        @DenyReplace
        private static final class Uncached extends ReinterpretLLVMAsLong {

            @TruffleBoundary
            @Override
            long executeWithWriteType(Object arg0Value, ForeignToLLVMType arg1Value) {
                if ((arg1Value.getSizeInBytes() == 2)) {
                    return doI16(arg0Value, arg1Value, (LLVMI16DataEscapeNodeGen.getUncached()));
                }
                if ((arg1Value.getSizeInBytes() == 4)) {
                    return doI32(arg0Value, arg1Value, (LLVMI32DataEscapeNodeGen.getUncached()));
                }
                if ((arg1Value.getSizeInBytes() == 8)) {
                    return doI64(arg0Value, arg1Value, (LLVMI64DataEscapeNodeGen.getUncached()));
                }
                return fallback(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ConvertOutgoingNode#doKnownType}
     *     Activation probability: 0.65000
     *     With/without class size: 22/8 bytes
     *   Specialization {@link ConvertOutgoingNode#doUnknownType}
     *     Activation probability: 0.35000
     *     With/without class size: 13/8 bytes
     * </pre>
     */
    @GeneratedBy(ConvertOutgoingNode.class)
    @SuppressWarnings("javadoc")
    static final class ConvertOutgoingNodeGen extends ConvertOutgoingNode implements GenerateAOT.Provider {

        static final ReferenceField<KnownTypeData> KNOWN_TYPE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "knownType_cache", KnownTypeData.class);
        static final ReferenceField<UnknownTypeData> UNKNOWN_TYPE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "unknownType_cache", UnknownTypeData.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ConvertOutgoingNode#doKnownType}
         *   2: SpecializationActive {@link ConvertOutgoingNode#doUnknownType}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private KnownTypeData knownType_cache;
        @UnsafeAccessedField @Child private UnknownTypeData unknownType_cache;

        private ConvertOutgoingNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(Object arg0Value, Value arg1Value, ForeignToLLVMType arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(Object, Value, ForeignToLLVMType, ForeignToLLVMType, LLVMDataEscapeNode)] || SpecializationActive[LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(Object, Value, ForeignToLLVMType, ForeignToLLVMType, LLVMDataEscapeNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(Object, Value, ForeignToLLVMType, ForeignToLLVMType, LLVMDataEscapeNode)] */ && (arg1Value != null)) {
                    KnownTypeData s0_ = this.knownType_cache;
                    while (s0_ != null) {
                        if ((decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2) == arg1Value.kind.foreignToLLVMType) && (arg2Value.getSizeInBytes() == decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2).getSizeInBytes())) {
                            return doKnownType(arg0Value, arg1Value, arg2Value, decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2), s0_.dataEscape_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(Object, Value, ForeignToLLVMType, ForeignToLLVMType, LLVMDataEscapeNode)] */) {
                    UnknownTypeData s1_ = this.unknownType_cache;
                    while (s1_ != null) {
                        if ((ConvertOutgoingNode.typeMismatch(arg1Value, decodeForeignToLLVMType((s1_.unknownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */) - 2))) && (decodeForeignToLLVMType((s1_.unknownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */) - 2) == arg2Value)) {
                            return doUnknownType(arg0Value, arg1Value, arg2Value, decodeForeignToLLVMType((s1_.unknownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */) - 2), s1_.dataEscape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Value arg1Value, ForeignToLLVMType arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((arg1Value != null)) {
                while (true) {
                    int count0_ = 0;
                    KnownTypeData s0_ = KNOWN_TYPE_CACHE_UPDATER.getVolatile(this);
                    KnownTypeData s0_original = s0_;
                    while (s0_ != null) {
                        if ((decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2) == arg1Value.kind.foreignToLLVMType) && (arg2Value.getSizeInBytes() == decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2).getSizeInBytes())) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        {
                            ForeignToLLVMType cachedOutgoingType__ = (arg1Value.kind.foreignToLLVMType);
                            // assert (decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2) == arg1Value.kind.foreignToLLVMType);
                            if ((arg2Value.getSizeInBytes() == cachedOutgoingType__.getSizeInBytes()) && count0_ < (3)) {
                                s0_ = this.insert(new KnownTypeData(s0_original));
                                s0_.knownType_state_0_ = (s0_.knownType_state_0_ | ((encodeForeignToLLVMType(cachedOutgoingType__) + 2) << 0) /* set-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */);
                                s0_.dataEscape_ = s0_.insert((LLVMDataEscapeNode.create(cachedOutgoingType__)));
                                if (!KNOWN_TYPE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(Object, Value, ForeignToLLVMType, ForeignToLLVMType, LLVMDataEscapeNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s0_ != null) {
                        return doKnownType(arg0Value, arg1Value, arg2Value, decodeForeignToLLVMType((s0_.knownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)] */) - 2), s0_.dataEscape_);
                    }
                    break;
                }
            }
            while (true) {
                int count1_ = 0;
                UnknownTypeData s1_ = UNKNOWN_TYPE_CACHE_UPDATER.getVolatile(this);
                UnknownTypeData s1_original = s1_;
                while (s1_ != null) {
                    if ((ConvertOutgoingNode.typeMismatch(arg1Value, decodeForeignToLLVMType((s1_.unknownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */) - 2))) && (decodeForeignToLLVMType((s1_.unknownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */) - 2) == arg2Value)) {
                        break;
                    }
                    count1_++;
                    s1_ = s1_.next_;
                }
                if (s1_ == null) {
                    {
                        ForeignToLLVMType cachedType__ = (arg2Value);
                        if ((ConvertOutgoingNode.typeMismatch(arg1Value, cachedType__))) {
                            // assert (cachedType__ == arg2Value);
                            if (count1_ < (3)) {
                                s1_ = this.insert(new UnknownTypeData(s1_original));
                                s1_.unknownType_state_0_ = (s1_.unknownType_state_0_ | ((encodeForeignToLLVMType(cachedType__) + 2) << 0) /* set-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */);
                                s1_.dataEscape_ = s1_.insert((LLVMDataEscapeNode.create(arg2Value)));
                                if (!UNKNOWN_TYPE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(Object, Value, ForeignToLLVMType, ForeignToLLVMType, LLVMDataEscapeNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s1_ != null) {
                    return doUnknownType(arg0Value, arg1Value, arg2Value, decodeForeignToLLVMType((s1_.unknownType_state_0_ >>> 0 /* get-int EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)] */) - 2), s1_.dataEscape_);
                }
                break;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    KnownTypeData s0_ = this.knownType_cache;
                    UnknownTypeData s1_ = this.unknownType_cache;
                    if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ConvertOutgoingNode create() {
            return new ConvertOutgoingNodeGen();
        }

        @NeverDefault
        public static ConvertOutgoingNode getUncached() {
            return ConvertOutgoingNodeGen.UNCACHED;
        }

        @GeneratedBy(ConvertOutgoingNode.class)
        @DenyReplace
        private static final class KnownTypeData extends Node implements SpecializationDataNode {

            @Child KnownTypeData next_;
            /**
             * State Info: <pre>
             *   0-4: EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doKnownType(..., ForeignToLLVMType cachedOutgoingType, ...)]
             * </pre>
             */
            @CompilationFinal private int knownType_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConvertOutgoingNode#doKnownType}
             *   Parameter: {@link LLVMDataEscapeNode} dataEscape</pre>
             */
            @Child LLVMDataEscapeNode dataEscape_;

            KnownTypeData(KnownTypeData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ConvertOutgoingNode.class)
        @DenyReplace
        private static final class UnknownTypeData extends Node implements SpecializationDataNode {

            @Child UnknownTypeData next_;
            /**
             * State Info: <pre>
             *   0-4: EncodedEnum[cache=LLVMInteropWriteNode.ConvertOutgoingNode.doUnknownType(..., ForeignToLLVMType cachedType, ...)]
             * </pre>
             */
            @CompilationFinal private int unknownType_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConvertOutgoingNode#doUnknownType}
             *   Parameter: {@link LLVMDataEscapeNode} dataEscape</pre>
             */
            @Child LLVMDataEscapeNode dataEscape_;

            UnknownTypeData(UnknownTypeData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ConvertOutgoingNode.class)
        @DenyReplace
        private static final class Uncached extends ConvertOutgoingNode {

            @TruffleBoundary
            @Override
            Object execute(Object arg0Value, Value arg1Value, ForeignToLLVMType arg2Value) {
                if ((arg1Value != null)) {
                    // assert ((arg1Value.kind.foreignToLLVMType) == arg1Value.kind.foreignToLLVMType);
                    if ((arg2Value.getSizeInBytes() == (arg1Value.kind.foreignToLLVMType).getSizeInBytes())) {
                        return doKnownType(arg0Value, arg1Value, arg2Value, (arg1Value.kind.foreignToLLVMType), (LLVMDataEscapeNode.getUncached((arg1Value.kind.foreignToLLVMType))));
                    }
                }
                if ((ConvertOutgoingNode.typeMismatch(arg1Value, (arg2Value)))) {
                    // assert ((arg2Value) == arg2Value);
                    return doUnknownType(arg0Value, arg1Value, arg2Value, (arg2Value), (LLVMDataEscapeNode.getUncached(arg2Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
