// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNodeFactory.GetForeignTypeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNodeFactory.ResolveNativePointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Buffer;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadDoubleNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadFloatNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI16Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI32Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI64Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI8Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadPointerNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDouble;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMReadFromForeignObjectNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMReadFromForeignObjectNodeFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadI8Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadI8Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadI8Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadI8Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadI8Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadI8Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadI8Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadI8NodeGen extends ForeignReadI8Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadI8Node#doNative}
         *   2: SpecializationActive {@link ForeignReadI8Node#doBuffer}
         *   3: SpecializationActive {@link ForeignReadI8Node#doBuffer}
         *   4: SpecializationActive {@link ForeignReadI8Node#doStructured}
         *   5: SpecializationActive {@link ForeignReadI8Node#doFallback}
         *   6: SpecializationActive {@link ForeignReadI8Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI8Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI8Node#doFallback}
         *   Parameter: {@link ToI8} toLLVM</pre>
         */
        @Child private ToI8 fallback1_toLLVM_;

        private ForeignReadI8NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public byte execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */) {
                            {
                                ToI8 toLLVM__ = this.fallback1_toLLVM_;
                                if (toLLVM__ != null) {
                                    if ((typeValue_ == null)) {
                                        return this.fallback1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue_, toLLVM__);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private byte buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private byte fallback1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_, ToI8 toLLVM__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, toLLVM__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private byte executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                ToI8 toLLVM__ = s4_.insert((ToI8NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.toLLVM_ = toLLVM__;
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                ToI8 toLLVM__ = this.insert((ToI8NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.fallback1_toLLVM_ = toLLVM__;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI8)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, toLLVM__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doNative(Object, long, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopRead_, 1);
                ((GenerateAOT.Provider) s3_.interopRead_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI8Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignReadI8Node create() {
            return new ForeignReadI8NodeGen();
        }

        @NeverDefault
        public static ForeignReadI8Node getUncached() {
            return ForeignReadI8NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadI8Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI8Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI8Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI8Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI8Node#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI8Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI8Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI8Node#doFallback}
             *   Parameter: {@link ToI8} toLLVM</pre>
             */
            @Child ToI8 toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI8Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadI8Node {

            @TruffleBoundary
            @Override
            public byte execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToI8NodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadI16Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadI16Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadI16Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadI16Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadI16Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadI16Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadI16Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadI16NodeGen extends ForeignReadI16Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadI16Node#doNative}
         *   2: SpecializationActive {@link ForeignReadI16Node#doBuffer}
         *   3: SpecializationActive {@link ForeignReadI16Node#doBuffer}
         *   4: SpecializationActive {@link ForeignReadI16Node#doStructured}
         *   5: SpecializationActive {@link ForeignReadI16Node#doFallback}
         *   6: SpecializationActive {@link ForeignReadI16Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI16Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI16Node#doFallback}
         *   Parameter: {@link ToI16} toLLVM</pre>
         */
        @Child private ToI16 fallback1_toLLVM_;

        private ForeignReadI16NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public short execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */) {
                            {
                                ToI16 toLLVM__ = this.fallback1_toLLVM_;
                                if (toLLVM__ != null) {
                                    if ((typeValue_ == null)) {
                                        return this.fallback1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue_, toLLVM__);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private short buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private short fallback1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_, ToI16 toLLVM__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, toLLVM__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private short executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                ToI16 toLLVM__ = s4_.insert((ToI16NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.toLLVM_ = toLLVM__;
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                ToI16 toLLVM__ = this.insert((ToI16NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.fallback1_toLLVM_ = toLLVM__;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI16)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, toLLVM__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI16Node.doNative(Object, long, LLVMNativePointer, Object)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ForeignReadI16Node create() {
            return new ForeignReadI16NodeGen();
        }

        @NeverDefault
        public static ForeignReadI16Node getUncached() {
            return ForeignReadI16NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadI16Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI16Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI16Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI16Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI16Node#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI16Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI16Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI16Node#doFallback}
             *   Parameter: {@link ToI16} toLLVM</pre>
             */
            @Child ToI16 toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI16Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadI16Node {

            @TruffleBoundary
            @Override
            public short execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToI16NodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadI32Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadI32Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadI32Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadI32Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadI32Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadI32Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadI32Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadI32NodeGen extends ForeignReadI32Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadI32Node#doNative}
         *   2: SpecializationActive {@link ForeignReadI32Node#doBuffer}
         *   3: SpecializationActive {@link ForeignReadI32Node#doBuffer}
         *   4: SpecializationActive {@link ForeignReadI32Node#doStructured}
         *   5: SpecializationActive {@link ForeignReadI32Node#doFallback}
         *   6: SpecializationActive {@link ForeignReadI32Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI32Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI32Node#doFallback}
         *   Parameter: {@link ToI32} toLLVM</pre>
         */
        @Child private ToI32 fallback1_toLLVM_;

        private ForeignReadI32NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public int execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */) {
                            {
                                ToI32 toLLVM__ = this.fallback1_toLLVM_;
                                if (toLLVM__ != null) {
                                    if ((typeValue_ == null)) {
                                        return this.fallback1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue_, toLLVM__);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private int buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private int fallback1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_, ToI32 toLLVM__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, toLLVM__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private int executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                ToI32 toLLVM__ = s4_.insert((ToI32NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.toLLVM_ = toLLVM__;
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                ToI32 toLLVM__ = this.insert((ToI32NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.fallback1_toLLVM_ = toLLVM__;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI32)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, toLLVM__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doNative(Object, long, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopRead_, 1);
                ((GenerateAOT.Provider) s3_.interopRead_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI32Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignReadI32Node create() {
            return new ForeignReadI32NodeGen();
        }

        @NeverDefault
        public static ForeignReadI32Node getUncached() {
            return ForeignReadI32NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadI32Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI32Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI32Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI32Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI32Node#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI32Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI32Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI32Node#doFallback}
             *   Parameter: {@link ToI32} toLLVM</pre>
             */
            @Child ToI32 toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI32Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadI32Node {

            @TruffleBoundary
            @Override
            public int execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToI32NodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadFloatNode#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadFloatNode#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadFloatNode#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadFloatNode#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadFloatNode#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadFloatNode#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadFloatNodeGen extends ForeignReadFloatNode implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadFloatNode#doNative}
         *   2: SpecializationActive {@link ForeignReadFloatNode#doBuffer}
         *   3: SpecializationActive {@link ForeignReadFloatNode#doBuffer}
         *   4: SpecializationActive {@link ForeignReadFloatNode#doStructured}
         *   5: SpecializationActive {@link ForeignReadFloatNode#doFallback}
         *   6: SpecializationActive {@link ForeignReadFloatNode#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadFloatNode#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadFloatNode#doFallback}
         *   Parameter: {@link ToFloat} toLLVM</pre>
         */
        @Child private ToFloat fallback1_toLLVM_;

        private ForeignReadFloatNodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public float execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */) {
                            {
                                ToFloat toLLVM__ = this.fallback1_toLLVM_;
                                if (toLLVM__ != null) {
                                    if ((typeValue_ == null)) {
                                        return this.fallback1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue_, toLLVM__);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private float buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private float fallback1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_, ToFloat toLLVM__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, toLLVM__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private float executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                ToFloat toLLVM__ = s4_.insert((ToFloatNodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.toLLVM_ = toLLVM__;
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                ToFloat toLLVM__ = this.insert((ToFloatNodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.fallback1_toLLVM_ = toLLVM__;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToFloat)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, toLLVM__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doNative(Object, long, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopRead_, 1);
                ((GenerateAOT.Provider) s3_.interopRead_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadFloatNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignReadFloatNode create() {
            return new ForeignReadFloatNodeGen();
        }

        @NeverDefault
        public static ForeignReadFloatNode getUncached() {
            return ForeignReadFloatNodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadFloatNode.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadFloatNode#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadFloatNode#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadFloatNode.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadFloatNode#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadFloatNode.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadFloatNode#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadFloatNode#doFallback}
             *   Parameter: {@link ToFloat} toLLVM</pre>
             */
            @Child ToFloat toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadFloatNode.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadFloatNode {

            @TruffleBoundary
            @Override
            public float execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToFloatNodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadDoubleNode#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadDoubleNode#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadDoubleNode#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadDoubleNode#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadDoubleNode#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadDoubleNode#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadDoubleNode.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadDoubleNodeGen extends ForeignReadDoubleNode implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadDoubleNode#doNative}
         *   2: SpecializationActive {@link ForeignReadDoubleNode#doBuffer}
         *   3: SpecializationActive {@link ForeignReadDoubleNode#doBuffer}
         *   4: SpecializationActive {@link ForeignReadDoubleNode#doStructured}
         *   5: SpecializationActive {@link ForeignReadDoubleNode#doFallback}
         *   6: SpecializationActive {@link ForeignReadDoubleNode#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadDoubleNode#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadDoubleNode#doFallback}
         *   Parameter: {@link ToDouble} toLLVM</pre>
         */
        @Child private ToDouble fallback1_toLLVM_;

        private ForeignReadDoubleNodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public double execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */) {
                            {
                                ToDouble toLLVM__ = this.fallback1_toLLVM_;
                                if (toLLVM__ != null) {
                                    if ((typeValue_ == null)) {
                                        return this.fallback1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue_, toLLVM__);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private double buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private double fallback1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_, ToDouble toLLVM__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, toLLVM__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private double executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                ToDouble toLLVM__ = s4_.insert((ToDoubleNodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.toLLVM_ = toLLVM__;
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                ToDouble toLLVM__ = this.insert((ToDoubleNodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.fallback1_toLLVM_ = toLLVM__;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToDouble)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, toLLVM__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doNative(Object, long, LLVMNativePointer, Object)] */;
            }
            {
                StructuredData s3_ = this.insert(new StructuredData());
                s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                VarHandle.storeStoreFence();
                this.structured_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.interopRead_, 1);
                ((GenerateAOT.Provider) s3_.interopRead_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadDoubleNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.structured_cache = null;
        }

        @NeverDefault
        public static ForeignReadDoubleNode create() {
            return new ForeignReadDoubleNodeGen();
        }

        @NeverDefault
        public static ForeignReadDoubleNode getUncached() {
            return ForeignReadDoubleNodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadDoubleNode.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadDoubleNode#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadDoubleNode#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadDoubleNode.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadDoubleNode#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadDoubleNode.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadDoubleNode#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadDoubleNode#doFallback}
             *   Parameter: {@link ToDouble} toLLVM</pre>
             */
            @Child ToDouble toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadDoubleNode.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadDoubleNode {

            @TruffleBoundary
            @Override
            public double execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToDoubleNodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadI64Node#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadI64Node#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadI64Node#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadI64Node#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadI64Node#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadI64Node#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadI64Node.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadI64NodeGen extends ForeignReadI64Node implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadI64Node#doNative}
         *   2: SpecializationActive {@link ForeignReadI64Node#doBuffer}
         *   3: SpecializationActive {@link ForeignReadI64Node#doBuffer}
         *   4: SpecializationActive {@link ForeignReadI64Node#doStructured}
         *   5: SpecializationActive {@link ForeignReadI64Node#doFallback}
         *   6: SpecializationActive {@link ForeignReadI64Node#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI64Node#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadI64Node#doFallback}
         *   Parameter: {@link ToI64} toLLVM</pre>
         */
        @Child private ToI64 fallback1_toLLVM_;

        private ForeignReadI64NodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public Object execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */) {
                            {
                                ToI64 toLLVM__ = this.fallback1_toLLVM_;
                                if (toLLVM__ != null) {
                                    if ((typeValue_ == null)) {
                                        return this.fallback1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue_, toLLVM__);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object fallback1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_, ToI64 toLLVM__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, toLLVM__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public long executeLong(Object foreignValue, long offsetValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */) {
                return LLVMTypesGen.expectLong(execute(foreignValue, offsetValue));
            }
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_));
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if (typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary0(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_));
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private long buffer1Boundary0(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) throws UnexpectedResultException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                ToI64 toLLVM__ = s4_.insert((ToI64NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.toLLVM_ = toLLVM__;
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                ToI64 toLLVM__ = this.insert((ToI64NodeGen.create()));
                                Objects.requireNonNull(toLLVM__, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)' cache 'toLLVM' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.fallback1_toLLVM_ = toLLVM__;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadI64Node.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToI64)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, toLLVM__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ForeignReadI64Node create() {
            return new ForeignReadI64NodeGen();
        }

        @NeverDefault
        public static ForeignReadI64Node getUncached() {
            return ForeignReadI64NodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadI64Node.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI64Node#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI64Node#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI64Node.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI64Node#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI64Node.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI64Node#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadI64Node#doFallback}
             *   Parameter: {@link ToI64} toLLVM</pre>
             */
            @Child ToI64 toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadI64Node.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadI64Node {

            @TruffleBoundary
            @Override
            public Object execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToI64NodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @TruffleBoundary
            @Override
            public long executeLong(Object foreignValue, long offsetValue) throws UnexpectedResultException {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return LLVMTypesGen.expectLong(doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached())));
                    }
                    if ((typeValue == null)) {
                        return LLVMTypesGen.expectLong(doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToI64NodeGen.getUncached())));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadPointerNode#doNative}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ForeignReadPointerNode#doBuffer}
     *     Activation probability: 0.23095
     *     With/without class size: 10/8 bytes
     *   Specialization {@link ForeignReadPointerNode#doBuffer}
     *     Activation probability: 0.18810
     *     With/without class size: 7/4 bytes
     *   Specialization {@link ForeignReadPointerNode#doStructured}
     *     Activation probability: 0.14524
     *     With/without class size: 6/4 bytes
     *   Specialization {@link ForeignReadPointerNode#doFallback}
     *     Activation probability: 0.10238
     *     With/without class size: 6/8 bytes
     *   Specialization {@link ForeignReadPointerNode#doFallback}
     *     Activation probability: 0.05952
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadPointerNode.class)
    @SuppressWarnings("javadoc")
    public static final class ForeignReadPointerNodeGen extends ForeignReadPointerNode implements GenerateAOT.Provider {

        static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
        static final ReferenceField<Fallback0Data> FALLBACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fallback0_cache", Fallback0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private ForeignDummy foreign_;
        @Child private OffsetDummy offset_;
        @Child private ResolveNativePointerNode resolve_;
        @Child private GetForeignTypeNode type_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadPointerNode#doNative}
         *   2: SpecializationActive {@link ForeignReadPointerNode#doBuffer}
         *   3: SpecializationActive {@link ForeignReadPointerNode#doBuffer}
         *   4: SpecializationActive {@link ForeignReadPointerNode#doStructured}
         *   5: SpecializationActive {@link ForeignReadPointerNode#doFallback}
         *   6: SpecializationActive {@link ForeignReadPointerNode#doFallback}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ForeignReadPointerNode#doBuffer}
         *   Parameter: {@link BranchProfile} oobProfile</pre>
         */
        @CompilationFinal private BranchProfile buffer1_oobProfile_;
        @Child private StructuredData structured_cache;
        @UnsafeAccessedField @Child private Fallback0Data fallback0_cache;
        @Child private Fallback1Data fallback1_cache;

        private ForeignReadPointerNodeGen() {
            this.foreign_ = (ForeignDummy.create());
            this.offset_ = (OffsetDummy.create());
            this.resolve_ = (ResolveNativePointerNodeGen.create());
            this.type_ = (GetForeignTypeNodeGen.create());
        }

        @ExplodeLoop
        @Override
        public LLVMPointer execute(Object foreignValue, long offsetValue) {
            int state_0 = this.state_0_;
            LLVMPointer resolveValue_ = this.resolve_.execute(foreignValue, offsetValue);
            Object typeValue_ = this.type_.execute(resolveValue_);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doNative(Object, long, LLVMNativePointer, Object)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doNative(Object, long, LLVMNativePointer, Object)] */ && LLVMTypes.isNativePointer(resolveValue_)) {
                    LLVMNativePointer resolveValue__ = LLVMTypes.asNativePointer(resolveValue_);
                    return doNative(foreignValue, offsetValue, resolveValue__, typeValue_);
                }
                if ((state_0 & 0b1111100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */ && LLVMTypes.isManagedPointer(resolveValue_)) {
                    LLVMManagedPointer resolveValue__ = LLVMTypes.asManagedPointer(resolveValue_);
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */ && typeValue_ instanceof Buffer) {
                        Buffer typeValue__ = (Buffer) typeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            Buffer0Data s1_ = this.buffer0_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue__.getObject()))) {
                                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, s1_.interop_, s1_.oobProfile_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                            {
                                BranchProfile oobProfile__ = this.buffer1_oobProfile_;
                                if (oobProfile__ != null) {
                                    return this.buffer1Boundary(state_0, foreignValue, offsetValue, resolveValue__, typeValue__, oobProfile__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */ && typeValue_ instanceof Structured) {
                        Structured typeValue__ = (Structured) typeValue_;
                        StructuredData s3_ = this.structured_cache;
                        if (s3_ != null) {
                            return doStructured(foreignValue, offsetValue, resolveValue__, typeValue__, s3_.interopRead_);
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] || SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */) {
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */) {
                            Fallback0Data s4_ = this.fallback0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(resolveValue__.getObject())) && (typeValue_ == null)) {
                                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, s4_.interop_, s4_.toLLVM_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */) {
                            Fallback1Data s5_ = this.fallback1_cache;
                            if (s5_ != null) {
                                if ((typeValue_ == null)) {
                                    return this.fallback1Boundary(state_0, s5_, foreignValue, offsetValue, resolveValue__, typeValue_);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(foreignValue, offsetValue, resolveValue_, typeValue_);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMPointer buffer1Boundary(int state_0, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Buffer typeValue__, BranchProfile oobProfile__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doBuffer(foreignValue, offsetValue, resolveValue__, typeValue__, interop__, oobProfile__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private LLVMPointer fallback1Boundary(int state_0, Fallback1Data s5_, Object foreignValue, long offsetValue, LLVMManagedPointer resolveValue__, Object typeValue_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue__.getObject()));
                    return doFallback(foreignValue, offsetValue, resolveValue__, typeValue_, interop__1, s5_.toLLVM_);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private LLVMPointer executeAndSpecialize(Object foreignValue, long offsetValue, LLVMPointer resolveValue, Object typeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(resolveValue)) {
                LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doNative(Object, long, LLVMNativePointer, Object)] */;
                this.state_0_ = state_0;
                return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
            }
            if (LLVMTypes.isManagedPointer(resolveValue)) {
                LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                if (typeValue instanceof Buffer) {
                    Buffer typeValue_ = (Buffer) typeValue;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */) {
                        while (true) {
                            int count1_ = 0;
                            Buffer0Data s1_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                            Buffer0Data s1_original = s1_;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(resolveValue_.getObject()))) {
                                    break;
                                }
                                count1_++;
                                s1_ = s1_.next_;
                            }
                            if (s1_ == null) {
                                // assert (s1_.interop_.accepts(resolveValue_.getObject()));
                                if (count1_ < (3)) {
                                    s1_ = this.insert(new Buffer0Data(s1_original));
                                    InteropLibrary interop__ = s1_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                    Objects.requireNonNull(interop__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.interop_ = interop__;
                                    BranchProfile oobProfile__ = (BranchProfile.create());
                                    Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s1_.oobProfile_ = oobProfile__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s1_ != null) {
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, s1_.interop_, s1_.oobProfile_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                interop__ = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                BranchProfile oobProfile__ = (BranchProfile.create());
                                Objects.requireNonNull(oobProfile__, "Specialization 'doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)' cache 'oobProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.buffer1_oobProfile_ = oobProfile__;
                                this.buffer0_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doBuffer(Object, long, LLVMManagedPointer, Buffer, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, interop__, oobProfile__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (typeValue instanceof Structured) {
                    Structured typeValue_ = (Structured) typeValue;
                    StructuredData s3_ = this.insert(new StructuredData());
                    s3_.interopRead_ = s3_.insert((LLVMInteropReadNode.create()));
                    VarHandle.storeStoreFence();
                    this.structured_cache = s3_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doStructured(Object, long, LLVMManagedPointer, Structured, LLVMInteropReadNode)] */;
                    this.state_0_ = state_0;
                    return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, s3_.interopRead_);
                }
                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */) {
                    while (true) {
                        int count4_ = 0;
                        Fallback0Data s4_ = FALLBACK0_CACHE_UPDATER.getVolatile(this);
                        Fallback0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(resolveValue_.getObject())) && (typeValue == null)) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            if ((typeValue == null) && count4_ < (3)) {
                                // assert (s4_.interop_.accepts(resolveValue_.getObject()));
                                s4_ = this.insert(new Fallback0Data(s4_original));
                                InteropLibrary interop__1 = s4_.insert((INTEROP_LIBRARY_.create(resolveValue_.getObject())));
                                Objects.requireNonNull(interop__1, "Specialization 'doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.interop_ = interop__1;
                                s4_.toLLVM_ = s4_.insert((ToPointer.create()));
                                if (!FALLBACK0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, s4_.interop_, s4_.toLLVM_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((typeValue == null)) {
                                Fallback1Data s5_ = this.insert(new Fallback1Data());
                                interop__1 = (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject()));
                                s5_.toLLVM_ = s5_.insert((ToPointer.create()));
                                VarHandle.storeStoreFence();
                                this.fallback1_cache = s5_;
                                this.fallback0_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMReadFromForeignObjectNode.ForeignReadPointerNode.doFallback(Object, long, LLVMManagedPointer, Object, InteropLibrary, ToPointer)] */;
                                this.state_0_ = state_0;
                                return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, interop__1, s5_.toLLVM_);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.foreign_, this.offset_, this.resolve_, this.type_}, foreignValue, offsetValue, resolveValue, typeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                    Buffer0Data s1_ = this.buffer0_cache;
                    Fallback0Data s4_ = this.fallback0_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ForeignReadPointerNode create() {
            return new ForeignReadPointerNodeGen();
        }

        @NeverDefault
        public static ForeignReadPointerNode getUncached() {
            return ForeignReadPointerNodeGen.UNCACHED;
        }

        @GeneratedBy(ForeignReadPointerNode.class)
        @DenyReplace
        private static final class Buffer0Data extends Node implements SpecializationDataNode {

            @Child Buffer0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadPointerNode#doBuffer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadPointerNode#doBuffer}
             *   Parameter: {@link BranchProfile} oobProfile</pre>
             */
            @CompilationFinal BranchProfile oobProfile_;

            Buffer0Data(Buffer0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadPointerNode.class)
        @DenyReplace
        private static final class StructuredData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadPointerNode#doStructured}
             *   Parameter: {@link LLVMInteropReadNode} interopRead</pre>
             */
            @Child LLVMInteropReadNode interopRead_;

            StructuredData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadPointerNode.class)
        @DenyReplace
        private static final class Fallback0Data extends Node implements SpecializationDataNode {

            @Child Fallback0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadPointerNode#doFallback}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadPointerNode#doFallback}
             *   Parameter: {@link ToPointer} toLLVM</pre>
             */
            @Child ToPointer toLLVM_;

            Fallback0Data(Fallback0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadPointerNode.class)
        @DenyReplace
        private static final class Fallback1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadPointerNode#doFallback}
             *   Parameter: {@link ToPointer} toLLVM</pre>
             */
            @Child ToPointer toLLVM_;

            Fallback1Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadPointerNode.class)
        @DenyReplace
        private static final class Uncached extends ForeignReadPointerNode {

            @TruffleBoundary
            @Override
            public LLVMPointer execute(Object foreignValue, long offsetValue) {
                LLVMPointer resolveValue = (ResolveNativePointerNodeGen.getUncached()).execute(foreignValue, offsetValue);
                Object typeValue = (GetForeignTypeNodeGen.getUncached()).execute(resolveValue);
                if (LLVMTypes.isNativePointer(resolveValue)) {
                    LLVMNativePointer resolveValue_ = LLVMTypes.asNativePointer(resolveValue);
                    return doNative(foreignValue, offsetValue, resolveValue_, typeValue);
                }
                if (LLVMTypes.isManagedPointer(resolveValue)) {
                    LLVMManagedPointer resolveValue_ = LLVMTypes.asManagedPointer(resolveValue);
                    if (typeValue instanceof Buffer) {
                        Buffer typeValue_ = (Buffer) typeValue;
                        return doBuffer(foreignValue, offsetValue, resolveValue_, typeValue_, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (BranchProfile.getUncached()));
                    }
                    if (typeValue instanceof Structured) {
                        Structured typeValue_ = (Structured) typeValue;
                        return doStructured(foreignValue, offsetValue, resolveValue_, typeValue_, (LLVMInteropReadNodeGen.getUncached()));
                    }
                    if ((typeValue == null)) {
                        return doFallback(foreignValue, offsetValue, resolveValue_, typeValue, (INTEROP_LIBRARY_.getUncached(resolveValue_.getObject())), (ToPointerNodeGen.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, foreignValue, offsetValue, resolveValue, typeValue);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
