// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToI32#fromInt}
 *     Activation probability: 0.14679
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI32#fromChar}
 *     Activation probability: 0.13526
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI32#fromShort}
 *     Activation probability: 0.12372
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI32#fromLong}
 *     Activation probability: 0.11218
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI32#fromByte}
 *     Activation probability: 0.10064
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI32#fromFloat}
 *     Activation probability: 0.08910
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToI32#fromDouble}
 *     Activation probability: 0.07756
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToI32#fromBoolean}
 *     Activation probability: 0.06603
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToI32#fromString}
 *     Activation probability: 0.05449
 *     With/without class size: 4/4 bytes
 *   Specialization {@link ToI32#fromForeign}
 *     Activation probability: 0.04295
 *     With/without class size: 5/12 bytes
 *   Specialization {@link ToI32#fromForeign}
 *     Activation probability: 0.03141
 *     With/without class size: 4/8 bytes
 *   Specialization {@link ToI32#fromForeignObject}
 *     Activation probability: 0.01987
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(ToI32.class)
@SuppressWarnings({"javadoc", "unused"})
public final class ToI32NodeGen extends ToI32 implements GenerateAOT.Provider {

    static final ReferenceField<FromForeign0Data> FROM_FOREIGN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fromForeign0_cache", FromForeign0Data.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToI32#fromInt}
     *   2: SpecializationActive {@link ToI32#fromChar}
     *   3: SpecializationActive {@link ToI32#fromShort}
     *   4: SpecializationActive {@link ToI32#fromLong}
     *   5: SpecializationActive {@link ToI32#fromByte}
     *   6: SpecializationActive {@link ToI32#fromFloat}
     *   7: SpecializationActive {@link ToI32#fromDouble}
     *   8: SpecializationActive {@link ToI32#fromBoolean}
     *   9: SpecializationActive {@link ToI32#fromString}
     *   10: SpecializationActive {@link ToI32#fromForeign}
     *   11: SpecializationActive {@link ToI32#fromForeign}
     *   12: SpecializationActive {@link ToI32#fromForeignObject}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToI32#fromString}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile fromString_exception_;
    @UnsafeAccessedField @Child private FromForeign0Data fromForeign0_cache;
    @Child private FromForeign1Data fromForeign1_cache;

    private ToI32NodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ToI32.fromInt(int)] */) && arg0Value instanceof Integer) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ToI32.fromChar(char)] */) && arg0Value instanceof Character) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI32.fromShort(short)] */) && arg0Value instanceof Short) {
            return false;
        }
        if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI32.fromLong(long)] */) && arg0Value instanceof Long) {
            return false;
        }
        if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI32.fromByte(byte)] */) && arg0Value instanceof Byte) {
            return false;
        }
        if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI32.fromFloat(float)] */) && arg0Value instanceof Float) {
            return false;
        }
        if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI32.fromDouble(double)] */) && arg0Value instanceof Double) {
            return false;
        }
        if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI32.fromBoolean(boolean)] */) && arg0Value instanceof Boolean) {
            return false;
        }
        if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI32.fromString(String, BranchProfile)] */) && arg0Value instanceof String) {
            return false;
        }
        {
            FromForeign1Data s10_ = this.fromForeign1_cache;
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(arg0Value)) && (s10_ == null || ((s10_.fromForeign1_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile), guardIndex=1] */ || (s10_.interop_.isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).asForeign(arg0Value))))) {
                return false;
            }
        }
        return true;
    }

    @ExplodeLoop
    @Override
    public Object executeWithForeignToLLVMType(Object arg0Value, Structured type, ForeignToLLVMType ftlType) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[ToI32.fromInt(int)] || SpecializationActive[ToI32.fromChar(char)] || SpecializationActive[ToI32.fromShort(short)] || SpecializationActive[ToI32.fromLong(long)] || SpecializationActive[ToI32.fromByte(byte)] || SpecializationActive[ToI32.fromFloat(float)] || SpecializationActive[ToI32.fromDouble(double)] || SpecializationActive[ToI32.fromBoolean(boolean)] || SpecializationActive[ToI32.fromString(String, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeignObject(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToI32.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToI32.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI32.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI32.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI32.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI32.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI32.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI32.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI32.fromString(String, BranchProfile)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    BranchProfile exception__ = this.fromString_exception_;
                    if (exception__ != null) {
                        return fromString(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0b1110000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeignObject(Object)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign0Data s9_ = this.fromForeign0_cache;
                    while (s9_ != null) {
                        if ((s9_.foreigns_.accepts(arg0Value)) && (s9_.foreigns_.isForeign(arg0Value)) && (s9_.interop_.isNumber(s9_.foreigns_.asForeign(arg0Value)))) {
                            return fromForeign(arg0Value, s9_.foreigns_, s9_.interop_, s9_.exception_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign1Data s10_ = this.fromForeign1_cache;
                    if (s10_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((s10_.fromForeign1_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                                if ((foreigns__.isForeign(arg0Value)) && (s10_.interop_.isNumber(foreigns__.asForeign(arg0Value)))) {
                                    return this.fromForeign1Boundary(state_0, s10_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToI32.fromForeignObject(Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return fromForeignObject(arg0Value);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeign1Boundary(int state_0, FromForeign1Data s10_, Object arg0Value) {
        {
            LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            return fromForeign(arg0Value, foreigns__, s10_.interop_, s10_.exception_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeWithType(Object arg0Value, Structured type) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[ToI32.fromInt(int)] || SpecializationActive[ToI32.fromChar(char)] || SpecializationActive[ToI32.fromShort(short)] || SpecializationActive[ToI32.fromLong(long)] || SpecializationActive[ToI32.fromByte(byte)] || SpecializationActive[ToI32.fromFloat(float)] || SpecializationActive[ToI32.fromDouble(double)] || SpecializationActive[ToI32.fromBoolean(boolean)] || SpecializationActive[ToI32.fromString(String, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeignObject(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToI32.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToI32.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI32.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI32.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI32.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI32.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI32.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI32.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI32.fromString(String, BranchProfile)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    BranchProfile exception__ = this.fromString_exception_;
                    if (exception__ != null) {
                        return fromString(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0b1110000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeignObject(Object)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign0Data s9_ = this.fromForeign0_cache;
                    while (s9_ != null) {
                        if ((s9_.foreigns_.accepts(arg0Value)) && (s9_.foreigns_.isForeign(arg0Value)) && (s9_.interop_.isNumber(s9_.foreigns_.asForeign(arg0Value)))) {
                            return fromForeign(arg0Value, s9_.foreigns_, s9_.interop_, s9_.exception_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign1Data s10_ = this.fromForeign1_cache;
                    if (s10_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((s10_.fromForeign1_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                                if ((foreigns__.isForeign(arg0Value)) && (s10_.interop_.isNumber(foreigns__.asForeign(arg0Value)))) {
                                    return this.fromForeign1Boundary0(state_0, s10_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToI32.fromForeignObject(Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return fromForeignObject(arg0Value);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeign1Boundary0(int state_0, FromForeign1Data s10_, Object arg0Value) {
        {
            LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            return fromForeign(arg0Value, foreigns__, s10_.interop_, s10_.exception_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[ToI32.fromInt(int)] || SpecializationActive[ToI32.fromChar(char)] || SpecializationActive[ToI32.fromShort(short)] || SpecializationActive[ToI32.fromLong(long)] || SpecializationActive[ToI32.fromByte(byte)] || SpecializationActive[ToI32.fromFloat(float)] || SpecializationActive[ToI32.fromDouble(double)] || SpecializationActive[ToI32.fromBoolean(boolean)] || SpecializationActive[ToI32.fromString(String, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeignObject(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToI32.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToI32.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToI32.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToI32.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToI32.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToI32.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToI32.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToI32.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToI32.fromString(String, BranchProfile)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    BranchProfile exception__ = this.fromString_exception_;
                    if (exception__ != null) {
                        return fromString(arg0Value_, exception__);
                    }
                }
            }
            if ((state_0 & 0b1110000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] || SpecializationActive[ToI32.fromForeignObject(Object)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign0Data s9_ = this.fromForeign0_cache;
                    while (s9_ != null) {
                        if ((s9_.foreigns_.accepts(arg0Value)) && (s9_.foreigns_.isForeign(arg0Value)) && (s9_.interop_.isNumber(s9_.foreigns_.asForeign(arg0Value)))) {
                            return fromForeign(arg0Value, s9_.foreigns_, s9_.interop_, s9_.exception_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
                    FromForeign1Data s10_ = this.fromForeign1_cache;
                    if (s10_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((s10_.fromForeign1_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                                if ((foreigns__.isForeign(arg0Value)) && (s10_.interop_.isNumber(foreigns__.asForeign(arg0Value)))) {
                                    return this.fromForeign1Boundary1(state_0, s10_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToI32.fromForeignObject(Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return fromForeignObject(arg0Value);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object fromForeign1Boundary1(int state_0, FromForeign1Data s10_, Object arg0Value) {
        {
            LLVMAsForeignLibrary foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            return fromForeign(arg0Value, foreigns__, s10_.interop_, s10_.exception_);
        }
    }

    @SuppressWarnings("unused")
    private int executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToI32.fromInt(int)] */;
            this.state_0_ = state_0;
            return fromInt(arg0Value_);
        }
        if (arg0Value instanceof Character) {
            char arg0Value_ = (char) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToI32.fromChar(char)] */;
            this.state_0_ = state_0;
            return fromChar(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToI32.fromShort(short)] */;
            this.state_0_ = state_0;
            return fromShort(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToI32.fromLong(long)] */;
            this.state_0_ = state_0;
            return fromLong(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ToI32.fromByte(byte)] */;
            this.state_0_ = state_0;
            return fromByte(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToI32.fromFloat(float)] */;
            this.state_0_ = state_0;
            return fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (double) arg0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToI32.fromDouble(double)] */;
            this.state_0_ = state_0;
            return fromDouble(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToI32.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String) arg0Value;
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "Specialization 'fromString(String, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromString_exception_ = exception__;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToI32.fromString(String, BranchProfile)] */;
            this.state_0_ = state_0;
            return fromString(arg0Value_, exception__);
        }
        if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */) {
            while (true) {
                int count9_ = 0;
                FromForeign0Data s9_ = FROM_FOREIGN0_CACHE_UPDATER.getVolatile(this);
                FromForeign0Data s9_original = s9_;
                while (s9_ != null) {
                    if ((s9_.foreigns_.accepts(arg0Value)) && (s9_.foreigns_.isForeign(arg0Value)) && (s9_.interop_.isNumber(s9_.foreigns_.asForeign(arg0Value)))) {
                        break;
                    }
                    count9_++;
                    s9_ = s9_.next_;
                }
                if (s9_ == null) {
                    {
                        LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.create(arg0Value)));
                        // assert (s9_.foreigns_.accepts(arg0Value));
                        if ((foreigns__.isForeign(arg0Value))) {
                            InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            if ((interop__.isNumber(foreigns__.asForeign(arg0Value))) && count9_ < (5)) {
                                s9_ = this.insert(new FromForeign0Data(s9_original));
                                Objects.requireNonNull(s9_.insert(foreigns__), "Specialization 'fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s9_.foreigns_ = foreigns__;
                                Objects.requireNonNull(s9_.insert(interop__), "Specialization 'fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s9_.interop_ = interop__;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "Specialization 'fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s9_.exception_ = exception__1;
                                if (!FROM_FOREIGN0_CACHE_UPDATER.compareAndSet(this, s9_original, s9_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                }
                if (s9_ != null) {
                    return fromForeign(arg0Value, s9_.foreigns_, s9_.interop_, s9_.exception_);
                }
                break;
            }
        }
        {
            LLVMAsForeignLibrary foreigns__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        foreigns__ = (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
                        if ((foreigns__.isForeign(arg0Value))) {
                            FromForeign1Data s10_ = this.insert(new FromForeign1Data());
                            InteropLibrary interop__ = s10_.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            if (((s10_.fromForeign1_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile), guardIndex=1] */) {
                                Objects.requireNonNull(s10_.insert(interop__), "Specialization 'fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s10_.interop_ = interop__;
                                s10_.fromForeign1_state_0_ = s10_.fromForeign1_state_0_ | 0b1 /* add GuardActive[specialization=ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile), guardIndex=1] */;
                                VarHandle.storeStoreFence();
                                this.fromForeign1_cache = s10_;
                                s10_ = this.insert(new FromForeign1Data(s10_));
                            }
                            if ((interop__.isNumber(foreigns__.asForeign(arg0Value)))) {
                                Objects.requireNonNull(s10_.insert(interop__), "Specialization 'fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s10_.interop_ = interop__;
                                BranchProfile exception__1 = (BranchProfile.create());
                                Objects.requireNonNull(exception__1, "Specialization 'fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s10_.exception_ = exception__1;
                                s10_.fromForeign1_state_0_ = s10_.fromForeign1_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                                VarHandle.storeStoreFence();
                                this.fromForeign1_cache = s10_;
                                this.fromForeign0_cache = null;
                                state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */;
                                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToI32.fromForeign(Object, LLVMAsForeignLibrary, InteropLibrary, BranchProfile)] */;
                                this.state_0_ = state_0;
                                return fromForeign(arg0Value, foreigns__, interop__, exception__1);
                            }
                        }
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToI32.fromForeignObject(Object)] */;
        this.state_0_ = state_0;
        return fromForeignObject(arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111111111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1111111111110) & ((state_0 & 0b1111111111110) - 1)) == 0 /* is-single  */) {
                FromForeign0Data s9_ = this.fromForeign0_cache;
                if ((s9_ == null || s9_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToI32.fromInt(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToI32.fromChar(char)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToI32.fromShort(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToI32.fromLong(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToI32.fromByte(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToI32.fromFloat(float)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToI32.fromDouble(double)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToI32.fromBoolean(boolean)] */;
        }
        {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "Specialization 'fromString(String, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromString_exception_ = exception__;
            this.fromString_exception_.disable();
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[ToI32.fromString(String, BranchProfile)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[ToI32.fromForeignObject(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.fromString_exception_.reset();
    }

    @NeverDefault
    public static ToI32 create() {
        return new ToI32NodeGen();
    }

    @NeverDefault
    public static ToI32 getUncached() {
        return ToI32NodeGen.UNCACHED;
    }

    @GeneratedBy(ToI32.class)
    @DenyReplace
    private static final class FromForeign0Data extends Node implements SpecializationDataNode {

        @Child FromForeign0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI32#fromForeign}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI32#fromForeign}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI32#fromForeign}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal BranchProfile exception_;

        FromForeign0Data(FromForeign0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToI32.class)
    @DenyReplace
    private static final class FromForeign1Data extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: GuardActive[guardIndex=1] {@link ToI32#fromForeign}
         *   1: SpecializationCachesInitialized {@link ToI32#fromForeign}
         * </pre>
         */
        @CompilationFinal private int fromForeign1_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI32#fromForeign}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToI32#fromForeign}
         *   Parameter: {@link BranchProfile} exception</pre>
         */
        @CompilationFinal BranchProfile exception_;

        FromForeign1Data() {
        }

        FromForeign1Data(FromForeign1Data delegate) {
            this.fromForeign1_state_0_ = delegate.fromForeign1_state_0_;
            this.interop_ = delegate.interop_;
            this.exception_ = delegate.exception_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToI32.class)
    @DenyReplace
    private static final class Uncached extends ToI32 {

        @TruffleBoundary
        @Override
        public Object executeWithForeignToLLVMType(Object arg0Value, Structured type, ForeignToLLVMType ftlType) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_, (BranchProfile.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) && ((INTEROP_LIBRARY_.getUncached()).isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).asForeign(arg0Value)))) {
                return fromForeign(arg0Value, (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }
            return fromForeignObject(arg0Value);
        }

        @TruffleBoundary
        @Override
        public Object executeWithType(Object arg0Value, Structured type) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_, (BranchProfile.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) && ((INTEROP_LIBRARY_.getUncached()).isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).asForeign(arg0Value)))) {
                return fromForeign(arg0Value, (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }
            return fromForeignObject(arg0Value);
        }

        @TruffleBoundary
        @Override
        public Object executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_, (BranchProfile.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) && ((INTEROP_LIBRARY_.getUncached()).isNumber((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).asForeign(arg0Value)))) {
                return fromForeign(arg0Value, (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }
            return fromForeignObject(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
