// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults.ArrayLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GeneratedBy(ArrayLibrary.class)
@SuppressWarnings("javadoc")
final class ArrayLibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ArrayLibrary.class, new LLVMNativeLibraryExports());
    }

    private ArrayLibraryGen() {
    }

    @GeneratedBy(ArrayLibrary.class)
    private static final class LLVMNativeLibraryExports extends LibraryExport<LLVMNativeLibrary> {

        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, byte[].class, true, false, 0);
        }

        @Override
        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert receiver instanceof byte[];
            LLVMNativeLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected LLVMNativeLibrary createCached(Object receiver) {
            assert receiver instanceof byte[];
            return new Cached();
        }

        @GeneratedBy(ArrayLibrary.class)
        private static final class Cached extends LLVMNativeLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ArrayLibrary.isPointer((((byte[]) receiver)));
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ArrayLibrary.asPointer((((byte[]) receiver)));
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ArrayLibrary#toNativePointer}
             *     Activation probability: 1.00000
             *     With/without class size: 16/0 bytes
             * </pre>
             */
            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                {
                    LLVMNativeLibrary self__ = (this);
                    return ArrayLibrary.toNativePointer(arg0Value, self__);
                }
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
        @GeneratedBy(ArrayLibrary.class)
        @DenyReplace
        private static final class Uncached extends LLVMNativeLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ArrayLibrary.isPointer(((byte[]) receiver) );
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ArrayLibrary.asPointer(((byte[]) receiver) );
            }

            @TruffleBoundary
            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = ((byte[]) arg0Value_);
                return ArrayLibrary.toNativePointer(arg0Value, (this));
            }

        }
    }
}
