// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadDoubleNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadFloatNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI16Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI32Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI64Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadI8Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode.ForeignReadPointerNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadFloatNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadI16NodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadI32NodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadI64NodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadI8NodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory.ForeignReadPointerNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.FallbackRead;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(FallbackRead.class)
@SuppressWarnings("javadoc")
final class FallbackReadGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(FallbackRead.class, new LLVMManagedReadLibraryExports());
    }

    private FallbackReadGen() {
    }

    @GeneratedBy(FallbackRead.class)
    private static final class LLVMManagedReadLibraryExports extends LibraryExport<LLVMManagedReadLibrary> {

        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, Object.class, true, false, 0);
        }

        @Override
        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            LLVMManagedReadLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected LLVMManagedReadLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(FallbackRead.class)
        private static final class Cached extends LLVMManagedReadLibrary {

            @Child private InteropLibrary receiverInteropLibrary_;
            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FallbackRead#readI8}
             *   1: SpecializationActive {@link FallbackRead#readI16}
             *   2: SpecializationActive {@link FallbackRead#readI32}
             *   3: SpecializationActive {@link FallbackRead#readI64}
             *   4: SpecializationActive {@link FallbackRead#readGenericI64}
             *   5: SpecializationActive {@link FallbackRead#readFloat}
             *   6: SpecializationActive {@link FallbackRead#readDouble}
             *   7: SpecializationActive {@link FallbackRead#readPointer}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readI64}
             *   Parameter: {@link ForeignReadI64Node} readNode</pre>
             */
            @Child private ForeignReadI64Node readI64;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readI8}
             *   Parameter: {@link ForeignReadI8Node} readNode</pre>
             */
            @Child private ForeignReadI8Node readI8Node__readI8_readNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readI16}
             *   Parameter: {@link ForeignReadI16Node} readNode</pre>
             */
            @Child private ForeignReadI16Node readI16Node__readI16_readNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readI32}
             *   Parameter: {@link ForeignReadI32Node} readNode</pre>
             */
            @Child private ForeignReadI32Node readI32Node__readI32_readNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readFloat}
             *   Parameter: {@link ForeignReadFloatNode} readNode</pre>
             */
            @Child private ForeignReadFloatNode readFloatNode__readFloat_readNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readDouble}
             *   Parameter: {@link ForeignReadDoubleNode} readNode</pre>
             */
            @Child private ForeignReadDoubleNode readDoubleNode__readDouble_readNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FallbackRead#readPointer}
             *   Parameter: {@link ForeignReadPointerNode} readNode</pre>
             */
            @Child private ForeignReadPointerNode readPointerNode__readPointer_readNode_;

            protected Cached(Object receiver) {
                this.receiverInteropLibrary_ = INTEROP_LIBRARY_.create((receiver));
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                if (!(dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_)) {
                    return false;
                } else if (!this.receiverInteropLibrary_.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#isReadable}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public boolean isReadable(Object arg0Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                {
                    InteropLibrary interop__ = this.receiverInteropLibrary_;
                    return FallbackRead.isReadable(arg0Value, interop__);
                }
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readI8}
             *     Activation probability: 0.11111
             *     With/without class size: 6/4 bytes
             * </pre>
             */
            @Override
            public byte readI8(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[FallbackRead.readI8(Object, long, ForeignReadI8Node)] */) {
                    {
                        ForeignReadI8Node readNode__ = this.readI8Node__readI8_readNode_;
                        if (readNode__ != null) {
                            return FallbackRead.readI8(arg0Value, arg1Value, readNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadI8Node readNode__ = this.insert((ForeignReadI8NodeGen.create()));
                Objects.requireNonNull(readNode__, "Specialization 'readI8(Object, long, ForeignReadI8Node)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readI8Node__readI8_readNode_ = readNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[FallbackRead.readI8(Object, long, ForeignReadI8Node)] */;
                this.state_0_ = state_0;
                return FallbackRead.readI8(arg0Value, arg1Value, readNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readI16}
             *     Activation probability: 0.11111
             *     With/without class size: 6/4 bytes
             * </pre>
             */
            @Override
            public short readI16(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[FallbackRead.readI16(Object, long, ForeignReadI16Node)] */) {
                    {
                        ForeignReadI16Node readNode__ = this.readI16Node__readI16_readNode_;
                        if (readNode__ != null) {
                            return FallbackRead.readI16(arg0Value, arg1Value, readNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadI16Node readNode__ = this.insert((ForeignReadI16NodeGen.create()));
                Objects.requireNonNull(readNode__, "Specialization 'readI16(Object, long, ForeignReadI16Node)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readI16Node__readI16_readNode_ = readNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[FallbackRead.readI16(Object, long, ForeignReadI16Node)] */;
                this.state_0_ = state_0;
                return FallbackRead.readI16(arg0Value, arg1Value, readNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readI32}
             *     Activation probability: 0.11111
             *     With/without class size: 6/4 bytes
             * </pre>
             */
            @Override
            public int readI32(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[FallbackRead.readI32(Object, long, ForeignReadI32Node)] */) {
                    {
                        ForeignReadI32Node readNode__ = this.readI32Node__readI32_readNode_;
                        if (readNode__ != null) {
                            return FallbackRead.readI32(arg0Value, arg1Value, readNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadI32Node readNode__ = this.insert((ForeignReadI32NodeGen.create()));
                Objects.requireNonNull(readNode__, "Specialization 'readI32(Object, long, ForeignReadI32Node)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readI32Node__readI32_readNode_ = readNode__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[FallbackRead.readI32(Object, long, ForeignReadI32Node)] */;
                this.state_0_ = state_0;
                return FallbackRead.readI32(arg0Value, arg1Value, readNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readI64}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public long readI64(Object arg0Value, long arg1Value) throws UnexpectedResultException {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[FallbackRead.readI64(Object, long, ForeignReadI64Node)] */) {
                    {
                        ForeignReadI64Node readI64_ = this.readI64;
                        if (readI64_ != null) {
                            return FallbackRead.readI64(arg0Value, arg1Value, readI64_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            private long readI64Node_AndSpecialize(Object arg0Value, long arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                ForeignReadI64Node readI64_;
                ForeignReadI64Node readI64__shared = this.readI64;
                if (readI64__shared != null) {
                    readI64_ = readI64__shared;
                } else {
                    readI64_ = this.insert((ForeignReadI64NodeGen.create()));
                    if (readI64_ == null) {
                        throw new IllegalStateException("Specialization 'readI64(Object, long, ForeignReadI64Node)' contains a shared cache with name 'readNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.readI64 == null) {
                    VarHandle.storeStoreFence();
                    this.readI64 = readI64_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[FallbackRead.readI64(Object, long, ForeignReadI64Node)] */;
                this.state_0_ = state_0;
                return FallbackRead.readI64(arg0Value, arg1Value, readI64_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readGenericI64}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[FallbackRead.readGenericI64(Object, long, ForeignReadI64Node)] */) {
                    {
                        ForeignReadI64Node readI64_ = this.readI64;
                        if (readI64_ != null) {
                            return FallbackRead.readGenericI64(arg0Value, arg1Value, readI64_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readGenericI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readGenericI64Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadI64Node readI64_;
                ForeignReadI64Node readI64__shared = this.readI64;
                if (readI64__shared != null) {
                    readI64_ = readI64__shared;
                } else {
                    readI64_ = this.insert((ForeignReadI64NodeGen.create()));
                    if (readI64_ == null) {
                        throw new IllegalStateException("Specialization 'readGenericI64(Object, long, ForeignReadI64Node)' contains a shared cache with name 'readNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.readI64 == null) {
                    VarHandle.storeStoreFence();
                    this.readI64 = readI64_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[FallbackRead.readGenericI64(Object, long, ForeignReadI64Node)] */;
                this.state_0_ = state_0;
                return FallbackRead.readGenericI64(arg0Value, arg1Value, readI64_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readFloat}
             *     Activation probability: 0.11111
             *     With/without class size: 6/4 bytes
             * </pre>
             */
            @Override
            public float readFloat(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[FallbackRead.readFloat(Object, long, ForeignReadFloatNode)] */) {
                    {
                        ForeignReadFloatNode readNode__ = this.readFloatNode__readFloat_readNode_;
                        if (readNode__ != null) {
                            return FallbackRead.readFloat(arg0Value, arg1Value, readNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadFloatNode readNode__ = this.insert((ForeignReadFloatNodeGen.create()));
                Objects.requireNonNull(readNode__, "Specialization 'readFloat(Object, long, ForeignReadFloatNode)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readFloatNode__readFloat_readNode_ = readNode__;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[FallbackRead.readFloat(Object, long, ForeignReadFloatNode)] */;
                this.state_0_ = state_0;
                return FallbackRead.readFloat(arg0Value, arg1Value, readNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readDouble}
             *     Activation probability: 0.11111
             *     With/without class size: 6/4 bytes
             * </pre>
             */
            @Override
            public double readDouble(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[FallbackRead.readDouble(Object, long, ForeignReadDoubleNode)] */) {
                    {
                        ForeignReadDoubleNode readNode__ = this.readDoubleNode__readDouble_readNode_;
                        if (readNode__ != null) {
                            return FallbackRead.readDouble(arg0Value, arg1Value, readNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadDoubleNode readNode__ = this.insert((ForeignReadDoubleNodeGen.create()));
                Objects.requireNonNull(readNode__, "Specialization 'readDouble(Object, long, ForeignReadDoubleNode)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readDoubleNode__readDouble_readNode_ = readNode__;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[FallbackRead.readDouble(Object, long, ForeignReadDoubleNode)] */;
                this.state_0_ = state_0;
                return FallbackRead.readDouble(arg0Value, arg1Value, readNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FallbackRead#readPointer}
             *     Activation probability: 0.11111
             *     With/without class size: 6/4 bytes
             * </pre>
             */
            @Override
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                assert dynamicDispatch_.accepts(arg0Value) && dynamicDispatch_.dispatch(arg0Value) == dynamicDispatchTarget_ : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[FallbackRead.readPointer(Object, long, ForeignReadPointerNode)] */) {
                    {
                        ForeignReadPointerNode readNode__ = this.readPointerNode__readPointer_readNode_;
                        if (readNode__ != null) {
                            return FallbackRead.readPointer(arg0Value, arg1Value, readNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerNode_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                ForeignReadPointerNode readNode__ = this.insert((ForeignReadPointerNodeGen.create()));
                Objects.requireNonNull(readNode__, "Specialization 'readPointer(Object, long, ForeignReadPointerNode)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readPointerNode__readPointer_readNode_ = readNode__;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[FallbackRead.readPointer(Object, long, ForeignReadPointerNode)] */;
                this.state_0_ = state_0;
                return FallbackRead.readPointer(arg0Value, arg1Value, readNode__);
            }

        }
        @GeneratedBy(FallbackRead.class)
        @DenyReplace
        private static final class Uncached extends LLVMManagedReadLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isReadable(Object arg0Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.isReadable(arg0Value, INTEROP_LIBRARY_.getUncached((arg0Value)));
            }

            @TruffleBoundary
            @Override
            public byte readI8(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readI8(arg0Value, arg1Value, (ForeignReadI8NodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short readI16(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readI16(arg0Value, arg1Value, (ForeignReadI16NodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int readI32(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readI32(arg0Value, arg1Value, (ForeignReadI32NodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long readI64(Object arg0Value, long arg1Value) throws UnexpectedResultException {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readI64(arg0Value, arg1Value, (ForeignReadI64NodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readGenericI64(arg0Value, arg1Value, (ForeignReadI64NodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readFloat(arg0Value, arg1Value, (ForeignReadFloatNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readDouble(arg0Value, arg1Value, (ForeignReadDoubleNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value) : "Invalid library usage. Library does not accept given receiver.";
                return FallbackRead.readPointer(arg0Value, arg1Value, (ForeignReadPointerNodeGen.getUncached()));
            }

        }
    }
}
