// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StosNode.LLVMAMD64StosbNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StosNode.LLVMAMD64StosdNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StosNode.LLVMAMD64StosqNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StosNode.LLVMAMD64StoswNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64StosNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64StosNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64StosbNode#opI8(VirtualFrame, byte, long, boolean)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link LLVMAMD64StosbNode#opI8(VirtualFrame, byte, LLVMPointer, boolean)}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64StosbNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64StosbNodeGen extends LLVMAMD64StosbNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode rax_;
        @Child private LLVMExpressionNode rdi_;
        @Child private LLVMExpressionNode df_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64StosbNode#opI8(VirtualFrame, byte, long, boolean)}
         *   2: SpecializationActive {@link LLVMAMD64StosbNode#opI8(VirtualFrame, byte, LLVMPointer, boolean)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64StosbNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte raxValue_;
            try {
                raxValue_ = this.rax_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */)) {
                execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */)) {
                execute_boolean1(state_0, frameValue, raxValue_);
                return;
            } else {
                execute_generic2(state_0, frameValue, raxValue_);
                return;
            }
        }

        private void execute_long_boolean0(int state_0__, VirtualFrame frameValue, byte raxValue_) {
            int state_0 = state_0__;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] */;
            opI8(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_boolean1(int state_0__, VirtualFrame frameValue, byte raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */;
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_generic2(int state_0__, VirtualFrame frameValue, byte raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] || SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] */ && rdiValue_ instanceof Long) {
                    long rdiValue__ = (long) rdiValue_;
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */ && LLVMTypes.isPointer(rdiValue_)) {
                    LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (raxValue instanceof Byte) {
                byte raxValue_ = (byte) raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (boolean) dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (long) rdiValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.rax_, this.rdi_, this.df_}, raxValue, rdiValue, dfValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, long, boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosbNode.opI8(VirtualFrame, byte, LLVMPointer, boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64StosbNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StosbNodeGen(writeRDI, rax, rdi, df);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64StoswNode#opI8(VirtualFrame, short, long, boolean)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link LLVMAMD64StoswNode#opI8(VirtualFrame, short, LLVMPointer, boolean)}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64StoswNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64StoswNodeGen extends LLVMAMD64StoswNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode rax_;
        @Child private LLVMExpressionNode rdi_;
        @Child private LLVMExpressionNode df_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64StoswNode#opI8(VirtualFrame, short, long, boolean)}
         *   2: SpecializationActive {@link LLVMAMD64StoswNode#opI8(VirtualFrame, short, LLVMPointer, boolean)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64StoswNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short raxValue_;
            try {
                raxValue_ = this.rax_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */)) {
                execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */)) {
                execute_boolean1(state_0, frameValue, raxValue_);
                return;
            } else {
                execute_generic2(state_0, frameValue, raxValue_);
                return;
            }
        }

        private void execute_long_boolean0(int state_0__, VirtualFrame frameValue, short raxValue_) {
            int state_0 = state_0__;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] */;
            opI8(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_boolean1(int state_0__, VirtualFrame frameValue, short raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */;
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_generic2(int state_0__, VirtualFrame frameValue, short raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] || SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] */ && rdiValue_ instanceof Long) {
                    long rdiValue__ = (long) rdiValue_;
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */ && LLVMTypes.isPointer(rdiValue_)) {
                    LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (raxValue instanceof Short) {
                short raxValue_ = (short) raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (boolean) dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (long) rdiValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.rax_, this.rdi_, this.df_}, raxValue, rdiValue, dfValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, long, boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StoswNode.opI8(VirtualFrame, short, LLVMPointer, boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64StoswNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StoswNodeGen(writeRDI, rax, rdi, df);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64StosdNode#opI8(VirtualFrame, int, long, boolean)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link LLVMAMD64StosdNode#opI8(VirtualFrame, int, LLVMPointer, boolean)}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64StosdNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64StosdNodeGen extends LLVMAMD64StosdNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode rax_;
        @Child private LLVMExpressionNode rdi_;
        @Child private LLVMExpressionNode df_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64StosdNode#opI8(VirtualFrame, int, long, boolean)}
         *   2: SpecializationActive {@link LLVMAMD64StosdNode#opI8(VirtualFrame, int, LLVMPointer, boolean)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64StosdNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int raxValue_;
            try {
                raxValue_ = this.rax_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */)) {
                execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */)) {
                execute_boolean1(state_0, frameValue, raxValue_);
                return;
            } else {
                execute_generic2(state_0, frameValue, raxValue_);
                return;
            }
        }

        private void execute_long_boolean0(int state_0__, VirtualFrame frameValue, int raxValue_) {
            int state_0 = state_0__;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] */;
            opI8(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_boolean1(int state_0__, VirtualFrame frameValue, int raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */;
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_generic2(int state_0__, VirtualFrame frameValue, int raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] || SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] */ && rdiValue_ instanceof Long) {
                    long rdiValue__ = (long) rdiValue_;
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */ && LLVMTypes.isPointer(rdiValue_)) {
                    LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (raxValue instanceof Integer) {
                int raxValue_ = (int) raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (boolean) dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (long) rdiValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.rax_, this.rdi_, this.df_}, raxValue, rdiValue, dfValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, long, boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosdNode.opI8(VirtualFrame, int, LLVMPointer, boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64StosdNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StosdNodeGen(writeRDI, rax, rdi, df);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64StosqNode#opI8(VirtualFrame, long, long, boolean)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link LLVMAMD64StosqNode#opI8(VirtualFrame, long, LLVMPointer, boolean)}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64StosqNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAMD64StosqNodeGen extends LLVMAMD64StosqNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode rax_;
        @Child private LLVMExpressionNode rdi_;
        @Child private LLVMExpressionNode df_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64StosqNode#opI8(VirtualFrame, long, long, boolean)}
         *   2: SpecializationActive {@link LLVMAMD64StosqNode#opI8(VirtualFrame, long, LLVMPointer, boolean)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMAMD64StosqNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long raxValue_;
            try {
                raxValue_ = this.rax_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */)) {
                execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] && SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */)) {
                execute_boolean1(state_0, frameValue, raxValue_);
                return;
            } else {
                execute_generic2(state_0, frameValue, raxValue_);
                return;
            }
        }

        private void execute_long_boolean0(int state_0__, VirtualFrame frameValue, long raxValue_) {
            int state_0 = state_0__;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object dfValue = this.df_.executeGeneric(frameValue);
                executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] */;
            opI8(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_boolean1(int state_0__, VirtualFrame frameValue, long raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */;
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void execute_generic2(int state_0__, VirtualFrame frameValue, long raxValue_) {
            int state_0 = state_0__;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            boolean dfValue_;
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
                return;
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] || SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] */ && rdiValue_ instanceof Long) {
                    long rdiValue__ = (long) rdiValue_;
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */ && LLVMTypes.isPointer(rdiValue_)) {
                    LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                    opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
            return;
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (raxValue instanceof Long) {
                long raxValue_ = (long) raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (boolean) dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (long) rdiValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */;
                        this.state_0_ = state_0;
                        opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.rax_, this.rdi_, this.df_}, raxValue, rdiValue, dfValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, long, boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64StosNode.LLVMAMD64StosqNode.opI8(VirtualFrame, long, LLVMPointer, boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64StosqNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StosqNodeGen(writeRDI, rax, rdi, df);
        }

    }
}
