// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToDoubleNode#doManagedPointer}
 *     Activation probability: 0.65000
 *     With/without class size: 24/16 bytes
 *   Specialization {@link LLVMToDoubleNode#doPointer}
 *     Activation probability: 0.35000
 *     With/without class size: 12/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMToDoubleNode.class)
@SuppressWarnings("javadoc")
public final class LLVMToDoubleNodeGen extends LLVMToDoubleNode implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToDoubleNode#doManagedPointer}
     *   2: SpecializationActive {@link LLVMToDoubleNode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private ManagedPointerData managedPointer_cache;
    @Child private PointerData pointer_cache;

    private LLVMToDoubleNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    private LLVMToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
        super(isRecursive);
        this.fromNode_ = fromNode;
    }

    @Override
    protected double executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    assert DSLSupport.assertIdempotence((!(isRecursive)));
                    return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    assert DSLSupport.assertIdempotence((!(isRecursive)));
                    return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @SuppressWarnings("unused")
    private double executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue)) {
            LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
            {
                LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                    ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                    s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.foreigns_ = foreigns__;
                    Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.interop_ = interop__;
                    VarHandle.storeStoreFence();
                    this.managedPointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                }
            }
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if ((!(isRecursive))) {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s1_.recursive_ = s1_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                this.state_0_ = state_0;
                return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((!(isRecursive))) {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s1_.recursive_ = s1_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMToDoubleNode create(LLVMExpressionNode fromNode) {
        return new LLVMToDoubleNodeGen(fromNode);
    }

    @NeverDefault
    public static LLVMToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
        return new LLVMToDoubleNodeGen(isRecursive, fromNode);
    }

    @GeneratedBy(LLVMToDoubleNode.class)
    @DenyReplace
    private static final class ManagedPointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
         *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
         */
        @Child ForeignToLLVM toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
         *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
         */
        @Child LLVMToDoubleNode recursive_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        ManagedPointerData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMToDoubleNode.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToDoubleNode#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToDoubleNode#doPointer}
         *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
         */
        @Child LLVMToDoubleNode recursive_;

        PointerData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToDoubleNode#doManagedPointer}
     *     Activation probability: 0.15909
     *     With/without class size: 9/16 bytes
     *   Specialization {@link LLVMToDoubleNode#doPointer}
     *     Activation probability: 0.14545
     *     With/without class size: 7/8 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(boolean)}
     *     Activation probability: 0.13182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(byte)}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(short)}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(int)}
     *     Activation probability: 0.09091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(long)}
     *     Activation probability: 0.07727
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(float)}
     *     Activation probability: 0.06364
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(double)}
     *     Activation probability: 0.05000
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(LLVM80BitFloat)}
     *     Activation probability: 0.03636
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToDoubleNode#doDouble(LLVM128BitFloat)}
     *     Activation probability: 0.02273
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToDoubleNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToDoubleNodeGen extends LLVMSignedCastToDoubleNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToDoubleNode#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToDoubleNode#doPointer}
         *   3: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(boolean)}
         *   4: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(byte)}
         *   5: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(short)}
         *   6: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(int)}
         *   7: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(long)}
         *   8: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(float)}
         *   9: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(double)}
         *   10: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(LLVM80BitFloat)}
         *   11: SpecializationActive {@link LLVMSignedCastToDoubleNode#doDouble(LLVM128BitFloat)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;

        private LLVMSignedCastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */) {
                return doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b111111101110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b111111011110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b111110111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b111101111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b111011111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b110111111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_boolean8(state_0, frameValue);
            } else if ((state_0 & 0b111111101110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_byte9(state_0, frameValue);
            } else if ((state_0 & 0b111111011110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_short10(state_0, frameValue);
            } else if ((state_0 & 0b111110111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_int11(state_0, frameValue);
            } else if ((state_0 & 0b111101111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_long12(state_0, frameValue);
            } else if ((state_0 & 0b111011111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_float13(state_0, frameValue);
            } else if ((state_0 & 0b110111111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] && SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */)) {
                return executeDouble_double14(state_0, frameValue);
            } else {
                return executeDouble_generic15(state_0, frameValue);
            }
        }

        private double executeDouble_boolean8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_byte9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_short10(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_int11(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_long12(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_float13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_double14(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_generic15(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] || SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private double executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        s0_.recursive_ = s0_.insert((createRecursive()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111111111110) & ((state_0 & 0b111111111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                    ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                    ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMSignedCastToDoubleNode.doDouble(LLVM128BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMSignedCastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToDoubleNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMSignedCastToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToDoubleNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMSignedCastToDoubleNode.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
             */
            @Child LLVMToDoubleNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMSignedCastToDoubleNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doPointer}
             *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
             */
            @Child LLVMToDoubleNode recursive_;

            PointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToDoubleNode#doManagedPointer}
     *     Activation probability: 0.21250
     *     With/without class size: 10/16 bytes
     *   Specialization {@link LLVMToDoubleNode#doPointer}
     *     Activation probability: 0.18750
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMUnsignedCastToDoubleNode#doDouble(boolean)}
     *     Activation probability: 0.16250
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToDoubleNode#doDouble(byte)}
     *     Activation probability: 0.13750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToDoubleNode#doDouble(short)}
     *     Activation probability: 0.11250
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToDoubleNode#doDouble(int)}
     *     Activation probability: 0.08750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToDoubleNode#doDouble(long)}
     *     Activation probability: 0.06250
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToDoubleNode#doDouble(double)}
     *     Activation probability: 0.03750
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToDoubleNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToDoubleNodeGen extends LLVMUnsignedCastToDoubleNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToDoubleNode#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToDoubleNode#doPointer}
         *   3: SpecializationActive {@link LLVMUnsignedCastToDoubleNode#doDouble(boolean)}
         *   4: SpecializationActive {@link LLVMUnsignedCastToDoubleNode#doDouble(byte)}
         *   5: SpecializationActive {@link LLVMUnsignedCastToDoubleNode#doDouble(short)}
         *   6: SpecializationActive {@link LLVMUnsignedCastToDoubleNode#doDouble(int)}
         *   7: SpecializationActive {@link LLVMUnsignedCastToDoubleNode#doDouble(long)}
         *   8: SpecializationActive {@link LLVMUnsignedCastToDoubleNode#doDouble(double)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;

        private LLVMUnsignedCastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */) {
                return doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b111101110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b111011110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b110111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b101111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b11111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeGeneric_double5(state_0, frameValue);
            } else {
                return executeGeneric_generic6(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeDouble_boolean7(state_0, frameValue);
            } else if ((state_0 & 0b111101110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeDouble_byte8(state_0, frameValue);
            } else if ((state_0 & 0b111011110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeDouble_short9(state_0, frameValue);
            } else if ((state_0 & 0b110111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeDouble_int10(state_0, frameValue);
            } else if ((state_0 & 0b101111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeDouble_long11(state_0, frameValue);
            } else if ((state_0 & 0b11111110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */)) {
                return executeDouble_double12(state_0, frameValue);
            } else {
                return executeDouble_generic13(state_0, frameValue);
            }
        }

        private double executeDouble_boolean7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_byte8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_short9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_int10(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_long11(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_double12(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_generic13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] || SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private double executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        s0_.recursive_ = s0_.insert((createRecursive()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111111110) & ((state_0 & 0b111111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                    ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                    ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.doDouble(double)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMUnsignedCastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToDoubleNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMUnsignedCastToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToDoubleNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMUnsignedCastToDoubleNode.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
             */
            @Child LLVMToDoubleNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMUnsignedCastToDoubleNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doPointer}
             *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
             */
            @Child LLVMToDoubleNode recursive_;

            PointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToDoubleNode#doManagedPointer}
     *     Activation probability: 0.14679
     *     With/without class size: 8/16 bytes
     *   Specialization {@link LLVMToDoubleNode#doPointer}
     *     Activation probability: 0.13526
     *     With/without class size: 7/8 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doDouble(long)}
     *     Activation probability: 0.12372
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doDouble(double)}
     *     Activation probability: 0.11218
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doFloat}
     *     Activation probability: 0.10064
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doI1Vector}
     *     Activation probability: 0.08910
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doI8Vector}
     *     Activation probability: 0.07756
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doI16Vector}
     *     Activation probability: 0.06603
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doI32Vector}
     *     Activation probability: 0.05449
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doFloatVector}
     *     Activation probability: 0.04295
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doI64Vector}
     *     Activation probability: 0.03141
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToDoubleNode#doDoubleVector}
     *     Activation probability: 0.01987
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToDoubleNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToDoubleNodeGen extends LLVMBitcastToDoubleNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToDoubleNode#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToDoubleNode#doPointer}
         *   3: SpecializationActive {@link LLVMBitcastToDoubleNode#doDouble(long)}
         *   4: SpecializationActive {@link LLVMBitcastToDoubleNode#doDouble(double)}
         *   5: SpecializationActive {@link LLVMBitcastToDoubleNode#doFloat}
         *   6: SpecializationActive {@link LLVMBitcastToDoubleNode#doI1Vector}
         *   7: SpecializationActive {@link LLVMBitcastToDoubleNode#doI8Vector}
         *   8: SpecializationActive {@link LLVMBitcastToDoubleNode#doI16Vector}
         *   9: SpecializationActive {@link LLVMBitcastToDoubleNode#doI32Vector}
         *   10: SpecializationActive {@link LLVMBitcastToDoubleNode#doFloatVector}
         *   11: SpecializationActive {@link LLVMBitcastToDoubleNode#doI64Vector}
         *   12: SpecializationActive {@link LLVMBitcastToDoubleNode#doDoubleVector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;

        private LLVMBitcastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMBitcastToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */) {
                return doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111110110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeGeneric_long0(state_0, frameValue);
            } else if ((state_0 & 0b1111111101110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeGeneric_double1(state_0, frameValue);
            } else if ((state_0 & 0b1111111011110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeGeneric_float2(state_0, frameValue);
            } else {
                return executeGeneric_generic3(state_0, frameValue);
            }
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_float2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] */ && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector) fromNodeValue_;
                    return doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] */ && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector) fromNodeValue_;
                    return doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] */ && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector) fromNodeValue_;
                    return doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */ && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector) fromNodeValue_;
                    return doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111110110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeDouble_long4(state_0, frameValue);
            } else if ((state_0 & 0b1111111101110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeDouble_double5(state_0, frameValue);
            } else if ((state_0 & 0b1111111011110) == 0 /* only-active SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] && SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */)) {
                return executeDouble_float6(state_0, frameValue);
            } else {
                return executeDouble_generic7(state_0, frameValue);
            }
        }

        private double executeDouble_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_double5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private double executeDouble_float6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private double executeDouble_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] || SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] */ && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector) fromNodeValue_;
                    return doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] */ && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector) fromNodeValue_;
                    return doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] */ && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector) fromNodeValue_;
                    return doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */ && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector) fromNodeValue_;
                    return doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private double executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToDoubleNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        s0_.recursive_ = s0_.insert((createRecursive()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToDoubleNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToDoubleNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] */;
                this.state_0_ = state_0;
                return doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] */;
                this.state_0_ = state_0;
                return doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] */;
                this.state_0_ = state_0;
                return doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] */;
                this.state_0_ = state_0;
                return doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector) fromNodeValue;
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */;
                this.state_0_ = state_0;
                return doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111111111110) & ((state_0 & 0b1111111111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                    ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                    ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToDoubleNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToDoubleNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDouble(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloat(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI1Vector(LLVMI1Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI8Vector(LLVMI8Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI16Vector(LLVMI16Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI32Vector(LLVMI32Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doFloatVector(LLVMFloatVector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doI64Vector(LLVMI64Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMToDoubleNode.LLVMBitcastToDoubleNode.doDoubleVector(LLVMDoubleVector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMBitcastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToDoubleNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMBitcastToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMBitcastToDoubleNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMBitcastToDoubleNode.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
             */
            @Child LLVMToDoubleNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMBitcastToDoubleNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToDoubleNode#doPointer}
             *   Parameter: {@link LLVMToDoubleNode} recursive</pre>
             */
            @Child LLVMToDoubleNode recursive_;

            PointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
