// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMArgNode#doPointer}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMArgNode#doObject}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMArgNode.class)
@SuppressWarnings("javadoc")
public final class LLVMArgNodeGen extends LLVMArgNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMArgNode#doPointer}
     *   2: SpecializationActive {@link LLVMArgNode#doObject}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMArgNodeGen(int index) {
        super(index);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMArgNode.doPointer(VirtualFrame)] || SpecializationActive[LLVMArgNode.doObject(VirtualFrame)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArgNode.doPointer(VirtualFrame)] */) {
                if ((isPointer(frameValue))) {
                    return doPointer(frameValue);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArgNode.doObject(VirtualFrame)] */) {
                if ((!(isPointer(frameValue)))) {
                    return doObject(frameValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((isPointer(frameValue))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMArgNode.doPointer(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doPointer(frameValue);
        }
        if ((!(isPointer(frameValue)))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMArgNode.doObject(VirtualFrame)] */;
            this.state_0_ = state_0;
            return doObject(frameValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {});
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMArgNode.doPointer(VirtualFrame)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMArgNode.doObject(VirtualFrame)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMArgNode create(int index) {
        return new LLVMArgNodeGen(index);
    }

}
