// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

@GeneratedBy(LLVMInvokeNode.class)
final class LLVMInvokeNodeWrapper extends LLVMInvokeNode implements WrapperNode {

    @Child private LLVMInvokeNode delegateNode;
    @Child private ProbeNode probeNode;

    LLVMInvokeNodeWrapper(LLVMInvokeNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public LLVMInvokeNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public void execute(VirtualFrame frame) {
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, null);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    break;
                }
                throw t;
            }
        }
    }

    @Override
    public int getSuccessorCount() {
        return this.delegateNode.getSuccessorCount();
    }

    @Override
    public int[] getSuccessors() {
        return this.delegateNode.getSuccessors();
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return this.delegateNode.getPhiNode(successorIndex);
    }

    @Override
    public int getNormalSuccessor() {
        return this.delegateNode.getNormalSuccessor();
    }

    @Override
    public int getUnwindSuccessor() {
        return this.delegateNode.getUnwindSuccessor();
    }

}
