// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode.LLVMCharset;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode.LLVMI16OffsetLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode.LLVMI32OffsetLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode.LLVMI64OffsetLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode.LLVMI8OffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPolyglotFromString#doFromString}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPolyglotFromString.class)
@SuppressWarnings("javadoc")
public final class LLVMPolyglotFromStringNodeGen extends LLVMPolyglotFromString implements GenerateAOT.Provider {

    @Child private LLVMReadCharsetNode charset_;
    @Child private ReadBytesNode rawString_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPolyglotFromString#doFromString}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMPolyglotFromStringNodeGen(LLVMReadCharsetNode charset, ReadBytesNode rawString) {
        this.charset_ = charset;
        this.rawString_ = rawString;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object charsetValue_ = this.charset_.execute(frameValue);
        byte[] rawStringValue_ = this.rawString_.execute(frameValue, (LLVMCharset) charsetValue_);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(charsetValue_, rawStringValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotFromString.doFromString(LLVMCharset, byte[])] */ && charsetValue_ instanceof LLVMCharset) {
            LLVMCharset charsetValue__ = (LLVMCharset) charsetValue_;
            return doFromString(charsetValue__, rawStringValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(charsetValue_, rawStringValue_);
    }

    private LLVMManagedPointer executeAndSpecialize(Object charsetValue, byte[] rawStringValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (charsetValue instanceof LLVMCharset) {
            LLVMCharset charsetValue_ = (LLVMCharset) charsetValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotFromString.doFromString(LLVMCharset, byte[])] */;
            this.state_0_ = state_0;
            return doFromString(charsetValue_, rawStringValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.charset_, this.rawString_}, charsetValue, rawStringValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPolyglotFromString.doFromString(LLVMCharset, byte[])] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotFromString create(LLVMReadCharsetNode charset, ReadBytesNode rawString) {
        return new LLVMPolyglotFromStringNodeGen(charset, rawString);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadBytesWithLengthNode#doRead}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(ReadBytesWithLengthNode.class)
    @SuppressWarnings("javadoc")
    static final class ReadBytesWithLengthNodeGen extends ReadBytesWithLengthNode implements GenerateAOT.Provider {

        @Child private LLVMReadCharsetNode child0_;
        @Child private LLVMExpressionNode string_;
        @Child private LLVMExpressionNode len_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReadBytesWithLengthNode#doRead}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private ReadBytesWithLengthNodeGen(LLVMReadCharsetNode child0, LLVMExpressionNode string, LLVMExpressionNode len) {
            this.child0_ = child0;
            this.string_ = string;
            this.len_ = len;
        }

        @Override
        protected byte[] execute(VirtualFrame frameValue, LLVMCharset child0Value) {
            int state_0 = this.state_0_;
            Object stringValue_ = this.string_.executeGeneric(frameValue);
            long lenValue_;
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(child0Value, stringValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value, stringValue_, lenValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotFromString.ReadBytesWithLengthNode.doRead(LLVMCharset, LLVMPointer, long)] */ && LLVMTypes.isPointer(stringValue_)) {
                LLVMPointer stringValue__ = LLVMTypes.asPointer(stringValue_);
                return doRead(child0Value, stringValue__, lenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value, stringValue_, lenValue_);
        }

        private byte[] executeAndSpecialize(Object child0Value, Object stringValue, Object lenValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMCharset) {
                LLVMCharset child0Value_ = (LLVMCharset) child0Value;
                if (LLVMTypes.isPointer(stringValue)) {
                    LLVMPointer stringValue_ = LLVMTypes.asPointer(stringValue);
                    if (lenValue instanceof Long) {
                        long lenValue_ = (long) lenValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotFromString.ReadBytesWithLengthNode.doRead(LLVMCharset, LLVMPointer, long)] */;
                        this.state_0_ = state_0;
                        return doRead(child0Value_, stringValue_, lenValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.string_, this.len_}, child0Value, stringValue, lenValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPolyglotFromString.ReadBytesWithLengthNode.doRead(LLVMCharset, LLVMPointer, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ReadBytesWithLengthNode create(LLVMReadCharsetNode child0, LLVMExpressionNode string, LLVMExpressionNode len) {
            return new ReadBytesWithLengthNodeGen(child0, string, len);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadZeroTerminatedBytesNode#doReadI8}
     *     Activation probability: 0.38500
     *     With/without class size: 11/4 bytes
     *   Specialization {@link ReadZeroTerminatedBytesNode#doReadI16}
     *     Activation probability: 0.29500
     *     With/without class size: 9/4 bytes
     *   Specialization {@link ReadZeroTerminatedBytesNode#doReadI32}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link ReadZeroTerminatedBytesNode#doReadI64}
     *     Activation probability: 0.11500
     *     With/without class size: 6/8 bytes
     * </pre>
     */
    @GeneratedBy(ReadZeroTerminatedBytesNode.class)
    @SuppressWarnings("javadoc")
    static final class ReadZeroTerminatedBytesNodeGen extends ReadZeroTerminatedBytesNode implements GenerateAOT.Provider {

        @Child private LLVMReadCharsetNode child0_;
        @Child private LLVMExpressionNode child1_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ReadZeroTerminatedBytesNode#doReadI8}
         *   2: SpecializationActive {@link ReadZeroTerminatedBytesNode#doReadI16}
         *   3: SpecializationActive {@link ReadZeroTerminatedBytesNode#doReadI32}
         *   4: SpecializationActive {@link ReadZeroTerminatedBytesNode#doReadI64}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ReadI8Data readI8_cache;
        @Child private ReadI16Data readI16_cache;
        @Child private ReadI32Data readI32_cache;
        @Child private ReadI64Data readI64_cache;

        private ReadZeroTerminatedBytesNodeGen(LLVMReadCharsetNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        protected byte[] execute(VirtualFrame frameValue, LLVMCharset child0Value) {
            int state_0 = this.state_0_;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(child0Value, child1Value_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI8(LLVMCharset, LLVMPointer, LLVMI8OffsetLoadNode)] || SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI16(LLVMCharset, LLVMPointer, LLVMI16OffsetLoadNode)] || SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI32(LLVMCharset, LLVMPointer, LLVMI32OffsetLoadNode)] || SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI64(LLVMCharset, LLVMPointer, LLVMI64OffsetLoadNode, LLVMToNativeNode)] */ && LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI8(LLVMCharset, LLVMPointer, LLVMI8OffsetLoadNode)] */) {
                    ReadI8Data s0_ = this.readI8_cache;
                    if (s0_ != null) {
                        if ((child0Value.zeroTerminatorLen == 1)) {
                            return doReadI8(child0Value, child1Value__, s0_.load_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI16(LLVMCharset, LLVMPointer, LLVMI16OffsetLoadNode)] */) {
                    ReadI16Data s1_ = this.readI16_cache;
                    if (s1_ != null) {
                        if ((child0Value.zeroTerminatorLen == 2)) {
                            return doReadI16(child0Value, child1Value__, s1_.load_);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI32(LLVMCharset, LLVMPointer, LLVMI32OffsetLoadNode)] */) {
                    ReadI32Data s2_ = this.readI32_cache;
                    if (s2_ != null) {
                        if ((child0Value.zeroTerminatorLen == 4)) {
                            return doReadI32(child0Value, child1Value__, s2_.load_);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI64(LLVMCharset, LLVMPointer, LLVMI64OffsetLoadNode, LLVMToNativeNode)] */) {
                    ReadI64Data s3_ = this.readI64_cache;
                    if (s3_ != null) {
                        if ((child0Value.zeroTerminatorLen == 8)) {
                            return doReadI64(child0Value, child1Value__, s3_.load_, s3_.toNative_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value, child1Value_);
        }

        private byte[] executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMCharset) {
                LLVMCharset child0Value_ = (LLVMCharset) child0Value;
                if (LLVMTypes.isPointer(child1Value)) {
                    LLVMPointer child1Value_ = LLVMTypes.asPointer(child1Value);
                    if ((child0Value_.zeroTerminatorLen == 1)) {
                        ReadI8Data s0_ = this.insert(new ReadI8Data());
                        s0_.load_ = s0_.insert((LLVMI8OffsetLoadNode.create()));
                        VarHandle.storeStoreFence();
                        this.readI8_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI8(LLVMCharset, LLVMPointer, LLVMI8OffsetLoadNode)] */;
                        this.state_0_ = state_0;
                        return doReadI8(child0Value_, child1Value_, s0_.load_);
                    }
                    if ((child0Value_.zeroTerminatorLen == 2)) {
                        ReadI16Data s1_ = this.insert(new ReadI16Data());
                        s1_.load_ = s1_.insert((LLVMI16OffsetLoadNode.create()));
                        VarHandle.storeStoreFence();
                        this.readI16_cache = s1_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI16(LLVMCharset, LLVMPointer, LLVMI16OffsetLoadNode)] */;
                        this.state_0_ = state_0;
                        return doReadI16(child0Value_, child1Value_, s1_.load_);
                    }
                    if ((child0Value_.zeroTerminatorLen == 4)) {
                        ReadI32Data s2_ = this.insert(new ReadI32Data());
                        s2_.load_ = s2_.insert((LLVMI32OffsetLoadNode.create()));
                        VarHandle.storeStoreFence();
                        this.readI32_cache = s2_;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI32(LLVMCharset, LLVMPointer, LLVMI32OffsetLoadNode)] */;
                        this.state_0_ = state_0;
                        return doReadI32(child0Value_, child1Value_, s2_.load_);
                    }
                    if ((child0Value_.zeroTerminatorLen == 8)) {
                        ReadI64Data s3_ = this.insert(new ReadI64Data());
                        s3_.load_ = s3_.insert((LLVMI64OffsetLoadNode.create()));
                        LLVMToNativeNode toNative__ = s3_.insert((LLVMToNativeNodeGen.create()));
                        Objects.requireNonNull(toNative__, "Specialization 'doReadI64(LLVMCharset, LLVMPointer, LLVMI64OffsetLoadNode, LLVMToNativeNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s3_.toNative_ = toNative__;
                        VarHandle.storeStoreFence();
                        this.readI64_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI64(LLVMCharset, LLVMPointer, LLVMI64OffsetLoadNode, LLVMToNativeNode)] */;
                        this.state_0_ = state_0;
                        return doReadI64(child0Value_, child1Value_, s3_.load_, toNative__);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.child1_}, child0Value, child1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                ReadI8Data s0_ = this.insert(new ReadI8Data());
                s0_.load_ = s0_.insert((LLVMI8OffsetLoadNode.create()));
                VarHandle.storeStoreFence();
                this.readI8_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.load_, 1);
                ((GenerateAOT.Provider) s0_.load_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI8(LLVMCharset, LLVMPointer, LLVMI8OffsetLoadNode)] */;
            }
            {
                ReadI16Data s1_ = this.insert(new ReadI16Data());
                s1_.load_ = s1_.insert((LLVMI16OffsetLoadNode.create()));
                VarHandle.storeStoreFence();
                this.readI16_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.load_, 1);
                ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI16(LLVMCharset, LLVMPointer, LLVMI16OffsetLoadNode)] */;
            }
            {
                ReadI32Data s2_ = this.insert(new ReadI32Data());
                s2_.load_ = s2_.insert((LLVMI32OffsetLoadNode.create()));
                VarHandle.storeStoreFence();
                this.readI32_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.load_, 1);
                ((GenerateAOT.Provider) s2_.load_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI32(LLVMCharset, LLVMPointer, LLVMI32OffsetLoadNode)] */;
            }
            {
                ReadI64Data s3_ = this.insert(new ReadI64Data());
                s3_.load_ = s3_.insert((LLVMI64OffsetLoadNode.create()));
                LLVMToNativeNode toNative__ = s3_.insert((LLVMToNativeNodeGen.create()));
                Objects.requireNonNull(toNative__, "Specialization 'doReadI64(LLVMCharset, LLVMPointer, LLVMI64OffsetLoadNode, LLVMToNativeNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s3_.toNative_ = toNative__;
                VarHandle.storeStoreFence();
                this.readI64_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.load_, 1);
                ((GenerateAOT.Provider) s3_.load_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s3_.toNative_, 1);
                ((GenerateAOT.Provider) s3_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.doReadI64(LLVMCharset, LLVMPointer, LLVMI64OffsetLoadNode, LLVMToNativeNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.readI8_cache = null;
            this.readI16_cache = null;
            this.readI32_cache = null;
            this.readI64_cache = null;
        }

        @NeverDefault
        public static ReadZeroTerminatedBytesNode create(LLVMReadCharsetNode child0, LLVMExpressionNode child1) {
            return new ReadZeroTerminatedBytesNodeGen(child0, child1);
        }

        @GeneratedBy(ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI8Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadZeroTerminatedBytesNode#doReadI8}
             *   Parameter: {@link LLVMI8OffsetLoadNode} load</pre>
             */
            @Child LLVMI8OffsetLoadNode load_;

            ReadI8Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI16Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadZeroTerminatedBytesNode#doReadI16}
             *   Parameter: {@link LLVMI16OffsetLoadNode} load</pre>
             */
            @Child LLVMI16OffsetLoadNode load_;

            ReadI16Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI32Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadZeroTerminatedBytesNode#doReadI32}
             *   Parameter: {@link LLVMI32OffsetLoadNode} load</pre>
             */
            @Child LLVMI32OffsetLoadNode load_;

            ReadI32Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI64Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadZeroTerminatedBytesNode#doReadI64}
             *   Parameter: {@link LLVMI64OffsetLoadNode} load</pre>
             */
            @Child LLVMI64OffsetLoadNode load_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadZeroTerminatedBytesNode#doReadI64}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            ReadI64Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
