// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMReadStringNode#readString(String)}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMReadStringNode#readString(LLVMManagedPointer)}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMReadStringNode#readForeign}
 *     Activation probability: 0.20500
 *     With/without class size: 8/8 bytes
 *   Specialization {@link LLVMReadStringNode#readOther}
 *     Activation probability: 0.11500
 *     With/without class size: 6/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMReadStringNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMReadStringNodeGen extends LLVMReadStringNode implements GenerateAOT.Provider {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMReadStringNode#readString(String)}
     *   2: SpecializationActive {@link LLVMReadStringNode#readString(LLVMManagedPointer)}
     *   3: SpecializationActive {@link LLVMReadStringNode#readForeign}
     *   4: SpecializationActive {@link LLVMReadStringNode#readOther}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private ReadForeignData readForeign_cache;
    @Child private FallbackData fallback_cache;

    private LLVMReadStringNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadStringNode.readString(String)] */) && arg0Value instanceof String) {
            return false;
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((LLVMReadStringNode.isString(arg0Value_))) {
                    return false;
                }
            }
            {
                ReadForeignData s2_ = this.readForeign_cache;
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((s2_ == null || ((s2_.readForeign_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode), guardIndex=0] */ || (s2_.foreigns_.isForeign(arg0Value_)))) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMReadStringNode.readString(String)] || SpecializationActive[LLVMReadStringNode.readString(LLVMManagedPointer)] || SpecializationActive[LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode)] || SpecializationActive[LLVMReadStringNode.readOther(Object, PointerReadStringNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadStringNode.readString(String)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return readString(arg0Value_);
            }
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadStringNode.readString(LLVMManagedPointer)] || SpecializationActive[LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadStringNode.readString(LLVMManagedPointer)] */) {
                    if ((LLVMReadStringNode.isString(arg0Value_))) {
                        return readString(arg0Value_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode)] */) {
                    ReadForeignData s2_ = this.readForeign_cache;
                    if (s2_ != null) {
                        if ((s2_.readForeign_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (s2_.foreigns_.isForeign(arg0Value_))) {
                            return readForeign(arg0Value_, s2_.foreigns_, s2_.read_);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMReadStringNode.readOther(Object, PointerReadStringNode)] */) {
                FallbackData s3_ = this.fallback_cache;
                if (s3_ != null) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return readOther(arg0Value, s3_.readOther_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("unused")
    private String executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadStringNode.readString(String)] */;
            this.state_0_ = state_0;
            return readString(arg0Value_);
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            if ((LLVMReadStringNode.isString(arg0Value_))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadStringNode.readString(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return readString(arg0Value_);
            }
            {
                ReadForeignData s2_ = this.insert(new ReadForeignData());
                LLVMAsForeignLibrary foreigns__ = s2_.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                if (((s2_.readForeign_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode), guardIndex=0] */) {
                    Objects.requireNonNull(s2_.insert(foreigns__), "Specialization 'readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s2_.foreigns_ = foreigns__;
                    s2_.readForeign_state_0_ = s2_.readForeign_state_0_ | 0b1 /* add GuardActive[specialization=LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode), guardIndex=0] */;
                    VarHandle.storeStoreFence();
                    this.readForeign_cache = s2_;
                    s2_ = this.insert(new ReadForeignData(s2_));
                }
                if ((foreigns__.isForeign(arg0Value_))) {
                    Objects.requireNonNull(s2_.insert(foreigns__), "Specialization 'readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s2_.foreigns_ = foreigns__;
                    s2_.read_ = s2_.insert((ForeignReadStringNode.create()));
                    s2_.readForeign_state_0_ = s2_.readForeign_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                    VarHandle.storeStoreFence();
                    this.readForeign_cache = s2_;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadStringNode.readForeign(LLVMManagedPointer, LLVMAsForeignLibrary, ForeignReadStringNode)] */;
                    this.state_0_ = state_0;
                    return readForeign(arg0Value_, foreigns__, s2_.read_);
                }
            }
        }
        FallbackData s3_ = this.insert(new FallbackData());
        s3_.readOther_ = s3_.insert((PointerReadStringNode.create()));
        VarHandle.storeStoreFence();
        this.fallback_cache = s3_;
        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMReadStringNode.readOther(Object, PointerReadStringNode)] */;
        this.state_0_ = state_0;
        return readOther(arg0Value, s3_.readOther_);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReadStringNode.readString(String)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMReadStringNode.readString(LLVMManagedPointer)] */;
        }
        {
            FallbackData s3_ = this.insert(new FallbackData());
            s3_.readOther_ = s3_.insert((PointerReadStringNode.create()));
            VarHandle.storeStoreFence();
            this.fallback_cache = s3_;
            assert NodeUtil.assertRecursion(s3_.readOther_, 1);
            ((GenerateAOT.Provider) s3_.readOther_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMReadStringNode.readOther(Object, PointerReadStringNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.fallback_cache = null;
    }

    @NeverDefault
    public static LLVMReadStringNode create() {
        return new LLVMReadStringNodeGen();
    }

    @GeneratedBy(LLVMReadStringNode.class)
    @DenyReplace
    private static final class ReadForeignData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: GuardActive[guardIndex=0] {@link LLVMReadStringNode#readForeign}
         *   1: SpecializationCachesInitialized {@link LLVMReadStringNode#readForeign}
         * </pre>
         */
        @CompilationFinal private int readForeign_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadStringNode#readForeign}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadStringNode#readForeign}
         *   Parameter: {@link ForeignReadStringNode} read</pre>
         */
        @Child ForeignReadStringNode read_;

        ReadForeignData() {
        }

        ReadForeignData(ReadForeignData delegate) {
            this.readForeign_state_0_ = delegate.readForeign_state_0_;
            this.foreigns_ = delegate.foreigns_;
            this.read_ = delegate.read_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMReadStringNode.class)
    @DenyReplace
    private static final class FallbackData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadStringNode#readOther}
         *   Parameter: {@link PointerReadStringNode} readOther</pre>
         */
        @Child PointerReadStringNode readOther_;

        FallbackData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ForeignReadStringNode#doDefault}
     *     Activation probability: 0.65000
     *     With/without class size: 22/8 bytes
     *   Specialization {@link ForeignReadStringNode#doDefault}
     *     Activation probability: 0.35000
     *     With/without class size: 11/4 bytes
     * </pre>
     */
    @GeneratedBy(ForeignReadStringNode.class)
    @SuppressWarnings("javadoc")
    static final class ForeignReadStringNodeGen extends ForeignReadStringNode implements GenerateAOT.Provider {

        static final ReferenceField<Default0Data> DEFAULT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "default0_cache", Default0Data.class);

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ForeignReadStringNode#doDefault}
         *   2: SpecializationActive {@link ForeignReadStringNode#doDefault}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private Default0Data default0_cache;
        @Child private Default1Data default1_cache;

        private ForeignReadStringNodeGen() {
        }

        @ExplodeLoop
        @Override
        protected String execute(LLVMManagedPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] || SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */) {
                    Default0Data s0_ = this.default0_cache;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg1Value))) {
                            return doDefault(arg0Value, arg1Value, s0_.interop_, s0_.read_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */) {
                    Default1Data s1_ = this.default1_cache;
                    if (s1_ != null) {
                        return this.default1Boundary(state_0, s1_, arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private String default1Boundary(int state_0, Default1Data s1_, LLVMManagedPointer arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                    return doDefault(arg0Value, arg1Value, interop__, s1_.read_);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private String executeAndSpecialize(LLVMManagedPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */) {
                while (true) {
                    int count0_ = 0;
                    Default0Data s0_ = DEFAULT0_CACHE_UPDATER.getVolatile(this);
                    Default0Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.interop_.accepts(arg1Value))) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (s0_.interop_.accepts(arg1Value));
                        if (count0_ < (3)) {
                            s0_ = this.insert(new Default0Data(s0_original));
                            InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(interop__, "Specialization 'doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s0_.interop_ = interop__;
                            s0_.read_ = s0_.insert((PointerReadStringNode.create()));
                            if (!DEFAULT0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        return doDefault(arg0Value, arg1Value, s0_.interop_, s0_.read_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        Default1Data s1_ = this.insert(new Default1Data());
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        s1_.read_ = s1_.insert((PointerReadStringNode.create()));
                        VarHandle.storeStoreFence();
                        this.default1_cache = s1_;
                        this.default0_cache = null;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadStringNode.ForeignReadStringNode.doDefault(LLVMManagedPointer, Object, InteropLibrary, PointerReadStringNode)] */;
                        this.state_0_ = state_0;
                        return doDefault(arg0Value, arg1Value, interop__, s1_.read_);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    Default0Data s0_ = this.default0_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ForeignReadStringNode create() {
            return new ForeignReadStringNodeGen();
        }

        @GeneratedBy(ForeignReadStringNode.class)
        @DenyReplace
        private static final class Default0Data extends Node implements SpecializationDataNode {

            @Child Default0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadStringNode#doDefault}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadStringNode#doDefault}
             *   Parameter: {@link PointerReadStringNode} read</pre>
             */
            @Child PointerReadStringNode read_;

            Default0Data(Default0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(ForeignReadStringNode.class)
        @DenyReplace
        private static final class Default1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link ForeignReadStringNode#doDefault}
             *   Parameter: {@link PointerReadStringNode} read</pre>
             */
            @Child PointerReadStringNode read_;

            Default1Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link PointerReadStringNode#doCachedPointer}
     *     Activation probability: 0.65000
     *     With/without class size: 19/8 bytes
     *   Specialization {@link PointerReadStringNode#doReadString}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(PointerReadStringNode.class)
    @SuppressWarnings("javadoc")
    static final class PointerReadStringNodeGen extends PointerReadStringNode implements GenerateAOT.Provider {

        static final ReferenceField<CachedPointerData> CACHED_POINTER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedPointer_cache", CachedPointerData.class);

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link PointerReadStringNode#doCachedPointer}
         *   2: SpecializationActive {@link PointerReadStringNode#doReadString}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @CompilationFinal private CachedPointerData cachedPointer_cache;

        private PointerReadStringNodeGen() {
        }

        @ExplodeLoop
        @Override
        protected String execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doCachedPointer(LLVMPointer, LLVMPointer, String)] || SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doReadString(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doCachedPointer(LLVMPointer, LLVMPointer, String)] */) {
                    CachedPointerData s0_ = this.cachedPointer_cache;
                    while (s0_ != null) {
                        if ((s0_.cachedAddress_.isSame(arg0Value_))) {
                            assert DSLSupport.assertIdempotence((isReadOnlyMemory(s0_.cachedAddress_)));
                            return doCachedPointer(arg0Value_, s0_.cachedAddress_, s0_.result_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doReadString(LLVMPointer)] */) {
                    return doReadString(arg0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doReadString(LLVMPointer)] */) {
                    while (true) {
                        int count0_ = 0;
                        CachedPointerData s0_ = CACHED_POINTER_CACHE_UPDATER.getVolatile(this);
                        CachedPointerData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.cachedAddress_.isSame(arg0Value_))) {
                                assert DSLSupport.assertIdempotence((isReadOnlyMemory(s0_.cachedAddress_)));
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                LLVMPointer cachedAddress__ = (arg0Value_);
                                if ((cachedAddress__.isSame(arg0Value_)) && (isReadOnlyMemory(cachedAddress__)) && count0_ < (3)) {
                                    s0_ = new CachedPointerData(s0_original);
                                    s0_.cachedAddress_ = cachedAddress__;
                                    s0_.result_ = (doReadString(cachedAddress__));
                                    if (!CACHED_POINTER_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doCachedPointer(LLVMPointer, LLVMPointer, String)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doCachedPointer(arg0Value_, s0_.cachedAddress_, s0_.result_);
                        }
                        break;
                    }
                }
                this.cachedPointer_cache = null;
                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doCachedPointer(LLVMPointer, LLVMPointer, String)] */;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doReadString(LLVMPointer)] */;
                this.state_0_ = state_0;
                return doReadString(arg0Value_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    CachedPointerData s0_ = this.cachedPointer_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.cachedPointer_cache = null;
                this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doCachedPointer(LLVMPointer, LLVMPointer, String)] */;
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMReadStringNode.PointerReadStringNode.doReadString(LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static PointerReadStringNode create() {
            return new PointerReadStringNodeGen();
        }

        @GeneratedBy(PointerReadStringNode.class)
        @DenyReplace
        private static final class CachedPointerData implements SpecializationDataNode {

            @CompilationFinal final CachedPointerData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PointerReadStringNode#doCachedPointer}
             *   Parameter: {@link LLVMPointer} cachedAddress</pre>
             */
            @CompilationFinal LLVMPointer cachedAddress_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PointerReadStringNode#doCachedPointer}
             *   Parameter: {@link String} result</pre>
             */
            @CompilationFinal String result_;

            CachedPointerData(CachedPointerData next_) {
                this.next_ = next_;
            }

        }
    }
}
